/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.mojang.datafixers.DataFixer;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class WorldUtils {
    private static final List<PositionCache> EASY_PLACE_POSITIONS = new ArrayList<PositionCache>();
    private static boolean preventOnBlockAdded;

    public static boolean shouldPreventOnBlockAdded() {
        return preventOnBlockAdded;
    }

    public static void setShouldPreventOnBlockAdded(boolean prevent) {
        preventOnBlockAdded = prevent;
    }

    public static boolean convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertSchematicaSchematicToLitematicaSchematic(inputDir, inputFileName, ignoreEntities, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertSchematicaSchematicToLitematicaSchematic(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        SchematicaSchematic schematic = SchematicaSchematic.createFromFile(new File(inputDir, inputFileName));
        if (schematic == null) {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_read_schematic");
            return null;
        }
        ayd settings = new ayd(0L, axv.c, false, false, ayg.c);
        WorldSchematic world = new WorldSchematic(null, settings, bod.b, adi.c, cft.s().y);
        WorldUtils.loadChunksSchematicWorld(world, el.a, schematic.getSize());
        bxn placementSettings = new bxn();
        placementSettings.a(ignoreEntities);
        schematic.placeSchematicDirectlyToChunks((axy)world, el.a, placementSettings);
        String subRegionName = FileUtils.getNameWithoutExtension((String)inputFileName) + " (Converted Schematic)";
        AreaSelection area = new AreaSelection();
        area.setName(subRegionName);
        subRegionName = area.createNewSubRegionBox(el.a, subRegionName);
        area.setSelectedSubRegionBox(subRegionName);
        Box box = area.getSelectedSubRegionBox();
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, el.a);
        area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, new el(schematic.getSize()).a(-1, -1, -1));
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromWorld((axy)world, area, false, "?", feedback);
        if (litematicaSchematic != null && !ignoreEntities) {
            litematicaSchematic.takeEntityDataFromSchematicaSchematic(schematic, subRegionName);
        } else {
            feedback.setString("litematica.error.schematic_conversion.schematic_to_litematica.failed_to_create_schematic");
        }
        return litematicaSchematic;
    }

    public static boolean convertStructureToLitematicaSchematic(File structureDir, String structureFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = WorldUtils.convertStructureToLitematicaSchematic(structureDir, structureFileName, ignoreEntities, feedback);
        return litematicaSchematic != null && litematicaSchematic.writeToFile(outputDir, outputFileName, override);
    }

    @Nullable
    public static LitematicaSchematic convertStructureToLitematicaSchematic(File structureDir, String structureFileName, boolean ignoreEntities, IStringConsumer feedback) {
        DataFixer fixer = cft.s().aa();
        File file = new File(structureDir, structureFileName);
        try {
            FileInputStream is = new FileInputStream(file);
            bxp template = WorldUtils.readTemplateFromStream(is, fixer);
            ((InputStream)is).close();
            ayd settings = new ayd(0L, axv.c, false, false, ayg.c);
            WorldSchematic world = new WorldSchematic(null, settings, bod.b, adi.c, cft.s().y);
            WorldUtils.loadChunksSchematicWorld(world, el.a, (ff)template.a());
            bxn placementSettings = new bxn();
            placementSettings.a(ignoreEntities);
            template.a((axz)world, el.a, null, placementSettings, 18);
            String subRegionName = FileUtils.getNameWithoutExtension((String)structureFileName) + " (Converted Structure)";
            AreaSelection area = new AreaSelection();
            area.setName(subRegionName);
            subRegionName = area.createNewSubRegionBox(el.a, subRegionName);
            area.setSelectedSubRegionBox(subRegionName);
            Box box = area.getSelectedSubRegionBox();
            area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_1, el.a);
            area.setSubRegionCornerPos(box, PositionUtils.Corner.CORNER_2, template.a().a(-1, -1, -1));
            LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromWorld((axy)world, area, ignoreEntities, template.b(), feedback);
            if (litematicaSchematic == null) {
                feedback.setString("litematica.error.schematic_conversion.structure_to_litematica_failed");
            }
            return litematicaSchematic;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean convertLitematicaSchematicToSchematicaSchematic(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        return false;
    }

    @Nullable
    public static SchematicaSchematic convertLitematicaSchematicToSchematicaSchematic(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName);
        if (litematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return null;
        }
        ayd settings = new ayd(0L, axv.c, false, false, ayg.c);
        WorldSchematic world = new WorldSchematic(null, settings, bod.b, adi.c, cft.s().y);
        el size = new el(litematicaSchematic.getTotalSize());
        WorldUtils.loadChunksSchematicWorld(world, el.a, (ff)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(litematicaSchematic, el.a);
        litematicaSchematic.placeToWorld((axy)world, schematicPlacement, false);
        SchematicaSchematic schematic = SchematicaSchematic.createFromWorld((axy)world, el.a, size, ignoreEntities);
        if (schematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_create_schematic");
        }
        return schematic;
    }

    public static boolean convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, File outputDir, String outputFileName, boolean ignoreEntities, boolean override, IStringConsumer feedback) {
        bxp template = WorldUtils.convertLitematicaSchematicToVanillaStructure(inputDir, inputFileName, ignoreEntities, feedback);
        return WorldUtils.writeVanillaStructureToFile(template, outputDir, outputFileName, override, feedback);
    }

    @Nullable
    public static bxp convertLitematicaSchematicToVanillaStructure(File inputDir, String inputFileName, boolean ignoreEntities, IStringConsumer feedback) {
        LitematicaSchematic litematicaSchematic = LitematicaSchematic.createFromFile(inputDir, inputFileName);
        if (litematicaSchematic == null) {
            feedback.setString("litematica.error.schematic_conversion.litematica_to_schematic.failed_to_read_schematic");
            return null;
        }
        ayd settings = new ayd(0L, axv.c, false, false, ayg.c);
        WorldSchematic world = new WorldSchematic(null, settings, bod.b, adi.c, cft.s().y);
        el size = new el(litematicaSchematic.getTotalSize());
        WorldUtils.loadChunksSchematicWorld(world, el.a, (ff)size);
        SchematicPlacement schematicPlacement = SchematicPlacement.createForSchematicConversion(litematicaSchematic, el.a);
        litematicaSchematic.placeToWorld((axy)world, schematicPlacement, false);
        bxp template = new bxp();
        template.a((axy)world, el.a, size, !ignoreEntities, bct.io);
        return template;
    }

    private static boolean writeVanillaStructureToFile(bxp template, File dir, String fileNameIn, boolean override, IStringConsumer feedback) {
        String fileName = fileNameIn;
        String extension = ".nbt";
        if (!fileName.endsWith(extension)) {
            fileName = fileName + extension;
        }
        File file = new File(dir, fileName);
        FileOutputStream os = null;
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()}));
                return false;
            }
            if (!override && file.exists()) {
                feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exists", (Object[])new Object[]{file.getAbsolutePath()}));
                return false;
            }
            gy tag = template.a(new gy());
            os = new FileOutputStream(file);
            hi.a((gy)tag, (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            feedback.setString(StringUtils.translate((String)"litematica.error.structure_write_to_file_failed.exception", (Object[])new Object[]{file.getAbsolutePath()}));
            return false;
        }
    }

    private static bxp readTemplateFromStream(InputStream stream, DataFixer fixer) throws IOException {
        gy nbt = hi.a((InputStream)stream);
        bxp template = new bxp();
        template.b(nbt);
        return template;
    }

    public static void loadChunksSchematicWorld(WorldSchematic world, el origin, ff areaSize) {
        el posEnd = origin.a((ff)PositionUtils.getRelativeEndPositionFromAreaSize(areaSize));
        el posMin = PositionUtils.getMinCorner(origin, posEnd);
        el posMax = PositionUtils.getMaxCorner(origin, posEnd);
        int cxMin = posMin.o() >> 4;
        int czMin = posMin.q() >> 4;
        int cxMax = posMax.o() >> 4;
        int czMax = posMax.q() >> 4;
        for (int cz = czMin; cz <= czMax; ++cz) {
            for (int cx = cxMin; cx <= cxMax; ++cx) {
                world.getChunkProvider().loadChunk(cx, cz);
            }
        }
    }

    public static void setToolModeBlockState(ToolMode mode, boolean primary, cft mc) {
        ceb trace = RayTraceUtils.getRayTraceFromEntity((axy)mc.g, (aer)mc.i, true, 6.0);
        blc state = bct.a.p();
        if (trace != null && trace.a == ceb.a.b) {
            state = mc.g.a_(trace.a());
        }
        if (primary) {
            mode.setPrimaryBlock(state);
        } else {
            mode.setSecondaryBlock(state);
        }
    }

    public static boolean doSchematicWorldPickBlock(boolean closest, cft mc) {
        el pos = null;
        pos = closest ? RayTraceUtils.getSchematicWorldTraceIfClosest((axy)mc.g, (aer)mc.i, 6.0) : RayTraceUtils.getFurthestSchematicWorldTrace((axy)mc.g, (aer)mc.i, 6.0);
        if (pos != null) {
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            blc state = world.a_(pos);
            ate stack = MaterialCache.getInstance().getItemForState(state, (axy)world, pos);
            if (!stack.a()) {
                aof inv = mc.i.bB;
                if (mc.i.bV.d) {
                    bji te = world.f(pos);
                    if (GuiBase.isCtrlDown() && te != null && mc.g.c(pos)) {
                        ItemUtils.storeTEInStack(stack, te);
                    }
                    InventoryUtils.setPickedItemToHand(stack, mc);
                    mc.e.a(mc.i.b(adk.a), 36 + inv.d);
                } else {
                    boolean canPick;
                    int slot = inv.b(stack);
                    boolean shouldPick = inv.d != slot;
                    boolean bl = canPick = slot != -1;
                    if (shouldPick && canPick) {
                        InventoryUtils.setPickedItemToHand(stack, mc);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void easyPlaceOnUseTick(cft mc) {
        if (mc.i != null && Configs.Generic.EASY_PLACE_HOLD_ENABLED.getBooleanValue() && Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && Hotkeys.EASY_PLACE_ACTIVATION.getKeybind().isKeybindHeld() && KeybindMulti.isKeyDown((int)KeybindMulti.getKeyCode((cfp)mc.t.ah))) {
            WorldUtils.doEasyPlaceAction(mc);
        }
    }

    public static boolean handleEasyPlace(cft mc) {
        adm result = WorldUtils.doEasyPlaceAction(mc);
        if (result == adm.c) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.easy_place_fail", (Object[])new Object[0]);
            return true;
        }
        return result != adm.b;
    }

    private static adm doEasyPlaceAction(cft mc) {
        RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((axy)mc.g, (aer)mc.i, 6.0, true);
        if (traceWrapper == null) {
            return adm.b;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            ceb trace = traceWrapper.getRayTraceResult();
            ceb traceVanilla = RayTraceUtils.getRayTraceFromEntity((axy)mc.g, (aer)mc.i, false, 6.0);
            el pos = trace.a();
            WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
            blc stateSchematic = world.a_(pos);
            ate stack = MaterialCache.getInstance().getItemForState(stateSchematic);
            if (WorldUtils.easyPlaceIsPositionCached(pos)) {
                return adm.c;
            }
            if (!stack.a()) {
                blc stateClient = mc.g.a_(pos);
                if (stateSchematic == stateClient) {
                    return adm.c;
                }
                if (WorldUtils.easyPlaceBlockChecksCancel(stateSchematic, stateClient, (aog)mc.i, traceVanilla, stack)) {
                    return adm.c;
                }
                if (!WorldUtils.doSchematicWorldPickBlock(true, mc)) {
                    return adm.c;
                }
                adk hand = EntityUtils.getUsedHandForItem((aog)mc.i, stack);
                if (hand == null) {
                    return adm.c;
                }
                cee hitPos = trace.c;
                eq sideOrig = trace.b;
                if (traceVanilla != null && traceVanilla.a == ceb.a.b) {
                    el posVanilla = traceVanilla.a();
                    blc stateVanilla = mc.g.a_(posVanilla);
                    cee hit = trace.c;
                    ark ctx = new ark(new aup((aog)mc.i, stack, posVanilla, traceVanilla.b, (float)hit.b, (float)hit.c, (float)hit.d));
                    if (!stateVanilla.a(ctx) && pos.equals((Object)(posVanilla = posVanilla.a(traceVanilla.b)))) {
                        hitPos = traceVanilla.c;
                        sideOrig = traceVanilla.b;
                    }
                }
                eq side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                hitPos = WorldUtils.applyCarpetProtocolHitVec(pos, stateSchematic, hitPos);
                WorldUtils.cacheEasyPlacePosition(pos);
                mc.e.a(mc.i, mc.g, pos, side, hitPos, hand);
                if (stateSchematic.c() instanceof bhl && stateSchematic.c((bmm)bhl.a) == bmp.c && (stateClient = mc.g.a_(pos)).c() instanceof bhl && stateClient.c((bmm)bhl.a) != bmp.c) {
                    side = WorldUtils.applyPlacementFacing(stateSchematic, sideOrig, stateClient);
                    mc.e.a(mc.i, mc.g, pos, side, hitPos, hand);
                }
            }
            return adm.a;
        }
        if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA) {
            return WorldUtils.placementRestrictionInEffect(mc) ? adm.c : adm.b;
        }
        return adm.b;
    }

    private static boolean easyPlaceBlockChecksCancel(blc stateSchematic, blc stateClient, aog player, ceb trace, ate stack) {
        bcs blockClient;
        bcs blockSchematic = stateSchematic.c();
        if (blockSchematic instanceof bhl && stateSchematic.c((bmm)bhl.a) == bmp.c && (blockClient = stateClient.c()) instanceof bhl && stateClient.c((bmm)bhl.a) != bmp.c) {
            return blockSchematic != blockClient;
        }
        cee hit = trace.c;
        ark ctx = new ark(new aup(player, stack, trace.a(), trace.b, (float)hit.b, (float)hit.c, (float)hit.d));
        return !stateClient.a(ctx);
    }

    public static cee applyCarpetProtocolHitVec(el pos, blc state, cee hitVecIn) {
        double x = hitVecIn.b;
        double y = hitVecIn.c;
        double z = hitVecIn.d;
        bcs block = state.c();
        eq facing = BlockUtils.getFirstPropertyFacingValue((blc)state);
        if (facing != null) {
            x = facing.ordinal() + 2 + pos.o();
        }
        if (block instanceof bgz) {
            x += (double)(((Integer)state.c((bmm)bgz.o) - 1) * 10);
        } else if (block instanceof bil && state.c((bmm)bil.b) == bmi.a) {
            x += 10.0;
        } else if (block instanceof bdn && state.c((bmm)bdn.a) == bmd.b) {
            x += 10.0;
        } else if (block instanceof bhx && state.c((bmm)bhx.b) == bmi.a) {
            x += 10.0;
        } else if (block instanceof bhl && state.c((bmm)bhl.a) != bmp.c) {
            y = state.c((bmm)bhl.a) == bmp.a ? (double)pos.p() + 0.9 : (double)pos.p();
        }
        return new cee(x, y, z);
    }

    private static eq applyPlacementFacing(blc stateSchematic, eq side, blc stateClient) {
        bcs blockSchematic = stateSchematic.c();
        bcs blockClient = stateClient.c();
        if (blockSchematic instanceof bhl) {
            if (stateSchematic.c((bmm)bhl.a) == bmp.c && blockClient instanceof bhl && stateClient.c((bmm)bhl.a) != bmp.c) {
                if (stateClient.c((bmm)bhl.a) == bmp.a) {
                    return eq.a;
                }
                return eq.b;
            }
            return eq.c;
        }
        return side;
    }

    public static boolean handlePlacementRestriction(cft mc) {
        boolean cancel = WorldUtils.placementRestrictionInEffect(mc);
        if (cancel) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.placement_restriction_fail", (Object[])new Object[0]);
        }
        return cancel;
    }

    private static boolean placementRestrictionInEffect(cft mc) {
        ceb trace = mc.s;
        ate stack = mc.i.cB();
        if (stack.a()) {
            stack = mc.i.cC();
        }
        if (stack.a()) {
            return false;
        }
        if (trace != null && trace.a == ceb.a.b) {
            el pos = trace.a();
            cee hit = trace.c;
            ark ctx = new ark(new aup((aog)mc.i, stack, pos, trace.b, (float)hit.b, (float)hit.c, (float)hit.d));
            pos = ctx.a();
            blc stateClient = mc.g.a_(pos);
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            LayerRange range = DataManager.getRenderLayerRange();
            boolean schematicHasAir = worldSchematic.c(pos);
            if (!schematicHasAir && !range.isPositionWithinRange(pos)) {
                return true;
            }
            if (schematicHasAir && WorldUtils.isPositionWithinRangeOfSchematicRegions(pos, 2)) {
                return true;
            }
            ctx = new ark(new aup((aog)mc.i, stack, pos, trace.b, (float)hit.b, (float)hit.c, (float)hit.d));
            if (!stateClient.a(ctx)) {
                return true;
            }
            blc stateSchematic = worldSchematic.a_(pos);
            stack = MaterialCache.getInstance().getItemForState(stateSchematic);
            if (!stack.a() && EntityUtils.getUsedHandForItem((aog)mc.i, stack) == null) {
                return true;
            }
        }
        return false;
    }

    public static boolean isPositionWithinRangeOfSchematicRegions(el pos, int range) {
        SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
        int minCX = pos.o() - range >> 4;
        int minCY = pos.p() - range >> 4;
        int minCZ = pos.q() - range >> 4;
        int maxCX = pos.o() + range >> 4;
        int maxCY = pos.p() + range >> 4;
        int maxCZ = pos.q() + range >> 4;
        int x = pos.o();
        int y = pos.p();
        int z = pos.q();
        for (int cy = minCY; cy <= maxCY; ++cy) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                for (int cx = minCX; cx <= maxCX; ++cx) {
                    List<IntBoundingBox> boxes = manager.getTouchedBoxesInSubChunk(new SubChunkPos(cx, cy, cz));
                    for (int i = 0; i < boxes.size(); ++i) {
                        IntBoundingBox box = boxes.get(i);
                        if (x < box.minX - range || x > box.maxX + range || y < box.minY - range || y > box.maxY + range || z < box.minZ - range || z > box.maxZ + range) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isSliceEmpty(axy world, eq.a axis, el pos1, el pos2) {
        switch (axis) {
            case c: {
                int x1 = Math.min(pos1.o(), pos2.o());
                int x2 = Math.max(pos1.o(), pos2.o());
                int y1 = Math.min(pos1.p(), pos2.p());
                int y2 = Math.max(pos1.p(), pos2.p());
                int z = pos1.q();
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                for (int cx = cxMin; cx <= cxMax; ++cx) {
                    bnj chunk = world.c(cx, z >> 4);
                    int xMin = Math.max(x1, cx << 4);
                    int xMax = Math.min(x2, (cx << 4) + 15);
                    int yMax = Math.min(y2, chunk.b() + 15);
                    for (int x = xMin; x <= xMax; ++x) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.a(x, y, z).f()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
            case b: {
                int x1 = Math.min(pos1.o(), pos2.o());
                int x2 = Math.max(pos1.o(), pos2.o());
                int y = pos1.p();
                int z1 = Math.min(pos1.q(), pos2.q());
                int z2 = Math.max(pos1.q(), pos2.q());
                int cxMin = x1 >> 4;
                int cxMax = x2 >> 4;
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    for (int cx = cxMin; cx <= cxMax; ++cx) {
                        bnj chunk = world.c(cx, cz);
                        if (y > chunk.b() + 15) continue;
                        int xMin = Math.max(x1, cx << 4);
                        int xMax = Math.min(x2, (cx << 4) + 15);
                        int zMin = Math.max(z1, cz << 4);
                        int zMax = Math.min(z2, (cz << 4) + 15);
                        for (int z = zMin; z <= zMax; ++z) {
                            for (int x = xMin; x <= xMax; ++x) {
                                if (chunk.a(x, y, z).f()) continue;
                                return false;
                            }
                        }
                    }
                }
                break;
            }
            case a: {
                int x = pos1.o();
                int z1 = Math.min(pos1.q(), pos2.q());
                int z2 = Math.max(pos1.q(), pos2.q());
                int y1 = Math.min(pos1.p(), pos2.p());
                int y2 = Math.max(pos1.p(), pos2.p());
                int czMin = z1 >> 4;
                int czMax = z2 >> 4;
                for (int cz = czMin; cz <= czMax; ++cz) {
                    bnj chunk = world.c(x >> 4, cz);
                    int zMin = Math.max(z1, cz << 4);
                    int zMax = Math.min(z2, (cz << 4) + 15);
                    int yMax = Math.min(y2, chunk.b() + 15);
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = y1; y <= yMax; ++y) {
                            if (chunk.a(x, y, z).f()) continue;
                            return false;
                        }
                    }
                }
                break;
            }
        }
        return true;
    }

    public static boolean easyPlaceIsPositionCached(el pos) {
        long currentTime = System.nanoTime();
        boolean cached = false;
        for (int i = 0; i < EASY_PLACE_POSITIONS.size(); ++i) {
            PositionCache val = EASY_PLACE_POSITIONS.get(i);
            boolean expired = val.hasExpired(currentTime);
            if (expired) {
                EASY_PLACE_POSITIONS.remove(i);
                --i;
                continue;
            }
            if (!val.getPos().equals((Object)pos)) continue;
            cached = true;
            if (EASY_PLACE_POSITIONS.size() < 16) break;
        }
        return cached;
    }

    private static void cacheEasyPlacePosition(el pos) {
        EASY_PLACE_POSITIONS.add(new PositionCache(pos, System.nanoTime(), 2000000000L));
    }

    public static class PositionCache {
        private final el pos;
        private final long time;
        private final long timeout;

        private PositionCache(el pos, long time, long timeout) {
            this.pos = pos;
            this.time = time;
            this.timeout = timeout;
        }

        public el getPos() {
            return this.pos;
        }

        public boolean hasExpired(long currentTime) {
            return currentTime - this.time > this.timeout;
        }
    }
}

