/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.interfaces.IMixinChunkProviderClient;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;

public class SchematicWorldRefresher
implements IRangeChangeListener {
    public static final SchematicWorldRefresher INSTANCE = new SchematicWorldRefresher();
    private final cft mc = cft.s();

    public void updateAll() {
        this.updateBetweenY(0, 255);
    }

    public void updateBetweenX(int minX, int maxX) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            int xMin = Math.min(minX, maxX);
            int xMax = Math.max(minX, maxX);
            int cxMin = xMin >> 4;
            int cxMax = xMax >> 4;
            WorldRendererSchematic renderer = LitematicaRenderer.getInstance().getWorldRenderer();
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            Long2ObjectMap<bnj> clientChunks = ((IMixinChunkProviderClient)this.mc.g.i()).getLoadedChunks();
            for (bnj chunk : schematicChunks.values()) {
                if (chunk.b < cxMin || chunk.b > cxMax || chunk.s() || !clientChunks.containsKey(axm.a((int)chunk.b, (int)chunk.c))) continue;
                minX = Math.max(chunk.b << 4, xMin);
                maxX = Math.min((chunk.b << 4) + 15, xMax);
                renderer.a(minX, 0, chunk.c << 4, maxX, 255, (chunk.c << 4) + 15);
            }
        }
    }

    public void updateBetweenY(int minY, int maxY) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            WorldRendererSchematic renderer = LitematicaRenderer.getInstance().getWorldRenderer();
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            Long2ObjectMap<bnj> clientChunks = ((IMixinChunkProviderClient)this.mc.g.i()).getLoadedChunks();
            for (bnj chunk : schematicChunks.values()) {
                if (chunk.s() || !clientChunks.containsKey(axm.a((int)chunk.b, (int)chunk.c))) continue;
                renderer.a(chunk.b << 4, minY, chunk.c << 4, (chunk.b << 4) + 15, maxY, (chunk.c << 4) + 15);
            }
        }
    }

    public void updateBetweenZ(int minZ, int maxZ) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            int zMin = Math.min(minZ, maxZ);
            int zMax = Math.max(minZ, maxZ);
            int czMin = zMin >> 4;
            int czMax = zMax >> 4;
            WorldRendererSchematic renderer = LitematicaRenderer.getInstance().getWorldRenderer();
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            Long2ObjectMap<bnj> clientChunks = ((IMixinChunkProviderClient)this.mc.g.i()).getLoadedChunks();
            for (bnj chunk : schematicChunks.values()) {
                if (chunk.c < czMin || chunk.c > czMax || chunk.s() || !clientChunks.containsKey(axm.a((int)chunk.b, (int)chunk.c))) continue;
                minZ = Math.max(chunk.c << 4, zMin);
                maxZ = Math.min((chunk.c << 4) + 15, zMax);
                renderer.a(chunk.b << 4, 0, minZ, (chunk.b << 4) + 15, 255, maxZ);
            }
        }
    }

    public void markSchematicChunksForRenderUpdate(axm chunkPos) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            Long2ObjectMap<bnj> clientChunks = ((IMixinChunkProviderClient)this.mc.g.i()).getLoadedChunks();
            long key = axm.a((int)chunkPos.a, (int)chunkPos.b);
            if (schematicChunks.containsKey(key) && clientChunks.containsKey(key)) {
                WorldRendererSchematic renderer = LitematicaRenderer.getInstance().getWorldRenderer();
                renderer.a(chunkPos.a << 4, 0, chunkPos.b << 4, (chunkPos.a << 4) + 15, 255, (chunkPos.b << 4) + 15);
            }
        }
    }

    public void markSchematicChunkForRenderUpdate(el pos) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world != null) {
            Long2ObjectMap<ChunkSchematic> schematicChunks = world.getChunkProvider().getLoadedChunks();
            Long2ObjectMap<bnj> clientChunks = ((IMixinChunkProviderClient)this.mc.g.i()).getLoadedChunks();
            long key = axm.a((int)(pos.o() >> 4), (int)(pos.q() >> 4));
            if (schematicChunks.containsKey(key) && clientChunks.containsKey(key)) {
                WorldRendererSchematic renderer = LitematicaRenderer.getInstance().getWorldRenderer();
                renderer.a(pos.o(), pos.p(), pos.q(), pos.o(), pos.p(), pos.q());
            }
        }
    }
}

