/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.gui.GuiSchematicSave;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.scheduler.tasks.TaskDeleteArea;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicDirect;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicSetblock;
import fi.dy.masa.litematica.scheduler.tasks.TaskSaveSchematic;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.schematic.projects.SchematicProject;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiTextInput;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class SchematicUtils {
    private static long areaMovedTime;

    public static boolean saveSchematic(boolean inMemoryOnly) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null) {
            if (DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                String title = "litematica.gui.title.schematic_projects.save_new_version";
                SchematicProject project = DataManager.getSchematicProjectsManager().getCurrentProject();
                GuiTextInput gui = new GuiTextInput(512, title, project.getCurrentVersionName(), GuiUtils.getCurrentScreen(), (IStringConsumerFeedback)new SchematicVersionCreator());
                GuiBase.openGui((ckd)gui);
            } else if (inMemoryOnly) {
                String title = "litematica.gui.title.create_in_memory_schematic";
                GuiTextInput gui = new GuiTextInput(512, title, area.getName(), GuiUtils.getCurrentScreen(), (IStringConsumer)new GuiSchematicSave.InMemorySchematicCreator(area));
                GuiBase.openGui((ckd)gui);
            } else {
                GuiSchematicSave gui = new GuiSchematicSave();
                gui.setParent(GuiUtils.getCurrentScreen());
                GuiBase.openGui((ckd)gui);
            }
            return true;
        }
        return false;
    }

    public static void unloadCurrentlySelectedSchematic() {
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (placement != null) {
            SchematicHolder.getInstance().removeSchematic(placement.getSchematic());
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
        }
    }

    public static boolean breakSchematicBlock(cft mc) {
        return SchematicUtils.setTargetedSchematicBlockState(mc, bct.a.p());
    }

    public static boolean placeSchematicBlock(cft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            el pos = info.pos.a(info.side);
            if (DataManager.getRenderLayerRange().isPositionWithinRange(pos)) {
                return SchematicUtils.setTargetedSchematicBlockState(pos, info.stateNew);
            }
        }
        return false;
    }

    public static boolean replaceSchematicBlocksInDirection(cft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            eq playerFacingH = mc.i.bA();
            eq direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((eq)info.side, (eq)playerFacingH, (el)info.pos, (cee)info.hitVec);
            if (direction == info.side) {
                direction = direction.d();
            }
            el posEnd = SchematicUtils.getReplacementBoxEndPos(info.pos, direction);
            return SchematicUtils.setSchematicBlockStates(info.pos, posEnd, info.stateNew);
        }
        return false;
    }

    public static boolean replaceAllIdenticalSchematicBlocks(cft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            return SchematicUtils.setAllIdenticalSchematicBlockStates(info.pos, info.stateOriginal, info.stateNew);
        }
        return false;
    }

    public static boolean breakSchematicBlocks(cft mc) {
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((axy)mc.g, (aer)mc.i, 10.0);
        if (wrapper != null) {
            ceb trace = wrapper.getRayTraceResult();
            el pos = trace.a();
            eq playerFacingH = mc.i.bA();
            eq direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((eq)trace.b, (eq)playerFacingH, (el)pos, (cee)trace.c);
            if (direction == trace.b) {
                direction = direction.d();
            }
            el posEnd = SchematicUtils.getReplacementBoxEndPos(pos, direction);
            return SchematicUtils.setSchematicBlockStates(pos, posEnd, bct.a.p());
        }
        return false;
    }

    public static boolean breakAllIdenticalSchematicBlocks(cft mc) {
        RayTraceUtils.RayTraceWrapper wrapper = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest((axy)mc.g, (aer)mc.i, 10.0);
        if (wrapper != null) {
            ceb trace = wrapper.getRayTraceResult();
            el pos = trace.a();
            blc stateOriginal = SchematicWorldHandler.getSchematicWorld().a_(pos);
            return SchematicUtils.setAllIdenticalSchematicBlockStates(pos, stateOriginal, bct.a.p());
        }
        return false;
    }

    public static boolean placeSchematicBlocksInDirection(cft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            eq playerFacingH = mc.i.bA();
            eq direction = fi.dy.masa.malilib.util.PositionUtils.getTargetedDirection((eq)info.side, (eq)playerFacingH, (el)info.pos, (cee)info.hitVec);
            el posStart = info.pos.a(info.side);
            if (SchematicWorldHandler.getSchematicWorld().a_(posStart).f()) {
                el posEnd = SchematicUtils.getReplacementBoxEndPos(posStart, direction);
                return SchematicUtils.setSchematicBlockStates(posStart, posEnd, info.stateNew);
            }
        }
        return false;
    }

    public static boolean fillAirWithBlocks(cft mc) {
        ReplacementInfo info = SchematicUtils.getTargetInfo(mc);
        if (info != null && info.stateNew != null) {
            el posStart = info.pos.a(info.side);
            if (SchematicWorldHandler.getSchematicWorld().a_(posStart).f()) {
                return SchematicUtils.setAllIdenticalSchematicBlockStates(posStart, bct.a.p(), info.stateNew);
            }
        }
        return false;
    }

    @Nullable
    private static ReplacementInfo getTargetInfo(cft mc) {
        ate stack = mc.i.cB();
        if (!stack.a() && stack.b() instanceof arj) {
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((axy)mc.g, (aer)mc.i, 10.0, true);
            if (worldSchematic != null && traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
                ceb trace = traceWrapper.getRayTraceResult();
                eq side = trace.b;
                cee hitVec = trace.c;
                el pos = trace.a();
                blc stateOriginal = worldSchematic.a_(pos);
                blc stateNew = bct.a.p();
                if (stack.b() instanceof arj) {
                    axy worldClient = mc.i.m;
                    mc.i.m = worldSchematic;
                    ark ctx = new ark(new aup((aog)mc.i, stack, pos.a(side), side, (float)hitVec.b, (float)hitVec.c, (float)hitVec.d));
                    mc.i.m = worldClient;
                    stateNew = ((arj)stack.b()).d().a(ctx);
                }
                return new ReplacementInfo(pos, side, hitVec, stateOriginal, stateNew);
            }
        }
        return null;
    }

    private static el getReplacementBoxEndPos(el startPos, eq direction) {
        return SchematicUtils.getReplacementBoxEndPos(startPos, direction, 10000);
    }

    private static el getReplacementBoxEndPos(el startPos, eq direction, int maxBlocks) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        LayerRange range = DataManager.getRenderLayerRange();
        blc stateStart = world.a_(startPos);
        el.a posMutable = new el.a(startPos);
        while (maxBlocks-- > 0) {
            posMutable.c(direction);
            if (range.isPositionWithinRange((el)posMutable) && world.getChunkProvider().isChunkLoaded(posMutable.o() >> 4, posMutable.q() >> 4) && world.a_((el)posMutable) == stateStart) continue;
            posMutable.c(direction.d());
            break;
        }
        return posMutable.h();
    }

    public static boolean setTargetedSchematicBlockState(cft mc, blc state) {
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        RayTraceUtils.RayTraceWrapper traceWrapper = RayTraceUtils.getGenericTrace((axy)mc.g, (aer)mc.i, 6.0, true);
        if (world != null && traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            ceb trace = traceWrapper.getRayTraceResult();
            el pos = trace.a();
            return SchematicUtils.setTargetedSchematicBlockState(pos, state);
        }
        return false;
    }

    private static boolean setTargetedSchematicBlockState(el pos, blc state) {
        if (pos != null) {
            SubChunkPos cpos = new SubChunkPos(pos);
            List<SchematicPlacementManager.PlacementPart> list = DataManager.getSchematicPlacementManager().getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((ff)pos)) continue;
                    SchematicPlacement placement = part.getPlacement();
                    String regionName = part.getSubRegionName();
                    LitematicaBlockStateContainer container = placement.getSchematic().getSubRegionContainer(regionName);
                    el posSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(pos, placement.getSchematic(), regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    if (posSchematic != null) {
                        state = SchematicUtils.getUntransformedBlockState(state, placement, regionName);
                        blc stateOriginal = container.get(posSchematic.o(), posSchematic.p(), posSchematic.q());
                        int totalBlocks = part.getPlacement().getSchematic().getMetadata().getTotalBlocks();
                        int increment = 0;
                        increment = !stateOriginal.f() ? (!state.f() ? 0 : -1) : (!state.f() ? 1 : 0);
                        container.set(posSchematic.o(), posSchematic.p(), posSchematic.q(), state);
                        part.getPlacement().getSchematic().getMetadata().setTotalBlocks(totalBlocks += increment);
                        DataManager.getSchematicPlacementManager().markChunkForRebuild(new axm(cpos.o(), cpos.q()));
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setSchematicBlockStates(el posStart, el posEnd, blc state) {
        if (posStart != null && posEnd != null) {
            SubChunkPos cpos = new SubChunkPos(posStart);
            List<SchematicPlacementManager.PlacementPart> list = DataManager.getSchematicPlacementManager().getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((ff)posStart)) continue;
                    SchematicPlacement placement = part.getPlacement();
                    String regionName = part.getSubRegionName();
                    LitematicaBlockStateContainer container = placement.getSchematic().getSubRegionContainer(regionName);
                    el posStartSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(posStart, placement.getSchematic(), regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    el posEndSchematic = SchematicUtils.getSchematicContainerPositionFromWorldPosition(posEnd, placement.getSchematic(), regionName, placement, placement.getRelativeSubRegionPlacement(regionName), container);
                    if (posStartSchematic != null && posEndSchematic != null) {
                        el posMin = PositionUtils.getMinCorner(posStartSchematic, posEndSchematic);
                        el posMax = PositionUtils.getMaxCorner(posStartSchematic, posEndSchematic);
                        int minX = Math.max(posMin.o(), 0);
                        int minY = Math.max(posMin.p(), 0);
                        int minZ = Math.max(posMin.q(), 0);
                        int maxX = Math.min(posMax.o(), container.getSize().o() - 1);
                        int maxY = Math.min(posMax.p(), container.getSize().p() - 1);
                        int maxZ = Math.min(posMax.q(), container.getSize().q() - 1);
                        int totalBlocks = part.getPlacement().getSchematic().getMetadata().getTotalBlocks();
                        int increment = 0;
                        state = SchematicUtils.getUntransformedBlockState(state, placement, regionName);
                        for (int y = minY; y <= maxY; ++y) {
                            for (int z = minZ; z <= maxZ; ++z) {
                                for (int x = minX; x <= maxX; ++x) {
                                    blc stateOriginal = container.get(x, y, z);
                                    increment = !stateOriginal.f() ? (!state.f() ? 0 : -1) : (!state.f() ? 1 : 0);
                                    totalBlocks += increment;
                                    container.set(x, y, z, state);
                                }
                            }
                        }
                        part.getPlacement().getSchematic().getMetadata().setTotalBlocks(totalBlocks);
                        DataManager.getSchematicPlacementManager().markAllPlacementsOfSchematicForRebuild(placement.getSchematic());
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean setAllIdenticalSchematicBlockStates(el posStart, blc stateOriginal, blc stateNew) {
        if (posStart != null) {
            SubChunkPos cpos = new SubChunkPos(posStart);
            SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
            List<SchematicPlacementManager.PlacementPart> list = manager.getAllPlacementsTouchingSubChunk(cpos);
            if (!list.isEmpty()) {
                for (SchematicPlacementManager.PlacementPart part : list) {
                    if (!part.getBox().containsPos((ff)posStart)) continue;
                    if (SchematicUtils.replaceAllIdenticalBlocks(manager, part, stateOriginal, stateNew)) {
                        manager.markAllPlacementsOfSchematicForRebuild(part.getPlacement().getSchematic());
                        return true;
                    }
                    return false;
                }
            }
        }
        return false;
    }

    private static boolean replaceAllIdenticalBlocks(SchematicPlacementManager manager, SchematicPlacementManager.PlacementPart part, blc stateOriginalIn, blc stateNewIn) {
        SchematicPlacement schematicPlacement = part.getPlacement();
        String selected = schematicPlacement.getSelectedSubRegionName();
        ArrayList<String> regions = new ArrayList<String>();
        if (selected != null) {
            regions.add(selected);
        } else if (manager.getSelectedSchematicPlacement() == schematicPlacement) {
            regions.addAll((Collection<String>)schematicPlacement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).keySet());
        } else {
            InfoUtils.showInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)20000, (String)"litematica.message.warn.schematic_rebuild_placement_not_selected", (Object[])new Object[0]);
            return false;
        }
        LayerRange range = DataManager.getRenderLayerRange();
        int totalBlocks = schematicPlacement.getSchematic().getMetadata().getTotalBlocks();
        int increment = 0;
        increment = !stateOriginalIn.f() ? (!stateNewIn.f() ? 0 : -1) : (!stateNewIn.f() ? 1 : 0);
        for (String regionName : regions) {
            LitematicaBlockStateContainer container = schematicPlacement.getSchematic().getSubRegionContainer(regionName);
            SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
            if (container == null || placement == null) continue;
            int minX = range.getClampedValue(LayerRange.getWorldMinValueForAxis((eq.a)eq.a.a), eq.a.a);
            int minY = range.getClampedValue(LayerRange.getWorldMinValueForAxis((eq.a)eq.a.b), eq.a.b);
            int minZ = range.getClampedValue(LayerRange.getWorldMinValueForAxis((eq.a)eq.a.c), eq.a.c);
            int maxX = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((eq.a)eq.a.a), eq.a.a);
            int maxY = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((eq.a)eq.a.b), eq.a.b);
            int maxZ = range.getClampedValue(LayerRange.getWorldMaxValueForAxis((eq.a)eq.a.c), eq.a.c);
            el posStart = new el(minX, minY, minZ);
            el posEnd = new el(maxX, maxY, maxZ);
            el pos1 = SchematicUtils.getReverserTransformedWorldPosition(posStart, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            el pos2 = SchematicUtils.getReverserTransformedWorldPosition(posEnd, schematicPlacement.getSchematic(), regionName, schematicPlacement, schematicPlacement.getRelativeSubRegionPlacement(regionName));
            if (pos1 == null || pos2 == null) {
                return false;
            }
            el posStartWorld = PositionUtils.getMinCorner(pos1, pos2);
            el posEndWorld = PositionUtils.getMaxCorner(pos1, pos2);
            ff size = container.getSize();
            int startX = Math.max(posStartWorld.o(), 0);
            int startY = Math.max(posStartWorld.p(), 0);
            int startZ = Math.max(posStartWorld.q(), 0);
            int endX = Math.min(posEndWorld.o(), size.o() - 1);
            int endY = Math.min(posEndWorld.p(), size.p() - 1);
            int endZ = Math.min(posEndWorld.q(), size.q() - 1);
            if (startX < 0 || startY < 0 || startZ < 0 || endX >= size.o() || endY >= size.p() || endZ >= size.q()) {
                System.out.printf("OUT OF BOUNDS == region: %s, sx: %d, sy: %s, sz: %d, ex: %d, ey: %d, ez: %d - size x: %d y: %d z: %d =============\n", regionName, startX, startY, startZ, endX, endY, endZ, size.o(), size.p(), size.q());
                return false;
            }
            blc stateOriginal = SchematicUtils.getUntransformedBlockState(stateOriginalIn, schematicPlacement, regionName);
            blc stateNew = SchematicUtils.getUntransformedBlockState(stateNewIn, schematicPlacement, regionName);
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        if (container.get(x, y, z) != stateOriginal) continue;
                        container.set(x, y, z, stateNew);
                        totalBlocks += increment;
                    }
                }
            }
        }
        schematicPlacement.getSchematic().getMetadata().setTotalBlocks(totalBlocks);
        return true;
    }

    public static void moveCurrentlySelectedWorldRegionToLookingDirection(int amount, aog player, cft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            el pos = area.getEffectiveOrigin().a(EntityUtils.getClosestLookingDirection((aer)player), amount);
            SchematicUtils.moveCurrentlySelectedWorldRegionTo(pos, mc);
        }
    }

    public static void moveCurrentlySelectedWorldRegionTo(el pos, cft mc) {
        if (mc.i == null || !mc.i.bV.d) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.generic.creative_mode_only", (Object[])new Object[0]);
            return;
        }
        TaskScheduler scheduler = TaskScheduler.getServerInstanceIfExistsOrClient();
        long currentTime = System.currentTimeMillis();
        if (currentTime - areaMovedTime < 400L || scheduler.hasTask(TaskSaveSchematic.class) || scheduler.hasTask(TaskDeleteArea.class) || scheduler.hasTask(TaskPasteSchematicSetblock.class) || scheduler.hasTask(TaskPasteSchematicDirect.class)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.move.pending_tasks", (Object[])new Object[0]);
            return;
        }
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(area, "");
            TaskSaveSchematic taskSave = new TaskSaveSchematic(schematic, area, true);
            taskSave.disableCompletionMessage();
            areaMovedTime = System.currentTimeMillis();
            taskSave.setCompletionListener(() -> {
                SchematicPlacement placement = SchematicPlacement.createFor(schematic, pos, "-", true, true);
                DataManager.getSchematicPlacementManager().addSchematicPlacement(placement, false);
                TaskDeleteArea taskDelete = new TaskDeleteArea(area.getAllSubRegionBoxes(), true);
                taskDelete.disableCompletionMessage();
                areaMovedTime = System.currentTimeMillis();
                taskDelete.setCompletionListener(() -> {
                    TaskBase taskPaste = mc.x() ? new TaskPasteSchematicDirect(placement) : new TaskPasteSchematicSetblock(placement, false);
                    taskPaste.disableCompletionMessage();
                    areaMovedTime = System.currentTimeMillis();
                    taskPaste.setCompletionListener(() -> {
                        SchematicHolder.getInstance().removeSchematic(schematic);
                        area.moveEntireSelectionTo(pos, false);
                        areaMovedTime = System.currentTimeMillis();
                    });
                    scheduler.scheduleTask(taskPaste, 1);
                });
                scheduler.scheduleTask(taskDelete, 1);
            });
            scheduler.scheduleTask(taskSave, 1);
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
        }
    }

    public static void cloneSelectionArea(cft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        if (area != null && area.getAllSubRegionBoxes().size() > 0) {
            LitematicaSchematic schematic = LitematicaSchematic.createEmptySchematic(area, mc.i.N_().getString());
            TaskSaveSchematic taskSave = new TaskSaveSchematic(schematic, area, true);
            taskSave.disableCompletionMessage();
            taskSave.setCompletionListener(() -> {
                SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
                String name = schematic.getMetadata().getName();
                el origin = RayTraceUtils.getTargetedPosition((axy)mc.g, (aog)mc.i, 6.0, false);
                if (origin == null) {
                    origin = new el((aer)mc.i);
                }
                SchematicPlacement placement = SchematicPlacement.createFor(schematic, origin, name, true, true);
                manager.addSchematicPlacement(placement, false);
                manager.setSelectedSchematicPlacement(placement);
                if (mc.i.bV.d) {
                    DataManager.setToolMode(ToolMode.PASTE_SCHEMATIC);
                }
            });
            TaskScheduler.getServerInstanceIfExistsOrClient().scheduleTask(taskSave, 10);
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
        }
    }

    @Nullable
    public static el getSchematicContainerPositionFromWorldPosition(el worldPos, LitematicaSchematic schematic, String regionName, SchematicPlacement schematicPlacement, SubRegionPlacement regionPlacement, LitematicaBlockStateContainer container) {
        el boxMinRel = SchematicUtils.getReverserTransformedWorldPosition(worldPos, schematic, regionName, schematicPlacement, regionPlacement);
        if (boxMinRel == null) {
            return null;
        }
        int startX = boxMinRel.o();
        int startY = boxMinRel.p();
        int startZ = boxMinRel.q();
        ff size = container.getSize();
        return new el(xq.a((int)startX, (int)0, (int)(size.o() - 1)), xq.a((int)startY, (int)0, (int)(size.p() - 1)), xq.a((int)startZ, (int)0, (int)(size.q() - 1)));
    }

    @Nullable
    private static el getReverserTransformedWorldPosition(el worldPos, LitematicaSchematic schematic, String regionName, SchematicPlacement schematicPlacement, SubRegionPlacement regionPlacement) {
        el origin = schematicPlacement.getOrigin();
        el regionPos = regionPlacement.getPos();
        el regionSize = schematic.getAreaSize(regionName);
        if (regionSize == null) {
            return null;
        }
        el posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((ff)regionSize).a((ff)regionPos);
        el posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        el regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        el relPos = new el(worldPos.o() - origin.o() - regionPosTransformed.o(), worldPos.p() - origin.p() - regionPosTransformed.p(), worldPos.q() - origin.q() - regionPosTransformed.q());
        relPos = PositionUtils.getReverseTransformedBlockPos(relPos, regionPlacement.getMirror(), regionPlacement.getRotation());
        relPos = PositionUtils.getReverseTransformedBlockPos(relPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        relPos = relPos.b((ff)posMinRel.b((ff)regionPos));
        return relPos;
    }

    public static blc getUntransformedBlockState(blc state, SchematicPlacement schematicPlacement, String subRegionName) {
        SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(subRegionName);
        if (placement != null) {
            bhb rotationCombined = PositionUtils.getReverseRotation(schematicPlacement.getRotation().a(placement.getRotation()));
            bfz mirrorMain = schematicPlacement.getMirror();
            bfz mirrorSub = placement.getMirror();
            if (mirrorSub != bfz.a && (schematicPlacement.getRotation() == bhb.b || schematicPlacement.getRotation() == bhb.d)) {
                bfz bfz2 = mirrorSub = mirrorSub == bfz.c ? bfz.b : bfz.c;
            }
            if (rotationCombined != bhb.a) {
                state = state.a(rotationCombined);
            }
            if (mirrorSub != bfz.a) {
                state = state.a(mirrorSub);
            }
            if (mirrorMain != bfz.a) {
                state = state.a(mirrorMain);
            }
        }
        return state;
    }

    public static class SchematicVersionCreator
    implements IStringConsumerFeedback {
        public boolean setString(String string) {
            return DataManager.getSchematicProjectsManager().commitNewVersion(string);
        }
    }

    private static class ReplacementInfo {
        public final el pos;
        public final eq side;
        public final cee hitVec;
        public final blc stateOriginal;
        public final blc stateNew;

        public ReplacementInfo(el pos, eq side, cee hitVec, blc stateOriginal, blc stateNew) {
            this.pos = pos;
            this.side = side;
            this.hitVec = hitVec;
            this.stateOriginal = stateOriginal;
            this.stateNew = stateNew;
        }
    }
}

