/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.LayerRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RayTraceUtils {
    private static RayTraceWrapper closestBox;
    private static RayTraceWrapper closestCorner;
    private static RayTraceWrapper closestOrigin;
    private static double closestBoxDistance;
    private static double closestCornerDistance;
    private static double closestOriginDistance;
    private static RayTraceWrapper.HitType originType;

    @Nullable
    public static el getTargetedPosition(axy world, aog player, double maxDistance, boolean sneakToOffset) {
        ceb trace = RayTraceUtils.getRayTraceFromEntity(world, (aer)player, false, maxDistance);
        if (trace.a != ceb.a.b) {
            return null;
        }
        el pos = trace.a();
        if (sneakToOffset == player.aZ()) {
            pos = pos.a(trace.b);
        }
        return pos;
    }

    @Nonnull
    public static RayTraceWrapper getWrappedRayTraceFromEntity(axy world, aer entity, double range) {
        cee eyesPos = entity.i(1.0f);
        cee rangedLookRot = entity.f(1.0f).a(range);
        cee lookEndPos = eyesPos.e(rangedLookRot);
        ceb result = RayTraceUtils.getRayTraceFromEntity(world, entity, false, range);
        double closestVanilla = result.a != ceb.a.a ? result.c.f(eyesPos) : -1.0;
        AreaSelection area = DataManager.getSelectionManager().getCurrentSelection();
        RayTraceWrapper wrapper = null;
        RayTraceUtils.clearTraceVars();
        if (!DataManager.getToolMode().getUsesSchematic() && area != null) {
            for (Box box : area.getAllSubRegionBoxes()) {
                boolean hitCorner = false;
                hitCorner |= RayTraceUtils.traceToSelectionBoxCorner(box, PositionUtils.Corner.CORNER_1, eyesPos, lookEndPos);
                if (hitCorner |= RayTraceUtils.traceToSelectionBoxCorner(box, PositionUtils.Corner.CORNER_2, eyesPos, lookEndPos)) continue;
                RayTraceUtils.traceToSelectionBoxBody(box, eyesPos, lookEndPos);
            }
            el origin = area.getExplicitOrigin();
            if (origin != null) {
                RayTraceUtils.traceToOrigin(origin, eyesPos, lookEndPos, RayTraceWrapper.HitType.SELECTION_ORIGIN, null);
            }
        }
        if (DataManager.getToolMode().getUsesSchematic()) {
            for (SchematicPlacement placement : DataManager.getSchematicPlacementManager().getAllSchematicsPlacements()) {
                if (!placement.isEnabled()) continue;
                RayTraceUtils.traceToPlacementBox(placement, eyesPos, lookEndPos);
                RayTraceUtils.traceToOrigin(placement.getOrigin(), eyesPos, lookEndPos, RayTraceWrapper.HitType.PLACEMENT_ORIGIN, placement);
            }
        }
        double closestDistance = closestVanilla;
        if (closestBoxDistance >= 0.0 && (closestVanilla < 0.0 || closestBoxDistance <= closestVanilla)) {
            closestDistance = closestBoxDistance;
            wrapper = closestBox;
        }
        if (closestCornerDistance >= 0.0 && (closestVanilla < 0.0 || closestCornerDistance <= closestVanilla)) {
            closestDistance = closestCornerDistance;
            wrapper = closestCorner;
        }
        if (closestOriginDistance >= 0.0 && (closestVanilla < 0.0 || closestOriginDistance <= closestVanilla)) {
            closestDistance = closestOriginDistance;
            wrapper = originType == RayTraceWrapper.HitType.PLACEMENT_ORIGIN ? closestOrigin : new RayTraceWrapper(RayTraceWrapper.HitType.SELECTION_ORIGIN);
        }
        RayTraceUtils.clearTraceVars();
        if (wrapper == null || closestDistance < 0.0) {
            wrapper = new RayTraceWrapper();
        }
        return wrapper;
    }

    private static void clearTraceVars() {
        closestBox = null;
        closestCorner = null;
        closestOrigin = null;
        closestBoxDistance = -1.0;
        closestCornerDistance = -1.0;
        closestOriginDistance = -1.0;
    }

    private static boolean traceToSelectionBoxCorner(Box box, PositionUtils.Corner corner, cee start, cee end) {
        cea bb;
        ceb hit;
        el pos;
        Object object = corner == PositionUtils.Corner.CORNER_1 ? box.getPos1() : (pos = corner == PositionUtils.Corner.CORNER_2 ? box.getPos2() : null);
        if (pos != null && (hit = (bb = PositionUtils.createAABBForPosition(pos)).b(start, end)) != null) {
            double dist = hit.c.f(start);
            if (closestCornerDistance < 0.0 || dist < closestCornerDistance) {
                closestCornerDistance = dist;
                closestCorner = new RayTraceWrapper(box, corner, hit.c);
            }
            return true;
        }
        return false;
    }

    private static boolean traceToSelectionBoxBody(Box box, cee start, cee end) {
        cea bb;
        ceb hit;
        if (box.getPos1() != null && box.getPos2() != null && (hit = (bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2())).b(start, end)) != null) {
            double dist = hit.c.f(start);
            if (closestBoxDistance < 0.0 || dist < closestBoxDistance) {
                closestBoxDistance = dist;
                closestBox = new RayTraceWrapper(box, PositionUtils.Corner.NONE, hit.c);
            }
            return true;
        }
        return false;
    }

    private static boolean traceToPlacementBox(SchematicPlacement placement, cee start, cee end) {
        ImmutableMap<String, Box> boxes = placement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED);
        boolean hitSomething = false;
        for (Map.Entry entry : boxes.entrySet()) {
            cea bb;
            ceb trace;
            String boxName = (String)entry.getKey();
            Box box = (Box)entry.getValue();
            if (box.getPos1() == null || box.getPos2() == null || (trace = (bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2())).b(start, end)) == null) continue;
            double dist = trace.c.f(start);
            if (!(closestBoxDistance < 0.0) && !(dist < closestBoxDistance)) continue;
            closestBoxDistance = dist;
            closestBox = new RayTraceWrapper(placement, trace.c, boxName);
            hitSomething = true;
        }
        return hitSomething;
    }

    private static boolean traceToOrigin(el pos, cee start, cee end, RayTraceWrapper.HitType type, @Nullable SchematicPlacement placement) {
        cea bb;
        ceb trace;
        if (pos != null && (trace = (bb = PositionUtils.createAABBForPosition(pos)).b(start, end)) != null) {
            double dist = trace.c.f(start);
            if (closestOriginDistance < 0.0 || dist < closestOriginDistance) {
                closestOriginDistance = dist;
                originType = type;
                if (type == RayTraceWrapper.HitType.PLACEMENT_ORIGIN) {
                    closestOrigin = new RayTraceWrapper(placement, trace.c, null);
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static ceb traceToPositions(List<el> posList, aer entity, double range) {
        if (posList.isEmpty()) {
            return null;
        }
        cee eyesPos = entity.i(1.0f);
        cee rangedLookRot = entity.f(1.0f).a(range);
        cee lookEndPos = eyesPos.e(rangedLookRot);
        double closest = -1.0;
        ceb trace = null;
        for (el pos : posList) {
            cea bb;
            ceb hit;
            if (pos == null || (hit = (bb = PositionUtils.createAABBForPosition(pos)).b(eyesPos, lookEndPos)) == null) continue;
            double dist = hit.c.f(eyesPos);
            if (!(closest < 0.0) && !(dist < closest)) continue;
            trace = new ceb(ceb.a.b, hit.c, hit.b, pos);
            closest = dist;
        }
        return trace;
    }

    @Nullable
    public static ceb traceToSchematicWorld(aer entity, double range, boolean respectRenderRange) {
        boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
        if (respectRenderRange && (!Configs.Visuals.ENABLE_RENDERING.getBooleanValue() || Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() == invert)) {
            return null;
        }
        WorldSchematic world = SchematicWorldHandler.getSchematicWorld();
        if (world == null) {
            return null;
        }
        cee eyesPos = entity.i(1.0f);
        cee rangedLookRot = entity.f(1.0f).a(range);
        cee lookEndPos = eyesPos.e(rangedLookRot);
        cec fluidMode = cec.c;
        return RayTraceUtils.rayTraceBlocks((axy)world, eyesPos, lookEndPos, fluidMode, false, true, respectRenderRange, 200);
    }

    @Nullable
    public static RayTraceWrapper getGenericTrace(axy worldClient, aer entity, double range, boolean respectRenderRange) {
        SchematicVerifier verifier;
        List<el> posList;
        ceb traceMismatch;
        SchematicPlacement placement;
        double dist;
        ceb traceClient = RayTraceUtils.getRayTraceFromEntity(worldClient, entity, true, range);
        ceb traceSchematic = RayTraceUtils.traceToSchematicWorld(entity, range, respectRenderRange);
        double distClosest = -1.0;
        RayTraceWrapper.HitType type = RayTraceWrapper.HitType.MISS;
        cee eyesPos = entity.i(1.0f);
        ceb trace = null;
        if (traceSchematic != null && traceSchematic.a == ceb.a.b) {
            dist = eyesPos.g(traceSchematic.c);
            if (distClosest < 0.0 || dist < distClosest) {
                trace = traceSchematic;
                distClosest = eyesPos.g(traceSchematic.c);
                type = RayTraceWrapper.HitType.SCHEMATIC_BLOCK;
            }
        }
        if (traceClient != null && traceClient.a == ceb.a.b) {
            dist = eyesPos.g(traceClient.c);
            if (distClosest < 0.0 || dist < distClosest) {
                trace = traceClient;
                distClosest = dist;
                type = RayTraceWrapper.HitType.VANILLA;
            }
        }
        if ((placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement()) != null && placement.hasVerifier() && (traceMismatch = RayTraceUtils.traceToPositions(posList = (verifier = placement.getSchematicVerifier()).getSelectedMismatchBlockPositionsForRender(), entity, range)) != null) {
            trace = traceMismatch;
            type = RayTraceWrapper.HitType.MISMATCH_OVERLAY;
        }
        if (trace != null) {
            return new RayTraceWrapper(type, trace);
        }
        return null;
    }

    @Nullable
    public static RayTraceWrapper getSchematicWorldTraceWrapperIfClosest(axy worldClient, aer entity, double range) {
        RayTraceWrapper trace = RayTraceUtils.getGenericTrace(worldClient, entity, range, true);
        if (trace != null && trace.getHitType() == RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            return trace;
        }
        return null;
    }

    @Nullable
    public static el getSchematicWorldTraceIfClosest(axy worldClient, aer entity, double range) {
        RayTraceWrapper trace = RayTraceUtils.getSchematicWorldTraceWrapperIfClosest(worldClient, entity, range);
        return trace != null ? trace.getRayTraceResult().a() : null;
    }

    @Nullable
    public static el getFurthestSchematicWorldTrace(axy worldClient, aer entity, double maxRange) {
        cee eyesPos = entity.i(1.0f);
        cee rangedLookRot = entity.f(1.0f).a(maxRange);
        cee lookEndPos = eyesPos.e(rangedLookRot);
        ceb traceVanilla = RayTraceUtils.getRayTraceFromEntity(worldClient, entity, false, maxRange);
        if (traceVanilla.a != ceb.a.b) {
            return null;
        }
        double closestVanilla = traceVanilla.c.g(eyesPos);
        el closestVanillaPos = traceVanilla.a();
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        List<ceb> list = RayTraceUtils.rayTraceBlocksToList((axy)worldSchematic, eyesPos, lookEndPos, cec.a, false, false, true, 200);
        ceb furthestTrace = null;
        double furthestDist = -1.0;
        if (!list.isEmpty()) {
            for (ceb trace : list) {
                double dist = trace.c.g(eyesPos);
                if ((furthestDist < 0.0 || dist > furthestDist) && (dist < closestVanilla || closestVanilla < 0.0) && !trace.a().equals((Object)closestVanillaPos)) {
                    furthestDist = dist;
                    furthestTrace = trace;
                }
                if (!(closestVanilla >= 0.0) || !(dist > closestVanilla)) continue;
                break;
            }
        }
        if (furthestTrace == null) {
            el pos = closestVanillaPos.a(traceVanilla.b);
            LayerRange layerRange = DataManager.getRenderLayerRange();
            if (layerRange.isPositionWithinRange(pos) && !worldSchematic.a_(pos).f() && worldClient.a_(pos).f()) {
                return pos;
            }
        }
        return furthestTrace != null ? furthestTrace.a() : null;
    }

    @Nonnull
    public static ceb getRayTraceFromEntity(axy world, aer entity, boolean useLiquids, double range) {
        cec fluidMode;
        cee rangedLookRot;
        cee lookEndPos;
        cee eyesPos = entity.i(1.0f);
        ceb result = RayTraceUtils.rayTraceBlocks(world, eyesPos, lookEndPos = eyesPos.e(rangedLookRot = entity.f(1.0f).a(range)), fluidMode = useLiquids ? cec.c : cec.a, false, false, false, 1000);
        if (result == null) {
            result = new ceb(ceb.a.a, cee.a, eq.b, el.a);
        }
        cea bb = entity.bD().b(rangedLookRot.b, rangedLookRot.c, rangedLookRot.d).b(1.0, 1.0, 1.0);
        List list = world.a(entity, bb);
        double closest = result.a == ceb.a.b ? eyesPos.f(result.c) : Double.MAX_VALUE;
        ceb entityTrace = null;
        aer targetEntity = null;
        for (int i = 0; i < list.size(); ++i) {
            double distance;
            aer entityTmp = (aer)list.get(i);
            bb = entityTmp.bD();
            ceb traceTmp = bb.b(lookEndPos, eyesPos);
            if (traceTmp == null || !((distance = eyesPos.f(traceTmp.c)) <= closest)) continue;
            targetEntity = entityTmp;
            entityTrace = traceTmp;
            closest = distance;
        }
        if (targetEntity != null) {
            result = new ceb(targetEntity, entityTrace.c);
        }
        if (eyesPos.f(result.c) > range) {
            result = new ceb(ceb.a.a, cee.a, eq.b, el.a);
        }
        return result;
    }

    @Nullable
    public static ceb rayTraceBlocks(axy world, cee start, cee end, cec fluidMode, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectLayerRange, int maxSteps) {
        byw fluidState;
        blc blockState;
        if (Double.isNaN(start.b) || Double.isNaN(start.c) || Double.isNaN(start.d) || Double.isNaN(end.b) || Double.isNaN(end.c) || Double.isNaN(end.d)) {
            return null;
        }
        LayerRange range = DataManager.getRenderLayerRange();
        RayTraceCalcsData data = new RayTraceCalcsData(start, end, range, fluidMode);
        ceb trace = RayTraceUtils.traceFirstStep(data, world, blockState = world.a_(data.blockPos), fluidState = world.b(data.blockPos), ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, respectLayerRange);
        if (trace != null) {
            return trace;
        }
        while (--maxSteps >= 0) {
            if (RayTraceUtils.rayTraceCalcs(data, returnLastUncollidableBlock, respectLayerRange)) {
                return data.trace;
            }
            blockState = world.a_(data.blockPos);
            if (!RayTraceUtils.traceLoopSteps(data, world, blockState, fluidState = world.b(data.blockPos), ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, respectLayerRange)) continue;
            return data.trace;
        }
        return returnLastUncollidableBlock ? data.trace : null;
    }

    @Nullable
    private static ceb traceFirstStep(RayTraceCalcsData data, axy world, blc blockState, byw fluidState, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectLayerRange) {
        if (!(respectLayerRange && !data.range.isPositionWithinRange(data.x, data.y, data.z) || ignoreBlockWithoutBoundingBox && blockState.h((axk)world, data.blockPos).b())) {
            boolean blockCollidable = blockState.c().d(blockState);
            boolean fluidCollidable = data.fluidMode.d.test(fluidState);
            if (blockCollidable || fluidCollidable) {
                ceb trace = null;
                if (blockCollidable) {
                    trace = bcs.a((blc)blockState, (axy)world, (el)data.blockPos, (cee)data.start, (cee)data.end);
                }
                if (trace == null && fluidCollidable) {
                    trace = cet.a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)fluidState.f(), (double)1.0).a(data.start, data.end, data.blockPos);
                }
                if (trace != null) {
                    return trace;
                }
            }
        }
        return null;
    }

    @Nullable
    private static boolean traceLoopSteps(RayTraceCalcsData data, axy world, blc blockState, byw fluidState, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectLayerRange) {
        if (!(respectLayerRange && !data.range.isPositionWithinRange(data.x, data.y, data.z) || ignoreBlockWithoutBoundingBox && blockState.d() != bza.c && blockState.h((axk)world, data.blockPos).b())) {
            boolean blockCollidable = blockState.c().d(blockState);
            boolean fluidCollidable = data.fluidMode.d.test(fluidState);
            if (!blockCollidable && !fluidCollidable) {
                cee pos = new cee(data.currentX, data.currentY, data.currentZ);
                data.trace = new ceb(ceb.a.a, pos, data.facing, data.blockPos);
            } else {
                ceb traceTmp = null;
                if (blockCollidable) {
                    traceTmp = bcs.a((blc)blockState, (axy)world, (el)data.blockPos, (cee)data.start, (cee)data.end);
                }
                if (traceTmp == null && fluidCollidable) {
                    traceTmp = cet.a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)fluidState.f(), (double)1.0).a(data.start, data.end, data.blockPos);
                }
                if (traceTmp != null) {
                    data.trace = traceTmp;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<ceb> rayTraceBlocksToList(axy world, cee start, cee end, cec fluidMode, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock, boolean respectLayerRange, int maxSteps) {
        if (Double.isNaN(start.b) || Double.isNaN(start.c) || Double.isNaN(start.d) || Double.isNaN(end.b) || Double.isNaN(end.c) || Double.isNaN(end.d)) {
            return ImmutableList.of();
        }
        LayerRange range = DataManager.getRenderLayerRange();
        RayTraceCalcsData data = new RayTraceCalcsData(start, end, range, fluidMode);
        blc blockState = world.a_(data.blockPos);
        byw fluidState = world.b(data.blockPos);
        ceb trace = RayTraceUtils.traceFirstStep(data, world, blockState, fluidState, ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, respectLayerRange);
        ArrayList<ceb> hits = new ArrayList<ceb>();
        if (trace != null) {
            hits.add(trace);
        }
        while (--maxSteps >= 0) {
            if (RayTraceUtils.rayTraceCalcs(data, returnLastUncollidableBlock, respectLayerRange)) {
                if (data.trace != null) {
                    hits.add(data.trace);
                }
                return hits;
            }
            blockState = world.a_(data.blockPos);
            if (!RayTraceUtils.traceLoopSteps(data, world, blockState, fluidState = world.b(data.blockPos), ignoreBlockWithoutBoundingBox, returnLastUncollidableBlock, respectLayerRange)) continue;
            hits.add(data.trace);
        }
        return hits;
    }

    private static boolean rayTraceCalcs(RayTraceCalcsData data, boolean returnLastNonCollidableBlock, boolean respectLayerRange) {
        boolean xDiffers = true;
        boolean yDiffers = true;
        boolean zDiffers = true;
        double nextX = 999.0;
        double nextY = 999.0;
        double nextZ = 999.0;
        if (Double.isNaN(data.currentX) || Double.isNaN(data.currentY) || Double.isNaN(data.currentZ)) {
            data.trace = null;
            return true;
        }
        if (data.x == data.xEnd && data.y == data.yEnd && data.z == data.zEnd) {
            if (!returnLastNonCollidableBlock) {
                data.trace = null;
            }
            return true;
        }
        if (data.xEnd > data.x) {
            nextX = (double)data.x + 1.0;
        } else if (data.xEnd < data.x) {
            nextX = (double)data.x + 0.0;
        } else {
            xDiffers = false;
        }
        if (data.yEnd > data.y) {
            nextY = (double)data.y + 1.0;
        } else if (data.yEnd < data.y) {
            nextY = (double)data.y + 0.0;
        } else {
            yDiffers = false;
        }
        if (data.zEnd > data.z) {
            nextZ = (double)data.z + 1.0;
        } else if (data.zEnd < data.z) {
            nextZ = (double)data.z + 0.0;
        } else {
            zDiffers = false;
        }
        double relStepX = 999.0;
        double relStepY = 999.0;
        double relStepZ = 999.0;
        double distToEndX = data.end.b - data.currentX;
        double distToEndY = data.end.c - data.currentY;
        double distToEndZ = data.end.d - data.currentZ;
        if (xDiffers) {
            relStepX = (nextX - data.currentX) / distToEndX;
        }
        if (yDiffers) {
            relStepY = (nextY - data.currentY) / distToEndY;
        }
        if (zDiffers) {
            relStepZ = (nextZ - data.currentZ) / distToEndZ;
        }
        if (relStepX == -0.0) {
            relStepX = -1.0E-4;
        }
        if (relStepY == -0.0) {
            relStepY = -1.0E-4;
        }
        if (relStepZ == -0.0) {
            relStepZ = -1.0E-4;
        }
        if (relStepX < relStepY && relStepX < relStepZ) {
            data.facing = data.xEnd > data.x ? eq.e : eq.f;
            data.currentX = nextX;
            data.currentY += distToEndY * relStepX;
            data.currentZ += distToEndZ * relStepX;
        } else if (relStepY < relStepZ) {
            data.facing = data.yEnd > data.y ? eq.a : eq.b;
            data.currentX += distToEndX * relStepY;
            data.currentY = nextY;
            data.currentZ += distToEndZ * relStepY;
        } else {
            data.facing = data.zEnd > data.z ? eq.c : eq.d;
            data.currentX += distToEndX * relStepZ;
            data.currentY += distToEndY * relStepZ;
            data.currentZ = nextZ;
        }
        data.x = xq.c((double)data.currentX) - (data.facing == eq.f ? 1 : 0);
        data.y = xq.c((double)data.currentY) - (data.facing == eq.b ? 1 : 0);
        data.z = xq.c((double)data.currentZ) - (data.facing == eq.d ? 1 : 0);
        data.blockPos = new el(data.x, data.y, data.z);
        return false;
    }

    public static class RayTraceWrapper {
        private final HitType type;
        private final PositionUtils.Corner corner;
        private final cee hitVec;
        @Nullable
        private final ceb trace;
        @Nullable
        private final Box box;
        @Nullable
        private final SchematicPlacement schematicPlacement;
        @Nullable
        private final String placementRegionName;

        public RayTraceWrapper() {
            this.type = HitType.MISS;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = cee.a;
            this.trace = null;
            this.box = null;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(ceb trace) {
            this.type = HitType.VANILLA;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = trace.c;
            this.trace = trace;
            this.box = null;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(HitType type) {
            this.type = type;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = cee.a;
            this.trace = null;
            this.box = null;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(HitType type, ceb trace) {
            this.type = type;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = trace.c;
            this.trace = trace;
            this.box = null;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(Box box, PositionUtils.Corner corner, cee hitVec) {
            this.type = corner == PositionUtils.Corner.NONE ? HitType.SELECTION_BOX_BODY : HitType.SELECTION_BOX_CORNER;
            this.corner = corner;
            this.hitVec = hitVec;
            this.trace = null;
            this.box = box;
            this.schematicPlacement = null;
            this.placementRegionName = null;
        }

        public RayTraceWrapper(SchematicPlacement placement, cee hitVec, @Nullable String regionName) {
            this.type = regionName != null ? HitType.PLACEMENT_SUBREGION : HitType.PLACEMENT_ORIGIN;
            this.corner = PositionUtils.Corner.NONE;
            this.hitVec = hitVec;
            this.trace = null;
            this.box = null;
            this.schematicPlacement = placement;
            this.placementRegionName = regionName;
        }

        public HitType getHitType() {
            return this.type;
        }

        @Nullable
        public ceb getRayTraceResult() {
            return this.trace;
        }

        @Nullable
        public Box getHitSelectionBox() {
            return this.box;
        }

        @Nullable
        public SchematicPlacement getHitSchematicPlacement() {
            return this.schematicPlacement;
        }

        @Nullable
        public String getHitSchematicPlacementRegionName() {
            return this.placementRegionName;
        }

        public cee getHitVec() {
            return this.hitVec;
        }

        public PositionUtils.Corner getHitCorner() {
            return this.corner;
        }

        public static enum HitType {
            MISS,
            VANILLA,
            SELECTION_BOX_BODY,
            SELECTION_BOX_CORNER,
            SELECTION_ORIGIN,
            PLACEMENT_SUBREGION,
            PLACEMENT_ORIGIN,
            SCHEMATIC_BLOCK,
            MISMATCH_OVERLAY;

        }
    }

    public static class RayTraceCalcsData {
        public final LayerRange range;
        public final cec fluidMode;
        public final cee start;
        public final cee end;
        public final int xEnd;
        public final int yEnd;
        public final int zEnd;
        public int x;
        public int y;
        public int z;
        public double currentX;
        public double currentY;
        public double currentZ;
        public el blockPos;
        public eq facing;
        public ceb trace;

        public RayTraceCalcsData(cee start, cee end, LayerRange range, cec fluidMode) {
            this.start = start;
            this.end = end;
            this.range = range;
            this.fluidMode = fluidMode;
            this.currentX = start.b;
            this.currentY = start.c;
            this.currentZ = start.d;
            this.xEnd = xq.c((double)end.b);
            this.yEnd = xq.c((double)end.c);
            this.zEnd = xq.c((double)end.d);
            this.x = xq.c((double)start.b);
            this.y = xq.c((double)start.c);
            this.z = xq.c((double)start.d);
            this.blockPos = new el(this.x, this.y, this.z);
            this.trace = null;
        }
    }
}

