/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class PositionUtils {
    public static final BlockPosComparator BLOCK_POS_COMPARATOR = new BlockPosComparator();
    public static final ChunkPosComparator CHUNK_POS_COMPARATOR = new ChunkPosComparator();
    public static final eq.a[] AXES_ALL = new eq.a[]{eq.a.a, eq.a.b, eq.a.c};
    public static final eq[] FACING_ALL = new eq[]{eq.a, eq.b, eq.c, eq.d, eq.e, eq.f};
    public static final eq[] FACING_HORIZONTALS = new eq[]{eq.c, eq.d, eq.e, eq.f};
    public static final eq[] ADJACENT_SIDES_ZY = new eq[]{eq.a, eq.b, eq.c, eq.d};
    public static final eq[] ADJACENT_SIDES_XY = new eq[]{eq.a, eq.b, eq.f, eq.e};
    public static final eq[] ADJACENT_SIDES_XZ = new eq[]{eq.c, eq.d, eq.f, eq.e};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_XN_ZN = new ff[]{new ff(0, 0, 0), new ff(-1, 0, 0), new ff(0, 0, -1), new ff(-1, 0, -1)};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_XP_ZN = new ff[]{new ff(0, 0, 0), new ff(1, 0, 0), new ff(0, 0, -1), new ff(1, 0, -1)};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_XN_ZP = new ff[]{new ff(0, 0, 0), new ff(-1, 0, 0), new ff(0, 0, 1), new ff(-1, 0, 1)};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_XP_ZP = new ff[]{new ff(0, 0, 0), new ff(1, 0, 0), new ff(0, 0, 1), new ff(1, 0, 1)};
    private static final ff[][] EDGE_NEIGHBOR_OFFSETS_Y = new ff[][]{EDGE_NEIGHBOR_OFFSETS_XN_ZN, EDGE_NEIGHBOR_OFFSETS_XP_ZN, EDGE_NEIGHBOR_OFFSETS_XN_ZP, EDGE_NEIGHBOR_OFFSETS_XP_ZP};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_XN_YN = new ff[]{new ff(0, 0, 0), new ff(-1, 0, 0), new ff(0, -1, 0), new ff(-1, -1, 0)};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_XP_YN = new ff[]{new ff(0, 0, 0), new ff(1, 0, 0), new ff(0, -1, 0), new ff(1, -1, 0)};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_XN_YP = new ff[]{new ff(0, 0, 0), new ff(-1, 0, 0), new ff(0, 1, 0), new ff(-1, 1, 0)};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_XP_YP = new ff[]{new ff(0, 0, 0), new ff(1, 0, 0), new ff(0, 1, 0), new ff(1, 1, 0)};
    private static final ff[][] EDGE_NEIGHBOR_OFFSETS_Z = new ff[][]{EDGE_NEIGHBOR_OFFSETS_XN_YN, EDGE_NEIGHBOR_OFFSETS_XP_YN, EDGE_NEIGHBOR_OFFSETS_XN_YP, EDGE_NEIGHBOR_OFFSETS_XP_YP};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_YN_ZN = new ff[]{new ff(0, 0, 0), new ff(0, -1, 0), new ff(0, 0, -1), new ff(0, -1, -1)};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_YP_ZN = new ff[]{new ff(0, 0, 0), new ff(0, 1, 0), new ff(0, 0, -1), new ff(0, 1, -1)};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_YN_ZP = new ff[]{new ff(0, 0, 0), new ff(0, -1, 0), new ff(0, 0, 1), new ff(0, -1, 1)};
    private static final ff[] EDGE_NEIGHBOR_OFFSETS_YP_ZP = new ff[]{new ff(0, 0, 0), new ff(0, 1, 0), new ff(0, 0, 1), new ff(0, 1, 1)};
    private static final ff[][] EDGE_NEIGHBOR_OFFSETS_X = new ff[][]{EDGE_NEIGHBOR_OFFSETS_YN_ZN, EDGE_NEIGHBOR_OFFSETS_YP_ZN, EDGE_NEIGHBOR_OFFSETS_YN_ZP, EDGE_NEIGHBOR_OFFSETS_YP_ZP};

    public static ff[] getEdgeNeighborOffsets(eq.a axis, int cornerIndex) {
        switch (axis) {
            case a: {
                return EDGE_NEIGHBOR_OFFSETS_X[cornerIndex];
            }
            case b: {
                return EDGE_NEIGHBOR_OFFSETS_Y[cornerIndex];
            }
            case c: {
                return EDGE_NEIGHBOR_OFFSETS_Z[cornerIndex];
            }
        }
        return null;
    }

    public static el getMinCorner(el pos1, el pos2) {
        return new el(Math.min(pos1.o(), pos2.o()), Math.min(pos1.p(), pos2.p()), Math.min(pos1.q(), pos2.q()));
    }

    public static el getMaxCorner(el pos1, el pos2) {
        return new el(Math.max(pos1.o(), pos2.o()), Math.max(pos1.p(), pos2.p()), Math.max(pos1.q(), pos2.q()));
    }

    public static boolean isPositionInsideArea(el pos, el posMin, el posMax) {
        return pos.o() >= posMin.o() && pos.o() <= posMax.o() && pos.p() >= posMin.p() && pos.p() <= posMax.p() && pos.q() >= posMin.q() && pos.q() <= posMax.q();
    }

    public static el getTransformedPlacementPosition(el posWithinSub, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        el pos = posWithinSub;
        pos = PositionUtils.getTransformedBlockPos(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        pos = PositionUtils.getTransformedBlockPos(pos, placement.getMirror(), placement.getRotation());
        return pos;
    }

    public static boolean arePositionsWithinWorld(axy world, el pos1, el pos2) {
        if (pos1.p() >= 0 && pos1.p() <= 255 && pos2.p() >= 0 && pos2.p() <= 255) {
            bmv border = world.d();
            return border.a(pos1) && border.a(pos2);
        }
        return false;
    }

    public static boolean isBoxWithinWorld(axy world, Box box) {
        if (box.getPos1() != null && box.getPos2() != null) {
            return PositionUtils.arePositionsWithinWorld(world, box.getPos1(), box.getPos2());
        }
        return false;
    }

    public static boolean isPlacementWithinWorld(axy world, SchematicPlacement schematicPlacement, boolean respectRenderRange) {
        LayerRange range = DataManager.getRenderLayerRange();
        el.a posMutable1 = new el.a();
        el.a posMutable2 = new el.a();
        for (Box box : schematicPlacement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED).values()) {
            if (respectRenderRange) {
                IntBoundingBox bb;
                if (!range.intersectsBox(box.getPos1(), box.getPos2()) || (bb = range.getClampedArea(box.getPos1(), box.getPos2())) == null) continue;
                posMutable1.c(bb.minX, bb.minY, bb.minZ);
                posMutable2.c(bb.maxX, bb.maxY, bb.maxZ);
                if (PositionUtils.arePositionsWithinWorld(world, (el)posMutable1, (el)posMutable2)) continue;
                return false;
            }
            if (PositionUtils.isBoxWithinWorld(world, box)) continue;
            return false;
        }
        return true;
    }

    public static el getAreaSizeFromRelativeEndPosition(el posEndRelative) {
        int x = posEndRelative.o();
        int y = posEndRelative.p();
        int z = posEndRelative.q();
        x = x >= 0 ? x + 1 : x - 1;
        y = y >= 0 ? y + 1 : y - 1;
        z = z >= 0 ? z + 1 : z - 1;
        return new el(x, y, z);
    }

    public static el getAreaSizeFromRelativeEndPositionAbs(el posEndRelative) {
        int x = posEndRelative.o();
        int y = posEndRelative.p();
        int z = posEndRelative.q();
        x = x >= 0 ? x + 1 : x - 1;
        y = y >= 0 ? y + 1 : y - 1;
        z = z >= 0 ? z + 1 : z - 1;
        return new el(Math.abs(x), Math.abs(y), Math.abs(z));
    }

    public static el getRelativeEndPositionFromAreaSize(ff size) {
        int x = size.o();
        int y = size.p();
        int z = size.q();
        x = x >= 0 ? x - 1 : x + 1;
        y = y >= 0 ? y - 1 : y + 1;
        z = z >= 0 ? z - 1 : z + 1;
        return new el(x, y, z);
    }

    public static List<Box> getValidBoxes(AreaSelection area) {
        ArrayList<Box> boxes = new ArrayList<Box>();
        List<Box> originalBoxes = area.getAllSubRegionBoxes();
        for (Box box : originalBoxes) {
            if (!PositionUtils.isBoxValid(box)) continue;
            boxes.add(box);
        }
        return boxes;
    }

    public static boolean isBoxValid(Box box) {
        return box.getPos1() != null && box.getPos2() != null;
    }

    public static el getEnclosingAreaSize(AreaSelection area) {
        return PositionUtils.getEnclosingAreaSize(area.getAllSubRegionBoxes());
    }

    public static el getEnclosingAreaSize(Collection<Box> boxes) {
        Pair<el, el> pair = PositionUtils.getEnclosingAreaCorners(boxes);
        return ((el)pair.getRight()).b((ff)pair.getLeft()).a(1, 1, 1);
    }

    @Nullable
    public static Pair<el, el> getEnclosingAreaCorners(Collection<Box> boxes) {
        if (boxes.isEmpty()) {
            return null;
        }
        el.a posMin = new el.a(60000000, 60000000, 60000000);
        el.a posMax = new el.a(-60000000, -60000000, -60000000);
        for (Box box : boxes) {
            PositionUtils.getMinMaxCoords(posMin, posMax, box.getPos1());
            PositionUtils.getMinMaxCoords(posMin, posMax, box.getPos2());
        }
        return Pair.of((Object)posMin.h(), (Object)posMax.h());
    }

    private static void getMinMaxCoords(el.a posMin, el.a posMax, @Nullable el posToCheck) {
        if (posToCheck != null) {
            posMin.c(Math.min(posMin.o(), posToCheck.o()), Math.min(posMin.p(), posToCheck.p()), Math.min(posMin.q(), posToCheck.q()));
            posMax.c(Math.max(posMax.o(), posToCheck.o()), Math.max(posMax.p(), posToCheck.p()), Math.max(posMax.q(), posToCheck.q()));
        }
    }

    public static int getTotalVolume(Collection<Box> boxes) {
        if (boxes.isEmpty()) {
            return 0;
        }
        int volume = 0;
        for (Box box : boxes) {
            if (!PositionUtils.isBoxValid(box)) continue;
            el min = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            el max = PositionUtils.getMaxCorner(box.getPos1(), box.getPos2());
            volume += (max.o() - min.o() + 1) * (max.p() - min.p() + 1) * (max.q() - min.q() + 1);
        }
        return volume;
    }

    public static ImmutableMap<String, IntBoundingBox> getBoxesWithinChunk(int chunkX, int chunkZ, ImmutableMap<String, Box> subRegions) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : subRegions.entrySet()) {
            Box box = (Box)entry.getValue();
            IntBoundingBox bb = box != null ? PositionUtils.getBoundsWithinChunkForBox(box, chunkX, chunkZ) : null;
            if (bb == null) continue;
            builder.put(entry.getKey(), (Object)bb);
        }
        return builder.build();
    }

    public static ImmutableList<IntBoundingBox> getBoxesWithinChunk(int chunkX, int chunkZ, Collection<Box> boxes) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (Box box : boxes) {
            IntBoundingBox bb = PositionUtils.getBoundsWithinChunkForBox(box, chunkX, chunkZ);
            if (bb == null) continue;
            builder.add((Object)bb);
        }
        return builder.build();
    }

    public static Set<axm> getTouchedChunks(ImmutableMap<String, Box> boxes) {
        return PositionUtils.getTouchedChunksForBoxes((Collection<Box>)boxes.values());
    }

    public static Set<axm> getTouchedChunksForBoxes(Collection<Box> boxes) {
        HashSet<axm> set = new HashSet<axm>();
        for (Box box : boxes) {
            int boxXMin = Math.min(box.getPos1().o(), box.getPos2().o()) >> 4;
            int boxZMin = Math.min(box.getPos1().q(), box.getPos2().q()) >> 4;
            int boxXMax = Math.max(box.getPos1().o(), box.getPos2().o()) >> 4;
            int boxZMax = Math.max(box.getPos1().q(), box.getPos2().q()) >> 4;
            for (int cz = boxZMin; cz <= boxZMax; ++cz) {
                for (int cx = boxXMin; cx <= boxXMax; ++cx) {
                    set.add(new axm(cx, cz));
                }
            }
        }
        return set;
    }

    @Nullable
    public static IntBoundingBox getBoundsWithinChunkForBox(Box box, int chunkX, int chunkZ) {
        boolean notOverlapping;
        int chunkXMin = chunkX << 4;
        int chunkZMin = chunkZ << 4;
        int chunkXMax = chunkXMin + 15;
        int chunkZMax = chunkZMin + 15;
        int boxXMin = Math.min(box.getPos1().o(), box.getPos2().o());
        int boxZMin = Math.min(box.getPos1().q(), box.getPos2().q());
        int boxXMax = Math.max(box.getPos1().o(), box.getPos2().o());
        int boxZMax = Math.max(box.getPos1().q(), box.getPos2().q());
        boolean bl = notOverlapping = boxXMin > chunkXMax || boxZMin > chunkZMax || boxXMax < chunkXMin || boxZMax < chunkZMin;
        if (!notOverlapping) {
            int xMin = Math.max(chunkXMin, boxXMin);
            int yMin = Math.min(box.getPos1().p(), box.getPos2().p());
            int zMin = Math.max(chunkZMin, boxZMin);
            int xMax = Math.min(chunkXMax, boxXMax);
            int yMax = Math.max(box.getPos1().p(), box.getPos2().p());
            int zMax = Math.min(chunkZMax, boxZMax);
            return new IntBoundingBox(xMin, yMin, zMin, xMax, yMax, zMax);
        }
        return null;
    }

    public static cea createEnclosingAABB(el pos1, el pos2) {
        int minX = Math.min(pos1.o(), pos2.o());
        int minY = Math.min(pos1.p(), pos2.p());
        int minZ = Math.min(pos1.q(), pos2.q());
        int maxX = Math.max(pos1.o(), pos2.o()) + 1;
        int maxY = Math.max(pos1.p(), pos2.p()) + 1;
        int maxZ = Math.max(pos1.q(), pos2.q()) + 1;
        return PositionUtils.createAABB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static cea createAABBFrom(IntBoundingBox bb) {
        return PositionUtils.createAABB(bb.minX, bb.minY, bb.minZ, bb.maxX + 1, bb.maxY + 1, bb.maxZ + 1);
    }

    public static cea createAABBForPosition(el pos) {
        return PositionUtils.createAABBForPosition(pos.o(), pos.p(), pos.q());
    }

    public static cea createAABBForPosition(int x, int y, int z) {
        return PositionUtils.createAABB(x, y, z, x + 1, y + 1, z + 1);
    }

    public static cea createAABB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return new cea((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    public static el getModifiedPosition(el pos, int value, PositionUtils.CoordinateType type) {
        switch (type) {
            case X: {
                pos = new el(value, pos.p(), pos.q());
                break;
            }
            case Y: {
                pos = new el(pos.o(), value, pos.q());
                break;
            }
            case Z: {
                pos = new el(pos.o(), pos.p(), value);
            }
        }
        return pos;
    }

    public static int getCoordinate(el pos, PositionUtils.CoordinateType type) {
        switch (type) {
            case X: {
                return pos.o();
            }
            case Y: {
                return pos.p();
            }
            case Z: {
                return pos.q();
            }
        }
        return 0;
    }

    public static Box growOrShrinkBox(Box box, int amount) {
        el pos1 = box.getPos1();
        el pos2 = box.getPos2();
        if (pos1 == null || pos2 == null) {
            if (pos1 == null && pos2 == null) {
                return box;
            }
            if (pos2 == null) {
                pos2 = pos1;
            } else {
                pos1 = pos2;
            }
        }
        Pair<Integer, Integer> x = PositionUtils.growCoordinatePair(pos1.o(), pos2.o(), amount);
        Pair<Integer, Integer> y = PositionUtils.growCoordinatePair(pos1.p(), pos2.p(), amount);
        Pair<Integer, Integer> z = PositionUtils.growCoordinatePair(pos1.q(), pos2.q(), amount);
        Box boxNew = box.copy();
        boxNew.setPos1(new el(((Integer)x.getLeft()).intValue(), ((Integer)y.getLeft()).intValue(), ((Integer)z.getLeft()).intValue()));
        boxNew.setPos2(new el(((Integer)x.getRight()).intValue(), ((Integer)y.getRight()).intValue(), ((Integer)z.getRight()).intValue()));
        return boxNew;
    }

    private static Pair<Integer, Integer> growCoordinatePair(int v1, int v2, int amount) {
        if (v2 >= v1) {
            if (v2 + amount >= v1) {
                v2 += amount;
            }
            if (v1 - amount <= v2) {
                v1 -= amount;
            }
        } else if (v1 > v2) {
            if (v1 + amount >= v2) {
                v1 += amount;
            }
            if (v2 - amount <= v1) {
                v2 -= amount;
            }
        }
        return Pair.of((Object)v1, (Object)v2);
    }

    public static void growOrShrinkCurrentSelection(boolean grow) {
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection area = sm.getCurrentSelection();
        crg world = cft.s().g;
        if (area == null || world == null) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
            return;
        }
        Box box = area.getSelectedSubRegionBox();
        if (box == null || box.getPos1() == null && box.getPos2() == null) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.area_selection.grow.no_sub_region_selected", (Object[])new Object[0]);
            return;
        }
        if (box != null && (box.getPos1() != null || box.getPos2() != null)) {
            int amount = 1;
            Box boxNew = box.copy();
            for (int i = 0; i < 256; ++i) {
                if (grow) {
                    boxNew = PositionUtils.growOrShrinkBox(boxNew, amount);
                }
                el pos1 = boxNew.getPos1();
                el pos2 = boxNew.getPos2();
                int xMin = Math.min(pos1.o(), pos2.o());
                int yMin = Math.min(pos1.p(), pos2.p());
                int zMin = Math.min(pos1.q(), pos2.q());
                int xMax = Math.max(pos1.o(), pos2.o());
                int yMax = Math.max(pos1.p(), pos2.p());
                int zMax = Math.max(pos1.q(), pos2.q());
                int emptySides = 0;
                if (WorldUtils.isSliceEmpty((axy)world, eq.a.a, new el(xMin, yMin, zMin), new el(xMin, yMax, zMax))) {
                    xMin += amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((axy)world, eq.a.a, new el(xMax, yMin, zMin), new el(xMax, yMax, zMax))) {
                    xMax -= amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((axy)world, eq.a.b, new el(xMin, yMin, zMin), new el(xMax, yMin, zMax))) {
                    yMin += amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((axy)world, eq.a.b, new el(xMin, yMax, zMin), new el(xMax, yMax, zMax))) {
                    yMax -= amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((axy)world, eq.a.c, new el(xMin, yMin, zMin), new el(xMax, yMax, zMin))) {
                    zMin += amount;
                    ++emptySides;
                }
                if (WorldUtils.isSliceEmpty((axy)world, eq.a.c, new el(xMin, yMin, zMax), new el(xMax, yMax, zMax))) {
                    zMax -= amount;
                    ++emptySides;
                }
                boxNew.setPos1(new el(xMin, yMin, zMin));
                boxNew.setPos2(new el(xMax, yMax, zMax));
                if (grow && emptySides >= 6 || !grow && emptySides == 0) break;
            }
            area.setSelectedSubRegionCornerPos(boxNew.getPos1(), Corner.CORNER_1);
            area.setSelectedSubRegionCornerPos(boxNew.getPos2(), Corner.CORNER_2);
        }
    }

    public static el getTransformedBlockPos(el pos, bfz mirror, bhb rotation) {
        int x = pos.o();
        int y = pos.p();
        int z = pos.q();
        boolean isMirrored = true;
        switch (mirror) {
            case b: {
                z = -z;
                break;
            }
            case c: {
                x = -x;
                break;
            }
            default: {
                isMirrored = false;
            }
        }
        switch (rotation) {
            case b: {
                return new el(-z, y, x);
            }
            case d: {
                return new el(z, y, -x);
            }
            case c: {
                return new el(-x, y, -z);
            }
        }
        return isMirrored ? new el(x, y, z) : pos;
    }

    public static el getReverseTransformedBlockPos(el pos, bfz mirror, bhb rotation) {
        int x = pos.o();
        int y = pos.p();
        int z = pos.q();
        boolean isRotated = true;
        int tmp = x;
        switch (rotation) {
            case b: {
                x = z;
                z = -tmp;
                break;
            }
            case d: {
                x = -z;
                z = tmp;
                break;
            }
            case c: {
                x = -x;
                z = -z;
                break;
            }
            default: {
                isRotated = false;
            }
        }
        switch (mirror) {
            case b: {
                z = -z;
                break;
            }
            case c: {
                x = -x;
                break;
            }
            default: {
                if (isRotated) break;
                return pos;
            }
        }
        return new el(x, y, z);
    }

    public static el getOriginalPositionFromTransformed(el pos, bfz mirror, bhb rotation) {
        int x = pos.o();
        int y = pos.p();
        int z = pos.q();
        boolean noRotation = false;
        switch (rotation) {
            case b: {
                int tmp = x;
                x = -z;
                z = tmp;
            }
            case d: {
                int tmp = x;
                x = z;
                z = -tmp;
            }
            case c: {
                x = -x;
                z = -z;
            }
        }
        noRotation = true;
        switch (mirror) {
            case b: {
                z = -z;
                break;
            }
            case c: {
                x = -x;
                break;
            }
            default: {
                if (!noRotation) break;
                return pos;
            }
        }
        return new el(x, y, z);
    }

    public static cee getTransformedPosition(cee originalPos, bfz mirror, bhb rotation) {
        double x = originalPos.b;
        double y = originalPos.c;
        double z = originalPos.d;
        boolean transformed = true;
        switch (mirror) {
            case b: {
                z = 1.0 - z;
                break;
            }
            case c: {
                x = 1.0 - x;
                break;
            }
            default: {
                transformed = false;
            }
        }
        switch (rotation) {
            case d: {
                return new cee(z, y, 1.0 - x);
            }
            case b: {
                return new cee(1.0 - z, y, x);
            }
            case c: {
                return new cee(1.0 - x, y, 1.0 - z);
            }
        }
        return transformed ? new cee(x, y, z) : originalPos;
    }

    public static bhb getReverseRotation(bhb rotationIn) {
        switch (rotationIn) {
            case d: {
                return bhb.b;
            }
            case b: {
                return bhb.d;
            }
            case c: {
                return bhb.c;
            }
        }
        return rotationIn;
    }

    public static el getModifiedPartiallyLockedPosition(el posOriginal, el posNew, int lockMask) {
        if (lockMask != 0) {
            int x = posNew.o();
            int y = posNew.p();
            int z = posNew.q();
            if ((lockMask & 1 << PositionUtils.CoordinateType.X.ordinal()) != 0) {
                x = posOriginal.o();
            }
            if ((lockMask & 1 << PositionUtils.CoordinateType.Y.ordinal()) != 0) {
                y = posOriginal.p();
            }
            if ((lockMask & 1 << PositionUtils.CoordinateType.Z.ordinal()) != 0) {
                z = posOriginal.q();
            }
            posNew = new el(x, y, z);
        }
        return posNew;
    }

    public static eq getFacingFromPositions(el pos1, el pos2) {
        if (pos1 == null || pos2 == null) {
            return null;
        }
        return PositionUtils.getFacingFromPositions(pos1.o(), pos1.q(), pos2.o(), pos2.q());
    }

    private static eq getFacingFromPositions(int x1, int z1, int x2, int z2) {
        if (x2 == x1) {
            return z2 > z1 ? eq.d : eq.c;
        }
        if (z2 == z1) {
            return x2 > x1 ? eq.f : eq.e;
        }
        if (x2 > x1) {
            return z2 > z1 ? eq.f : eq.c;
        }
        return z2 > z1 ? eq.d : eq.e;
    }

    public static bhb cycleRotation(bhb rotation, boolean reverse) {
        int ordinal = rotation.ordinal();
        ordinal = reverse ? (ordinal == 0 ? bhb.values().length - 1 : ordinal - 1) : (ordinal >= bhb.values().length - 1 ? 0 : ordinal + 1);
        return bhb.values()[ordinal];
    }

    public static bfz cycleMirror(bfz mirror, boolean reverse) {
        int ordinal = mirror.ordinal();
        ordinal = reverse ? (ordinal == 0 ? bfz.values().length - 1 : ordinal - 1) : (ordinal >= bfz.values().length - 1 ? 0 : ordinal + 1);
        return bfz.values()[ordinal];
    }

    public static String getRotationNameShort(bhb rotation) {
        switch (rotation) {
            case b: {
                return "CW_90";
            }
            case c: {
                return "CW_180";
            }
            case d: {
                return "CCW_90";
            }
        }
        return "NONE";
    }

    public static String getMirrorName(bfz mirror) {
        switch (mirror) {
            case c: {
                return "FRONT_BACK";
            }
            case b: {
                return "LEFT_RIGHT";
            }
        }
        return "NONE";
    }

    public static float getRotatedYaw(float yaw, bhb rotation) {
        yaw = xq.g((float)yaw);
        switch (rotation) {
            case c: {
                yaw += 180.0f;
                break;
            }
            case d: {
                yaw += 270.0f;
                break;
            }
            case b: {
                yaw += 90.0f;
                break;
            }
        }
        return yaw;
    }

    public static float getMirroredYaw(float yaw, bfz mirror) {
        yaw = xq.g((float)yaw);
        switch (mirror) {
            case b: {
                yaw = 180.0f - yaw;
                break;
            }
            case c: {
                yaw = -yaw;
                break;
            }
        }
        return yaw;
    }

    public static enum Corner {
        NONE,
        CORNER_1,
        CORNER_2;

    }

    public static class ChunkPosComparator
    implements Comparator<axm> {
        private el posReference = el.a;
        private boolean closestFirst;

        public ChunkPosComparator setClosestFirst(boolean closestFirst) {
            this.closestFirst = closestFirst;
            return this;
        }

        public ChunkPosComparator setReferencePosition(el pos) {
            this.posReference = pos;
            return this;
        }

        @Override
        public int compare(axm pos1, axm pos2) {
            double dist2;
            double dist1 = this.distanceSq(pos1);
            if (dist1 == (dist2 = this.distanceSq(pos2))) {
                return 0;
            }
            return dist1 < dist2 == this.closestFirst ? -1 : 1;
        }

        private double distanceSq(axm pos) {
            double dx = (double)(pos.a << 4) - (double)this.posReference.o();
            double dz = (double)(pos.b << 4) - (double)this.posReference.q();
            return dx * dx + dz * dz;
        }
    }

    public static class BlockPosComparator
    implements Comparator<el> {
        private el posReference = el.a;
        private boolean closestFirst;

        public void setClosestFirst(boolean closestFirst) {
            this.closestFirst = closestFirst;
        }

        public void setReferencePosition(el pos) {
            this.posReference = pos;
        }

        @Override
        public int compare(el pos1, el pos2) {
            double dist2;
            double dist1 = pos1.n((ff)this.posReference);
            if (dist1 == (dist2 = pos2.n((ff)this.posReference))) {
                return 0;
            }
            return dist1 < dist2 == this.closestFirst ? -1 : 1;
        }
    }
}

