/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.verifier;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.render.infohud.RenderPhase;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.BlockInfoListType;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.ICompletionListener;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.StringUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class SchematicVerifier
extends TaskBase
implements IInfoHudRenderer {
    private static final MutablePair<blc, blc> MUTABLE_PAIR = new MutablePair();
    private static final el.a MUTABLE_POS = new el.a();
    private static final List<SchematicVerifier> ACTIVE_VERIFIERS = new ArrayList<SchematicVerifier>();
    private final ArrayListMultimap<Pair<blc, blc>, el> missingBlocksPositions = ArrayListMultimap.create();
    private final ArrayListMultimap<Pair<blc, blc>, el> extraBlocksPositions = ArrayListMultimap.create();
    private final ArrayListMultimap<Pair<blc, blc>, el> wrongBlocksPositions = ArrayListMultimap.create();
    private final ArrayListMultimap<Pair<blc, blc>, el> wrongStatesPositions = ArrayListMultimap.create();
    private final Object2IntOpenHashMap<blc> correctStateCounts = new Object2IntOpenHashMap();
    private final Object2ObjectOpenHashMap<el, BlockMismatch> blockMismatches = new Object2ObjectOpenHashMap();
    private final HashSet<Pair<blc, blc>> ignoredMismatches = new HashSet();
    private final List<el> missingBlocksPositionsClosest = new ArrayList<el>();
    private final List<el> extraBlocksPositionsClosest = new ArrayList<el>();
    private final List<el> mismatchedBlocksPositionsClosest = new ArrayList<el>();
    private final List<el> mismatchedStatesPositionsClosest = new ArrayList<el>();
    private final Set<MismatchType> selectedCategories = new HashSet<MismatchType>();
    private final HashMultimap<MismatchType, BlockMismatch> selectedEntries = HashMultimap.create();
    private final Set<axm> requiredChunks = new HashSet<axm>();
    private final Set<el> recheckQueue = new HashSet<el>();
    private final cft mc = cft.s();
    private crg worldClient;
    private WorldSchematic worldSchematic;
    private SchematicPlacement schematicPlacement;
    private final List<MismatchRenderPos> mismatchPositionsForRender = new ArrayList<MismatchRenderPos>();
    private final List<el> mismatchBlockPositionsForRender = new ArrayList<el>();
    private SortCriteria sortCriteria = SortCriteria.NAME_EXPECTED;
    private boolean sortReverse;
    private boolean verificationStarted;
    private boolean verificationActive;
    private boolean shouldRenderInfoHud = true;
    private int totalRequiredChunks;
    private int schematicBlocks;
    private int clientBlocks;
    private int correctStatesCount;

    public SchematicVerifier() {
        this.name = StringUtils.translate((String)"litematica.gui.label.schematic_verifier.verifier", (Object[])new Object[0]);
    }

    public static void clearActiveVerifiers() {
        ACTIVE_VERIFIERS.clear();
    }

    public static void markVerifierBlockChanges(el pos) {
        for (int i = 0; i < ACTIVE_VERIFIERS.size(); ++i) {
            ACTIVE_VERIFIERS.get(i).markBlockChanged(pos);
        }
    }

    @Override
    public boolean getShouldRenderText(RenderPhase phase) {
        return this.shouldRenderInfoHud && phase == RenderPhase.POST && Configs.InfoOverlays.VERIFIER_OVERLAY_ENABLED.getBooleanValue();
    }

    public void toggleShouldRenderInfoHUD() {
        this.shouldRenderInfoHud = !this.shouldRenderInfoHud;
    }

    public boolean isActive() {
        return this.verificationActive;
    }

    public boolean isPaused() {
        return this.verificationStarted && !this.verificationActive && !this.finished;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getTotalChunks() {
        return this.totalRequiredChunks;
    }

    public int getUnseenChunks() {
        return this.requiredChunks.size();
    }

    public int getSchematicTotalBlocks() {
        return this.schematicBlocks;
    }

    public int getRealWorldTotalBlocks() {
        return this.clientBlocks;
    }

    public int getMissingBlocks() {
        return this.missingBlocksPositions.size();
    }

    public int getExtraBlocks() {
        return this.extraBlocksPositions.size();
    }

    public int getMismatchedBlocks() {
        return this.wrongBlocksPositions.size();
    }

    public int getMismatchedStates() {
        return this.wrongStatesPositions.size();
    }

    public int getCorrectStatesCount() {
        return this.correctStatesCount;
    }

    public int getTotalErrors() {
        return this.getMismatchedBlocks() + this.getMismatchedStates() + this.getExtraBlocks() + this.getMissingBlocks();
    }

    public SortCriteria getSortCriteria() {
        return this.sortCriteria;
    }

    public boolean getSortInReverse() {
        return this.sortReverse;
    }

    public void setSortCriteria(SortCriteria criteria) {
        if (this.sortCriteria == criteria) {
            this.sortReverse = !this.sortReverse;
        } else {
            this.sortCriteria = criteria;
            this.sortReverse = criteria != SortCriteria.COUNT;
        }
    }

    public void toggleMismatchCategorySelected(MismatchType type) {
        if (type == MismatchType.CORRECT_STATE) {
            return;
        }
        if (this.selectedCategories.contains((Object)type)) {
            this.selectedCategories.remove((Object)type);
        } else {
            this.selectedCategories.add(type);
            this.removeSelectedEntriesOfType(type);
        }
        this.updateMismatchOverlays();
    }

    public void toggleMismatchEntrySelected(BlockMismatch mismatch) {
        MismatchType type = mismatch.mismatchType;
        if (this.selectedEntries.containsValue((Object)mismatch)) {
            this.selectedEntries.remove((Object)type, (Object)mismatch);
            this.updateMismatchOverlays();
        } else {
            if (this.selectedCategories.contains((Object)type)) {
                this.selectedCategories.remove((Object)type);
            }
            this.selectedEntries.put((Object)type, (Object)mismatch);
            this.updateMismatchOverlays();
        }
    }

    private void removeSelectedEntriesOfType(MismatchType type) {
        this.selectedEntries.removeAll((Object)type);
    }

    public boolean isMismatchCategorySelected(MismatchType type) {
        return this.selectedCategories.contains((Object)type);
    }

    public boolean isMismatchEntrySelected(BlockMismatch mismatch) {
        return this.selectedEntries.containsValue((Object)mismatch);
    }

    private void clearActiveMismatchRenderPositions() {
        this.mismatchPositionsForRender.clear();
        this.mismatchBlockPositionsForRender.clear();
        this.infoHudLines.clear();
    }

    public List<MismatchRenderPos> getSelectedMismatchPositionsForRender() {
        return this.mismatchPositionsForRender;
    }

    public List<el> getSelectedMismatchBlockPositionsForRender() {
        return this.mismatchBlockPositionsForRender;
    }

    @Override
    public boolean canExecute() {
        return this.mc.g != null;
    }

    @Override
    public boolean shouldRemove() {
        return !this.canExecute();
    }

    @Override
    public boolean execute() {
        this.verifyChunks();
        this.checkChangedPositions();
        return false;
    }

    @Override
    public void stop() {
    }

    public void startVerification(crg worldClient, WorldSchematic worldSchematic, SchematicPlacement schematicPlacement, ICompletionListener completionListener) {
        this.reset();
        this.worldClient = worldClient;
        this.worldSchematic = worldSchematic;
        this.schematicPlacement = schematicPlacement;
        this.setCompletionListener(completionListener);
        this.requiredChunks.addAll(schematicPlacement.getTouchedChunks());
        this.totalRequiredChunks = this.requiredChunks.size();
        this.verificationStarted = true;
        TaskScheduler.getInstanceClient().scheduleTask(this, 10);
        InfoHud.getInstance().addInfoHudRenderer(this, true);
        ACTIVE_VERIFIERS.add(this);
        this.verificationActive = true;
        this.updateRequiredChunksStringList();
    }

    public void resume() {
        if (this.verificationStarted) {
            this.verificationActive = true;
            this.updateRequiredChunksStringList();
        }
    }

    public void stopVerification() {
        this.verificationActive = false;
    }

    public void reset() {
        this.stopVerification();
        this.clearReferences();
        this.clearData();
    }

    private void clearReferences() {
        this.worldClient = null;
        this.worldSchematic = null;
        this.schematicPlacement = null;
    }

    private void clearData() {
        this.verificationActive = false;
        this.verificationStarted = false;
        this.finished = false;
        this.totalRequiredChunks = 0;
        this.correctStatesCount = 0;
        this.schematicBlocks = 0;
        this.clientBlocks = 0;
        this.requiredChunks.clear();
        this.recheckQueue.clear();
        this.missingBlocksPositions.clear();
        this.extraBlocksPositions.clear();
        this.wrongBlocksPositions.clear();
        this.wrongStatesPositions.clear();
        this.blockMismatches.clear();
        this.correctStateCounts.clear();
        this.selectedCategories.clear();
        this.selectedEntries.clear();
        this.mismatchBlockPositionsForRender.clear();
        this.mismatchPositionsForRender.clear();
        ACTIVE_VERIFIERS.remove(this);
        TaskScheduler.getInstanceClient().removeTask(this);
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        this.clearActiveMismatchRenderPositions();
    }

    public void markBlockChanged(el pos) {
        BlockMismatch mismatch;
        if (this.finished && (mismatch = (BlockMismatch)this.blockMismatches.get((Object)pos)) != null) {
            this.recheckQueue.add(pos);
        }
    }

    private void checkChangedPositions() {
        if (this.finished && !this.recheckQueue.isEmpty()) {
            Iterator<el> iter = this.recheckQueue.iterator();
            while (iter.hasNext()) {
                el pos = iter.next();
                if (!this.worldClient.a(pos, 1, false) || !this.worldSchematic.b(pos, false)) continue;
                BlockMismatch mismatch = (BlockMismatch)this.blockMismatches.get((Object)pos);
                if (mismatch != null) {
                    this.blockMismatches.remove((Object)pos);
                    blc stateFound = this.worldClient.a_(pos);
                    MUTABLE_PAIR.setLeft((Object)mismatch.stateExpected);
                    MUTABLE_PAIR.setRight((Object)mismatch.stateFound);
                    this.getMapForMismatchType(mismatch.mismatchType).remove(MUTABLE_PAIR, (Object)pos);
                    this.checkBlockStates(pos.o(), pos.p(), pos.q(), mismatch.stateExpected, stateFound);
                    if (!stateFound.f() && mismatch.stateFound.f()) {
                        ++this.clientBlocks;
                    }
                } else {
                    blc stateExpected = this.worldSchematic.a_(pos);
                    blc stateFound = this.worldClient.a_(pos);
                    this.checkBlockStates(pos.o(), pos.p(), pos.q(), stateExpected, stateFound);
                }
                iter.remove();
            }
            if (this.recheckQueue.isEmpty()) {
                this.updateMismatchOverlays();
            }
        }
    }

    private ArrayListMultimap<Pair<blc, blc>, el> getMapForMismatchType(MismatchType mismatchType) {
        switch (mismatchType) {
            case MISSING: {
                return this.missingBlocksPositions;
            }
            case EXTRA: {
                return this.extraBlocksPositions;
            }
            case WRONG_BLOCK: {
                return this.wrongBlocksPositions;
            }
            case WRONG_STATE: {
                return this.wrongStatesPositions;
            }
        }
        return null;
    }

    private boolean verifyChunks() {
        if (this.verificationActive) {
            Iterator<axm> iter = this.requiredChunks.iterator();
            boolean checkedSome = false;
            while (iter.hasNext() && System.nanoTime() - DataManager.getClientTickStartTime() < 50000000L) {
                axm pos = iter.next();
                int count = 0;
                for (int cx = pos.a - 1; cx <= pos.a + 1; ++cx) {
                    for (int cz = pos.b - 1; cz <= pos.b + 1; ++cz) {
                        if (this.worldClient.i().a(cx, cz, false, false) == null) continue;
                        ++count;
                    }
                }
                if (count != 9 || !this.worldSchematic.getChunkProvider().isChunkLoaded(pos.a, pos.b)) continue;
                bnj chunkClient = this.worldClient.c(pos.a, pos.b);
                bnj chunkSchematic = this.worldSchematic.c(pos.a, pos.b);
                ImmutableMap<String, IntBoundingBox> boxes = this.schematicPlacement.getBoxesWithinChunk(pos.a, pos.b);
                for (IntBoundingBox box : boxes.values()) {
                    this.verifyChunk(chunkClient, chunkSchematic, box);
                }
                iter.remove();
                checkedSome = true;
            }
            if (checkedSome) {
                this.updateRequiredChunksStringList();
            }
            if (this.requiredChunks.isEmpty()) {
                this.verificationActive = false;
                this.verificationStarted = false;
                this.finished = true;
                this.notifyListener();
            }
        }
        return !this.verificationActive;
    }

    public void ignoreStateMismatch(BlockMismatch mismatch) {
        this.ignoreStateMismatch(mismatch, true);
    }

    private void ignoreStateMismatch(BlockMismatch mismatch, boolean updateOverlay) {
        Pair ignore = Pair.of((Object)mismatch.stateExpected, (Object)mismatch.stateFound);
        if (!this.ignoredMismatches.contains(ignore)) {
            this.ignoredMismatches.add((Pair<blc, blc>)ignore);
            this.getMapForMismatchType(mismatch.mismatchType).removeAll((Object)ignore);
            ObjectIterator iter = this.blockMismatches.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (!((BlockMismatch)entry.getValue()).equals(mismatch)) continue;
                iter.remove();
            }
        }
        if (updateOverlay) {
            this.updateMismatchOverlays();
        }
    }

    public void addIgnoredStateMismatches(Collection<BlockMismatch> ignore) {
        for (BlockMismatch mismatch : ignore) {
            this.ignoreStateMismatch(mismatch, false);
        }
        this.updateMismatchOverlays();
    }

    public void resetIgnoredStateMismatches() {
        this.ignoredMismatches.clear();
    }

    public Set<Pair<blc, blc>> getIgnoredMismatches() {
        return this.ignoredMismatches;
    }

    public Object2IntOpenHashMap<blc> getCorrectStates() {
        return this.correctStateCounts;
    }

    @Nullable
    public BlockMismatch getMismatchForPosition(el pos) {
        return (BlockMismatch)this.blockMismatches.get((Object)pos);
    }

    public List<BlockMismatch> getMismatchOverviewFor(MismatchType type) {
        ArrayList<BlockMismatch> list = new ArrayList<BlockMismatch>();
        if (type == MismatchType.ALL) {
            return this.getMismatchOverviewCombined();
        }
        this.addCountFor(type, this.getMapForMismatchType(type), list);
        return list;
    }

    public List<BlockMismatch> getMismatchOverviewCombined() {
        ArrayList<BlockMismatch> list = new ArrayList<BlockMismatch>();
        this.addCountFor(MismatchType.MISSING, this.missingBlocksPositions, list);
        this.addCountFor(MismatchType.EXTRA, this.extraBlocksPositions, list);
        this.addCountFor(MismatchType.WRONG_BLOCK, this.wrongBlocksPositions, list);
        this.addCountFor(MismatchType.WRONG_STATE, this.wrongStatesPositions, list);
        Collections.sort(list);
        return list;
    }

    private void addCountFor(MismatchType mismatchType, ArrayListMultimap<Pair<blc, blc>, el> map, List<BlockMismatch> list) {
        for (Pair pair : map.keySet()) {
            list.add(new BlockMismatch(mismatchType, (blc)pair.getLeft(), (blc)pair.getRight(), map.get((Object)pair).size()));
        }
    }

    public List<Pair<blc, blc>> getIgnoredStateMismatchPairs(GuiBase gui) {
        ArrayList list = Lists.newArrayList(this.ignoredMismatches);
        try {
            Collections.sort(list, new Comparator<Pair<blc, blc>>(){

                @Override
                public int compare(Pair<blc, blc> o1, Pair<blc, blc> o2) {
                    String name2;
                    String name1 = fc.g.b((Object)((blc)o1.getLeft()).c()).toString();
                    int val = name1.compareTo(name2 = fc.g.b((Object)((blc)o2.getLeft()).c()).toString());
                    if (val < 0) {
                        return -1;
                    }
                    if (val > 0) {
                        return 1;
                    }
                    name1 = fc.g.b((Object)((blc)o1.getRight()).c()).toString();
                    name2 = fc.g.b((Object)((blc)o2.getRight()).c()).toString();
                    return name1.compareTo(name2);
                }
            });
        }
        catch (Exception e) {
            gui.addMessage(Message.MessageType.ERROR, "litematica.error.generic.failed_to_sort_list_of_ignored_states", new Object[0]);
        }
        return list;
    }

    private boolean verifyChunk(bnj chunkClient, bnj chunkSchematic, IntBoundingBox box) {
        LayerRange range = DataManager.getRenderLayerRange();
        eq.a axis = range.getAxis();
        boolean ranged = this.schematicPlacement.getSchematicVerifierType() == BlockInfoListType.RENDER_LAYERS;
        int startX = ranged && axis == eq.a.a ? Math.max(box.minX, range.getLayerMin()) : box.minX;
        int startY = ranged && axis == eq.a.b ? Math.max(box.minY, range.getLayerMin()) : box.minY;
        int startZ = ranged && axis == eq.a.c ? Math.max(box.minZ, range.getLayerMin()) : box.minZ;
        int endX = ranged && axis == eq.a.a ? Math.min(box.maxX, range.getLayerMax()) : box.maxX;
        int endY = ranged && axis == eq.a.b ? Math.min(box.maxY, range.getLayerMax()) : box.maxY;
        int endZ = ranged && axis == eq.a.c ? Math.min(box.maxZ, range.getLayerMax()) : box.maxZ;
        for (int y = startY; y <= endY; ++y) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int x = startX; x <= endX; ++x) {
                    MUTABLE_POS.c(x, y, z);
                    blc stateClient = chunkClient.a(x, y, z);
                    blc stateSchematic = chunkSchematic.a(x, y, z);
                    this.checkBlockStates(x, y, z, stateSchematic, stateClient);
                    if (!stateSchematic.f()) {
                        ++this.schematicBlocks;
                    }
                    if (stateClient.f()) continue;
                    ++this.clientBlocks;
                }
            }
        }
        return true;
    }

    private void checkBlockStates(int x, int y, int z, blc stateSchematic, blc stateClient) {
        el pos = new el(x, y, z);
        if (!(stateClient == stateSchematic || stateClient.f() && stateSchematic.f())) {
            MUTABLE_PAIR.setLeft((Object)stateSchematic);
            MUTABLE_PAIR.setRight((Object)stateClient);
            if (!this.ignoredMismatches.contains(MUTABLE_PAIR)) {
                BlockMismatch mismatch;
                if (!stateSchematic.f()) {
                    if (stateClient.f()) {
                        mismatch = new BlockMismatch(MismatchType.MISSING, stateSchematic, stateClient, 1);
                        this.missingBlocksPositions.put((Object)Pair.of((Object)stateSchematic, (Object)stateClient), (Object)pos);
                    } else if (stateSchematic.c() != stateClient.c()) {
                        mismatch = new BlockMismatch(MismatchType.WRONG_BLOCK, stateSchematic, stateClient, 1);
                        this.wrongBlocksPositions.put((Object)Pair.of((Object)stateSchematic, (Object)stateClient), (Object)pos);
                    } else {
                        mismatch = new BlockMismatch(MismatchType.WRONG_STATE, stateSchematic, stateClient, 1);
                        this.wrongStatesPositions.put((Object)Pair.of((Object)stateSchematic, (Object)stateClient), (Object)pos);
                    }
                } else {
                    mismatch = new BlockMismatch(MismatchType.EXTRA, stateSchematic, stateClient, 1);
                    this.extraBlocksPositions.put((Object)Pair.of((Object)stateSchematic, (Object)stateClient), (Object)pos);
                }
                this.blockMismatches.put((Object)pos, (Object)mismatch);
                ItemUtils.setItemForBlock((axy)this.worldClient, pos, stateClient);
                ItemUtils.setItemForBlock((axy)this.worldSchematic, pos, stateSchematic);
            }
        } else {
            ItemUtils.setItemForBlock((axy)this.worldClient, pos, stateClient);
            this.correctStateCounts.addTo((Object)stateClient, 1);
            if (!stateSchematic.f()) {
                ++this.correctStatesCount;
            }
        }
    }

    private void updateMismatchOverlays() {
        if (this.mc.i != null) {
            int maxEntries = Configs.InfoOverlays.VERIFIER_ERROR_HILIGHT_MAX_POSITIONS.getIntegerValue();
            el centerPos = new el(this.mc.i.bI());
            this.updateClosestPositions(centerPos, maxEntries);
            this.combineClosestPositions(centerPos, maxEntries);
            if (this.selectedCategories.size() == 1 && this.selectedEntries.size() == 0) {
                MismatchType type = this.mismatchPositionsForRender.size() > 0 ? this.mismatchPositionsForRender.get((int)0).type : null;
                this.updateMismatchPositionStringList(type, this.mismatchPositionsForRender);
            } else {
                this.updateMismatchPositionStringList(null, this.mismatchPositionsForRender);
            }
        }
    }

    private void updateClosestPositions(el centerPos, int maxEntries) {
        PositionUtils.BLOCK_POS_COMPARATOR.setReferencePosition(centerPos);
        PositionUtils.BLOCK_POS_COMPARATOR.setClosestFirst(true);
        this.addAndSortPositions(MismatchType.WRONG_BLOCK, this.wrongBlocksPositions, this.mismatchedBlocksPositionsClosest, maxEntries);
        this.addAndSortPositions(MismatchType.WRONG_STATE, this.wrongStatesPositions, this.mismatchedStatesPositionsClosest, maxEntries);
        this.addAndSortPositions(MismatchType.EXTRA, this.extraBlocksPositions, this.extraBlocksPositionsClosest, maxEntries);
        this.addAndSortPositions(MismatchType.MISSING, this.missingBlocksPositions, this.missingBlocksPositionsClosest, maxEntries);
    }

    private void addAndSortPositions(MismatchType type, ArrayListMultimap<Pair<blc, blc>, el> sourceMap, List<el> listOut, int maxEntries) {
        listOut.clear();
        if (this.selectedCategories.contains((Object)type)) {
            listOut.addAll(sourceMap.values());
        } else {
            Set mismatches = this.selectedEntries.get((Object)type);
            for (BlockMismatch mismatch : mismatches) {
                MUTABLE_PAIR.setLeft((Object)mismatch.stateExpected);
                MUTABLE_PAIR.setRight((Object)mismatch.stateFound);
                listOut.addAll(sourceMap.get(MUTABLE_PAIR));
            }
        }
        Collections.sort(listOut, PositionUtils.BLOCK_POS_COMPARATOR);
    }

    private void combineClosestPositions(el centerPos, int maxEntries) {
        this.mismatchPositionsForRender.clear();
        this.mismatchBlockPositionsForRender.clear();
        ArrayList<MismatchRenderPos> tempList = new ArrayList<MismatchRenderPos>();
        this.getMismatchRenderPositionFor(MismatchType.WRONG_BLOCK, tempList);
        this.getMismatchRenderPositionFor(MismatchType.WRONG_STATE, tempList);
        this.getMismatchRenderPositionFor(MismatchType.EXTRA, tempList);
        this.getMismatchRenderPositionFor(MismatchType.MISSING, tempList);
        Collections.sort(tempList, new RenderPosComparator(centerPos, true));
        int max = Math.min(maxEntries, tempList.size());
        for (int i = 0; i < max; ++i) {
            MismatchRenderPos entry = (MismatchRenderPos)tempList.get(i);
            this.mismatchPositionsForRender.add(entry);
            this.mismatchBlockPositionsForRender.add(entry.pos);
        }
    }

    private void getMismatchRenderPositionFor(MismatchType type, List<MismatchRenderPos> listOut) {
        List<el> list = this.getClosestMismatchedPositionsFor(type);
        for (el pos : list) {
            listOut.add(new MismatchRenderPos(type, pos));
        }
    }

    private List<el> getClosestMismatchedPositionsFor(MismatchType type) {
        switch (type) {
            case MISSING: {
                return this.missingBlocksPositionsClosest;
            }
            case EXTRA: {
                return this.extraBlocksPositionsClosest;
            }
            case WRONG_BLOCK: {
                return this.mismatchedBlocksPositionsClosest;
            }
            case WRONG_STATE: {
                return this.mismatchedStatesPositionsClosest;
            }
        }
        return Collections.emptyList();
    }

    private void updateMismatchPositionStringList(@Nullable MismatchType mismatchType, List<MismatchRenderPos> positionList) {
        ArrayList<String> hudLines = new ArrayList<String>();
        if (!positionList.isEmpty()) {
            String rst = GuiBase.TXT_RST;
            if (mismatchType != null) {
                hudLines.add(String.format("%s%s%s", mismatchType.getFormattingCode(), mismatchType.getDisplayname(), rst));
            } else {
                String title = StringUtils.translate((String)"litematica.gui.title.schematic_verifier_errors", (Object[])new Object[0]);
                hudLines.add(String.format("%s%s%s", GuiBase.TXT_BOLD, title, rst));
            }
            int count = Math.min(positionList.size(), Configs.InfoOverlays.INFO_HUD_MAX_LINES.getIntegerValue());
            for (int i = 0; i < count; ++i) {
                MismatchRenderPos entry = positionList.get(i);
                el pos = entry.pos;
                String pre = entry.type.getColorCode();
                hudLines.add(String.format("%sx: %5d, y: %3d, z: %5d%s", pre, pos.o(), pos.p(), pos.q(), rst));
            }
        }
        this.infoHudLines = hudLines;
    }

    public void updateRequiredChunksStringList() {
        this.updateInfoHudLinesMissingChunks(this.requiredChunks);
    }

    public static enum SortCriteria {
        NAME_EXPECTED,
        NAME_FOUND,
        COUNT;

    }

    public static enum MismatchType {
        ALL(0xFF0000, "litematica.gui.label.schematic_verifier_display_type.all", GuiBase.TXT_WHITE),
        MISSING(65535, "litematica.gui.label.schematic_verifier_display_type.missing", GuiBase.TXT_AQUA),
        EXTRA(0xFF00CF, "litematica.gui.label.schematic_verifier_display_type.extra", GuiBase.TXT_LIGHT_PURPLE),
        WRONG_BLOCK(0xFF0000, "litematica.gui.label.schematic_verifier_display_type.wrong_blocks", GuiBase.TXT_RED),
        WRONG_STATE(0xFFAF00, "litematica.gui.label.schematic_verifier_display_type.wrong_state", GuiBase.TXT_GOLD),
        CORRECT_STATE(0x11FF11, "litematica.gui.label.schematic_verifier_display_type.correct_state", GuiBase.TXT_GREEN);

        private final String unlocName;
        private final String colorCode;
        private final Color4f color;

        private MismatchType(int color, String unlocName, String colorCode) {
            this.color = Color4f.fromColor((int)color, (float)1.0f);
            this.unlocName = unlocName;
            this.colorCode = colorCode;
        }

        public Color4f getColor() {
            return this.color;
        }

        public String getDisplayname() {
            return StringUtils.translate((String)this.unlocName, (Object[])new Object[0]);
        }

        public String getColorCode() {
            return this.colorCode;
        }

        public String getFormattingCode() {
            return this.colorCode + GuiBase.TXT_BOLD;
        }
    }

    private static class RenderPosComparator
    implements Comparator<MismatchRenderPos> {
        private final el posReference;
        private final boolean closestFirst;

        public RenderPosComparator(el posReference, boolean closestFirst) {
            this.posReference = posReference;
            this.closestFirst = closestFirst;
        }

        @Override
        public int compare(MismatchRenderPos pos1, MismatchRenderPos pos2) {
            double dist2;
            double dist1 = pos1.pos.n((ff)this.posReference);
            if (dist1 == (dist2 = pos2.pos.n((ff)this.posReference))) {
                return 0;
            }
            return dist1 < dist2 == this.closestFirst ? -1 : 1;
        }
    }

    public static class MismatchRenderPos {
        public final MismatchType type;
        public final el pos;

        public MismatchRenderPos(MismatchType type, el pos) {
            this.type = type;
            this.pos = pos;
        }
    }

    public static class BlockMismatch
    implements Comparable<BlockMismatch> {
        public final MismatchType mismatchType;
        public final blc stateExpected;
        public final blc stateFound;
        public final int count;

        public BlockMismatch(MismatchType mismatchType, blc stateExpected, blc stateFound, int count) {
            this.mismatchType = mismatchType;
            this.stateExpected = stateExpected;
            this.stateFound = stateFound;
            this.count = count;
        }

        @Override
        public int compareTo(BlockMismatch other) {
            return this.count > other.count ? -1 : (this.count < other.count ? 1 : 0);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.mismatchType == null ? 0 : this.mismatchType.hashCode());
            result = 31 * result + (this.stateExpected == null ? 0 : this.stateExpected.hashCode());
            result = 31 * result + (this.stateFound == null ? 0 : this.stateFound.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BlockMismatch other = (BlockMismatch)obj;
            if (this.mismatchType != other.mismatchType) {
                return false;
            }
            if (this.stateExpected == null ? other.stateExpected != null : this.stateExpected != other.stateExpected) {
                return false;
            }
            return !(this.stateFound == null ? other.stateFound != null : this.stateFound != other.stateFound);
        }
    }
}

