/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.placement;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.data.SchematicHolder;
import fi.dy.masa.litematica.render.LitematicaRenderer;
import fi.dy.masa.litematica.render.OverlayRenderer;
import fi.dy.masa.litematica.render.infohud.StatusInfoRenderer;
import fi.dy.masa.litematica.scheduler.TaskScheduler;
import fi.dy.masa.litematica.scheduler.tasks.TaskPasteSchematicSetblock;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.LayerMode;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class SchematicPlacementManager {
    private final List<SchematicPlacement> schematicPlacements = new ArrayList<SchematicPlacement>();
    private final HashMultimap<axm, SchematicPlacement> schematicsTouchingChunk = HashMultimap.create();
    private final ArrayListMultimap<SubChunkPos, PlacementPart> touchedVolumesInSubChunk = ArrayListMultimap.create();
    private final Set<axm> chunksToRebuild = new HashSet<axm>();
    private final Set<axm> chunksToUnload = new HashSet<axm>();
    private final Set<axm> chunksPreChange = new HashSet<axm>();
    @Nullable
    private SchematicPlacement selectedPlacement;

    public boolean hasPendingRebuilds() {
        return !this.chunksToRebuild.isEmpty();
    }

    public boolean hasPendingRebuildFor(axm pos) {
        return this.chunksToRebuild.contains(pos);
    }

    public boolean processQueuedChunks() {
        if (!this.chunksToUnload.isEmpty()) {
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            if (worldSchematic != null) {
                for (axm pos : this.chunksToUnload) {
                    this.unloadSchematicChunk(worldSchematic, pos.a, pos.b);
                }
            }
            this.chunksToUnload.clear();
        }
        if (!this.chunksToRebuild.isEmpty()) {
            crg worldClient = cft.s().g;
            if (worldClient == null) {
                this.chunksToRebuild.clear();
                return true;
            }
            WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
            Iterator<axm> iter = this.chunksToRebuild.iterator();
            while (iter.hasNext() && System.nanoTime() - DataManager.getClientTickStartTime() < 45000000L) {
                axm pos = iter.next();
                if (!this.schematicsTouchingChunk.containsKey((Object)pos)) {
                    iter.remove();
                    continue;
                }
                if (Configs.Generic.LOAD_ENTIRE_SCHEMATICS.getBooleanValue() || worldClient.i().a(pos.a, pos.b, false, false) != null) {
                    this.unloadSchematicChunk(worldSchematic, pos.a, pos.b);
                    worldSchematic.getChunkProvider().loadChunk(pos.a, pos.b);
                }
                if (!worldSchematic.getChunkProvider().isChunkLoaded(pos.a, pos.b)) continue;
                Set placements = this.schematicsTouchingChunk.get((Object)pos);
                if (!placements.isEmpty()) {
                    for (SchematicPlacement placement : placements) {
                        if (!placement.isEnabled()) continue;
                        placement.getSchematic().placeToWorldWithinChunk((axy)worldSchematic, pos, placement, false);
                    }
                    int maxY = worldSchematic.getChunkProvider().getChunk(pos.a, pos.b).b() + 15;
                    worldSchematic.a(pos.a << 4, 0, pos.b << 4, (pos.a << 4) + 15, maxY, (pos.b << 4) + 15);
                }
                iter.remove();
            }
            LitematicaRenderer.getInstance().getWorldRenderer().markNeedsUpdate();
            if (this.chunksToRebuild.isEmpty()) {
                return true;
            }
        }
        return false;
    }

    public void onClientChunkUnload(int chunkX, int chunkZ) {
        WorldSchematic worldSchematic;
        if (!Configs.Generic.LOAD_ENTIRE_SCHEMATICS.getBooleanValue() && (worldSchematic = SchematicWorldHandler.getSchematicWorld()) != null) {
            this.unloadSchematicChunk(worldSchematic, chunkX, chunkZ);
            this.chunksToRebuild.add(new axm(chunkX, chunkZ));
        }
    }

    private void unloadSchematicChunk(WorldSchematic worldSchematic, int chunkX, int chunkZ) {
        if (worldSchematic.getChunkProvider().isChunkLoaded(chunkX, chunkZ)) {
            worldSchematic.a(chunkX << 4, 0, chunkZ << 4, (chunkX << 4) + 15, 255, (chunkZ << 4) + 15);
            worldSchematic.getChunkProvider().a(chunkX, chunkZ);
        }
    }

    public List<SchematicPlacement> getAllSchematicsPlacements() {
        return this.schematicPlacements;
    }

    public List<IntBoundingBox> getTouchedBoxesInSubChunk(SubChunkPos subChunk) {
        ArrayList<IntBoundingBox> list = new ArrayList<IntBoundingBox>();
        for (PlacementPart part : this.touchedVolumesInSubChunk.get((Object)subChunk)) {
            list.add(part.getBox());
        }
        return list;
    }

    public List<PlacementPart> getAllPlacementsTouchingSubChunk(SubChunkPos pos) {
        return this.touchedVolumesInSubChunk.get((Object)pos);
    }

    public Set<SubChunkPos> getAllTouchedSubChunks() {
        return this.touchedVolumesInSubChunk.keySet();
    }

    public void addSchematicPlacement(SchematicPlacement placement, boolean printMessages) {
        if (!this.schematicPlacements.contains(placement)) {
            this.schematicPlacements.add(placement);
            this.addTouchedChunksFor(placement);
            StatusInfoRenderer.getInstance().startOverrideDelay();
            if (printMessages) {
                InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)StringUtils.translate((String)"litematica.message.schematic_placement_created", (Object[])new Object[]{placement.getName()}), (Object[])new Object[0]);
                if (Configs.InfoOverlays.WARN_DISABLED_RENDERING.getBooleanValue()) {
                    String hotkeyVal;
                    String hotkeyName;
                    String configName;
                    ConfigHotkey hotkey;
                    LayerMode mode = DataManager.getRenderLayerRange().getLayerMode();
                    if (mode != LayerMode.ALL) {
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)"litematica.message.warn.layer_mode_currently_at", (Object[])new Object[]{mode.getDisplayName()});
                    }
                    if (!Configs.Visuals.ENABLE_RENDERING.getBooleanValue()) {
                        hotkey = Hotkeys.TOGGLE_ALL_RENDERING;
                        configName = Configs.Visuals.ENABLE_RENDERING.getName();
                        hotkeyName = hotkey.getName();
                        hotkeyVal = hotkey.getKeybind().getKeysDisplayString();
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"litematica.message.warn.main_rendering_disabled", (Object[])new Object[]{configName, hotkeyName, hotkeyVal});
                    }
                    if (!Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
                        hotkey = Hotkeys.TOGGLE_SCHEMATIC_RENDERING;
                        configName = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getName();
                        hotkeyName = hotkey.getName();
                        hotkeyVal = hotkey.getKeybind().getKeysDisplayString();
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"litematica.message.warn.schematic_rendering_disabled", (Object[])new Object[]{configName, hotkeyName, hotkeyVal});
                    }
                    if (!Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue()) {
                        hotkey = Hotkeys.TOGGLE_SCHEMATIC_BLOCK_RENDERING;
                        configName = Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getName();
                        hotkeyName = hotkey.getName();
                        hotkeyVal = hotkey.getKeybind().getKeysDisplayString();
                        InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.WARNING, (int)8000, (String)"litematica.message.warn.schematic_blocks_rendering_disabled", (Object[])new Object[]{configName, hotkeyName, hotkeyVal});
                    }
                }
            }
        } else if (printMessages) {
            InfoUtils.showGuiAndInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.duplicate_schematic_placement", (Object[])new Object[0]);
        }
    }

    public boolean removeSchematicPlacement(SchematicPlacement placement) {
        return this.removeSchematicPlacement(placement, true);
    }

    public boolean removeSchematicPlacement(SchematicPlacement placement, boolean update) {
        if (this.selectedPlacement == placement) {
            this.selectedPlacement = null;
        }
        boolean ret = this.schematicPlacements.remove(placement);
        this.removeTouchedChunksFor(placement);
        if (ret) {
            placement.onRemoved();
            if (update) {
                this.onPlacementModified(placement);
            }
        }
        return ret;
    }

    public void removeAllPlacementsOfSchematic(LitematicaSchematic schematic) {
        boolean removed = false;
        for (int i = 0; i < this.schematicPlacements.size(); ++i) {
            SchematicPlacement placement = this.schematicPlacements.get(i);
            if (placement.getSchematic() != schematic) continue;
            removed |= this.removeSchematicPlacement(placement, false);
            --i;
        }
        if (removed) {
            OverlayRenderer.getInstance().updatePlacementCache();
        }
    }

    @Nullable
    public SchematicPlacement getSelectedSchematicPlacement() {
        return this.selectedPlacement;
    }

    public void setSelectedSchematicPlacement(@Nullable SchematicPlacement placement) {
        if (placement == null || this.schematicPlacements.contains(placement)) {
            this.selectedPlacement = placement;
            OverlayRenderer.getInstance().updatePlacementCache();
            DataManager.setMaterialList(null);
        }
    }

    private void addTouchedChunksFor(SchematicPlacement placement) {
        if (placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) {
            Set<axm> chunks = placement.getTouchedChunks();
            for (axm pos : chunks) {
                if (!this.schematicsTouchingChunk.containsEntry((Object)pos, (Object)placement)) {
                    this.schematicsTouchingChunk.put((Object)pos, (Object)placement);
                    this.updateTouchedBoxesInChunk(pos);
                }
                this.chunksToUnload.remove(pos);
            }
            this.markChunksForRebuild(placement);
            this.onPlacementModified(placement);
        }
    }

    private void removeTouchedChunksFor(SchematicPlacement placement) {
        if (placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) {
            Set<axm> chunks = placement.getTouchedChunks();
            for (axm pos : chunks) {
                this.schematicsTouchingChunk.remove((Object)pos, (Object)placement);
                this.updateTouchedBoxesInChunk(pos);
                if (this.schematicsTouchingChunk.containsKey((Object)pos)) continue;
                this.chunksToUnload.add(pos);
            }
            chunks.removeAll(this.chunksToUnload);
            this.markChunksForRebuild(chunks);
        }
    }

    void onPrePlacementChange(SchematicPlacement placement) {
        this.chunksPreChange.clear();
        this.chunksPreChange.addAll(placement.getTouchedChunks());
    }

    void onPostPlacementChange(SchematicPlacement placement) {
        Set<axm> chunksPost = placement.getTouchedChunks();
        HashSet<axm> toRebuild = new HashSet<axm>(chunksPost);
        this.chunksPreChange.removeAll(chunksPost);
        for (axm pos : this.chunksPreChange) {
            this.schematicsTouchingChunk.remove((Object)pos, (Object)placement);
            this.updateTouchedBoxesInChunk(pos);
            if (!this.schematicsTouchingChunk.containsKey((Object)pos)) {
                this.chunksToUnload.add(pos);
                continue;
            }
            toRebuild.add(pos);
        }
        for (axm pos : chunksPost) {
            if (!this.schematicsTouchingChunk.containsEntry((Object)pos, (Object)placement)) {
                this.schematicsTouchingChunk.put((Object)pos, (Object)placement);
            }
            this.updateTouchedBoxesInChunk(pos);
        }
        this.markChunksForRebuild(toRebuild);
        this.onPlacementModified(placement);
    }

    private void updateTouchedBoxesInChunk(axm pos) {
        for (int y = 0; y < 16; ++y) {
            SubChunkPos subChunk = new SubChunkPos(pos.a, y, pos.b);
            this.touchedVolumesInSubChunk.removeAll((Object)subChunk);
        }
        Set placements = this.schematicsTouchingChunk.get((Object)pos);
        if (!placements.isEmpty()) {
            for (SchematicPlacement placement : placements) {
                if (!placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.RENDERING_ENABLED)) continue;
                ImmutableMap<String, IntBoundingBox> boxMap = placement.getBoxesWithinChunk(pos.a, pos.b);
                for (Map.Entry entry : boxMap.entrySet()) {
                    IntBoundingBox bbOrig = (IntBoundingBox)entry.getValue();
                    int startCY = bbOrig.minY >> 4;
                    int endCY = bbOrig.maxY >> 4;
                    for (int cy = startCY; cy <= endCY; ++cy) {
                        int y1 = Math.max(cy << 4, bbOrig.minY);
                        int y2 = Math.min((cy << 4) + 15, bbOrig.maxY);
                        IntBoundingBox bbSub = new IntBoundingBox(bbOrig.minX, y1, bbOrig.minZ, bbOrig.maxX, y2, bbOrig.maxZ);
                        PlacementPart part = new PlacementPart(placement, (String)entry.getKey(), bbSub);
                        this.touchedVolumesInSubChunk.put((Object)new SubChunkPos(pos.a, cy, pos.b), (Object)part);
                    }
                }
            }
        }
    }

    public void markAllPlacementsOfSchematicForRebuild(LitematicaSchematic schematic) {
        for (int i = 0; i < this.schematicPlacements.size(); ++i) {
            SchematicPlacement placement = this.schematicPlacements.get(i);
            if (placement.getSchematic() != schematic) continue;
            this.markChunksForRebuild(placement);
        }
    }

    public void markChunksForRebuild(SchematicPlacement placement) {
        if (placement.matchesRequirement(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED)) {
            this.markChunksForRebuild(placement.getTouchedChunks());
        }
    }

    void markChunksForRebuild(Collection<axm> chunks) {
        this.chunksToRebuild.addAll(chunks);
    }

    public void markChunkForRebuild(axm pos) {
        this.chunksToRebuild.add(pos);
    }

    private void onPlacementModified(SchematicPlacement placement) {
        if (placement.isEnabled()) {
            OverlayRenderer.getInstance().updatePlacementCache();
        }
    }

    public boolean changeSelection(axy world, aer entity, int maxDistance) {
        if (this.schematicPlacements.size() > 0) {
            RayTraceUtils.RayTraceWrapper trace = RayTraceUtils.getWrappedRayTraceFromEntity(world, entity, maxDistance);
            SchematicPlacement placement = this.getSelectedSchematicPlacement();
            if (placement != null) {
                placement.setSelectedSubRegionName(null);
            }
            if (trace.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.PLACEMENT_SUBREGION || trace.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.PLACEMENT_ORIGIN) {
                this.setSelectedSchematicPlacement(trace.getHitSchematicPlacement());
                boolean selectSubRegion = Hotkeys.SELECTION_GRAB_MODIFIER.getKeybind().isKeybindHeld();
                String subRegionName = selectSubRegion ? trace.getHitSchematicPlacementRegionName() : null;
                this.getSelectedSchematicPlacement().setSelectedSubRegionName(subRegionName);
                return true;
            }
            if (trace.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.MISS) {
                this.setSelectedSchematicPlacement(null);
                return true;
            }
        }
        return false;
    }

    public void setPositionOfCurrentSelectionToRayTrace(cft mc, double maxDistance) {
        SchematicPlacement schematicPlacement = this.getSelectedSchematicPlacement();
        if (schematicPlacement != null) {
            ceb trace = RayTraceUtils.getRayTraceFromEntity((axy)mc.g, (aer)mc.i, false, maxDistance);
            if (trace.a != ceb.a.b) {
                return;
            }
            el pos = trace.a();
            if (!mc.i.aZ()) {
                pos = pos.a(trace.b);
            }
            this.setPositionOfCurrentSelectionTo(pos, mc);
        }
    }

    public void setPositionOfCurrentSelectionTo(el pos, cft mc) {
        SchematicPlacement schematicPlacement = this.getSelectedSchematicPlacement();
        if (schematicPlacement != null) {
            boolean movingBox;
            if (schematicPlacement.isLocked()) {
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.placement.cant_modify_is_locked", (Object[])new Object[0]);
                return;
            }
            boolean bl = movingBox = schematicPlacement.getSelectedSubRegionPlacement() != null;
            if (movingBox) {
                schematicPlacement.moveSubRegionTo(schematicPlacement.getSelectedSubRegionName(), pos, InfoUtils.INFO_MESSAGE_CONSUMER);
                String posStr = String.format("x: %d, y: %d, z: %d", pos.o(), pos.p(), pos.q());
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.placement.moved_subregion_to", (Object[])new Object[]{posStr});
            } else {
                el old = schematicPlacement.getOrigin();
                schematicPlacement.setOrigin(pos, InfoUtils.INFO_MESSAGE_CONSUMER);
                if (!old.equals((Object)schematicPlacement.getOrigin())) {
                    String posStrOld = String.format("x: %d, y: %d, z: %d", old.o(), old.p(), old.q());
                    String posStrNew = String.format("x: %d, y: %d, z: %d", pos.o(), pos.p(), pos.q());
                    InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.placement.moved_placement_origin", (Object[])new Object[]{posStrOld, posStrNew});
                }
            }
        }
    }

    public void nudgePositionOfCurrentSelection(eq direction, int amount) {
        SchematicPlacement schematicPlacement = this.getSelectedSchematicPlacement();
        if (schematicPlacement != null) {
            if (schematicPlacement.isLocked()) {
                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.placement.cant_modify_is_locked", (Object[])new Object[0]);
                return;
            }
            SubRegionPlacement placement = schematicPlacement.getSelectedSubRegionPlacement();
            if (placement != null) {
                el old = PositionUtils.getTransformedBlockPos(placement.getPos(), schematicPlacement.getMirror(), schematicPlacement.getRotation());
                old = old.a((ff)schematicPlacement.getOrigin());
                schematicPlacement.moveSubRegionTo(placement.getName(), old.a(direction, amount), InfoUtils.INFO_MESSAGE_CONSUMER);
            } else {
                el old = schematicPlacement.getOrigin();
                schematicPlacement.setOrigin(old.a(direction, amount), InfoUtils.INFO_MESSAGE_CONSUMER);
            }
        }
    }

    public void pasteCurrentPlacementToWorld(cft mc) {
        this.pastePlacementToWorld(this.getSelectedSchematicPlacement(), mc);
    }

    public void pastePlacementToWorld(SchematicPlacement schematicPlacement, cft mc) {
        this.pastePlacementToWorld(schematicPlacement, true, mc);
    }

    public void pastePlacementToWorld(SchematicPlacement schematicPlacement, boolean changedBlocksOnly, cft mc) {
        this.pastePlacementToWorld(schematicPlacement, changedBlocksOnly, true, mc);
    }

    public void pastePlacementToWorld(SchematicPlacement schematicPlacement, boolean changedBlocksOnly, boolean printMessage, cft mc) {
        if (mc.i != null && mc.i.bV.d) {
            if (schematicPlacement != null) {
                if (!PositionUtils.isPlacementWithinWorld((axy)mc.g, schematicPlacement, false)) {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.placement_paste_outside_world", (Object[])new Object[0]);
                    return;
                }
                if (mc.x()) {
                    td world = mc.y().a(mc.i.bJ().t.q());
                    LitematicaSchematic schematic = schematicPlacement.getSchematic();
                    world.a(() -> {
                        if (schematic.placeToWorld((axy)world, schematicPlacement, false)) {
                            if (printMessage) {
                                InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted", (Object[])new Object[0]);
                            }
                        } else {
                            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
                        }
                    });
                    if (printMessage) {
                        InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.scheduled_task_added", (Object[])new Object[0]);
                    }
                } else {
                    TaskPasteSchematicSetblock task = new TaskPasteSchematicSetblock(schematicPlacement, changedBlocksOnly);
                    TaskScheduler.getInstanceClient().scheduleTask(task, Configs.Generic.PASTE_COMMAND_INTERVAL.getIntegerValue());
                    if (printMessage) {
                        InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.INFO, (String)"litematica.message.scheduled_task_added", (Object[])new Object[0]);
                    }
                }
            } else {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_placement_selected", (Object[])new Object[0]);
            }
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.generic.creative_mode_only", (Object[])new Object[0]);
        }
    }

    public void clear() {
        this.schematicPlacements.clear();
        this.selectedPlacement = null;
        this.schematicsTouchingChunk.clear();
        this.touchedVolumesInSubChunk.clear();
        this.chunksPreChange.clear();
        this.chunksToRebuild.clear();
        this.chunksToUnload.clear();
        SchematicHolder.getInstance().clearLoadedSchematics();
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        if (this.schematicPlacements.size() > 0) {
            JsonArray arr = new JsonArray();
            int selectedIndex = 0;
            boolean indexValid = false;
            for (int i = 0; i < this.schematicPlacements.size(); ++i) {
                JsonObject objPlacement;
                SchematicPlacement placement = this.schematicPlacements.get(i);
                if (!placement.shouldBeSaved() || (objPlacement = placement.toJson()) == null) continue;
                arr.add((JsonElement)objPlacement);
                if (this.selectedPlacement == placement) {
                    indexValid = true;
                    continue;
                }
                if (indexValid) continue;
                ++selectedIndex;
            }
            obj.add("placements", (JsonElement)arr);
            if (indexValid) {
                obj.add("selected", (JsonElement)new JsonPrimitive((Number)selectedIndex));
                obj.add("origin_selected", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            }
        }
        return obj;
    }

    public void loadFromJson(JsonObject obj) {
        this.clear();
        if (JsonUtils.hasArray((JsonObject)obj, (String)"placements")) {
            JsonArray arr = obj.get("placements").getAsJsonArray();
            int index = JsonUtils.hasInteger((JsonObject)obj, (String)"selected") ? obj.get("selected").getAsInt() : -1;
            int size = arr.size();
            for (int i = 0; i < size; ++i) {
                JsonElement el2 = arr.get(i);
                if (el2.isJsonObject()) {
                    SchematicPlacement placement = SchematicPlacement.fromJson(el2.getAsJsonObject());
                    if (placement == null) continue;
                    this.addSchematicPlacement(placement, false);
                    continue;
                }
                index = -1;
            }
            if (index >= 0 && index < this.schematicPlacements.size()) {
                this.selectedPlacement = this.schematicPlacements.get(index);
            }
        }
        OverlayRenderer.getInstance().updatePlacementCache();
    }

    public static class PlacementPart {
        private final SchematicPlacement placement;
        private final String subRegionName;
        private final IntBoundingBox bb;

        public PlacementPart(SchematicPlacement placement, String subRegionName, IntBoundingBox bb) {
            this.placement = placement;
            this.subRegionName = subRegionName;
            this.bb = bb;
        }

        public SchematicPlacement getPlacement() {
            return this.placement;
        }

        public String getSubRegionName() {
            return this.subRegionName;
        }

        public IntBoundingBox getBox() {
            return this.bb;
        }
    }
}

