/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import java.util.HashMap;

public class StateTagFixers_1_12_to_1_13_2 {
    private static final HashMap<String, IStateTagFixer> FIXERS = new HashMap();
    public static final IStateTagFixer FIXER_LEVER = tagIn -> {
        String facing;
        gy newTag = tagIn.f();
        gy tagProps = newTag.p("Properties");
        String face = facing = tagProps.l("facing");
        switch (facing) {
            case "down_x": {
                facing = "west";
                face = "ceiling";
                break;
            }
            case "down_z": {
                facing = "north";
                face = "ceiling";
                break;
            }
            case "up_x": {
                facing = "west";
                face = "floor";
                break;
            }
            case "up_z": {
                facing = "north";
                face = "floor";
                break;
            }
        }
        tagProps.a("facing", facing);
        tagProps.a("face", face);
        return newTag;
    };
    public static final IStateTagFixer FIXER_REDSTONE_TORCHES = tagIn -> {
        gy newTag = tagIn.f();
        gy tagProps = newTag.p("Properties");
        boolean isLit = newTag.l("Name").equals("minecraft:redstone_torch");
        tagProps.a("lit", isLit ? "true" : "false");
        if (tagProps.l("facing").equals("up")) {
            newTag.a("Name", "minecraft:redstone_torch");
            tagProps.r("facing");
        } else {
            newTag.a("Name", "minecraft:redstone_wall_torch");
        }
        return newTag;
    };
    public static final IStateTagFixer FIXER_TORCH = tagIn -> {
        gy newTag = tagIn.f();
        if (newTag.p("Properties").l("facing").equals("up")) {
            newTag.r("Properties");
        } else {
            newTag.a("Name", "minecraft:wall_torch");
        }
        return newTag;
    };

    public static void init() {
        FIXERS.clear();
        FIXERS.put("minecraft:lever", FIXER_LEVER);
        FIXERS.put("minecraft:redstone_torch", FIXER_REDSTONE_TORCHES);
        FIXERS.put("minecraft:unlit_redstone_torch", FIXER_REDSTONE_TORCHES);
        FIXERS.put("minecraft:torch", FIXER_TORCH);
    }

    public static gy fixStateTag(gy tagIn) {
        String blockName = tagIn.l("Name");
        IStateTagFixer fixer = FIXERS.get(blockName);
        if (fixer != null) {
            return fixer.fixStateTag(tagIn);
        }
        return tagIn;
    }

    public static interface IStateTagFixer {
        public gy fixStateTag(gy var1);
    }
}

