/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.conversion;

import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import java.util.Arrays;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;

public class SchematicConverter {
    private final IdentityHashMap<Class<? extends bcs>, SchematicConversionFixers.IStateFixer> fixersPerBlock = new IdentityHashMap();
    private IdentityHashMap<blc, SchematicConversionFixers.IStateFixer> postProcessingStateFixers = new IdentityHashMap();

    private SchematicConverter() {
        this.addPostUpdateBlocks();
    }

    public static SchematicConverter create() {
        return new SchematicConverter();
    }

    public boolean getConvertedStatesForBlock(int schematicBlockId, String blockName, blc[] paletteOut) {
        int shiftedOldVanillaId = SchematicConversionMaps.getOldNameToShiftedBlockId(blockName);
        int successCount = 0;
        if (shiftedOldVanillaId >= 0) {
            for (int meta = 0; meta < 16; ++meta) {
                blc state = SchematicConversionMaps.get_1_13_2_StateForIdMeta(shiftedOldVanillaId & 0xFFF0 | meta);
                if (state == null) continue;
                paletteOut[schematicBlockId << 4 | meta] = state;
                ++successCount;
            }
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)("Failed to convert block with old name '" + blockName + "'"), (Object[])new Object[0]);
        }
        return successCount > 0;
    }

    public boolean getVanillaBlockPalette(blc[] paletteOut) {
        for (int idMeta = 0; idMeta < paletteOut.length; ++idMeta) {
            blc state = SchematicConversionMaps.get_1_13_2_StateForIdMeta(idMeta);
            if (state == null) continue;
            paletteOut[idMeta] = state;
        }
        return true;
    }

    public blc[] getBlockStatePaletteForBlockPalette(String[] blockPalette) {
        Object[] palette = new blc[blockPalette.length * 16];
        Arrays.fill(palette, bct.a.p());
        for (int schematicBlockId = 0; schematicBlockId < blockPalette.length; ++schematicBlockId) {
            String blockName = blockPalette[schematicBlockId];
            this.getConvertedStatesForBlock(schematicBlockId, blockName, (blc[])palette);
        }
        return palette;
    }

    public boolean createPostProcessStateFilter(blc[] palette) {
        boolean needsPostProcess = false;
        this.postProcessingStateFixers.clear();
        for (int i = 0; i < palette.length; ++i) {
            blc state = palette[i];
            if (!this.needsPostProcess(state)) continue;
            this.postProcessingStateFixers.put(state, this.getFixerFor(state));
            needsPostProcess = true;
        }
        return needsPostProcess;
    }

    public IdentityHashMap<blc, SchematicConversionFixers.IStateFixer> getPostProcessStateFilter() {
        return this.postProcessingStateFixers;
    }

    private boolean needsPostProcess(blc state) {
        return !state.f() && this.fixersPerBlock.containsKey(state.c().getClass());
    }

    @Nullable
    private SchematicConversionFixers.IStateFixer getFixerFor(blc state) {
        return this.fixersPerBlock.get(state.c().getClass());
    }

    public gy fixTileEntityNBT(gy tag, blc state) {
        return tag;
    }

    private void addPostUpdateBlocks() {
        this.fixersPerBlock.put(bdj.class, SchematicConversionFixers.FIXER_CHRORUS_PLANT);
        this.fixersPerBlock.put(bhp.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(bed.class, SchematicConversionFixers.FIXER_DOOR);
        this.fixersPerBlock.put(ber.class, SchematicConversionFixers.FIXER_FENCE);
        this.fixersPerBlock.put(bes.class, SchematicConversionFixers.FIXER_FENCE_GATE);
        this.fixersPerBlock.put(bet.class, SchematicConversionFixers.FIXER_FIRE);
        this.fixersPerBlock.put(bez.class, SchematicConversionFixers.FIXER_PANE);
        this.fixersPerBlock.put(bfc.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(bgb.class, SchematicConversionFixers.FIXER_DIRT_SNOWY);
        this.fixersPerBlock.put(bfm.class, SchematicConversionFixers.FIXER_PANE);
        this.fixersPerBlock.put(bgz.class, SchematicConversionFixers.FIXER_REDSTONE_REPEATER);
        this.fixersPerBlock.put(bgu.class, SchematicConversionFixers.FIXER_REDSTONE_WIRE);
        this.fixersPerBlock.put(bhh.class, SchematicConversionFixers.FIXER_DOUBLE_PLANT);
        this.fixersPerBlock.put(bhz.class, SchematicConversionFixers.FIXER_STEM);
        this.fixersPerBlock.put(bhw.class, SchematicConversionFixers.FIXER_PANE);
        this.fixersPerBlock.put(bhx.class, SchematicConversionFixers.FIXER_STAIRS);
        this.fixersPerBlock.put(big.class, SchematicConversionFixers.FIXER_DOUBLE_PLANT);
        this.fixersPerBlock.put(bin.class, SchematicConversionFixers.FIXER_TRIPWIRE);
        this.fixersPerBlock.put(biq.class, SchematicConversionFixers.FIXER_VINE);
        this.fixersPerBlock.put(bis.class, SchematicConversionFixers.FIXER_WALL);
        this.fixersPerBlock.put(bcg.class, SchematicConversionFixers.FIXER_BANNER);
        this.fixersPerBlock.put(bir.class, SchematicConversionFixers.FIXER_BANNER_WALL);
        this.fixersPerBlock.put(bcq.class, SchematicConversionFixers.FIXER_BED);
        this.fixersPerBlock.put(bev.class, SchematicConversionFixers.FIXER_FLOWER_POT);
        this.fixersPerBlock.put(bgf.class, SchematicConversionFixers.FIXER_NOTE_BLOCK);
        this.fixersPerBlock.put(bhk.class, SchematicConversionFixers.FIXER_SKULL);
        this.fixersPerBlock.put(biu.class, SchematicConversionFixers.FIXER_SKULL_WALL);
    }
}

