/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic.container;

import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;

public class LitematicaBitArray {
    private final long[] longArray;
    private final int bitsPerEntry;
    private final long maxEntryValue;
    private final int arraySize;

    public LitematicaBitArray(int bitsPerEntryIn, int arraySizeIn) {
        this(bitsPerEntryIn, arraySizeIn, null);
    }

    public LitematicaBitArray(int bitsPerEntryIn, int arraySizeIn, @Nullable long[] longArrayIn) {
        Validate.inclusiveBetween((long)1L, (long)32L, (long)bitsPerEntryIn);
        this.arraySize = arraySizeIn;
        this.bitsPerEntry = bitsPerEntryIn;
        this.maxEntryValue = (1L << bitsPerEntryIn) - 1L;
        this.longArray = longArrayIn != null ? longArrayIn : new long[xq.c((int)(arraySizeIn * bitsPerEntryIn), (int)64) / 64];
    }

    public void setAt(int index, int value) {
        Validate.inclusiveBetween((long)0L, (long)(this.arraySize - 1), (long)index);
        Validate.inclusiveBetween((long)0L, (long)this.maxEntryValue, (long)value);
        int startOffset = index * this.bitsPerEntry;
        int startArrIndex = startOffset >> 6;
        int endArrIndex = (index + 1) * this.bitsPerEntry - 1 >> 6;
        int startBitOffset = startOffset & 0x3F;
        this.longArray[startArrIndex] = this.longArray[startArrIndex] & (this.maxEntryValue << startBitOffset ^ 0xFFFFFFFFFFFFFFFFL) | ((long)value & this.maxEntryValue) << startBitOffset;
        if (startArrIndex != endArrIndex) {
            int endOffset = 64 - startBitOffset;
            int j1 = this.bitsPerEntry - endOffset;
            this.longArray[endArrIndex] = this.longArray[endArrIndex] >>> j1 << j1 | ((long)value & this.maxEntryValue) >> endOffset;
        }
    }

    public int getAt(int index) {
        Validate.inclusiveBetween((long)0L, (long)(this.arraySize - 1), (long)index);
        int startOffset = index * this.bitsPerEntry;
        int startArrIndex = startOffset >> 6;
        int endArrIndex = (index + 1) * this.bitsPerEntry - 1 >> 6;
        int startBitOffset = startOffset & 0x3F;
        if (startArrIndex == endArrIndex) {
            return (int)(this.longArray[startArrIndex] >>> startBitOffset & this.maxEntryValue);
        }
        int endOffset = 64 - startBitOffset;
        return (int)((this.longArray[startArrIndex] >>> startBitOffset | this.longArray[endArrIndex] << endOffset) & this.maxEntryValue);
    }

    public long[] getBackingLongArray() {
        return this.longArray;
    }

    public int size() {
        return this.arraySize;
    }
}

