/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.conversion.IBlockReaderWithData;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import fi.dy.masa.litematica.schematic.conversion.SchematicConverter;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.NBTUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class SchematicaSchematic {
    public static final String FILE_EXTENSION = ".schematic";
    private final SchematicConverter converter;
    private final blc[] palette = new blc[65536];
    private LitematicaBlockStateContainer blocks;
    private Map<el, gy> tiles = new HashMap<el, gy>();
    private List<gy> entities = new ArrayList<gy>();
    private ff size = ff.e;
    private String fileName;
    private IdentityHashMap<blc, SchematicConversionFixers.IStateFixer> postProcessingFilter;
    private boolean needsConversionPostProcessing;

    private SchematicaSchematic() {
        this.converter = SchematicConverter.create();
    }

    public ff getSize() {
        return this.size;
    }

    public Map<el, gy> getTiles() {
        return this.tiles;
    }

    public List<LitematicaSchematic.EntityInfo> getEntities() {
        ArrayList<LitematicaSchematic.EntityInfo> entityList = new ArrayList<LitematicaSchematic.EntityInfo>();
        int size = this.entities.size();
        for (int i = 0; i < size; ++i) {
            gy entityData = this.entities.get(i);
            cee posVec = NBTUtils.readEntityPositionFromTag((gy)entityData);
            if (posVec == null || entityData.isEmpty()) continue;
            entityList.add(new LitematicaSchematic.EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    public void placeSchematicToWorld(axy world, el posStart, bxn placement, int setBlockStateFlags) {
        int width = this.size.o();
        int height = this.size.p();
        int length = this.size.q();
        int numBlocks = width * height * length;
        if (this.blocks != null && numBlocks > 0 && this.blocks.getSize().equals((Object)this.size)) {
            int x;
            int z;
            int y;
            bcs ignoredBlock = placement.i();
            bhb rotation = placement.c();
            bfz mirror = placement.b();
            for (y = 0; y < height; ++y) {
                for (z = 0; z < length; ++z) {
                    for (x = 0; x < width; ++x) {
                        bji te;
                        blc state = this.blocks.get(x, y, z);
                        if (ignoredBlock != null && state.c() == ignoredBlock) continue;
                        el pos = new el(x, y, z);
                        gy teNBT = this.tiles.get(pos);
                        pos = bxp.a((bxn)placement, (el)pos).a((ff)posStart);
                        state = state.a(mirror);
                        state = state.a(rotation);
                        if (teNBT != null && (te = world.f(pos)) != null) {
                            if (te instanceof ade) {
                                ((ade)te).m();
                            }
                            world.a(pos, bct.fU.p(), 20);
                        }
                        if (!world.a(pos, state, setBlockStateFlags) || teNBT == null || (te = world.f(pos)) == null) continue;
                        teNBT.b("x", pos.o());
                        teNBT.b("y", pos.p());
                        teNBT.b("z", pos.q());
                        try {
                            te.b(teNBT);
                            te.a(mirror);
                            te.a(rotation);
                            continue;
                        }
                        catch (Exception e) {
                            Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                        }
                    }
                }
            }
            if ((setBlockStateFlags & 1) != 0) {
                for (y = 0; y < height; ++y) {
                    for (z = 0; z < length; ++z) {
                        for (x = 0; x < width; ++x) {
                            bji te;
                            el pos = new el(x, y, z);
                            gy teNBT = this.tiles.get(pos);
                            pos = bxp.a((bxn)placement, (el)pos).a((ff)posStart);
                            world.a(pos, world.a_(pos).c());
                            if (teNBT == null || (te = world.f(pos)) == null) continue;
                            te.g();
                        }
                    }
                }
            }
            if (!placement.h()) {
                this.addEntitiesToWorld(world, posStart, placement);
            }
        }
    }

    public void placeSchematicDirectlyToChunks(axy world, el posStart, bxn placement) {
        int width = this.size.o();
        int height = this.size.p();
        int length = this.size.q();
        int numBlocks = width * height * length;
        el posEnd = posStart.a(this.size).a(-1, -1, -1);
        if (this.blocks != null && numBlocks > 0 && this.blocks.getSize().equals((Object)this.size) && PositionUtils.arePositionsWithinWorld(world, posStart, posEnd)) {
            el posMin = PositionUtils.getMinCorner(posStart, posEnd);
            el posMax = PositionUtils.getMaxCorner(posStart, posEnd);
            bcs ignoredBlock = placement.i();
            bhb rotation = placement.c();
            bfz mirror = placement.b();
            int cxStart = posMin.o() >> 4;
            int czStart = posMin.q() >> 4;
            int cxEnd = posMax.o() >> 4;
            int czEnd = posMax.q() >> 4;
            el.a posMutable = new el.a();
            for (int cz = czStart; cz <= czEnd; ++cz) {
                for (int cx = cxStart; cx <= cxEnd; ++cx) {
                    int xMinChunk = Math.max(cx << 4, posMin.o());
                    int zMinChunk = Math.max(cz << 4, posMin.q());
                    int xMaxChunk = Math.min((cx << 4) + 15, posMax.o());
                    int zMaxChunk = Math.min((cz << 4) + 15, posMax.q());
                    bnj chunk = world.c(cx, cz);
                    int y = posMin.p();
                    for (int ySrc = 0; ySrc < height; ++ySrc) {
                        int z = zMinChunk;
                        int zSrc = zMinChunk - posStart.q();
                        while (z <= zMaxChunk) {
                            int x = xMinChunk;
                            int xSrc = xMinChunk - posStart.o();
                            while (x <= xMaxChunk) {
                                blc state = this.blocks.get(xSrc, ySrc, zSrc);
                                if (state.c() != ignoredBlock) {
                                    bji te;
                                    posMutable.c(xSrc, ySrc, zSrc);
                                    gy teNBT = this.tiles.get(posMutable);
                                    el pos = new el(x, y, z);
                                    if (teNBT != null && (te = chunk.a(pos, bnj.a.c)) != null) {
                                        if (te instanceof ade) {
                                            ((ade)te).m();
                                        }
                                        world.a(pos, bct.fU.p(), 20);
                                    }
                                    chunk.a(pos, state, false);
                                    if (teNBT != null && (te = chunk.a(pos, bnj.a.c)) != null) {
                                        teNBT.b("x", pos.o());
                                        teNBT.b("y", pos.p());
                                        teNBT.b("z", pos.q());
                                        try {
                                            te.b(teNBT);
                                            te.a(mirror);
                                            te.a(rotation);
                                        }
                                        catch (Exception e) {
                                            Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                                        }
                                    }
                                }
                                ++x;
                                ++xSrc;
                            }
                            ++z;
                            ++zSrc;
                        }
                        ++y;
                    }
                }
            }
            if (!placement.h()) {
                this.addEntitiesToWorld(world, posStart, placement);
            }
        }
    }

    private void addEntitiesToWorld(axy world, el posStart, bxn placement) {
        bfz mirror = placement.b();
        bhb rotation = placement.c();
        for (gy tag : this.entities) {
            cee relativePos = NBTUtils.readEntityPositionFromTag((gy)tag);
            cee transformedRelativePos = PositionUtils.getTransformedPosition(relativePos, mirror, rotation);
            cee realPos = transformedRelativePos.b((double)posStart.o(), (double)posStart.p(), (double)posStart.q());
            aer entity = EntityUtils.createEntityAndPassengersFromNBT(tag, world);
            if (entity == null) continue;
            float rotationYaw = entity.a(mirror);
            entity.b(realPos.b, realPos.c, realPos.d, rotationYaw += entity.w - entity.a(rotation), entity.x);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    public Map<el, String> getDataStructureBlocks(el posStart, bxn placement) {
        HashMap<el, String> map = new HashMap<el, String>();
        for (Map.Entry<el, gy> entry : this.tiles.entrySet()) {
            gy tag = entry.getValue();
            if (!tag.l("id").equals("minecraft:structure_block") || bmr.valueOf((String)tag.l("mode")) != bmr.d) continue;
            el pos = entry.getKey();
            pos = bxp.a((bxn)placement, (el)pos).a((ff)posStart);
            map.put(pos, tag.l("metadata"));
        }
        return map;
    }

    private void readBlocksFromWorld(axy world, el posStart, el size) {
        int startX = posStart.o();
        int startY = posStart.p();
        int startZ = posStart.q();
        int endX = startX + size.o();
        int endY = startY + size.p();
        int endZ = startZ + size.q();
        el.a posMutable = new el.a(0, 0, 0);
        this.blocks = new LitematicaBlockStateContainer(size.o(), size.p(), size.q());
        this.tiles.clear();
        this.size = size;
        for (int y = startY; y < endY; ++y) {
            for (int z = startZ; z < endZ; ++z) {
                for (int x = startX; x < endX; ++x) {
                    int relX = x - startX;
                    int relY = y - startY;
                    int relZ = z - startZ;
                    posMutable.c(x, y, z);
                    blc state = world.a_((el)posMutable);
                    this.blocks.set(relX, relY, relZ, state);
                    bji te = world.f((el)posMutable);
                    if (te == null) continue;
                    try {
                        gy nbt = te.a(new gy());
                        nbt.b("x", relX);
                        nbt.b("y", relY);
                        nbt.b("z", relZ);
                        this.tiles.put(new el(relX, relY, relZ), nbt);
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("SchematicaSchematic: Exception while trying to store TileEntity data for block '{}' at {}", (Object)state, (Object)posMutable.toString(), (Object)e);
                    }
                }
            }
        }
    }

    private void readEntitiesFromWorld(axy world, el posStart, el size) {
        this.entities.clear();
        List entities = world.a(null, new cea(posStart, posStart.a((ff)size)));
        for (aer entity : entities) {
            gy tag;
            if (!entity.d(tag = new gy())) continue;
            cee pos = new cee(entity.q - (double)posStart.o(), entity.r - (double)posStart.p(), entity.s - (double)posStart.q());
            NBTUtils.writeEntityPositionToTag((cee)pos, (gy)tag);
            this.entities.add(tag);
        }
    }

    public static SchematicaSchematic createFromWorld(axy world, el posStart, el size, boolean ignoreEntities) {
        SchematicaSchematic schematic = new SchematicaSchematic();
        schematic.readBlocksFromWorld(world, posStart, size);
        if (!ignoreEntities) {
            schematic.readEntitiesFromWorld(world, posStart, size);
        }
        return schematic;
    }

    @Nullable
    public static SchematicaSchematic createFromFile(File file) {
        SchematicaSchematic schematic = new SchematicaSchematic();
        if (schematic.readFromFile(file)) {
            return schematic;
        }
        return null;
    }

    public boolean readFromNBT(gy nbt) {
        if (this.readBlocksFromNBT(nbt)) {
            this.readEntitiesFromNBT(nbt);
            this.readTileEntitiesFromNBT(nbt);
            this.postProcessBlocks();
            return true;
        }
        Litematica.logger.error("SchematicaSchematic: Missing block data in the schematic '{}'", (Object)this.fileName);
        return false;
    }

    private boolean readPaletteFromNBT(gy nbt) {
        Arrays.fill(this.palette, bct.a.p());
        if (nbt.c("SchematicaMapping", 10)) {
            gy tag = nbt.p("SchematicaMapping");
            Set keys = tag.c();
            for (String key : keys) {
                String str;
                short id = tag.g(key);
                if (id < 0 || id >= 4096) {
                    str = String.format("SchematicaSchematic: Invalid ID '%d' in SchematicaMapping for block '%s', range: 0 - 4095", id, key);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                    Litematica.logger.warn(str);
                    return false;
                }
                if (this.converter.getConvertedStatesForBlock(id, key, this.palette)) continue;
                str = String.format("SchematicaSchematic: Missing/non-existing block '%s' in SchematicaMapping", key);
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                Litematica.logger.warn(str);
            }
        } else if (nbt.c("BlockIDs", 10)) {
            gy tag = nbt.p("BlockIDs");
            Set keys = tag.c();
            for (String idStr : keys) {
                String str;
                int id;
                String key = tag.l(idStr);
                try {
                    id = Integer.parseInt(idStr);
                }
                catch (NumberFormatException e) {
                    String str2 = String.format("SchematicaSchematic: Invalid ID '%d' (not a number) in MCEdit2 palette for block '%s'", idStr, key);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str2, (Object[])new Object[0]);
                    Litematica.logger.warn(str2);
                    return false;
                }
                if (id < 0 || id >= 4096) {
                    str = String.format("SchematicaSchematic: Invalid ID '%d' in MCEdit2 palette for block '%s', range: 0 - 4095", id, key);
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                    Litematica.logger.warn(str);
                    return false;
                }
                if (this.converter.getConvertedStatesForBlock(id, key, this.palette)) continue;
                str = String.format("SchematicaSchematic: Missing/non-existing block '%s' in MCEdit2 palette", key);
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
                Litematica.logger.warn(str);
            }
        } else {
            this.converter.getVanillaBlockPalette(this.palette);
        }
        if (this.converter.createPostProcessStateFilter(this.palette)) {
            this.postProcessingFilter = this.converter.getPostProcessStateFilter();
            this.needsConversionPostProcessing = true;
        }
        return true;
    }

    private boolean readBlocksFromNBT(gy nbt) {
        int z;
        int y;
        int x;
        blc state;
        int byteId;
        byte addValue;
        int expectedAddLength;
        if (!(nbt.c("Blocks", 7) && nbt.c("Data", 7) && nbt.c("Width", 2) && nbt.c("Height", 2) && nbt.c("Length", 2))) {
            return false;
        }
        short sizeX = nbt.g("Width");
        short sizeY = nbt.g("Height");
        short sizeZ = nbt.g("Length");
        byte[] blockIdsByte = nbt.m("Blocks");
        byte[] metaArr = nbt.m("Data");
        int numBlocks = blockIdsByte.length;
        int layerSize = sizeX * sizeZ;
        if (numBlocks != sizeX * sizeY * sizeZ) {
            String str = String.format("SchematicaSchematic: Mismatched block array size compared to the width/height/length,\nblocks: %d, W x H x L: %d x %d x %d", numBlocks, (int)sizeX, (int)sizeY, (int)sizeZ);
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
            return false;
        }
        if (numBlocks != metaArr.length) {
            String str = String.format("SchematicaSchematic: Mismatched block ID and metadata array sizes, blocks: %d, meta: %d", numBlocks, metaArr.length);
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
            return false;
        }
        if (!this.readPaletteFromNBT(nbt)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"SchematicaSchematic: Failed to read the block palette", (Object[])new Object[0]);
            return false;
        }
        this.size = new ff((int)sizeX, (int)sizeY, (int)sizeZ);
        this.blocks = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
        if (nbt.c("Add", 7)) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"SchematicaSchematic: Old Schematica format detected, not currently implemented...", (Object[])new Object[0]);
            return false;
        }
        byte[] add = null;
        if (nbt.c("AddBlocks", 7) && (add = nbt.m("AddBlocks")).length != (expectedAddLength = (int)Math.ceil((double)blockIdsByte.length / 2.0))) {
            String str = String.format("SchematicaSchematic: Add array size mismatch, blocks: %d, add: %d, expected add: %d", numBlocks, add.length, expectedAddLength);
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)str, (Object[])new Object[0]);
            return false;
        }
        int loopMax = numBlocks % 2 == 0 ? numBlocks - 1 : numBlocks - 2;
        int bi = 0;
        int ai = 0;
        while (bi < loopMax) {
            addValue = add != null ? add[ai] : (byte)0;
            byteId = blockIdsByte[bi] & 0xFF;
            state = this.palette[(addValue & 0xF0) << 8 | byteId << 4 | metaArr[bi]];
            x = bi % sizeX;
            y = bi / layerSize;
            z = bi % layerSize / sizeX;
            this.blocks.set(x, y, z, state);
            x = (bi + 1) % sizeX;
            y = (bi + 1) / layerSize;
            z = (bi + 1) % layerSize / sizeX;
            byteId = blockIdsByte[bi + 1] & 0xFF;
            state = this.palette[(addValue & 0xF) << 12 | byteId << 4 | metaArr[bi + 1]];
            this.blocks.set(x, y, z, state);
            bi += 2;
            ++ai;
        }
        if (numBlocks % 2 != 0) {
            addValue = add != null ? add[ai] : (byte)0;
            byteId = blockIdsByte[bi] & 0xFF;
            state = this.palette[(addValue & 0xF0) << 8 | byteId << 4 | metaArr[bi]];
            x = bi % sizeX;
            y = bi / layerSize;
            z = bi % layerSize / sizeX;
            this.blocks.set(x, y, z, state);
        }
        return true;
    }

    private void postProcessBlocks() {
        if (this.needsConversionPostProcessing) {
            int sizeX = this.blocks.getSize().o();
            int sizeY = this.blocks.getSize().p();
            int sizeZ = this.blocks.getSize().q();
            BlockReaderSchematicaSchematic reader = new BlockReaderSchematicaSchematic(this.blocks, this.tiles);
            el.a posMutable = new el.a();
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        blc state = this.blocks.get(x, y, z);
                        SchematicConversionFixers.IStateFixer fixer = this.postProcessingFilter.get(state);
                        if (fixer == null) continue;
                        posMutable.c(x, y, z);
                        blc stateFixed = fixer.fixState(reader, state, (el)posMutable);
                        if (stateFixed == state) continue;
                        this.blocks.set(x, y, z, stateFixed);
                    }
                }
            }
        }
    }

    private void readEntitiesFromNBT(gy nbt) {
        this.entities.clear();
        he tagList = nbt.d("Entities", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            this.entities.add(tagList.e(i));
        }
    }

    private void readTileEntitiesFromNBT(gy nbt) {
        this.tiles.clear();
        he tagList = nbt.d("TileEntities", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            gy tag = tagList.e(i);
            el pos = new el(tag.h("x"), tag.h("y"), tag.h("z"));
            ff size = this.blocks.getSize();
            if (pos.o() < 0 || pos.o() >= size.o() || pos.p() < 0 || pos.p() >= size.p() || pos.q() < 0 || pos.q() >= size.q()) continue;
            tag = this.converter.fixTileEntityNBT(tag, this.blocks.get(pos.o(), pos.p(), pos.q()));
            this.tiles.put(pos, tag);
        }
    }

    public boolean readFromFile(File file) {
        if (file.exists() && file.isFile() && file.canRead()) {
            this.fileName = file.getName();
            try {
                FileInputStream is = new FileInputStream(file);
                gy nbt = hi.a((InputStream)is);
                is.close();
                return this.readFromNBT(nbt);
            }
            catch (Exception e) {
                Litematica.logger.error("SchematicaSchematic: Failed to read Schematic data from file '{}'", (Object)file.getAbsolutePath());
            }
        }
        return false;
    }

    public static class BlockReaderSchematicaSchematic
    implements IBlockReaderWithData {
        private final LitematicaBlockStateContainer container;
        private final Map<el, gy> blockEntityData;
        private final ff size;
        private final blc air;

        public BlockReaderSchematicaSchematic(LitematicaBlockStateContainer container, Map<el, gy> blockEntityData) {
            this.container = container;
            this.blockEntityData = blockEntityData;
            this.size = container.getSize();
            this.air = bct.a.p();
        }

        public blc a_(el pos) {
            if (pos.o() >= 0 && pos.o() < this.size.o() && pos.p() >= 0 && pos.p() < this.size.p() && pos.q() >= 0 && pos.q() < this.size.q()) {
                return this.container.get(pos.o(), pos.p(), pos.q());
            }
            return this.air;
        }

        public byw b(el pos) {
            return this.a_(pos).s();
        }

        @Nullable
        public bji f(el pos) {
            return null;
        }

        @Override
        @Nullable
        public gy getBlockEntityData(el pos) {
            return this.blockEntityData.get(pos);
        }
    }
}

