/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import fi.dy.masa.malilib.util.NBTUtils;
import javax.annotation.Nullable;

public class SchematicMetadata {
    private String name = "?";
    private String author = "Unknown";
    private String description = "";
    private ff enclosingSize = ff.e;
    private long timeCreated;
    private long timeModified;
    private int regionCount;
    private int totalVolume;
    private int totalBlocks;
    private int[] thumbnailPixelData;

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDescription() {
        return this.description;
    }

    @Nullable
    public int[] getPreviewImagePixelData() {
        return this.thumbnailPixelData;
    }

    public int getRegionCount() {
        return this.regionCount;
    }

    public int getTotalVolume() {
        return this.totalVolume;
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public ff getEnclosingSize() {
        return this.enclosingSize;
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public long getTimeModified() {
        return this.timeModified;
    }

    public boolean hasBeenModified() {
        return this.timeCreated != this.timeModified;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPreviewImagePixelData(int[] pixelData) {
        this.thumbnailPixelData = pixelData;
    }

    public void setRegionCount(int regionCount) {
        this.regionCount = regionCount;
    }

    public void setTotalVolume(int totalVolume) {
        this.totalVolume = totalVolume;
    }

    public void setTotalBlocks(int totalBlocks) {
        this.totalBlocks = totalBlocks;
    }

    public void setEnclosingSize(ff enclosingSize) {
        this.enclosingSize = enclosingSize;
    }

    public void setTimeCreated(long timeCreated) {
        this.timeCreated = timeCreated;
    }

    public void setTimeModified(long timeModified) {
        this.timeModified = timeModified;
    }

    public gy writeToNBT() {
        gy nbt = new gy();
        nbt.a("Name", this.name);
        nbt.a("Author", this.author);
        nbt.a("Description", this.description);
        nbt.b("RegionCount", this.regionCount);
        nbt.b("TotalVolume", this.totalVolume);
        nbt.b("TotalBlocks", this.totalBlocks);
        nbt.a("TimeCreated", this.timeCreated);
        nbt.a("TimeModified", this.timeModified);
        nbt.a("EnclosingSize", (ho)NBTUtils.createBlockPosTag((ff)this.enclosingSize));
        if (this.thumbnailPixelData != null) {
            nbt.a("PreviewImageData", this.thumbnailPixelData);
        }
        return nbt;
    }

    public void readFromNBT(gy nbt) {
        this.name = nbt.l("Name");
        this.author = nbt.l("Author");
        this.description = nbt.l("Description");
        this.regionCount = nbt.h("RegionCount");
        this.totalVolume = nbt.h("TotalVolume");
        this.totalBlocks = nbt.h("TotalBlocks");
        this.timeCreated = nbt.i("TimeCreated");
        this.timeModified = nbt.i("TimeModified");
        el size = NBTUtils.readBlockPos((gy)nbt.p("EnclosingSize"));
        if (size != null) {
            this.enclosingSize = size;
        }
        if (nbt.c("PreviewImageData", 11)) {
            this.thumbnailPixelData = nbt.n("PreviewImageData");
        }
    }
}

