/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.mixin.IMixinNBTTagLongArray;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.NBTUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;

public class LitematicaSchematic {
    public static final String FILE_EXTENSION = ".litematic";
    public static final int SCHEMATIC_VERSION_1_13_2 = 5;
    public static final int MINECRAFT_DATA_VERSION_1_13_2 = 1631;
    public static final int SCHEMATIC_VERSION = 5;
    public static final int MINECRAFT_DATA_VERSION = 1631;
    private final Map<String, LitematicaBlockStateContainer> blockContainers = new HashMap<String, LitematicaBlockStateContainer>();
    private final Map<String, Map<el, gy>> tileEntities = new HashMap<String, Map<el, gy>>();
    private final Map<String, Map<el, ayp<bcs>>> pendingBlockTicks = new HashMap<String, Map<el, ayp<bcs>>>();
    private final Map<String, Map<el, ayp<byv>>> pendingFluidTicks = new HashMap<String, Map<el, ayp<byv>>>();
    private final Map<String, List<EntityInfo>> entities = new HashMap<String, List<EntityInfo>>();
    private final Map<String, el> subRegionPositions = new HashMap<String, el>();
    private final Map<String, el> subRegionSizes = new HashMap<String, el>();
    private final SchematicMetadata metadata = new SchematicMetadata();
    private int totalBlocks;
    @Nullable
    private final File schematicFile;

    private LitematicaSchematic(@Nullable File file) {
        this.schematicFile = file;
    }

    @Nullable
    public File getFile() {
        return this.schematicFile;
    }

    public ff getTotalSize() {
        return this.metadata.getEnclosingSize();
    }

    public int getTotalBlocks() {
        return this.totalBlocks;
    }

    public SchematicMetadata getMetadata() {
        return this.metadata;
    }

    public int getSubRegionCount() {
        return this.blockContainers.size();
    }

    @Nullable
    public el getSubRegionPosition(String areaName) {
        return this.subRegionPositions.get(areaName);
    }

    public Map<String, el> getAreaPositions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            el pos = this.subRegionPositions.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    public Map<String, el> getAreaSizes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionSizes.keySet()) {
            el pos = this.subRegionSizes.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    @Nullable
    public el getAreaSize(String regionName) {
        return this.subRegionSizes.get(regionName);
    }

    public Map<String, Box> getAreas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            el pos = this.subRegionPositions.get(name);
            el posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((ff)this.subRegionSizes.get(name));
            Box box = new Box(pos, pos.a((ff)posEndRel), name);
            builder.put((Object)name, (Object)box);
        }
        return builder.build();
    }

    @Nullable
    public static LitematicaSchematic createFromWorld(axy world, AreaSelection area, boolean ignoreEntities, String author, IStringConsumer feedback) {
        List<Box> boxes = PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            feedback.setString(StringUtils.translate((String)"litematica.error.schematic.create.no_selections", (Object[])new Object[0]));
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(null);
        long time = new Date().getTime();
        el origin = area.getEffectiveOrigin();
        schematic.setSubRegionPositions(boxes, origin);
        schematic.setSubRegionSizes(boxes);
        schematic.takeBlocksFromWorld(world, boxes);
        if (!ignoreEntities) {
            schematic.takeEntitiesFromWorld(world, boxes, origin);
        }
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setTimeCreated(time);
        schematic.metadata.setTimeModified(time);
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize((ff)PositionUtils.getEnclosingAreaSize(boxes));
        schematic.metadata.setTotalBlocks(schematic.totalBlocks);
        return schematic;
    }

    public static LitematicaSchematic createEmptySchematic(AreaSelection area, String author) {
        List<Box> boxes = PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)StringUtils.translate((String)"litematica.error.schematic.create.no_selections", (Object[])new Object[0]), (Object[])new Object[0]);
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(null);
        schematic.setSubRegionPositions(boxes, area.getEffectiveOrigin());
        schematic.setSubRegionSizes(boxes);
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize((ff)PositionUtils.getEnclosingAreaSize(boxes));
        for (Box box : boxes) {
            String regionName = box.getName();
            el size = box.getSize();
            int sizeX = Math.abs(size.o());
            int sizeY = Math.abs(size.p());
            int sizeZ = Math.abs(size.q());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            schematic.blockContainers.put(regionName, container);
            schematic.tileEntities.put(regionName, new HashMap());
            schematic.entities.put(regionName, new ArrayList());
            schematic.pendingBlockTicks.put(regionName, new HashMap());
            schematic.pendingFluidTicks.put(regionName, new HashMap());
        }
        return schematic;
    }

    public void takeEntityDataFromSchematicaSchematic(SchematicaSchematic schematic, String subRegionName) {
        this.tileEntities.put(subRegionName, schematic.getTiles());
        this.entities.put(subRegionName, schematic.getEntities());
    }

    public boolean placeToWorld(axy world, SchematicPlacement schematicPlacement, boolean notifyNeighbors) {
        WorldUtils.setShouldPreventOnBlockAdded(true);
        ImmutableMap<String, SubRegionPlacement> relativePlacements = schematicPlacement.getEnabledRelativeSubRegionPlacements();
        el origin = schematicPlacement.getOrigin();
        for (String regionName : relativePlacements.keySet()) {
            SubRegionPlacement placement = (SubRegionPlacement)relativePlacements.get((Object)regionName);
            if (!placement.isEnabled()) continue;
            el regionPos = placement.getPos();
            el regionSize = this.subRegionSizes.get(regionName);
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<el, gy> tileMap = this.tileEntities.get(regionName);
            List<EntityInfo> entityList = this.entities.get(regionName);
            Map<el, ayp<bcs>> scheduledBlockTicks = this.pendingBlockTicks.get(regionName);
            Map<el, ayp<byv>> scheduledFluidTicks = this.pendingFluidTicks.get(regionName);
            if (regionPos != null && regionSize != null && container != null && tileMap != null) {
                this.placeBlocksToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, container, tileMap, scheduledBlockTicks, scheduledFluidTicks, notifyNeighbors);
            } else {
                Litematica.logger.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)this.metadata.getName(), (Object)regionName);
            }
            if (schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
            this.placeEntitiesToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, entityList);
        }
        WorldUtils.setShouldPreventOnBlockAdded(false);
        return true;
    }

    private boolean placeBlocksToWorld(axy world, el origin, el regionPos, el regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, LitematicaBlockStateContainer container, Map<el, gy> tileMap, @Nullable Map<el, ayp<bcs>> scheduledBlockTicks, @Nullable Map<el, ayp<byv>> scheduledFluidTicks, boolean notifyNeighbors) {
        blc state;
        int x;
        int z;
        int y;
        el posEndRelSub = PositionUtils.getRelativeEndPositionFromAreaSize((ff)regionSize);
        el posEndRel = posEndRelSub.a((ff)regionPos);
        el posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        el regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        el posEndAbs = PositionUtils.getTransformedBlockPos(posEndRelSub, placement.getMirror(), placement.getRotation()).a((ff)regionPosTransformed).a((ff)origin);
        el regionPosAbs = regionPosTransformed.a((ff)origin);
        if (!PositionUtils.arePositionsWithinWorld(world, regionPosAbs, posEndAbs)) {
            return false;
        }
        int sizeX = Math.abs(regionSize.o());
        int sizeY = Math.abs(regionSize.p());
        int sizeZ = Math.abs(regionSize.q());
        blc barrier = bct.fU.p();
        el.a posMutable = new el.a();
        ReplaceBehavior replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        bhb rotationCombined = schematicPlacement.getRotation().a(placement.getRotation());
        bfz mirrorMain = schematicPlacement.getMirror();
        bfz mirrorSub = placement.getMirror();
        if (mirrorSub != bfz.a && (schematicPlacement.getRotation() == bhb.b || schematicPlacement.getRotation() == bhb.d)) {
            mirrorSub = mirrorSub == bfz.c ? bfz.b : bfz.c;
        }
        for (y = 0; y < sizeY; ++y) {
            for (z = 0; z < sizeZ; ++z) {
                for (x = 0; x < sizeX; ++x) {
                    bji te;
                    state = container.get(x, y, z);
                    if (state.c() == bct.io) continue;
                    posMutable.c(x, y, z);
                    gy teNBT = tileMap.get(posMutable);
                    posMutable.c(posMinRel.o() + x - regionPos.o(), posMinRel.p() + y - regionPos.p(), posMinRel.q() + z - regionPos.q());
                    el pos = PositionUtils.getTransformedPlacementPosition((el)posMutable, schematicPlacement, placement);
                    pos = pos.a((ff)regionPosTransformed).a((ff)origin);
                    blc stateOld = world.a_(pos);
                    if (replace == ReplaceBehavior.NONE && !stateOld.f() || replace == ReplaceBehavior.WITH_NON_AIR && state.f()) continue;
                    if (mirrorMain != bfz.a) {
                        state = state.a(mirrorMain);
                    }
                    if (mirrorSub != bfz.a) {
                        state = state.a(mirrorSub);
                    }
                    if (rotationCombined != bhb.a) {
                        state = state.a(rotationCombined);
                    }
                    if (stateOld == state) continue;
                    bji teOld = world.f(pos);
                    if (teOld != null) {
                        if (teOld instanceof ade) {
                            ((ade)teOld).m();
                        }
                        world.a(pos, barrier, 20);
                    }
                    if (!world.a(pos, state, 18) || teNBT == null || (te = world.f(pos)) == null) continue;
                    teNBT = teNBT.f();
                    teNBT.b("x", pos.o());
                    teNBT.b("y", pos.p());
                    teNBT.b("z", pos.q());
                    try {
                        te.b(teNBT);
                        if (mirrorMain != bfz.a) {
                            te.a(mirrorMain);
                        }
                        if (mirrorSub != bfz.a) {
                            te.a(mirrorSub);
                        }
                        if (rotationCombined == bhb.a) continue;
                        te.a(rotationCombined);
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        if (notifyNeighbors) {
            for (y = 0; y < sizeY; ++y) {
                for (z = 0; z < sizeZ; ++z) {
                    for (x = 0; x < sizeX; ++x) {
                        posMutable.c(posMinRel.o() + x - regionPos.o(), posMinRel.p() + y - regionPos.p(), posMinRel.q() + z - regionPos.q());
                        el pos = PositionUtils.getTransformedPlacementPosition((el)posMutable, schematicPlacement, placement).a((ff)origin);
                        world.a(pos, world.a_(pos).c());
                    }
                }
            }
        }
        if (scheduledBlockTicks != null && !scheduledBlockTicks.isEmpty()) {
            for (Map.Entry<el, ayp<bcs>> entry : scheduledBlockTicks.entrySet()) {
                el pos = entry.getKey().a((ff)regionPosAbs);
                ayp<bcs> tick = entry.getValue();
                world.J().a(pos, tick.a(), (int)tick.b, tick.c);
            }
        }
        if (scheduledFluidTicks != null && !scheduledFluidTicks.isEmpty()) {
            for (Map.Entry<el, ayp<byv>> entry : scheduledFluidTicks.entrySet()) {
                el pos = entry.getKey().a((ff)regionPosAbs);
                state = world.a_(pos);
                if (state.s().e()) continue;
                ayp<byv> tick = entry.getValue();
                world.I().a(pos, tick.a(), (int)tick.b, tick.c);
            }
        }
        return true;
    }

    private void placeEntitiesToWorld(axy world, el origin, el regionPos, el regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, List<EntityInfo> entityList) {
        el regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.o() + origin.o();
        int offY = regionPosRelTransformed.p() + origin.p();
        int offZ = regionPosRelTransformed.q() + origin.q();
        bhb rotationCombined = schematicPlacement.getRotation().a(placement.getRotation());
        bfz mirrorMain = schematicPlacement.getMirror();
        bfz mirrorSub = placement.getMirror();
        if (mirrorSub != bfz.a && (schematicPlacement.getRotation() == bhb.b || schematicPlacement.getRotation() == bhb.d)) {
            mirrorSub = mirrorSub == bfz.c ? bfz.b : bfz.c;
        }
        for (EntityInfo info : entityList) {
            aer entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            cee pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.b + (double)offX;
            double y = pos.c + (double)offY;
            double z = pos.d + (double)offZ;
            this.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    public boolean placeToWorldWithinChunk(axy world, axm chunkPos, SchematicPlacement schematicPlacement, boolean notifyNeighbors) {
        Set<String> regionsTouchingChunk = schematicPlacement.getRegionsTouchingChunk(chunkPos.a, chunkPos.b);
        el origin = schematicPlacement.getOrigin();
        for (String regionName : regionsTouchingChunk) {
            SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
            if (!placement.isEnabled()) continue;
            el regionPos = placement.getPos();
            el regionSize = this.subRegionSizes.get(regionName);
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<el, gy> tileMap = this.tileEntities.get(regionName);
            List<EntityInfo> entityList = this.entities.get(regionName);
            if (regionPos != null && regionSize != null && container != null && tileMap != null) {
                this.placeBlocksWithinChunk(world, chunkPos, regionName, origin, regionPos, regionSize, schematicPlacement, placement, container, tileMap, notifyNeighbors);
            } else {
                Litematica.logger.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)this.metadata.getName(), (Object)regionName);
            }
            if (schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
            this.placeEntitiesToWorldWithinChunk(world, chunkPos, origin, regionPos, regionSize, schematicPlacement, placement, entityList);
        }
        return true;
    }

    private void placeBlocksWithinChunk(axy world, axm chunkPos, String regionName, el origin, el regionPos, el regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, LitematicaBlockStateContainer container, Map<el, gy> tileMap, boolean notifyNeighbors) {
        int x;
        int z;
        int y;
        IntBoundingBox bounds = schematicPlacement.getBoxWithinChunkForRegion(regionName, chunkPos.a, chunkPos.b);
        if (bounds == null) {
            return;
        }
        el posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((ff)regionSize).a((ff)regionPos);
        el posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        el regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        el boxMinRel = new el(bounds.minX - origin.o() - regionPosTransformed.o(), 0, bounds.minZ - origin.q() - regionPosTransformed.q());
        el boxMaxRel = new el(bounds.maxX - origin.o() - regionPosTransformed.o(), 0, bounds.maxZ - origin.q() - regionPosTransformed.q());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, placement.getMirror(), placement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, placement.getMirror(), placement.getRotation());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMinRel = boxMinRel.b((ff)posMinRel.b((ff)regionPos));
        boxMaxRel = boxMaxRel.b((ff)posMinRel.b((ff)regionPos));
        el posMin = PositionUtils.getMinCorner(boxMinRel, boxMaxRel);
        el posMax = PositionUtils.getMaxCorner(boxMinRel, boxMaxRel);
        int startX = posMin.o();
        int startZ = posMin.q();
        int endX = posMax.o();
        int endZ = posMax.q();
        boolean startY = false;
        int endY = Math.abs(regionSize.p()) - 1;
        el.a posMutable = new el.a();
        if (startX < 0 || startZ < 0 || endX >= container.getSize().o() || endZ >= container.getSize().q()) {
            System.out.printf("DEBUG ============= OUT OF BOUNDS - region: %s, sx: %d, sz: %d, ex: %d, ez: %d - size x: %d z: %d =============\n", regionName, startX, startZ, endX, endZ, container.getSize().o(), container.getSize().q());
            return;
        }
        bhb rotationCombined = schematicPlacement.getRotation().a(placement.getRotation());
        bfz mirrorMain = schematicPlacement.getMirror();
        blc barrier = bct.fU.p();
        bfz mirrorSub = placement.getMirror();
        if (mirrorSub != bfz.a && (schematicPlacement.getRotation() == bhb.b || schematicPlacement.getRotation() == bhb.d)) {
            mirrorSub = mirrorSub == bfz.c ? bfz.b : bfz.c;
        }
        for (y = 0; y <= endY; ++y) {
            for (z = startZ; z <= endZ; ++z) {
                for (x = startX; x <= endX; ++x) {
                    bji te;
                    blc state = container.get(x, y, z);
                    if (state.f()) continue;
                    posMutable.c(x, y, z);
                    gy teNBT = tileMap.get(posMutable);
                    posMutable.c(posMinRel.o() + x - regionPos.o(), posMinRel.p() + y - regionPos.p(), posMinRel.q() + z - regionPos.q());
                    el pos = PositionUtils.getTransformedPlacementPosition((el)posMutable, schematicPlacement, placement);
                    pos = pos.a((ff)regionPosTransformed).a((ff)origin);
                    if (mirrorMain != bfz.a) {
                        state = state.a(mirrorMain);
                    }
                    if (mirrorSub != bfz.a) {
                        state = state.a(mirrorSub);
                    }
                    if (rotationCombined != bhb.a) {
                        state = state.a(rotationCombined);
                    }
                    if (teNBT != null && (te = world.f(pos)) != null) {
                        if (te instanceof ade) {
                            ((ade)te).m();
                        }
                        world.a(pos, barrier, 20);
                    }
                    if (!world.a(pos, state, 18) || teNBT == null || (te = world.f(pos)) == null) continue;
                    teNBT = teNBT.f();
                    teNBT.b("x", pos.o());
                    teNBT.b("y", pos.p());
                    teNBT.b("z", pos.q());
                    try {
                        te.b(teNBT);
                        if (mirrorMain != bfz.a) {
                            te.a(mirrorMain);
                        }
                        if (mirrorSub != bfz.a) {
                            te.a(mirrorSub);
                        }
                        if (rotationCombined == bhb.a) continue;
                        te.a(rotationCombined);
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        if (notifyNeighbors) {
            for (y = startX; y <= endY; ++y) {
                for (z = 0; z <= endZ; ++z) {
                    for (x = startZ; x <= endX; ++x) {
                        posMutable.c(posMinRel.o() + x - regionPos.o(), posMinRel.p() + y - regionPos.p(), posMinRel.q() + z - regionPos.q());
                        el pos = PositionUtils.getTransformedPlacementPosition((el)posMutable, schematicPlacement, placement).a((ff)origin);
                        world.a(pos, world.a_(pos).c());
                    }
                }
            }
        }
    }

    private void placeEntitiesToWorldWithinChunk(axy world, axm chunkPos, el origin, el regionPos, el regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, List<EntityInfo> entityList) {
        el regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.o() + origin.o();
        int offY = regionPosRelTransformed.p() + origin.p();
        int offZ = regionPosRelTransformed.q() + origin.q();
        double minX = chunkPos.a << 4;
        double minZ = chunkPos.b << 4;
        double maxX = (chunkPos.a << 4) + 16;
        double maxZ = (chunkPos.b << 4) + 16;
        bhb rotationCombined = schematicPlacement.getRotation().a(placement.getRotation());
        bfz mirrorMain = schematicPlacement.getMirror();
        bfz mirrorSub = placement.getMirror();
        if (mirrorSub != bfz.a && (schematicPlacement.getRotation() == bhb.b || schematicPlacement.getRotation() == bhb.d)) {
            mirrorSub = mirrorSub == bfz.c ? bfz.b : bfz.c;
        }
        for (EntityInfo info : entityList) {
            aer entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            cee pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.b + (double)offX;
            double y = pos.c + (double)offY;
            double z = pos.d + (double)offZ;
            if (!(x >= minX) || !(x < maxX) || !(z >= minZ) || !(z < maxZ)) continue;
            this.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    private void rotateEntity(aer entity, double x, double y, double z, bhb rotationCombined, bfz mirrorMain, bfz mirrorSub) {
        float rotationYaw = entity.w;
        if (mirrorMain != bfz.a) {
            rotationYaw = entity.a(mirrorMain);
        }
        if (mirrorSub != bfz.a) {
            rotationYaw = entity.a(mirrorSub);
        }
        if (rotationCombined != bhb.a) {
            rotationYaw += entity.w - entity.a(rotationCombined);
        }
        entity.b(x, y, z, rotationYaw, entity.x);
        entity.y = rotationYaw;
        entity.z = entity.x;
        if (entity instanceof afa) {
            afa livingBase = (afa)entity;
            livingBase.aS = rotationYaw;
            livingBase.aT = rotationYaw;
            livingBase.aQ = rotationYaw;
            livingBase.aR = rotationYaw;
        }
    }

    private void takeEntitiesFromWorld(axy world, List<Box> boxes, el origin) {
        for (Box box : boxes) {
            cea bb = PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2());
            el regionPosAbs = box.getPos1();
            ArrayList<EntityInfo> list = new ArrayList<EntityInfo>();
            List entities = world.a(null, bb, null);
            for (aer entity : entities) {
                gy tag;
                if (!entity.d(tag = new gy())) continue;
                cee posVec = new cee(entity.q - (double)regionPosAbs.o(), entity.r - (double)regionPosAbs.p(), entity.s - (double)regionPosAbs.q());
                NBTUtils.writeEntityPositionToTag((cee)posVec, (gy)tag);
                list.add(new EntityInfo(posVec, tag));
            }
            this.entities.put(box.getName(), list);
        }
    }

    public void takeEntitiesFromWorldWithinChunk(axy world, int chunkX, int chunkZ, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes, Set<UUID> existingEntities, el origin) {
        for (Map.Entry entry : volumes.entrySet()) {
            String regionName = (String)entry.getKey();
            List<EntityInfo> list = this.entities.get(regionName);
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null || list == null) continue;
            cea bb = PositionUtils.createAABBFrom((IntBoundingBox)entry.getValue());
            List entities = world.a(null, bb, null);
            el regionPosAbs = box.getPos1();
            for (aer entity : entities) {
                gy tag;
                UUID uuid = entity.bt();
                if (existingEntities.contains(uuid) || !entity.d(tag = new gy())) continue;
                cee posVec = new cee(entity.q - (double)regionPosAbs.o(), entity.r - (double)regionPosAbs.p(), entity.s - (double)regionPosAbs.q());
                NBTUtils.writeEntityPositionToTag((cee)posVec, (gy)tag);
                list.add(new EntityInfo(posVec, tag));
                existingEntities.add(uuid);
            }
        }
    }

    private void takeBlocksFromWorld(axy world, List<Box> boxes) {
        el.a posMutable = new el.a(0, 0, 0);
        for (Box box : boxes) {
            el size = box.getSize();
            int sizeX = Math.abs(size.o());
            int sizeY = Math.abs(size.p());
            int sizeZ = Math.abs(size.q());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            HashMap<el, gy> tileEntityMap = new HashMap<el, gy>();
            HashMap blockTickMap = new HashMap();
            HashMap fluidTickMap = new HashMap();
            el minCorner = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int startX = minCorner.o();
            int startY = minCorner.p();
            int startZ = minCorner.q();
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        bji te;
                        posMutable.c(x + startX, y + startY, z + startZ);
                        blc state = world.a_((el)posMutable);
                        container.set(x, y, z, state);
                        if (!state.f()) {
                            ++this.totalBlocks;
                        }
                        if (!state.c().i() || (te = world.f((el)posMutable)) == null) continue;
                        el pos = new el(x, y, z);
                        gy tag = te.a(new gy());
                        NBTUtils.writeBlockPosToTag((ff)pos, (gy)tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (world instanceof td) {
                List fluidTicks;
                IntBoundingBox tickBox = IntBoundingBox.createProper((int)startX, (int)startY, (int)startZ, (int)(startX + sizeX), (int)(startY + sizeY), (int)(startZ + sizeZ));
                List blockTicks = ((td)world).x().a(tickBox.toVanillaBox(), false);
                if (blockTicks != null) {
                    this.getPendingTicksFromWorld(blockTickMap, blockTicks, minCorner, startY, tickBox.maxY, world.V());
                }
                if ((fluidTicks = ((td)world).y().a(tickBox.toVanillaBox(), false)) != null) {
                    this.getPendingTicksFromWorld(fluidTickMap, fluidTicks, minCorner, startY, tickBox.maxY, world.V());
                }
            }
            this.blockContainers.put(box.getName(), container);
            this.tileEntities.put(box.getName(), tileEntityMap);
            this.pendingBlockTicks.put(box.getName(), blockTickMap);
            this.pendingFluidTicks.put(box.getName(), fluidTickMap);
        }
    }

    private <T> void getPendingTicksFromWorld(Map<el, ayp<T>> map, List<ayp<T>> list, el minCorner, int startY, int maxY, long currentTime) {
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            ayp<T> entry = list.get(i);
            if (entry.a.p() < startY || entry.a.p() >= maxY) continue;
            el posRelative = new el(entry.a.o() - minCorner.o(), entry.a.p() - minCorner.p(), entry.a.q() - minCorner.q());
            ayp newEntry = new ayp(posRelative, entry.a(), entry.b - currentTime, entry.c);
            map.put(posRelative, newEntry);
        }
    }

    public void takeBlocksFromWorldWithinChunk(axy world, int chunkX, int chunkZ, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes) {
        el.a posMutable = new el.a(0, 0, 0);
        for (Map.Entry volumeEntry : volumes.entrySet()) {
            List fluidTicks;
            String regionName = (String)volumeEntry.getKey();
            IntBoundingBox bb = (IntBoundingBox)volumeEntry.getValue();
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null) {
                Litematica.logger.error("null Box for sub-region '{}' while trying to save chunk-wise schematic", (Object)regionName);
                continue;
            }
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<el, gy> tileEntityMap = this.tileEntities.get(regionName);
            Map blockTickMap = this.pendingBlockTicks.get(regionName);
            Map fluidTickMap = this.pendingFluidTicks.get(regionName);
            if (container == null || tileEntityMap == null || blockTickMap == null || fluidTickMap == null) {
                Litematica.logger.error("null map(s) for sub-region '{}' while trying to save chunk-wise schematic", (Object)regionName);
                continue;
            }
            el minCorner = PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int offsetX = minCorner.o();
            int offsetY = minCorner.p();
            int offsetZ = minCorner.q();
            int startX = bb.minX - minCorner.o();
            int startY = bb.minY - minCorner.p();
            int startZ = bb.minZ - minCorner.q();
            int endX = startX + (bb.maxX - bb.minX);
            int endY = startY + (bb.maxY - bb.minY);
            int endZ = startZ + (bb.maxZ - bb.minZ);
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        bji te;
                        posMutable.c(x + offsetX, y + offsetY, z + offsetZ);
                        blc state = world.a_((el)posMutable);
                        container.set(x, y, z, state);
                        if (!state.f()) {
                            ++this.totalBlocks;
                        }
                        if (!state.c().i() || (te = world.f((el)posMutable)) == null) continue;
                        el pos = new el(x, y, z);
                        gy tag = te.a(new gy());
                        NBTUtils.writeBlockPosToTag((ff)pos, (gy)tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (!(world instanceof td)) continue;
            IntBoundingBox tickBox = IntBoundingBox.createProper((int)(offsetX + startX), (int)(offsetY + startY), (int)(offsetZ + startZ), (int)(offsetX + endX + 1), (int)(offsetY + endY + 1), (int)(offsetZ + endZ + 1));
            List blockTicks = ((td)world).x().a(tickBox.toVanillaBox(), false);
            if (blockTicks != null) {
                this.getPendingTicksFromWorld(blockTickMap, blockTicks, minCorner, startY, tickBox.maxY, world.V());
            }
            if ((fluidTicks = ((td)world).y().a(tickBox.toVanillaBox(), false)) == null) continue;
            this.getPendingTicksFromWorld(fluidTickMap, fluidTicks, minCorner, startY, tickBox.maxY, world.V());
        }
    }

    private void setSubRegionPositions(List<Box> boxes, el areaOrigin) {
        for (Box box : boxes) {
            this.subRegionPositions.put(box.getName(), box.getPos1().b((ff)areaOrigin));
        }
    }

    private void setSubRegionSizes(List<Box> boxes) {
        for (Box box : boxes) {
            this.subRegionSizes.put(box.getName(), box.getSize());
        }
    }

    @Nullable
    public LitematicaBlockStateContainer getSubRegionContainer(String regionName) {
        return this.blockContainers.get(regionName);
    }

    private gy writeToNBT() {
        gy nbt = new gy();
        nbt.b("Version", 5);
        nbt.b("MinecraftDataVersion", 1631);
        nbt.a("Metadata", (ho)this.metadata.writeToNBT());
        nbt.a("Regions", (ho)this.writeSubRegionsToNBT());
        return nbt;
    }

    private gy writeSubRegionsToNBT() {
        gy wrapper = new gy();
        if (!this.blockContainers.isEmpty()) {
            for (String regionName : this.blockContainers.keySet()) {
                LitematicaBlockStateContainer blockContainer = this.blockContainers.get(regionName);
                Map<el, gy> tileMap = this.tileEntities.get(regionName);
                List<EntityInfo> entityList = this.entities.get(regionName);
                Map pendingBlockTicks = this.pendingBlockTicks.get(regionName);
                Map pendingFluidTicks = this.pendingFluidTicks.get(regionName);
                gy tag = new gy();
                tag.a("BlockStatePalette", (ho)blockContainer.getPalette().writeToNBT());
                tag.a("BlockStates", (ho)new hf(blockContainer.getBackingLongArray()));
                tag.a("TileEntities", (ho)this.writeTileEntitiesToNBT(tileMap));
                if (pendingBlockTicks != null) {
                    tag.a("PendingBlockTicks", (ho)this.writePendingTicksToNBT(pendingBlockTicks));
                }
                if (pendingFluidTicks != null) {
                    tag.a("PendingFluidTicks", (ho)this.writePendingTicksToNBT(pendingFluidTicks));
                }
                if (entityList != null) {
                    tag.a("Entities", (ho)this.writeEntitiesToNBT(entityList));
                }
                el pos = this.subRegionPositions.get(regionName);
                tag.a("Position", (ho)NBTUtils.createBlockPosTag((ff)pos));
                pos = this.subRegionSizes.get(regionName);
                tag.a("Size", (ho)NBTUtils.createBlockPosTag((ff)pos));
                wrapper.a(regionName, (ho)tag);
            }
        }
        return wrapper;
    }

    private he writeEntitiesToNBT(List<EntityInfo> entityList) {
        he tagList = new he();
        if (!entityList.isEmpty()) {
            for (EntityInfo info : entityList) {
                tagList.a((ho)info.nbt);
            }
        }
        return tagList;
    }

    private <T> he writePendingTicksToNBT(Map<el, ayp<T>> tickMap) {
        he tagList = new he();
        if (!tickMap.isEmpty()) {
            for (ayp<T> entry : tickMap.values()) {
                String tagName;
                pc rl;
                Object target = entry.a();
                if (target instanceof bcs) {
                    rl = fc.g.b((Object)((bcs)target));
                    tagName = "Block";
                } else {
                    rl = fc.h.b((Object)((byv)target));
                    tagName = "Fluid";
                }
                if (rl == null) continue;
                gy tag = new gy();
                tag.a(tagName, rl.toString());
                tag.b("Priority", entry.c.a());
                tag.b("Time", (int)entry.b);
                tag.b("x", entry.a.o());
                tag.b("y", entry.a.p());
                tag.b("z", entry.a.q());
                tagList.a((ho)tag);
            }
        }
        return tagList;
    }

    private he writeTileEntitiesToNBT(Map<el, gy> tileMap) {
        he tagList = new he();
        if (!tileMap.isEmpty()) {
            for (gy tag : tileMap.values()) {
                tagList.a((ho)tag);
            }
        }
        return tagList;
    }

    private boolean readFromNBT(gy nbt) {
        this.blockContainers.clear();
        this.tileEntities.clear();
        this.entities.clear();
        this.subRegionPositions.clear();
        this.subRegionSizes.clear();
        if (nbt.c("Version", 3)) {
            int version = nbt.h("Version");
            int minecraftDataVersion = nbt.h("MinecraftDataVersion");
            if (version >= 1 && version <= 5) {
                this.metadata.readFromNBT(nbt.p("Metadata"));
                this.readSubRegionsFromNBT(nbt.p("Regions"), version, minecraftDataVersion);
                return true;
            }
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_load.unsupported_schematic_version", (Object[])new Object[]{version});
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_load.no_schematic_version_information", (Object[])new Object[0]);
        }
        return false;
    }

    private void readSubRegionsFromNBT(gy tag, int version, int minecraftDataVersion) {
        for (String regionName : tag.c()) {
            ho nbtBase;
            he list;
            if (tag.c(regionName).a() != 10) continue;
            gy regionTag = tag.p(regionName);
            el regionPos = NBTUtils.readBlockPos((gy)regionTag.p("Position"));
            el regionSize = NBTUtils.readBlockPos((gy)regionTag.p("Size"));
            if (regionPos == null || regionSize == null) continue;
            this.subRegionPositions.put(regionName, regionPos);
            this.subRegionSizes.put(regionName, regionSize);
            if (version >= 2) {
                this.tileEntities.put(regionName, this.readTileEntitiesFromNBT(regionTag.d("TileEntities", 10)));
                this.entities.put(regionName, this.readEntitiesFromNBT(regionTag.d("Entities", 10)));
            } else if (version == 1) {
                this.tileEntities.put(regionName, this.readTileEntitiesFromNBT_v1(regionTag.d("TileEntities", 10)));
                this.entities.put(regionName, this.readEntitiesFromNBT_v1(regionTag.d("Entities", 10)));
            }
            if (version >= 3) {
                list = regionTag.d("PendingBlockTicks", 10);
                this.pendingBlockTicks.put(regionName, this.readPendingTicksFromNBT(list, bct.a));
            }
            if (version >= 5) {
                list = regionTag.d("PendingFluidTicks", 10);
                this.pendingFluidTicks.put(regionName, this.readPendingTicksFromNBT(list, byy.a));
            }
            if ((nbtBase = regionTag.c("BlockStates")) == null || nbtBase.a() != 12) continue;
            he palette = regionTag.d("BlockStatePalette", 10);
            long[] blockStateArr = ((IMixinNBTTagLongArray)nbtBase).getArray();
            el posEndRel = PositionUtils.getRelativeEndPositionFromAreaSize((ff)regionSize).a((ff)regionPos);
            el posMin = PositionUtils.getMinCorner(regionPos, posEndRel);
            el posMax = PositionUtils.getMaxCorner(regionPos, posEndRel);
            el size = posMax.b((ff)posMin).a(1, 1, 1);
            palette = this.convertBlockStatePalette_1_12_to_1_13_2(palette, version, minecraftDataVersion);
            LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createFrom(palette, blockStateArr, size);
            this.blockContainers.put(regionName, container);
        }
    }

    private he convertBlockStatePalette_1_12_to_1_13_2(he oldPalette, int version, int minecraftDataVersion) {
        if (version < 5 || minecraftDataVersion < 1631 && minecraftDataVersion > 0) {
            he newPalette = new he();
            int count = oldPalette.size();
            for (int i = 0; i < count; ++i) {
                newPalette.a((ho)SchematicConversionMaps.get_1_13_2_StateTagFor_1_12_Tag(oldPalette.e(i)));
            }
            return newPalette;
        }
        return oldPalette;
    }

    private List<EntityInfo> readEntitiesFromNBT(he tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            gy entityData = tagList.e(i);
            cee posVec = NBTUtils.readEntityPositionFromTag((gy)entityData);
            if (posVec == null || entityData.isEmpty()) continue;
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<el, gy> readTileEntitiesFromNBT(he tagList) {
        HashMap<el, gy> tileMap = new HashMap<el, gy>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            gy tag = tagList.e(i);
            el pos = NBTUtils.readBlockPos((gy)tag);
            if (pos == null || tag.isEmpty()) continue;
            tileMap.put(pos, tag);
        }
        return tileMap;
    }

    private <T> Map<el, ayp<T>> readPendingTicksFromNBT(he tagList, T clazz) {
        HashMap<el, ayp<T>> tickMap = new HashMap<el, ayp<T>>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            gy tag = tagList.e(i);
            if (!tag.c("Time", 99)) continue;
            Object target = null;
            try {
                if (clazz instanceof bcs && tag.c("Block", 8) ? (target = fc.g.b(new pc(tag.l("Block")))) == null || target == bct.a : clazz instanceof byv && tag.c("Fluid", 8) && ((target = fc.h.b(new pc(tag.l("Fluid")))) == null || target == byy.a)) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (target == null) continue;
            el pos = new el(tag.h("x"), tag.h("y"), tag.h("z"));
            int scheduledTime = tag.h("Time");
            ayq priority = ayq.a((int)tag.h("Priority"));
            ayp entry = new ayp(pos, target, (long)scheduledTime, priority);
            tickMap.put(pos, entry);
        }
        return tickMap;
    }

    private List<EntityInfo> readEntitiesFromNBT_v1(he tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            gy tag = tagList.e(i);
            cee posVec = NBTUtils.readVec3d((gy)tag);
            gy entityData = tag.p("EntityData");
            if (posVec == null || entityData.isEmpty()) continue;
            NBTUtils.writeEntityPositionToTag((cee)posVec, (gy)entityData);
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<el, gy> readTileEntitiesFromNBT_v1(he tagList) {
        HashMap<el, gy> tileMap = new HashMap<el, gy>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            gy tag = tagList.e(i);
            gy tileNbt = tag.p("TileNBT");
            el pos = NBTUtils.readBlockPos((gy)tag);
            if (pos == null || tileNbt.isEmpty()) continue;
            NBTUtils.writeBlockPosToTag((ff)pos, (gy)tileNbt);
            tileMap.put(pos, tileNbt);
        }
        return tileMap;
    }

    public boolean writeToFile(File dir, String fileNameIn, boolean override) {
        String fileName = fileNameIn;
        if (!fileName.endsWith(FILE_EXTENSION)) {
            fileName = fileName + FILE_EXTENSION;
        }
        File fileSchematic = new File(dir, fileName);
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()});
                return false;
            }
            if (!override && fileSchematic.exists()) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.exists", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
                return false;
            }
            FileOutputStream os = new FileOutputStream(fileSchematic);
            hi.a((gy)this.writeToNBT(), (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.exception", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)e.getMessage(), (Object[])new Object[0]);
            return false;
        }
    }

    @Nullable
    public static LitematicaSchematic createFromFile(File dir, String fileName) {
        File fileSchematic;
        if (!fileName.endsWith(FILE_EXTENSION)) {
            fileName = fileName + FILE_EXTENSION;
        }
        if (!(fileSchematic = new File(dir, fileName)).exists() || !fileSchematic.canRead()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.cant_read", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
            return null;
        }
        try {
            LitematicaSchematic schematic;
            FileInputStream is = new FileInputStream(fileSchematic);
            gy nbt = hi.a((InputStream)is);
            is.close();
            if (nbt != null && (schematic = new LitematicaSchematic(fileSchematic)).readFromNBT(nbt)) {
                return schematic;
            }
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.exception", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
        }
        return null;
    }

    public static class EntityInfo {
        public final cee posVec;
        public final gy nbt;

        public EntityInfo(cee posVec, gy nbt) {
            this.posVec = posVec;
            this.nbt = nbt;
        }
    }
}

