/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class TaskProcessChunkBase
extends TaskBase {
    protected final ArrayListMultimap<axm, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    protected final Set<axm> requiredChunks = new HashSet<axm>();
    protected final crg worldClient;
    protected final axy world;
    protected final boolean isClientWorld;

    protected TaskProcessChunkBase(String nameOnHud) {
        this.worldClient = this.mc.g;
        this.world = WorldUtils.getBestWorld((cft)this.mc);
        this.isClientWorld = this.world == this.mc.g;
        this.name = StringUtils.translate((String)nameOnHud, (Object[])new Object[0]);
        InfoHud.getInstance().addInfoHudRenderer(this, true);
    }

    @Override
    public boolean execute() {
        if (this.worldClient != null) {
            Iterator<axm> iter = this.requiredChunks.iterator();
            int processed = 0;
            while (iter.hasNext()) {
                axm pos = iter.next();
                if (!this.canProcessChunk(pos)) continue;
                this.processChunk(pos);
                iter.remove();
                ++processed;
            }
            if (processed > 0) {
                this.updateInfoHudLinesMissingChunks(this.requiredChunks);
            }
        }
        this.finished = this.requiredChunks.isEmpty();
        return this.finished;
    }

    @Override
    public void stop() {
        if (this.isClientWorld) {
            this.onStop();
        } else {
            this.mc.a(new Runnable(){

                @Override
                public void run() {
                    TaskProcessChunkBase.this.onStop();
                }
            });
        }
    }

    protected void onStop() {
        this.notifyListener();
    }

    protected abstract boolean canProcessChunk(axm var1);

    protected abstract boolean processChunk(axm var1);

    protected void addBoxesPerChunks(Collection<Box> allBoxes) {
        this.boxesInChunks.clear();
        this.requiredChunks.clear();
        this.requiredChunks.addAll(PositionUtils.getTouchedChunksForBoxes(allBoxes));
        for (axm pos : this.requiredChunks) {
            this.boxesInChunks.putAll((Object)pos, PositionUtils.getBoxesWithinChunk(pos.a, pos.b, allBoxes));
        }
    }

    protected List<IntBoundingBox> getBoxesInChunk(axm pos) {
        return this.boxesInChunks.get((Object)pos);
    }
}

