/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import com.google.common.collect.ArrayListMultimap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskBase;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class TaskPasteSchematicSetblock
extends TaskBase
implements IInfoHudRenderer {
    private final ArrayListMultimap<axm, IntBoundingBox> boxesInChunks = ArrayListMultimap.create();
    private final List<IntBoundingBox> boxesInCurrentChunk = new ArrayList<IntBoundingBox>();
    private final List<axm> chunks = new ArrayList<axm>();
    private final PositionUtils.ChunkPosComparator comparator;
    private final int maxCommandsPerTick;
    private final boolean changedBlockOnly;
    private final ReplaceBehavior replace;
    private int sentCommandsThisTick;
    private int sentCommandsTotal;
    private int currentX;
    private int currentY;
    private int currentZ;
    private int currentIndex;
    private int boxVolume;
    private boolean boxInProgress;

    public TaskPasteSchematicSetblock(SchematicPlacement placement, boolean changedBlocksOnly) {
        this.changedBlockOnly = changedBlocksOnly;
        this.maxCommandsPerTick = Configs.Generic.PASTE_COMMAND_LIMIT.getIntegerValue();
        this.comparator = new PositionUtils.ChunkPosComparator();
        this.comparator.setClosestFirst(true);
        this.replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        this.name = StringUtils.translate((String)"litematica.gui.label.task_name.paste", (Object[])new Object[0]);
        Set<axm> touchedChunks = placement.getTouchedChunks();
        for (axm pos : touchedChunks) {
            this.boxesInChunks.putAll((Object)pos, (Iterable)placement.getBoxesWithinChunk(pos.a, pos.b).values());
            this.chunks.add(pos);
        }
        this.sortChunkList();
        InfoHud.getInstance().addInfoHudRenderer(this, true);
        this.updateInfoHudLines();
    }

    @Override
    public boolean canExecute() {
        return !this.boxesInChunks.isEmpty() && this.mc.g != null && this.mc.i != null && !this.mc.x();
    }

    @Override
    public boolean execute() {
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        crg worldClient = this.mc.g;
        this.sentCommandsThisTick = 0;
        int processed = 0;
        int chunkAttempts = 0;
        if (this.sentCommandsTotal == 0) {
            this.mc.i.f("/gamerule sendCommandFeedback false");
        }
        block0: while (!this.chunks.isEmpty()) {
            axm pos = this.chunks.get(0);
            if (!this.canProcessChunk(pos, worldSchematic, worldClient)) {
                if (this.boxInProgress || chunkAttempts > 0) {
                    return false;
                }
                this.sortChunkList();
                ++chunkAttempts;
                continue;
            }
            while (!this.boxesInCurrentChunk.isEmpty()) {
                IntBoundingBox box = this.boxesInCurrentChunk.get(0);
                if (this.processBox(pos, box, worldSchematic, worldClient, this.mc.i)) {
                    this.boxesInCurrentChunk.remove(0);
                    if (!this.boxesInCurrentChunk.isEmpty()) continue;
                    this.boxesInChunks.removeAll((Object)pos);
                    this.chunks.remove(0);
                    ++processed;
                    if (this.chunks.isEmpty()) {
                        this.finished = true;
                        return true;
                    }
                    this.sortChunkList();
                    continue block0;
                }
                if (processed > 0) {
                    this.updateInfoHudLines();
                }
                return false;
            }
        }
        if (processed > 0) {
            this.updateInfoHudLines();
        }
        return false;
    }

    private void sortChunkList() {
        if (this.chunks.size() > 0) {
            if (this.mc.i != null) {
                this.comparator.setReferencePosition(new el((aer)this.mc.i));
                Collections.sort(this.chunks, this.comparator);
            }
            this.boxesInCurrentChunk.clear();
            this.boxesInCurrentChunk.addAll(this.boxesInChunks.get((Object)this.chunks.get(0)));
        }
    }

    protected boolean canProcessChunk(axm pos, WorldSchematic worldSchematic, crg worldClient) {
        if (!worldSchematic.getChunkProvider().isChunkLoaded(pos.a, pos.b) || DataManager.getSchematicPlacementManager().hasPendingRebuildFor(pos)) {
            return false;
        }
        return this.areSurroundingChunksLoaded(pos, worldClient, 1);
    }

    protected boolean processBox(axm pos, IntBoundingBox box, WorldSchematic worldSchematic, crg worldClient, ctj player) {
        el.a posMutable = new el.a();
        ChunkSchematic chunkSchematic = worldSchematic.getChunkProvider().getChunk(pos.a, pos.b);
        bnj chunkClient = worldClient.i().a(pos.a, pos.b, false, false);
        if (!this.boxInProgress) {
            this.currentX = box.minX;
            this.currentY = box.minY;
            this.currentZ = box.minZ;
            this.boxVolume = (box.maxX - box.minX + 1) * (box.maxY - box.minY + 1) * (box.maxZ - box.minZ + 1);
            this.currentIndex = 0;
            this.boxInProgress = true;
        }
        while (this.currentIndex < this.boxVolume) {
            posMutable.c(this.currentX, this.currentY, this.currentZ);
            if (++this.currentY > box.maxY) {
                this.currentY = box.minY;
                if (++this.currentX > box.maxX) {
                    this.currentX = box.minX;
                    ++this.currentZ;
                }
            }
            ++this.currentIndex;
            blc stateSchematic = chunkSchematic.a_((el)posMutable);
            blc stateClient = chunkClient.a_((el)posMutable);
            if (stateSchematic.f() && stateClient.f() || this.changedBlockOnly && stateClient == stateSchematic || this.replace == ReplaceBehavior.NONE && !stateClient.f() || this.replace == ReplaceBehavior.WITH_NON_AIR && stateSchematic.f()) continue;
            this.sendSetBlockCommand(posMutable.o(), posMutable.p(), posMutable.q(), stateSchematic, player);
            if (++this.sentCommandsThisTick < this.maxCommandsPerTick) continue;
            break;
        }
        if (this.currentIndex >= this.boxVolume) {
            this.summonEntities(box, worldSchematic, player);
            this.boxInProgress = false;
            return true;
        }
        return false;
    }

    private void summonEntities(IntBoundingBox box, WorldSchematic worldSchematic, ctj player) {
        cea bb = new cea((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
        List entities = worldSchematic.a(null, bb);
        for (aer entity : entities) {
            String id = EntityUtils.getEntityId(entity);
            if (id == null) continue;
            String strCommand = String.format("/summon %s %f %f %f", id, entity.q, entity.r, entity.s);
            player.f(strCommand);
        }
    }

    private void sendSetBlockCommand(int x, int y, int z, blc state, ctj player) {
        String cmdName = Configs.Generic.PASTE_COMMAND_SETBLOCK.getStringValue();
        String blockString = cw.a((blc)state, null);
        String strCommand = String.format("/%s %d %d %d %s", cmdName, x, y, z, blockString);
        player.f(strCommand);
        ++this.sentCommandsTotal;
    }

    @Override
    public void stop() {
        if (this.finished) {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.schematic_pasted_using_setblock", (Object[])new Object[]{this.sentCommandsTotal});
        } else {
            InfoUtils.showGuiOrActionBarMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.schematic_paste_failed", (Object[])new Object[0]);
        }
        if (this.mc.i != null) {
            this.mc.i.f("/gamerule sendCommandFeedback true");
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        super.stop();
    }

    private void updateInfoHudLines() {
        ArrayList<String> hudLines = new ArrayList<String>();
        String pre = GuiBase.TXT_WHITE + GuiBase.TXT_BOLD;
        String title = StringUtils.translate((String)"litematica.gui.label.schematic_paste.missing_chunks", (Object[])new Object[]{this.chunks.size()});
        hudLines.add(String.format("%s%s%s", pre, title, GuiBase.TXT_RST));
        int maxLines = Math.min(this.chunks.size(), Configs.InfoOverlays.INFO_HUD_MAX_LINES.getIntegerValue());
        for (int i = 0; i < maxLines; ++i) {
            axm pos = this.chunks.get(i);
            hudLines.add(String.format("cx: %5d, cz: %5d (x: %d, z: %d)", pos.a, pos.b, pos.a << 4, pos.b << 4));
        }
        this.infoHudLines = hudLines;
    }
}

