/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskProcessChunkBase;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import java.util.List;
import javax.annotation.Nullable;

public class TaskFillArea
extends TaskProcessChunkBase {
    protected final blc fillState;
    @Nullable
    protected final blc replaceState;
    protected final String blockString;
    protected final boolean removeEntities;
    protected int chunkCount;

    public TaskFillArea(List<Box> boxes, blc fillState, @Nullable blc replaceState, boolean removeEntities) {
        this(boxes, fillState, replaceState, removeEntities, "litematica.gui.label.task_name.fill");
    }

    protected TaskFillArea(List<Box> boxes, blc fillState, @Nullable blc replaceState, boolean removeEntities, String nameOnHud) {
        super(nameOnHud);
        this.fillState = fillState;
        this.replaceState = replaceState;
        this.removeEntities = removeEntities;
        String blockString = cw.a((blc)fillState, null);
        if (replaceState != null) {
            blockString = blockString + " replace " + cw.a((blc)replaceState, null);
        }
        this.blockString = blockString;
        this.addBoxesPerChunks(boxes);
        this.updateInfoHudLinesMissingChunks(this.requiredChunks);
    }

    @Override
    public boolean canExecute() {
        return super.canExecute() && this.blockString != null;
    }

    @Override
    protected boolean canProcessChunk(axm pos) {
        return this.mc.i != null && this.areSurroundingChunksLoaded(pos, this.worldClient, 1);
    }

    @Override
    protected boolean processChunk(axm pos) {
        if (this.chunkCount == 0) {
            this.mc.i.f("/gamerule sendCommandFeedback false");
        }
        for (IntBoundingBox box : this.getBoxesInChunk(pos)) {
            if (this.isClientWorld) {
                this.fillBoxCommands(box, this.removeEntities);
                continue;
            }
            this.fillBoxDirect(box, this.removeEntities);
        }
        ++this.chunkCount;
        return true;
    }

    protected void fillBoxDirect(IntBoundingBox box, boolean removeEntities) {
        if (removeEntities) {
            cea aabb = new cea((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1));
            List entities = this.world.a((aer)this.mc.i, aabb, EntityUtils.NOT_PLAYER);
            for (aer entity : entities) {
                if (entity instanceof aog) continue;
                entity.V();
            }
        }
        blc barrier = bct.fU.p();
        el.a posMutable = new el.a();
        for (int z = box.minZ; z <= box.maxZ; ++z) {
            for (int x = box.minX; x <= box.maxX; ++x) {
                for (int y = box.maxY; y >= box.minY; --y) {
                    posMutable.c(x, y, z);
                    blc oldState = this.world.a_((el)posMutable);
                    if ((this.replaceState != null || oldState == this.fillState) && oldState != this.replaceState) continue;
                    bji te = this.world.f((el)posMutable);
                    if (te instanceof ade) {
                        ((ade)te).m();
                        this.world.a((el)posMutable, barrier, 18);
                    }
                    this.world.a((el)posMutable, this.fillState, 18);
                }
            }
        }
    }

    protected void fillBoxCommands(IntBoundingBox box, boolean removeEntities) {
        cea aabb;
        if (removeEntities && this.world.a((aer)this.mc.i, aabb = new cea((double)box.minX, (double)box.minY, (double)box.minZ, (double)(box.maxX + 1), (double)(box.maxY + 1), (double)(box.maxZ + 1)), EntityUtils.NOT_PLAYER).size() > 0) {
            String killCmd = String.format("/kill @e[type=!player,x=%d,y=%d,z=%d,dx=%d,dy=%d,dz=%d]", box.minX, box.minY, box.minZ, box.maxX - box.minX + 1, box.maxY - box.minY + 1, box.maxZ - box.minZ + 1);
            this.mc.i.f(killCmd);
        }
        String fillCmd = String.format("/fill %d %d %d %d %d %d %s", box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ, this.blockString);
        this.mc.i.f(fillCmd);
    }

    @Override
    protected void onStop() {
        this.printCompletionMessage();
        if (this.isClientWorld && this.mc.i != null) {
            this.mc.i.f("/gamerule sendCommandFeedback true");
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        this.notifyListener();
    }

    protected void printCompletionMessage() {
        if (this.finished) {
            if (this.printCompletionMessage) {
                InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.SUCCESS, (String)"litematica.message.area_filled", (Object[])new Object[0]);
            }
        } else {
            InfoUtils.showGuiMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.area_fill_fail", (Object[])new Object[0]);
        }
    }
}

