/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.scheduler.tasks;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.IMaterialList;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.materials.MaterialListUtils;
import fi.dy.masa.litematica.render.infohud.InfoHud;
import fi.dy.masa.litematica.scheduler.tasks.TaskProcessChunkBase;
import fi.dy.masa.litematica.util.BlockInfoListType;
import fi.dy.masa.litematica.util.SchematicWorldRefresher;
import fi.dy.masa.malilib.interfaces.IRangeChangeListener;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;

public abstract class TaskCountBlocksBase
extends TaskProcessChunkBase {
    protected final Object2IntOpenHashMap<blc> countsTotal = new Object2IntOpenHashMap();
    protected final Object2IntOpenHashMap<blc> countsMissing = new Object2IntOpenHashMap();
    protected final Object2IntOpenHashMap<blc> countsMismatch = new Object2IntOpenHashMap();
    protected final IMaterialList materialList;
    protected final LayerRange layerRange;

    protected TaskCountBlocksBase(IMaterialList materialList, String nameOnHud) {
        super(nameOnHud);
        this.materialList = materialList;
        this.layerRange = materialList.getMaterialListType() == BlockInfoListType.ALL ? new LayerRange((IRangeChangeListener)SchematicWorldRefresher.INSTANCE) : DataManager.getRenderLayerRange();
    }

    @Override
    protected boolean canProcessChunk(axm pos) {
        return this.areSurroundingChunksLoaded(pos, this.worldClient, 1);
    }

    @Override
    protected boolean processChunk(axm pos) {
        this.countBlocksInChunk(pos);
        return true;
    }

    protected void countBlocksInChunk(axm pos) {
        LayerRange range = this.layerRange;
        eq.a axis = range.getAxis();
        el.a posMutable = new el.a();
        for (IntBoundingBox bb : this.getBoxesInChunk(pos)) {
            int startX = axis == eq.a.a ? Math.max(bb.minX, range.getLayerMin()) : bb.minX;
            int startY = axis == eq.a.b ? Math.max(bb.minY, range.getLayerMin()) : bb.minY;
            int startZ = axis == eq.a.c ? Math.max(bb.minZ, range.getLayerMin()) : bb.minZ;
            int endX = axis == eq.a.a ? Math.min(bb.maxX, range.getLayerMax()) : bb.maxX;
            int endY = axis == eq.a.b ? Math.min(bb.maxY, range.getLayerMax()) : bb.maxY;
            int endZ = axis == eq.a.c ? Math.min(bb.maxZ, range.getLayerMax()) : bb.maxZ;
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        posMutable.c(x, y, z);
                        this.countAtPosition((el)posMutable);
                    }
                }
            }
        }
    }

    protected abstract void countAtPosition(el var1);

    @Override
    protected void onStop() {
        if (this.finished && this.mc.i != null) {
            List<MaterialListEntry> list = MaterialListUtils.getMaterialList(this.countsTotal, this.countsMissing, this.countsMismatch, (aog)this.mc.i);
            this.materialList.setMaterialListEntries(list);
        }
        InfoHud.getInstance().removeInfoHudRenderer(this, false);
        this.notifyListener();
    }
}

