/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Lists;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.IMixinBlockRendererDispatcher;
import fi.dy.masa.litematica.mixin.IMixinViewFrustum;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderContainerSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.CompiledChunkSchematic;
import fi.dy.masa.litematica.render.schematic.RenderChunkFactoryList;
import fi.dy.masa.litematica.render.schematic.RenderChunkFactoryVbo;
import fi.dy.masa.litematica.render.schematic.RenderChunkSchematicVbo;
import fi.dy.masa.litematica.render.schematic.RenderListSchematic;
import fi.dy.masa.litematica.render.schematic.VboRenderListSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class WorldRendererSchematic
extends cue {
    private final cft mc;
    private final cyo renderManager;
    private final cut blockModelShapes;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final cuv fluidRenderer;
    private final Set<bji> setTileEntities = new HashSet<bji>();
    private final List<RenderChunkSchematicVbo> renderInfos = new ArrayList<RenderChunkSchematicVbo>(1024);
    private Set<RenderChunkSchematicVbo> chunksToUpdate = new LinkedHashSet<RenderChunkSchematicVbo>();
    private WorldSchematic world;
    private cup viewFrustum;
    private double frustumUpdatePosX = Double.MIN_VALUE;
    private double frustumUpdatePosY = Double.MIN_VALUE;
    private double frustumUpdatePosZ = Double.MIN_VALUE;
    private int frustumUpdatePosChunkX = Integer.MIN_VALUE;
    private int frustumUpdatePosChunkY = Integer.MIN_VALUE;
    private int frustumUpdatePosChunkZ = Integer.MIN_VALUE;
    private double lastViewEntityX = Double.MIN_VALUE;
    private double lastViewEntityY = Double.MIN_VALUE;
    private double lastViewEntityZ = Double.MIN_VALUE;
    private float lastViewEntityPitch = Float.MIN_VALUE;
    private float lastViewEntityYaw = Float.MIN_VALUE;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private ChunkRenderContainerSchematic renderContainer;
    private cwu renderChunkFactory;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private boolean vboEnabled;
    private double prevRenderSortX;
    private double prevRenderSortY;
    private double prevRenderSortZ;
    private boolean displayListEntitiesDirty = true;

    public WorldRendererSchematic(cft mc) {
        super(mc);
        this.mc = mc;
        this.renderManager = mc.U();
        this.vboEnabled = dhq.f();
        if (this.vboEnabled) {
            this.renderContainer = new VboRenderListSchematic();
            this.renderChunkFactory = new RenderChunkFactoryVbo();
        } else {
            this.renderContainer = new RenderListSchematic();
            this.renderChunkFactory = new RenderChunkFactoryList();
        }
        cuu dispatcher = mc.T();
        this.blockModelShapes = dispatcher.a();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.ad());
        this.fluidRenderer = ((IMixinBlockRendererDispatcher)dispatcher).getFluidRenderer();
    }

    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    public String f() {
        int rcTotal = this.viewFrustum != null ? this.viewFrustum.f.length : 0;
        int rcRendered = this.viewFrustum != null ? this.g() : 0;
        return String.format("C: %d/%d %sD: %d, L: %d, %s", rcRendered, rcTotal, this.mc.D ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    public String h() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    protected int g() {
        int count = 0;
        for (RenderChunkSchematicVbo renderChunk : this.renderInfos) {
            CompiledChunkSchematic data = renderChunk.getChunkRenderData();
            if (data == CompiledChunkSchematic.EMPTY || data.a()) continue;
            ++count;
        }
        return count;
    }

    public void setWorldAndLoadRenderers(@Nullable WorldSchematic worldSchematic) {
        if (this.world != null) {
            this.world.b((ayb)this);
        }
        this.frustumUpdatePosX = Double.MIN_VALUE;
        this.frustumUpdatePosY = Double.MIN_VALUE;
        this.frustumUpdatePosZ = Double.MIN_VALUE;
        this.frustumUpdatePosChunkX = Integer.MIN_VALUE;
        this.frustumUpdatePosChunkY = Integer.MIN_VALUE;
        this.frustumUpdatePosChunkZ = Integer.MIN_VALUE;
        this.world = worldSchematic;
        if (worldSchematic != null) {
            worldSchematic.a((ayb)this);
            this.a();
        } else {
            this.chunksToUpdate.clear();
            this.renderInfos.clear();
            if (this.viewFrustum != null) {
                this.viewFrustum.a();
                this.viewFrustum = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a() {
        if (this.world != null) {
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica();
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = this.mc.t.e;
            boolean vboEnabledPrevious = this.vboEnabled;
            this.vboEnabled = dhq.f();
            if (!this.vboEnabled && vboEnabledPrevious) {
                this.renderContainer = new RenderListSchematic();
                this.renderChunkFactory = new RenderChunkFactoryList();
            } else if (this.vboEnabled && !vboEnabledPrevious) {
                this.renderContainer = new VboRenderListSchematic();
                this.renderChunkFactory = new RenderChunkFactoryVbo();
            }
            if (this.viewFrustum != null) {
                this.viewFrustum.a();
            }
            this.e();
            Set<bji> set = this.setTileEntities;
            synchronized (set) {
                this.setTileEntities.clear();
            }
            this.viewFrustum = new cup((axy)this.world, this.mc.t.e, (cue)this, this.renderChunkFactory);
            aer entity = this.mc.S();
            if (entity != null) {
                this.viewFrustum.a(entity.q, entity.s);
            }
            this.renderEntitiesStartupCounter = 2;
        }
    }

    protected void e() {
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates();
    }

    public void a(aer viewEntity, float partialTicks, cwz camera, int frameCount, boolean playerSpectator) {
        Set<RenderChunkSchematicVbo> set;
        this.world.A.a("setup_terrain");
        if (this.viewFrustum == null || this.mc.t.e != this.renderDistanceChunks) {
            this.a();
        }
        this.world.A.a("camera");
        double diffX = viewEntity.q - this.frustumUpdatePosX;
        double diffY = viewEntity.r - this.frustumUpdatePosY;
        double diffZ = viewEntity.s - this.frustumUpdatePosZ;
        if (this.frustumUpdatePosChunkX != viewEntity.ae || this.frustumUpdatePosChunkY != viewEntity.af || this.frustumUpdatePosChunkZ != viewEntity.ag || diffX * diffX + diffY * diffY + diffZ * diffZ > 16.0) {
            this.frustumUpdatePosX = viewEntity.q;
            this.frustumUpdatePosY = viewEntity.r;
            this.frustumUpdatePosZ = viewEntity.s;
            this.frustumUpdatePosChunkX = viewEntity.ae;
            this.frustumUpdatePosChunkY = viewEntity.af;
            this.frustumUpdatePosChunkZ = viewEntity.ag;
            this.viewFrustum.a(viewEntity.q, viewEntity.s);
        }
        this.world.A.c("renderlist_camera");
        double x = viewEntity.N + (viewEntity.q - viewEntity.N) * (double)partialTicks;
        double y = viewEntity.O + (viewEntity.r - viewEntity.O) * (double)partialTicks;
        double z = viewEntity.P + (viewEntity.s - viewEntity.P) * (double)partialTicks;
        this.renderContainer.a(x, y, z);
        this.world.A.c("culling");
        el viewPos = new el(x, y + (double)viewEntity.bF(), z);
        int centerChunkX = viewPos.o() >> 4;
        int centerChunkZ = viewPos.q() >> 4;
        int renderDistance = this.mc.t.e;
        SubChunkPos viewSubChunk = new SubChunkPos(centerChunkX, viewPos.p() >> 4, centerChunkZ);
        el viewPosSubChunk = new el(viewSubChunk.o() << 4, viewSubChunk.p() << 4, viewSubChunk.q() << 4);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || viewEntity.q != this.lastViewEntityX || viewEntity.r != this.lastViewEntityY || viewEntity.s != this.lastViewEntityZ || viewEntity.x != this.lastViewEntityPitch || viewEntity.w != this.lastViewEntityYaw;
        this.lastViewEntityX = viewEntity.q;
        this.lastViewEntityY = viewEntity.r;
        this.lastViewEntityZ = viewEntity.s;
        this.lastViewEntityPitch = viewEntity.x;
        this.lastViewEntityYaw = viewEntity.w;
        this.world.A.c("update");
        if (this.displayListEntitiesDirty) {
            this.world.A.a("fetch");
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            aer.b((double)xq.a((double)((double)renderDistance / 8.0), (double)1.0, (double)2.5));
            set = DataManager.getSchematicPlacementManager().getAllTouchedSubChunks();
            ArrayList<RenderChunkSchematicVbo> positions = new ArrayList<RenderChunkSchematicVbo>(set.size());
            positions.addAll(set);
            Collections.sort(positions, new SubChunkPos.DistanceComparator(viewSubChunk));
            this.world.A.c("iteration");
            for (int i = 0; i < positions.size(); ++i) {
                el subChunkCornerPos;
                RenderChunkSchematicVbo renderChunk;
                SubChunkPos subChunk = (SubChunkPos)positions.get(i);
                if (Math.abs(subChunk.o() - centerChunkX) > renderDistance || Math.abs(subChunk.q() - centerChunkZ) > renderDistance || !this.world.getChunkProvider().isChunkLoaded(subChunk.o(), subChunk.q()) || (renderChunk = (RenderChunkSchematicVbo)((IMixinViewFrustum)this.viewFrustum).invokeGetRenderChunk(subChunkCornerPos = new el(subChunk.o() << 4, subChunk.p() << 4, subChunk.q() << 4))) == null || !renderChunk.a(frameCount) || !camera.a(renderChunk.c)) continue;
                if (renderChunk.m() && subChunkCornerPos.equals((Object)viewPosSubChunk)) {
                    renderChunk.a(true);
                }
                this.renderInfos.add(renderChunk);
            }
            this.world.A.e();
        }
        this.world.A.c("rebuild_near");
        set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<RenderChunkSchematicVbo>();
        for (RenderChunkSchematicVbo renderChunkTmp : this.renderInfos) {
            boolean isNear;
            if (!renderChunkTmp.m() && !set.contains((Object)renderChunkTmp)) continue;
            this.displayListEntitiesDirty = true;
            el pos = renderChunkTmp.k().a(8, 8, 8);
            boolean bl = isNear = pos.n((ff)viewPos) < 1024.0;
            if (!renderChunkTmp.n() && !isNear) {
                this.chunksToUpdate.add(renderChunkTmp);
                continue;
            }
            this.world.A.a("build_near");
            this.renderDispatcher.updateChunkNow(renderChunkTmp);
            renderChunkTmp.l();
            this.world.A.e();
        }
        this.chunksToUpdate.addAll(set);
        this.world.A.e();
        this.world.A.e();
    }

    public void a(long finishTimeNano) {
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano);
        if (!this.chunksToUpdate.isEmpty()) {
            RenderChunkSchematicVbo renderChunk;
            boolean flag;
            Iterator<RenderChunkSchematicVbo> iterator = this.chunksToUpdate.iterator();
            while (iterator.hasNext() && (flag = (renderChunk = iterator.next()).n() ? this.renderDispatcher.updateChunkNow(renderChunk) : this.renderDispatcher.updateChunkLater(renderChunk))) {
                renderChunk.l();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i >= 0L) continue;
                break;
            }
        }
    }

    public int a(axl blockLayerIn, double partialTicks, aer entityIn) {
        this.world.A.a("render_block_layer_" + blockLayerIn);
        RenderUtils.disableItemLighting();
        if (blockLayerIn == axl.d) {
            this.world.A.a("translucent_sort");
            double diffX = entityIn.q - this.prevRenderSortX;
            double diffY = entityIn.r - this.prevRenderSortY;
            double diffZ = entityIn.s - this.prevRenderSortZ;
            if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
                this.prevRenderSortX = entityIn.q;
                this.prevRenderSortY = entityIn.r;
                this.prevRenderSortZ = entityIn.s;
                int i = 0;
                for (RenderChunkSchematicVbo renderChunk : this.renderInfos) {
                    if (!renderChunk.getChunkRenderData().d(blockLayerIn) && (renderChunk.getChunkRenderData() == cwr.a || !renderChunk.hasOverlay()) || i++ >= 15) continue;
                    this.renderDispatcher.updateTransparencyLater(renderChunk);
                }
            }
            this.world.A.e();
        }
        this.world.A.a("filter_empty");
        boolean reverse = blockLayerIn == axl.d;
        int startIndex = reverse ? this.renderInfos.size() - 1 : 0;
        int stopIndex = reverse ? -1 : this.renderInfos.size();
        int increment = reverse ? -1 : 1;
        int count = 0;
        for (int i = startIndex; i != stopIndex; i += increment) {
            RenderChunkSchematicVbo renderchunk = this.renderInfos.get(i);
            if (renderchunk.getChunkRenderData().b(blockLayerIn)) continue;
            ++count;
            this.renderContainer.a(renderchunk, blockLayerIn);
        }
        this.world.A.c("render");
        this.renderBlockLayer(blockLayerIn);
        this.world.A.e();
        this.world.A.e();
        return count;
    }

    private void renderBlockLayer(axl layer) {
        this.mc.n.i();
        if (dhq.f()) {
            cua.q((int)32884);
            dhq.l((int)dhq.q);
            cua.q((int)32888);
            dhq.l((int)dhq.r);
            cua.q((int)32888);
            dhq.l((int)dhq.q);
            cua.q((int)32886);
        }
        this.renderContainer.a(layer);
        if (dhq.f()) {
            for (ddx vertexformatelement : ddu.g.h()) {
                ddx.b vertexformatelement$enumusage = vertexformatelement.b();
                int index = vertexformatelement.d();
                switch (vertexformatelement$enumusage) {
                    case a: {
                        cua.p((int)32884);
                        break;
                    }
                    case d: {
                        dhq.l((int)(dhq.q + index));
                        cua.p((int)32888);
                        dhq.l((int)dhq.q);
                        break;
                    }
                    case c: {
                        cua.p((int)32886);
                        cua.I();
                    }
                }
            }
        }
        this.mc.n.h();
    }

    public void renderBlockOverlays() {
        this.renderBlockOverlay(RenderChunkSchematicVbo.OverlayRenderType.OUTLINE);
        this.renderBlockOverlay(RenderChunkSchematicVbo.OverlayRenderType.QUAD);
    }

    private void renderBlockOverlay(RenderChunkSchematicVbo.OverlayRenderType type) {
        this.world.A.a("overlay_" + type.name());
        this.world.A.a("filter_empty");
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            CompiledChunkSchematic compiledChunk;
            RenderChunkSchematicVbo renderChunk = this.renderInfos.get(i);
            if (renderChunk.getChunkRenderData() == cwr.a || !renderChunk.hasOverlay() || (compiledChunk = renderChunk.getChunkRenderData()).isOverlayTypeEmpty(type)) continue;
            this.renderContainer.addOverlayChunk(renderChunk);
        }
        this.world.A.c("render");
        this.renderBlockOverlayBuffers(type);
        this.world.A.e();
        this.world.A.e();
    }

    private void renderBlockOverlayBuffers(RenderChunkSchematicVbo.OverlayRenderType type) {
        this.mc.n.i();
        if (dhq.f()) {
            cua.q((int)32884);
            cua.q((int)32886);
        }
        this.renderContainer.renderBlockOverlays(type);
        if (dhq.f()) {
            for (ddx element : ddu.l.h()) {
                ddx.b usage = element.b();
                switch (usage) {
                    case a: {
                        cua.p((int)32884);
                        break;
                    }
                    case d: {
                        dhq.l((int)(dhq.q + element.d()));
                        cua.p((int)32888);
                        dhq.l((int)dhq.q);
                        break;
                    }
                    case c: {
                        cua.p((int)32886);
                        cua.I();
                    }
                }
            }
        }
        this.mc.n.h();
    }

    public boolean renderBlock(blc state, el pos, aye world, ctq bufferBuilderIn) {
        try {
            bgy renderType = state.i();
            if (renderType == bgy.a) {
                return false;
            }
            switch (renderType) {
                case c: {
                    return this.blockModelRenderer.renderModel(world, this.getModelForState(state), state, pos, bufferBuilderIn, state.a(pos));
                }
                case b: {
                    return false;
                }
            }
            return false;
        }
        catch (Throwable throwable) {
            b crashreport = b.a((Throwable)throwable, (String)"Tesselating block in world");
            c crashreportcategory = crashreport.a("Block being tesselated");
            c.a((c)crashreportcategory, (el)pos, (blc)state);
            throw new h(crashreport);
        }
    }

    public boolean renderFluid(byw state, el pos, aye world, ctq bufferBuilderIn) {
        try {
            return this.fluidRenderer.a(world, pos, bufferBuilderIn, state);
        }
        catch (Throwable throwable) {
            b crashreport = b.a((Throwable)throwable, (String)"Tesselating liquid in world");
            c crashreportcategory = crashreport.a("Block being tesselated");
            c.a((c)crashreportcategory, (el)pos, null);
            throw new h(crashreport);
        }
    }

    public dez getModelForState(blc state) {
        return this.blockModelShapes.b(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(aer renderViewEntity, cwz camera, float partialTicks) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            double renderX = renderViewEntity.n + (renderViewEntity.q - renderViewEntity.n) * (double)partialTicks;
            double renderY = renderViewEntity.o + (renderViewEntity.r - renderViewEntity.o) * (double)partialTicks;
            double renderZ = renderViewEntity.p + (renderViewEntity.s - renderViewEntity.p) * (double)partialTicks;
            this.world.A.a("prepare");
            cwa.a.a((axy)this.world, this.mc.E(), this.mc.l, this.mc.S(), this.mc.s, partialTicks);
            this.renderManager.a((axy)this.world, this.mc.l, this.mc.S(), this.mc.j, this.mc.t, partialTicks);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            aer entity = this.mc.S();
            double entityX = entity.N + (entity.q - entity.N) * (double)partialTicks;
            double entityY = entity.O + (entity.r - entity.O) * (double)partialTicks;
            double entityZ = entity.P + (entity.s - entity.P) * (double)partialTicks;
            cwa.b = entityX;
            cwa.c = entityY;
            cwa.d = entityZ;
            this.renderManager.a(entityX, entityY, entityZ);
            this.mc.n.i();
            this.countEntitiesTotal = this.world.R();
            this.world.A.c("regular_entities");
            ArrayList entitiesOutlined = Lists.newArrayList();
            ArrayList entitiesMultipass = Lists.newArrayList();
            el.b posMutable = el.b.r();
            LayerRange layerRange = DataManager.getRenderLayerRange();
            for (RenderChunkSchematicVbo renderChunk : this.renderInfos) {
                bnj chunk = this.world.l(renderChunk.k());
                xe classinheritancemultimap = chunk.C()[renderChunk.k().p() / 16];
                if (classinheritancemultimap.isEmpty()) continue;
                for (aer entityTmp : classinheritancemultimap) {
                    boolean sleeping;
                    boolean shouldRender;
                    if (!layerRange.isPositionWithinRange((int)entityTmp.q, (int)entityTmp.r, (int)entityTmp.s) || !(shouldRender = this.renderManager.a(entityTmp, camera, renderX, renderY, renderZ) || entityTmp.y((aer)this.mc.i))) continue;
                    boolean bl = sleeping = this.mc.S() instanceof afa ? ((afa)this.mc.S()).cL() : false;
                    if (entityTmp == this.mc.S() && this.mc.t.aA == 0 && !sleeping || !(entityTmp.r < 0.0) && !(entityTmp.r >= 256.0) && !this.world.D((el)posMutable.c(entityTmp))) continue;
                    ++this.countEntitiesRendered;
                    this.renderManager.a(entityTmp, 0.0f, false);
                    if (this.isOutlineActive(entityTmp, entity, camera)) {
                        entitiesOutlined.add(entityTmp);
                    }
                    if (!this.renderManager.b(entityTmp)) continue;
                    entitiesMultipass.add(entityTmp);
                }
            }
            posMutable.close();
            if (!entitiesMultipass.isEmpty()) {
                for (aer entityTmp : entitiesMultipass) {
                    this.renderManager.a(entityTmp, partialTicks);
                }
            }
            this.world.A.c("block_entities");
            RenderUtils.enableItemLighting();
            for (RenderChunkSchematicVbo renderChunk : this.renderInfos) {
                List tiles = renderChunk.getChunkRenderData().b();
                if (tiles.isEmpty()) continue;
                for (bji te : tiles) {
                    try {
                        cwa.a.a(te, partialTicks, -1);
                    }
                    catch (Exception exception) {}
                }
            }
            Set<bji> set = this.setTileEntities;
            synchronized (set) {
                for (bji te : this.setTileEntities) {
                    try {
                        cwa.a.a(te, partialTicks, -1);
                    }
                    catch (Exception exception) {}
                }
            }
            this.mc.n.h();
            this.world.A.e();
        }
    }

    private boolean isOutlineActive(aer entityIn, aer viewer, cwz camera) {
        boolean sleeping;
        boolean bl = sleeping = viewer instanceof afa && ((afa)viewer).cL();
        if (entityIn == viewer && this.mc.t.aA == 0 && !sleeping) {
            return false;
        }
        if (entityIn.bc()) {
            return true;
        }
        if (this.mc.i.t() && this.mc.t.ar.d() && entityIn instanceof aog) {
            return entityIn.ak || camera.a(entityIn.bD()) || entityIn.y((aer)this.mc.i);
        }
        return false;
    }

    public void a(axk worldIn, el pos, blc oldState, blc newState, int flags) {
        int x = pos.o();
        int y = pos.p();
        int z = pos.q();
        this.markBlocksForUpdate(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, (flags & 8) != 0);
    }

    public void a(int x1, int y1, int z1, int x2, int y2, int z2) {
        this.markBlocksForUpdate(x1 - 1, y1 - 1, z1 - 1, x2 + 1, y2 + 1, z2 + 1, false);
    }

    private void markBlocksForUpdate(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, boolean updateImmediately) {
        if (this.viewFrustum != null) {
            this.viewFrustum.a(minX, minY, minZ, maxX, maxY, maxZ, updateImmediately);
        }
    }

    public void a(el pos) {
    }

    public void a(@Nullable aog player, wi soundIn, wk category, double x, double y, double z, float volume, float pitch) {
    }

    public void a(wi soundIn, el pos) {
    }

    public void a(fk particle, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void a(fk particle, boolean ignoreRange, boolean minimizeLevel, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
    }

    public void a(aer entityIn) {
    }

    public void b(aer entityIn) {
    }

    public void a(int soundID, el pos, int data) {
    }

    public void a(aog player, int type, el blockPosIn, int data) {
    }

    public void b(int breakerId, el pos, int progress) {
    }
}

