/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Sets;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkCacheSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.CompiledChunkSchematic;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.util.OverlayType;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.LayerRange;
import fi.dy.masa.malilib.util.SubChunkPos;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;

public class RenderChunkSchematicVbo
extends cwt {
    public static int schematicRenderChunksUpdated;
    private final WorldRendererSchematic worldRenderer;
    private final ddv[] vertexBufferOverlay = new ddv[OverlayRenderType.values().length];
    private final Set<bji> setTileEntities = new HashSet<bji>();
    private final List<IntBoundingBox> boxes = new ArrayList<IntBoundingBox>();
    private final EnumSet<OverlayRenderType> existingOverlays = EnumSet.noneOf(OverlayRenderType.class);
    private boolean hasOverlay = false;
    private ChunkRenderTaskSchematic compileTask;
    protected final ReentrantLock chunkRenderDataLock;
    private ChunkCacheSchematic schematicWorldView;
    private ChunkCacheSchematic clientWorldView;
    private CompiledChunkSchematic schematicChunkRenderData;
    private Color4f overlayColor;

    public RenderChunkSchematicVbo(axy worldIn, cue renderGlobalIn) {
        super(worldIn, renderGlobalIn);
        this.worldRenderer = (WorldRendererSchematic)renderGlobalIn;
        this.chunkRenderDataLock = new ReentrantLock();
        this.schematicChunkRenderData = CompiledChunkSchematic.EMPTY;
        if (dhq.f()) {
            for (int i = 0; i < OverlayRenderType.values().length; ++i) {
                this.vertexBufferOverlay[i] = new ddv(ddu.l);
            }
        }
    }

    public CompiledChunkSchematic getChunkRenderData() {
        return this.schematicChunkRenderData;
    }

    public void setChunkRenderData(CompiledChunkSchematic data) {
        this.chunkRenderDataLock.lock();
        try {
            this.schematicChunkRenderData = data;
        }
        finally {
            this.chunkRenderDataLock.unlock();
        }
    }

    public boolean hasOverlay() {
        return this.hasOverlay;
    }

    public EnumSet<OverlayRenderType> getOverlayTypes() {
        return this.existingOverlays;
    }

    public ddv getOverlayVertexBuffer(OverlayRenderType type) {
        return this.vertexBufferOverlay[type.ordinal()];
    }

    public void a() {
        super.a();
        for (int i = 0; i < this.vertexBufferOverlay.length; ++i) {
            if (this.vertexBufferOverlay[i] == null) continue;
            this.vertexBufferOverlay[i].c();
        }
    }

    public void resortTransparency(float x, float y, float z, ChunkRenderTaskSchematic generator) {
        OverlayRenderType type;
        CompiledChunkSchematic compiledChunk = generator.getCompiledChunk();
        BufferBuilderCache buffers = generator.getBufferCache();
        ctq.a bufferState = compiledChunk.getBlockBufferState(axl.d);
        if (bufferState != null && !compiledChunk.b(axl.d)) {
            ctq buffer = buffers.getWorldRendererByLayer(axl.d);
            this.preRenderBlocks(buffer, this.k());
            buffer.a(bufferState);
            this.postRenderBlocks(axl.d, x, y, z, buffer, compiledChunk);
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() && (bufferState = compiledChunk.getOverlayBufferState(type = OverlayRenderType.QUAD)) != null && !compiledChunk.isOverlayTypeEmpty(type)) {
            ctq buffer = buffers.getOverlayBuffer(type);
            this.preRenderOverlay(buffer, type.getGlMode());
            buffer.a(bufferState);
            this.postRenderOverlay(type, x, y, z, buffer, compiledChunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildChunk(float x, float y, float z, ChunkRenderTaskSchematic generator) {
        CompiledChunkSchematic data = new CompiledChunkSchematic();
        generator.getLock().lock();
        try {
            if (generator.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                return;
            }
            generator.setCompiledChunk(data);
        }
        finally {
            generator.getLock().unlock();
        }
        HashSet<bji> tileEntities = new HashSet<bji>();
        el posChunk = this.k();
        LayerRange range = DataManager.getRenderLayerRange();
        this.existingOverlays.clear();
        this.hasOverlay = false;
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            if (!(this.boxes.isEmpty() || this.schematicWorldView.isEmpty() && this.clientWorldView.isEmpty() || !range.intersects(new SubChunkPos(posChunk.o() >> 4, posChunk.p() >> 4, posChunk.q() >> 4)))) {
                ++schematicRenderChunksUpdated;
                boolean[] usedLayers = new boolean[axl.values().length];
                BufferBuilderCache buffers = generator.getBufferCache();
                for (IntBoundingBox box : this.boxes) {
                    if ((box = range.getClampedRenderBoundingBox(box)) == null) continue;
                    el posFrom = new el(box.minX, box.minY, box.minZ);
                    el posTo = new el(box.maxX, box.maxY, box.maxZ);
                    for (el.a posMutable : el.b((el)posFrom, (el)posTo)) {
                        this.renderBlocksAndOverlay((el)posMutable, tileEntities, usedLayers, data, buffers);
                    }
                }
                for (axl layerTmp : axl.values()) {
                    if (usedLayers[layerTmp.ordinal()]) {
                        data.a(layerTmp);
                    }
                    if (!data.d(layerTmp)) continue;
                    this.postRenderBlocks(layerTmp, x, y, z, buffers.getWorldRendererByLayer(layerTmp), data);
                }
                if (this.hasOverlay) {
                    for (OverlayRenderType type : this.existingOverlays) {
                        if (!data.isOverlayTypeStarted(type)) continue;
                        data.setOverlayTypeUsed(type);
                        this.postRenderOverlay(type, x, y, z, buffers.getOverlayBuffer(type), data);
                    }
                }
            }
        }
        this.c().lock();
        try {
            HashSet set = Sets.newHashSet(tileEntities);
            HashSet set1 = Sets.newHashSet(this.setTileEntities);
            set.removeAll(this.setTileEntities);
            set1.removeAll(tileEntities);
            this.setTileEntities.clear();
            this.setTileEntities.addAll(tileEntities);
            this.worldRenderer.a(set1, set);
        }
        finally {
            this.c().unlock();
        }
    }

    protected void renderBlocksAndOverlay(el pos, Set<bji> tileEntities, boolean[] usedLayers, CompiledChunkSchematic data, BufferBuilderCache buffers) {
        blc stateSchematic = this.schematicWorldView.a_(pos);
        blc stateClient = this.clientWorldView.a_(pos);
        bcs blockSchematic = stateSchematic.c();
        boolean clientHasAir = stateClient.f();
        boolean schematicHasAir = stateSchematic.f();
        boolean missing = false;
        if (clientHasAir && schematicHasAir) {
            return;
        }
        this.overlayColor = null;
        if (clientHasAir || stateSchematic != stateClient && Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
            ctq bufferSchematic;
            int layerIndex;
            axl layer;
            if (blockSchematic.i()) {
                this.addTileEntity(pos, data, tileEntities);
            }
            boolean translucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
            byw fluidState = stateSchematic.s();
            if (!fluidState.e()) {
                layer = fluidState.k();
                layerIndex = layer.ordinal();
                bufferSchematic = buffers.getWorldRendererByLayerId(layerIndex);
                if (!data.d(layer)) {
                    data.c(layer);
                    this.preRenderBlocks(bufferSchematic, this.k());
                }
                int n = layerIndex;
                usedLayers[n] = usedLayers[n] | this.worldRenderer.renderFluid(fluidState, pos, this.schematicWorldView, bufferSchematic);
            }
            if (stateSchematic.i() != bgy.a) {
                layer = translucent ? axl.d : blockSchematic.c();
                layerIndex = layer.ordinal();
                bufferSchematic = buffers.getWorldRendererByLayerId(layerIndex);
                if (!data.d(layer)) {
                    data.c(layer);
                    this.preRenderBlocks(bufferSchematic, this.k());
                }
                int n = layerIndex;
                usedLayers[n] = usedLayers[n] | this.worldRenderer.renderBlock(stateSchematic, pos, this.schematicWorldView, bufferSchematic);
                if (clientHasAir) {
                    missing = true;
                }
            }
        }
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue()) {
            OverlayType type = this.getOverlayType(stateSchematic, stateClient);
            this.overlayColor = this.getOverlayColor(type);
            if (this.overlayColor != null) {
                this.renderOverlay(type, pos, stateSchematic, missing, data, buffers);
            }
        }
    }

    protected void renderOverlay(OverlayType type, el pos, blc stateSchematic, boolean missing, CompiledChunkSchematic data, BufferBuilderCache buffers) {
        dez bakedModel;
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_SIDES.getBooleanValue()) {
            ctq bufferOverlayQuads = buffers.getOverlayBuffer(OverlayRenderType.QUAD);
            if (!data.isOverlayTypeStarted(OverlayRenderType.QUAD)) {
                data.setOverlayTypeStarted(OverlayRenderType.QUAD);
                this.preRenderOverlay(bufferOverlayQuads, OverlayRenderType.QUAD);
            }
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                el.b posMutable = el.b.r();
                for (int i = 0; i < 6; ++i) {
                    eq side = PositionUtils.FACING_ALL[i];
                    posMutable.f(pos.o() + side.g(), pos.p() + side.h(), pos.q() + side.i());
                    blc adjStateSchematic = this.schematicWorldView.a_((el)posMutable);
                    blc adjStateClient = this.clientWorldView.a_((el)posMutable);
                    OverlayType typeAdj = this.getOverlayType(adjStateSchematic, adjStateClient);
                    if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                        dez bakedModel2 = this.worldRenderer.getModelForState(stateSchematic);
                        if (type.getRenderPriority() <= typeAdj.getRenderPriority() && stateSchematic.c((axk)this.schematicWorldView, pos, side) == blb.a) continue;
                        RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel2, stateSchematic, pos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                        continue;
                    }
                    if (type.getRenderPriority() <= typeAdj.getRenderPriority()) continue;
                    RenderUtils.drawBlockBoxSideBatchedQuads(pos, side, this.overlayColor, 0.0, bufferOverlayQuads);
                }
                posMutable.close();
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_SIDES.getBooleanValue()) {
                bakedModel = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelQuadOverlayBatched(bakedModel, stateSchematic, pos, this.overlayColor, 0.0, bufferOverlayQuads);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxSidesBatchedQuads((el)pos, (Color4f)this.overlayColor, (double)0.0, (ctq)bufferOverlayQuads);
            }
        }
        if (Configs.Visuals.SCHEMATIC_OVERLAY_ENABLE_OUTLINES.getBooleanValue()) {
            ctq bufferOverlayOutlines = buffers.getOverlayBuffer(OverlayRenderType.OUTLINE);
            if (!data.isOverlayTypeStarted(OverlayRenderType.OUTLINE)) {
                data.setOverlayTypeStarted(OverlayRenderType.OUTLINE);
                this.preRenderOverlay(bufferOverlayOutlines, OverlayRenderType.OUTLINE);
            }
            this.overlayColor = new Color4f(this.overlayColor.r, this.overlayColor.g, this.overlayColor.b, 1.0f);
            if (Configs.Visuals.OVERLAY_REDUCED_INNER_SIDES.getBooleanValue()) {
                OverlayType[][][] adjTypes = new OverlayType[3][3][3];
                el.b posMutable = el.b.r();
                for (int y = 0; y <= 2; ++y) {
                    for (int z = 0; z <= 2; ++z) {
                        for (int x = 0; x <= 2; ++x) {
                            if (x != 1 || y != 1 || z != 1) {
                                posMutable.f(pos.o() + x - 1, pos.p() + y - 1, pos.q() + z - 1);
                                blc adjStateSchematic = this.schematicWorldView.a_((el)posMutable);
                                blc adjStateClient = this.clientWorldView.a_((el)posMutable);
                                adjTypes[x][y][z] = this.getOverlayType(adjStateSchematic, adjStateClient);
                                continue;
                            }
                            adjTypes[x][y][z] = type;
                        }
                    }
                }
                posMutable.close();
                if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                    dez bakedModel3 = this.worldRenderer.getModelForState(stateSchematic);
                    if (stateSchematic.g()) {
                        this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                    } else {
                        RenderUtils.drawBlockModelOutlinesBatched(bakedModel3, stateSchematic, pos, this.overlayColor, 0.0, bufferOverlayOutlines);
                    }
                } else {
                    this.renderOverlayReducedEdges(pos, adjTypes, type, bufferOverlayOutlines);
                }
            } else if (missing && Configs.Visuals.SCHEMATIC_OVERLAY_MODEL_OUTLINE.getBooleanValue()) {
                bakedModel = this.worldRenderer.getModelForState(stateSchematic);
                RenderUtils.drawBlockModelOutlinesBatched(bakedModel, stateSchematic, pos, this.overlayColor, 0.0, bufferOverlayOutlines);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((el)pos, (Color4f)this.overlayColor, (double)0.0, (ctq)bufferOverlayOutlines);
            }
        }
    }

    protected void renderOverlayReducedEdges(el pos, OverlayType[][][] adjTypes, OverlayType typeSelf, ctq bufferOverlayOutlines) {
        OverlayType[] neighborTypes = new OverlayType[4];
        ff[] neighborPositions = new ff[4];
        int lines = 0;
        for (eq.a axis : PositionUtils.AXES_ALL) {
            for (int corner = 0; corner < 4; ++corner) {
                ff[] offsets = PositionUtils.getEdgeNeighborOffsets(axis, corner);
                int index = -1;
                boolean hasCurrent = false;
                for (int i = 0; i < 4; ++i) {
                    ff offset = offsets[i];
                    OverlayType type = adjTypes[offset.o() + 1][offset.p() + 1][offset.q() + 1];
                    if (type == OverlayType.NONE || index != -1 && type.getRenderPriority() < neighborTypes[index - 1].getRenderPriority()) continue;
                    if (index < 0 || type.getRenderPriority() > neighborTypes[index - 1].getRenderPriority()) {
                        index = 0;
                    }
                    neighborPositions[index] = new ff(pos.o() + offset.o(), pos.p() + offset.p(), pos.q() + offset.q());
                    neighborTypes[index] = type;
                    hasCurrent |= i == 0;
                    ++index;
                }
                if (index <= 0 || !hasCurrent) continue;
                ff posTmp = new ff(pos.o(), pos.p(), pos.q());
                int ind = -1;
                for (int i = 0; i < index; ++i) {
                    ff tmp = neighborPositions[i];
                    if (tmp.o() > posTmp.o() || tmp.p() > posTmp.p() || tmp.q() > posTmp.q()) continue;
                    posTmp = tmp;
                    ind = i;
                }
                if (posTmp.o() != pos.o() || posTmp.p() != pos.p() || posTmp.q() != pos.q()) continue;
                RenderUtils.drawBlockBoxEdgeBatchedLines(pos, axis, corner, this.overlayColor, bufferOverlayOutlines);
                ++lines;
            }
        }
    }

    protected OverlayType getOverlayType(blc stateSchematic, blc stateClient) {
        if (stateSchematic == stateClient) {
            return OverlayType.NONE;
        }
        boolean clientHasAir = stateClient.f();
        boolean schematicHasAir = stateSchematic.f();
        if (schematicHasAir) {
            return clientHasAir ? OverlayType.NONE : OverlayType.EXTRA;
        }
        if (clientHasAir) {
            return OverlayType.MISSING;
        }
        if (stateSchematic.c() != stateClient.c()) {
            return OverlayType.WRONG_BLOCK;
        }
        return OverlayType.WRONG_STATE;
    }

    @Nullable
    protected Color4f getOverlayColor(OverlayType overlayType) {
        Color4f overlayColor = null;
        switch (overlayType) {
            case MISSING: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_MISSING.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_MISSING.getColor();
                break;
            }
            case EXTRA: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_EXTRA.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_EXTRA.getColor();
                break;
            }
            case WRONG_BLOCK: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_BLOCK.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_BLOCK.getColor();
                break;
            }
            case WRONG_STATE: {
                if (!Configs.Visuals.SCHEMATIC_OVERLAY_TYPE_WRONG_STATE.getBooleanValue()) break;
                overlayColor = Configs.Colors.SCHEMATIC_OVERLAY_COLOR_WRONG_STATE.getColor();
                break;
            }
        }
        return overlayColor;
    }

    private void addTileEntity(el pos, cwr compiledChunk, Set<bji> tileEntities) {
        cwb tesr;
        bji te = this.schematicWorldView.getTileEntity(pos, bnj.a.c);
        if (te != null && (tesr = cwa.a.a(te)) != null) {
            compiledChunk.a(te);
            if (tesr.a(te)) {
                tileEntities.add(te);
            }
        }
    }

    private void preRenderBlocks(ctq buffer, el pos) {
        buffer.a(7, ddu.g);
        buffer.c((double)(-pos.o()), (double)(-pos.p()), (double)(-pos.q()));
    }

    private void postRenderBlocks(axl layer, float x, float y, float z, ctq buffer, CompiledChunkSchematic compiledChunk) {
        if (layer == axl.d && !compiledChunk.b(layer)) {
            buffer.a(x, y, z);
            compiledChunk.setBlockBufferState(layer, buffer.a());
        }
        buffer.e();
    }

    private void preRenderOverlay(ctq buffer, OverlayRenderType type) {
        this.existingOverlays.add(type);
        this.hasOverlay = true;
        el pos = this.k();
        buffer.a(type.getGlMode(), ddu.l);
        buffer.c((double)(-pos.o()), (double)(-pos.p()), (double)(-pos.q()));
    }

    private void preRenderOverlay(ctq buffer, int glMode) {
        el pos = this.k();
        buffer.a(glMode, ddu.l);
        buffer.c((double)(-pos.o()), (double)(-pos.p()), (double)(-pos.q()));
    }

    private void postRenderOverlay(OverlayRenderType type, float x, float y, float z, ctq buffer, CompiledChunkSchematic compiledChunk) {
        if (type == OverlayRenderType.QUAD && !compiledChunk.isOverlayTypeEmpty(type)) {
            buffer.a(x, y, z);
            compiledChunk.setOverlayBufferState(type, buffer.a());
        }
        buffer.e();
    }

    public ChunkRenderTaskSchematic makeCompileTaskChunkSchematic() {
        this.c().lock();
        ChunkRenderTaskSchematic generator = null;
        try {
            this.b();
            this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.REBUILD_CHUNK, this.f());
            this.rebuildWorldView();
            generator = this.compileTask;
        }
        finally {
            this.c().unlock();
        }
        return generator;
    }

    @Nullable
    public ChunkRenderTaskSchematic makeCompileTaskTransparencySchematic() {
        this.c().lock();
        try {
            if (this.compileTask == null || this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                    this.compileTask.finish();
                }
                this.compileTask = new ChunkRenderTaskSchematic(this, ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY, this.f());
                this.compileTask.setCompiledChunk(this.schematicChunkRenderData);
                ChunkRenderTaskSchematic chunkRenderTaskSchematic = this.compileTask;
                return chunkRenderTaskSchematic;
            }
        }
        finally {
            this.c().unlock();
        }
        return null;
    }

    protected void b() {
        this.c().lock();
        try {
            if (this.compileTask != null && this.compileTask.getStatus() != ChunkRenderTaskSchematic.Status.DONE) {
                this.compileTask.finish();
                this.compileTask = null;
            }
        }
        finally {
            this.c().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildWorldView() {
        List<IntBoundingBox> list = this.boxes;
        synchronized (list) {
            this.schematicWorldView = new ChunkCacheSchematic(this.o(), this.k(), 2);
            this.clientWorldView = new ChunkCacheSchematic((axy)cft.s().g, this.k(), 2);
            el pos = this.k();
            SubChunkPos subChunk = new SubChunkPos(pos.o() >> 4, pos.p() >> 4, pos.q() >> 4);
            this.boxes.clear();
            this.boxes.addAll(DataManager.getSchematicPlacementManager().getTouchedBoxesInSubChunk(subChunk));
        }
    }

    public static enum OverlayRenderType {
        OUTLINE(1),
        QUAD(7);

        private final int glMode;

        private OverlayRenderType(int glMode) {
            this.glMode = glMode;
        }

        public int getGlMode() {
            return this.glMode;
        }
    }
}

