/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.render.schematic.BufferBuilderCache;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderTaskSchematic;
import fi.dy.masa.litematica.render.schematic.CompiledChunkSchematic;
import fi.dy.masa.litematica.render.schematic.RenderChunkSchematicVbo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Logger;

public class ChunkRenderWorkerLitematica
implements Runnable {
    private static final Logger LOGGER = Litematica.logger;
    private final ChunkRenderDispatcherLitematica chunkRenderDispatcher;
    private final BufferBuilderCache bufferCache;
    private boolean shouldRun = true;

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn) {
        this(chunkRenderDispatcherIn, null);
    }

    public ChunkRenderWorkerLitematica(ChunkRenderDispatcherLitematica chunkRenderDispatcherIn, @Nullable BufferBuilderCache bufferCache) {
        this.chunkRenderDispatcher = chunkRenderDispatcherIn;
        this.bufferCache = bufferCache;
    }

    @Override
    public void run() {
        while (this.shouldRun) {
            try {
                this.processTask(this.chunkRenderDispatcher.getNextChunkUpdate());
            }
            catch (InterruptedException e) {
                LOGGER.debug("Stopping chunk worker due to interrupt");
                return;
            }
            catch (Throwable throwable) {
                b crashreport = b.a((Throwable)throwable, (String)"Batching chunks");
                cft.s().a(cft.s().b(crashreport));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processTask(final ChunkRenderTaskSchematic generator) throws InterruptedException {
        generator.getLock().lock();
        try {
            if (generator.getStatus() != ChunkRenderTaskSchematic.Status.PENDING) {
                if (!generator.isFinished()) {
                    LOGGER.warn("Chunk render task was {} when I expected it to be pending; ignoring task", (Object)generator.getStatus());
                }
                return;
            }
            generator.setStatus(ChunkRenderTaskSchematic.Status.COMPILING);
        }
        finally {
            generator.getLock().unlock();
        }
        aer entity = cft.s().S();
        if (entity == null) {
            generator.finish();
        } else {
            generator.setRegionRenderCacheBuilder(this.getRegionRenderCacheBuilder());
            ChunkRenderTaskSchematic.Type generatorType = generator.getType();
            float x = (float)entity.q;
            float y = (float)entity.r + entity.bF();
            float z = (float)entity.s;
            if (generatorType == ChunkRenderTaskSchematic.Type.REBUILD_CHUNK) {
                generator.getRenderChunk().rebuildChunk(x, y, z, generator);
            } else if (generatorType == ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY) {
                generator.getRenderChunk().resortTransparency(x, y, z, generator);
            }
            generator.getLock().lock();
            try {
                if (generator.getStatus() != ChunkRenderTaskSchematic.Status.COMPILING) {
                    if (!generator.isFinished()) {
                        LOGGER.warn("Chunk render task was {} when I expected it to be compiling; aborting task", (Object)generator.getStatus());
                    }
                    this.freeRenderBuilder(generator);
                    return;
                }
                generator.setStatus(ChunkRenderTaskSchematic.Status.UPLOADING);
            }
            finally {
                generator.getLock().unlock();
            }
            final CompiledChunkSchematic compiledChunk = generator.getCompiledChunk();
            ArrayList futuresList = Lists.newArrayList();
            BufferBuilderCache buffers = generator.getBufferCache();
            RenderChunkSchematicVbo renderChunk = generator.getRenderChunk();
            if (generatorType == ChunkRenderTaskSchematic.Type.REBUILD_CHUNK) {
                ctq buffer;
                for (axl axl2 : axl.values()) {
                    if (compiledChunk.b(axl2)) continue;
                    buffer = buffers.getWorldRendererByLayer(axl2);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(axl2, buffer, renderChunk, compiledChunk, generator.getDistanceSq()));
                }
                for (RenderChunkSchematicVbo.OverlayRenderType overlayRenderType : RenderChunkSchematicVbo.OverlayRenderType.values()) {
                    if (compiledChunk.isOverlayTypeEmpty(overlayRenderType)) continue;
                    buffer = buffers.getOverlayBuffer(overlayRenderType);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(overlayRenderType, buffer, renderChunk, compiledChunk, generator.getDistanceSq()));
                }
            } else if (generatorType == ChunkRenderTaskSchematic.Type.RESORT_TRANSPARENCY) {
                ctq ctq2 = buffers.getWorldRendererByLayer(axl.d);
                futuresList.add(this.chunkRenderDispatcher.uploadChunkBlocks(axl.d, ctq2, renderChunk, compiledChunk, generator.getDistanceSq()));
                if (!compiledChunk.isOverlayTypeEmpty(RenderChunkSchematicVbo.OverlayRenderType.QUAD)) {
                    ctq ctq3 = buffers.getOverlayBuffer(RenderChunkSchematicVbo.OverlayRenderType.QUAD);
                    futuresList.add(this.chunkRenderDispatcher.uploadChunkOverlay(RenderChunkSchematicVbo.OverlayRenderType.QUAD, ctq3, renderChunk, compiledChunk, generator.getDistanceSq()));
                }
            }
            final ListenableFuture listenableFuture = Futures.allAsList((Iterable)futuresList);
            generator.addFinishRunnable(new Runnable(){

                @Override
                public void run() {
                    listenableFuture.cancel(false);
                }
            });
            Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<List<Object>>(){

                public void onSuccess(@Nullable List<Object> list) {
                    block6: {
                        ChunkRenderWorkerLitematica.this.freeRenderBuilder(generator);
                        generator.getLock().lock();
                        try {
                            if (generator.getStatus() == ChunkRenderTaskSchematic.Status.UPLOADING) {
                                generator.setStatus(ChunkRenderTaskSchematic.Status.DONE);
                                break block6;
                            }
                            if (!generator.isFinished()) {
                                LOGGER.warn("Chunk render task was {} when I expected it to be uploading; aborting task", (Object)generator.getStatus());
                            }
                        }
                        finally {
                            generator.getLock().unlock();
                        }
                        return;
                    }
                    generator.getRenderChunk().setChunkRenderData(compiledChunk);
                }

                public void onFailure(Throwable throwable) {
                    ChunkRenderWorkerLitematica.this.freeRenderBuilder(generator);
                    if (!(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                        cft.s().a(b.a((Throwable)throwable, (String)"Rendering Litematica chunk"));
                    }
                }
            });
        }
    }

    private BufferBuilderCache getRegionRenderCacheBuilder() throws InterruptedException {
        return this.bufferCache != null ? this.bufferCache : this.chunkRenderDispatcher.allocateRenderBuilder();
    }

    private void freeRenderBuilder(ChunkRenderTaskSchematic generator) {
        if (this.bufferCache == null) {
            this.chunkRenderDispatcher.freeRenderBuilder(generator.getBufferCache());
        }
    }

    public void notifyToStop() {
        this.shouldRun = false;
    }
}

