/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;

public class BlockModelRendererSchematic
extends cuw {
    private final cgf blockColors;
    private final Random random = new Random();

    public BlockModelRendererSchematic(cgf blockColorsIn) {
        super(blockColorsIn);
        this.blockColors = blockColorsIn;
    }

    public boolean renderModel(aye worldIn, dez modelIn, blc stateIn, el posIn, ctq buffer, long rand) {
        boolean ao = cft.r() && stateIn.e() == 0 && modelIn.a();
        try {
            if (ao) {
                return this.renderModelSmooth(worldIn, modelIn, stateIn, posIn, buffer, this.random, rand);
            }
            return this.renderModelFlat(worldIn, modelIn, stateIn, posIn, buffer, this.random, rand);
        }
        catch (Throwable throwable) {
            b crashreport = b.a((Throwable)throwable, (String)"Tesselating block model");
            c crashreportcategory = crashreport.a("Block model being tesselated");
            c.a((c)crashreportcategory, (el)posIn, (blc)stateIn);
            crashreportcategory.a("Using AO", (Object)ao);
            throw new h(crashreport);
        }
    }

    public boolean renderModelSmooth(aye worldIn, dez modelIn, blc stateIn, el posIn, ctq buffer, Random random, long seedIn) {
        boolean renderedSomething = false;
        float[] quadBounds = new float[eq.values().length * 2];
        BitSet bitset = new BitSet(3);
        AmbientOcclusionFace aoFace = new AmbientOcclusionFace();
        for (eq side : eq.values()) {
            random.setSeed(seedIn);
            List quads = modelIn.a(stateIn, side, random);
            if (quads.isEmpty() || !this.shouldRenderModelSide(worldIn, stateIn, posIn, side)) continue;
            this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, quads, quadBounds, bitset, aoFace);
            renderedSomething = true;
        }
        random.setSeed(seedIn);
        List quads = modelIn.a(stateIn, (eq)null, random);
        if (!quads.isEmpty()) {
            this.renderQuadsSmooth(worldIn, stateIn, posIn, buffer, quads, quadBounds, bitset, aoFace);
            renderedSomething = true;
        }
        return renderedSomething;
    }

    public boolean renderModelFlat(aye worldIn, dez modelIn, blc stateIn, el posIn, ctq buffer, Random random, long seedIn) {
        boolean renderedSomething = false;
        BitSet bitset = new BitSet(3);
        for (eq side : eq.values()) {
            random.setSeed(seedIn);
            List quads = modelIn.a(stateIn, side, random);
            if (quads.isEmpty() || !this.shouldRenderModelSide(worldIn, stateIn, posIn, side)) continue;
            int lightMapCoords = stateIn.a(worldIn, posIn.a(side));
            this.renderQuadsFlat(worldIn, stateIn, posIn, lightMapCoords, false, buffer, quads, bitset);
            renderedSomething = true;
        }
        random.setSeed(seedIn);
        List quads = modelIn.a(stateIn, null, random);
        if (!quads.isEmpty()) {
            this.renderQuadsFlat(worldIn, stateIn, posIn, -1, true, buffer, quads, bitset);
            renderedSomething = true;
        }
        return renderedSomething;
    }

    private boolean shouldRenderModelSide(aye worldIn, blc stateIn, el posIn, eq side) {
        return DataManager.getRenderLayerRange().isPositionAtRenderEdgeOnSide(posIn, side) || Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue() && Configs.Visuals.RENDER_TRANSLUCENT_INNER_SIDES.getBooleanValue() || bcs.c((blc)stateIn, (axk)worldIn, (el)posIn, (eq)side);
    }

    private void renderQuadsSmooth(aye world, blc stateIn, el posIn, ctq buffer, List<cux> list, float[] quadBounds, BitSet bitSet, AmbientOcclusionFace aoFace) {
        cee vec3d = stateIn.k((axk)world, posIn);
        double x = (double)posIn.o() + vec3d.b;
        double y = (double)posIn.p() + vec3d.c;
        double z = (double)posIn.q() + vec3d.d;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            cux bakedquad = list.get(i);
            this.fillQuadBounds(stateIn, bakedquad.b(), bakedquad.e(), quadBounds, bitSet);
            aoFace.updateVertexBrightness(world, stateIn, posIn, bakedquad.e(), quadBounds, bitSet);
            buffer.a(bakedquad.b());
            buffer.a(aoFace.vertexBrightness[0], aoFace.vertexBrightness[1], aoFace.vertexBrightness[2], aoFace.vertexBrightness[3]);
            if (bakedquad.c()) {
                int k = this.blockColors.a(stateIn, (ayc)world, posIn, bakedquad.d());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                buffer.a(aoFace.vertexColorMultiplier[0] * f, aoFace.vertexColorMultiplier[0] * f1, aoFace.vertexColorMultiplier[0] * f2, 4);
                buffer.a(aoFace.vertexColorMultiplier[1] * f, aoFace.vertexColorMultiplier[1] * f1, aoFace.vertexColorMultiplier[1] * f2, 3);
                buffer.a(aoFace.vertexColorMultiplier[2] * f, aoFace.vertexColorMultiplier[2] * f1, aoFace.vertexColorMultiplier[2] * f2, 2);
                buffer.a(aoFace.vertexColorMultiplier[3] * f, aoFace.vertexColorMultiplier[3] * f1, aoFace.vertexColorMultiplier[3] * f2, 1);
            } else {
                buffer.a(aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], aoFace.vertexColorMultiplier[0], 4);
                buffer.a(aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], aoFace.vertexColorMultiplier[1], 3);
                buffer.a(aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], aoFace.vertexColorMultiplier[2], 2);
                buffer.a(aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], aoFace.vertexColorMultiplier[3], 1);
            }
            buffer.a(x, y, z);
        }
    }

    private void renderQuadsFlat(aye world, blc stateIn, el posIn, int brightnessIn, boolean ownBrightness, ctq buffer, List<cux> list, BitSet bitSet) {
        cee vec3d = stateIn.k((axk)world, posIn);
        double d0 = (double)posIn.o() + vec3d.b;
        double d1 = (double)posIn.p() + vec3d.c;
        double d2 = (double)posIn.q() + vec3d.d;
        int j = list.size();
        for (int i = 0; i < j; ++i) {
            cux bakedquad = list.get(i);
            if (ownBrightness) {
                this.fillQuadBounds(stateIn, bakedquad.b(), bakedquad.e(), null, bitSet);
                el blockpos = bitSet.get(0) ? posIn.a(bakedquad.e()) : posIn;
                brightnessIn = stateIn.a(world, blockpos);
            }
            buffer.a(bakedquad.b());
            buffer.a(brightnessIn, brightnessIn, brightnessIn, brightnessIn);
            if (bakedquad.c()) {
                int k = this.blockColors.a(stateIn, (ayc)world, posIn, bakedquad.d());
                float f = (float)(k >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(k & 0xFF) / 255.0f;
                buffer.a(f, f1, f2, 4);
                buffer.a(f, f1, f2, 3);
                buffer.a(f, f1, f2, 2);
                buffer.a(f, f1, f2, 1);
            }
            buffer.a(d0, d1, d2);
        }
    }

    private void fillQuadBounds(blc stateIn, int[] vertexData, eq face, @Nullable float[] quadBounds, BitSet boundsFlags) {
        float f = 32.0f;
        float f1 = 32.0f;
        float f2 = 32.0f;
        float f3 = -32.0f;
        float f4 = -32.0f;
        float f5 = -32.0f;
        for (int i = 0; i < 4; ++i) {
            float f6 = Float.intBitsToFloat(vertexData[i * 7]);
            float f7 = Float.intBitsToFloat(vertexData[i * 7 + 1]);
            float f8 = Float.intBitsToFloat(vertexData[i * 7 + 2]);
            f = Math.min(f, f6);
            f1 = Math.min(f1, f7);
            f2 = Math.min(f2, f8);
            f3 = Math.max(f3, f6);
            f4 = Math.max(f4, f7);
            f5 = Math.max(f5, f8);
        }
        if (quadBounds != null) {
            quadBounds[eq.e.a()] = f;
            quadBounds[eq.f.a()] = f3;
            quadBounds[eq.a.a()] = f1;
            quadBounds[eq.b.a()] = f4;
            quadBounds[eq.c.a()] = f2;
            quadBounds[eq.d.a()] = f5;
            int j = eq.values().length;
            quadBounds[eq.e.a() + j] = 1.0f - f;
            quadBounds[eq.f.a() + j] = 1.0f - f3;
            quadBounds[eq.a.a() + j] = 1.0f - f1;
            quadBounds[eq.b.a() + j] = 1.0f - f4;
            quadBounds[eq.c.a() + j] = 1.0f - f2;
            quadBounds[eq.d.a() + j] = 1.0f - f5;
        }
        switch (face) {
            case a: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f1 < 1.0E-4f || stateIn.g()) && f1 == f4);
                break;
            }
            case b: {
                boundsFlags.set(1, f >= 1.0E-4f || f2 >= 1.0E-4f || f3 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f4 > 0.9999f || stateIn.g()) && f1 == f4);
                break;
            }
            case c: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f2 < 1.0E-4f || stateIn.g()) && f2 == f5);
                break;
            }
            case d: {
                boundsFlags.set(1, f >= 1.0E-4f || f1 >= 1.0E-4f || f3 <= 0.9999f || f4 <= 0.9999f);
                boundsFlags.set(0, (f5 > 0.9999f || stateIn.g()) && f2 == f5);
                break;
            }
            case e: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f < 1.0E-4f || stateIn.g()) && f == f3);
                break;
            }
            case f: {
                boundsFlags.set(1, f1 >= 1.0E-4f || f2 >= 1.0E-4f || f4 <= 0.9999f || f5 <= 0.9999f);
                boundsFlags.set(0, (f3 > 0.9999f || stateIn.g()) && f == f3);
            }
        }
    }

    static enum VertexTranslations {
        DOWN(0, 1, 2, 3),
        UP(2, 3, 0, 1),
        NORTH(3, 0, 1, 2),
        SOUTH(0, 1, 2, 3),
        WEST(3, 0, 1, 2),
        EAST(1, 2, 3, 0);

        private final int vert0;
        private final int vert1;
        private final int vert2;
        private final int vert3;
        private static final VertexTranslations[] VALUES;

        private VertexTranslations(int p_i46234_3_, int p_i46234_4_, int p_i46234_5_, int p_i46234_6_) {
            this.vert0 = p_i46234_3_;
            this.vert1 = p_i46234_4_;
            this.vert2 = p_i46234_5_;
            this.vert3 = p_i46234_6_;
        }

        public static VertexTranslations getVertexTranslations(eq p_178184_0_) {
            return VALUES[p_178184_0_.a()];
        }

        static {
            VALUES = new VertexTranslations[6];
            VertexTranslations.VALUES[eq.a.a()] = DOWN;
            VertexTranslations.VALUES[eq.b.a()] = UP;
            VertexTranslations.VALUES[eq.c.a()] = NORTH;
            VertexTranslations.VALUES[eq.d.a()] = SOUTH;
            VertexTranslations.VALUES[eq.e.a()] = WEST;
            VertexTranslations.VALUES[eq.f.a()] = EAST;
        }
    }

    public static enum Orientation {
        DOWN(eq.a, false),
        UP(eq.b, false),
        NORTH(eq.c, false),
        SOUTH(eq.d, false),
        WEST(eq.e, false),
        EAST(eq.f, false),
        FLIP_DOWN(eq.a, true),
        FLIP_UP(eq.b, true),
        FLIP_NORTH(eq.c, true),
        FLIP_SOUTH(eq.d, true),
        FLIP_WEST(eq.e, true),
        FLIP_EAST(eq.f, true);

        private final int shape;

        private Orientation(eq p_i46233_3_, boolean p_i46233_4_) {
            this.shape = p_i46233_3_.a() + (p_i46233_4_ ? eq.values().length : 0);
        }
    }

    public static enum EnumNeighborInfo {
        DOWN(new eq[]{eq.e, eq.f, eq.c, eq.d}, 0.5f, true, new Orientation[]{Orientation.FLIP_WEST, Orientation.SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.WEST, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_WEST, Orientation.NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.WEST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.EAST, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_EAST, Orientation.SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.EAST, Orientation.SOUTH}),
        UP(new eq[]{eq.f, eq.e, eq.c, eq.d}, 1.0f, true, new Orientation[]{Orientation.EAST, Orientation.SOUTH, Orientation.EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.FLIP_SOUTH, Orientation.FLIP_EAST, Orientation.SOUTH}, new Orientation[]{Orientation.EAST, Orientation.NORTH, Orientation.EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.FLIP_NORTH, Orientation.FLIP_EAST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.NORTH, Orientation.WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.FLIP_NORTH, Orientation.FLIP_WEST, Orientation.NORTH}, new Orientation[]{Orientation.WEST, Orientation.SOUTH, Orientation.WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.FLIP_SOUTH, Orientation.FLIP_WEST, Orientation.SOUTH}),
        NORTH(new eq[]{eq.b, eq.a, eq.f, eq.e}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST}),
        SOUTH(new eq[]{eq.e, eq.f, eq.a, eq.b}, 0.8f, true, new Orientation[]{Orientation.UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.FLIP_WEST, Orientation.FLIP_UP, Orientation.WEST, Orientation.UP, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.FLIP_WEST, Orientation.FLIP_DOWN, Orientation.WEST, Orientation.DOWN, Orientation.WEST}, new Orientation[]{Orientation.DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.FLIP_EAST, Orientation.FLIP_DOWN, Orientation.EAST, Orientation.DOWN, Orientation.EAST}, new Orientation[]{Orientation.UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.FLIP_EAST, Orientation.FLIP_UP, Orientation.EAST, Orientation.UP, Orientation.EAST}),
        WEST(new eq[]{eq.b, eq.a, eq.c, eq.d}, 0.6f, true, new Orientation[]{Orientation.UP, Orientation.SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.FLIP_UP, Orientation.SOUTH}, new Orientation[]{Orientation.UP, Orientation.NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.FLIP_UP, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.FLIP_DOWN, Orientation.NORTH}, new Orientation[]{Orientation.DOWN, Orientation.SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.FLIP_DOWN, Orientation.SOUTH}),
        EAST(new eq[]{eq.a, eq.b, eq.c, eq.d}, 0.6f, true, new Orientation[]{Orientation.FLIP_DOWN, Orientation.SOUTH, Orientation.FLIP_DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.FLIP_SOUTH, Orientation.DOWN, Orientation.SOUTH}, new Orientation[]{Orientation.FLIP_DOWN, Orientation.NORTH, Orientation.FLIP_DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.FLIP_NORTH, Orientation.DOWN, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.NORTH, Orientation.FLIP_UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.FLIP_NORTH, Orientation.UP, Orientation.NORTH}, new Orientation[]{Orientation.FLIP_UP, Orientation.SOUTH, Orientation.FLIP_UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.FLIP_SOUTH, Orientation.UP, Orientation.SOUTH});

        private final boolean doNonCubicWeight;
        private final Orientation[] vert0Weights;
        private final Orientation[] vert1Weights;
        private final Orientation[] vert2Weights;
        private final Orientation[] vert3Weights;
        private static final EnumNeighborInfo[] VALUES;

        private EnumNeighborInfo(eq[] p_i46236_3_, float p_i46236_4_, boolean p_i46236_5_, Orientation[] p_i46236_6_, Orientation[] p_i46236_7_, Orientation[] p_i46236_8_, Orientation[] p_i46236_9_) {
            this.doNonCubicWeight = p_i46236_5_;
            this.vert0Weights = p_i46236_6_;
            this.vert1Weights = p_i46236_7_;
            this.vert2Weights = p_i46236_8_;
            this.vert3Weights = p_i46236_9_;
        }

        public static EnumNeighborInfo getNeighbourInfo(eq p_178273_0_) {
            return VALUES[p_178273_0_.a()];
        }

        static {
            VALUES = new EnumNeighborInfo[6];
            EnumNeighborInfo.VALUES[eq.a.a()] = DOWN;
            EnumNeighborInfo.VALUES[eq.b.a()] = UP;
            EnumNeighborInfo.VALUES[eq.c.a()] = NORTH;
            EnumNeighborInfo.VALUES[eq.d.a()] = SOUTH;
            EnumNeighborInfo.VALUES[eq.e.a()] = WEST;
            EnumNeighborInfo.VALUES[eq.f.a()] = EAST;
        }
    }

    class AmbientOcclusionFace {
        private final float[] vertexColorMultiplier = new float[4];
        private final int[] vertexBrightness = new int[4];

        AmbientOcclusionFace() {
        }

        public void updateVertexBrightness(aye worldIn, blc state, el centerPos, eq direction, float[] faceShape, BitSet shapeState) {
            EnumNeighborInfo neighborInfo = EnumNeighborInfo.getNeighbourInfo(direction);
            VertexTranslations vertexTranslations = VertexTranslations.getVertexTranslations(direction);
            float f8 = 1.0f;
            float f7 = 1.0f;
            float f6 = 1.0f;
            float f5 = 1.0f;
            float f4 = 1.0f;
            float f3 = 1.0f;
            float f2 = 1.0f;
            float f1 = 1.0f;
            float f = 1.0f;
            int l1 = 0xF000F0;
            int k1 = 0xF000F0;
            int j1 = 0xF000F0;
            int i3 = 0xF000F0;
            int i1 = 0xF000F0;
            int l = 0xF000F0;
            int k = 0xF000F0;
            int j = 0xF000F0;
            int i = 0xF000F0;
            if (shapeState.get(1) && neighborInfo.doNonCubicWeight) {
                float f29 = (f3 + f + f5 + f8) * 0.25f;
                float f30 = (f2 + f + f4 + f8) * 0.25f;
                float f31 = (f2 + f1 + f6 + f8) * 0.25f;
                float f32 = (f3 + f1 + f7 + f8) * 0.25f;
                float f13 = faceShape[neighborInfo.vert0Weights[0].shape] * faceShape[neighborInfo.vert0Weights[1].shape];
                float f14 = faceShape[neighborInfo.vert0Weights[2].shape] * faceShape[neighborInfo.vert0Weights[3].shape];
                float f15 = faceShape[neighborInfo.vert0Weights[4].shape] * faceShape[neighborInfo.vert0Weights[5].shape];
                float f16 = faceShape[neighborInfo.vert0Weights[6].shape] * faceShape[neighborInfo.vert0Weights[7].shape];
                float f17 = faceShape[neighborInfo.vert1Weights[0].shape] * faceShape[neighborInfo.vert1Weights[1].shape];
                float f18 = faceShape[neighborInfo.vert1Weights[2].shape] * faceShape[neighborInfo.vert1Weights[3].shape];
                float f19 = faceShape[neighborInfo.vert1Weights[4].shape] * faceShape[neighborInfo.vert1Weights[5].shape];
                float f20 = faceShape[neighborInfo.vert1Weights[6].shape] * faceShape[neighborInfo.vert1Weights[7].shape];
                float f21 = faceShape[neighborInfo.vert2Weights[0].shape] * faceShape[neighborInfo.vert2Weights[1].shape];
                float f22 = faceShape[neighborInfo.vert2Weights[2].shape] * faceShape[neighborInfo.vert2Weights[3].shape];
                float f23 = faceShape[neighborInfo.vert2Weights[4].shape] * faceShape[neighborInfo.vert2Weights[5].shape];
                float f24 = faceShape[neighborInfo.vert2Weights[6].shape] * faceShape[neighborInfo.vert2Weights[7].shape];
                float f25 = faceShape[neighborInfo.vert3Weights[0].shape] * faceShape[neighborInfo.vert3Weights[1].shape];
                float f26 = faceShape[neighborInfo.vert3Weights[2].shape] * faceShape[neighborInfo.vert3Weights[3].shape];
                float f27 = faceShape[neighborInfo.vert3Weights[4].shape] * faceShape[neighborInfo.vert3Weights[5].shape];
                float f28 = faceShape[neighborInfo.vert3Weights[6].shape] * faceShape[neighborInfo.vert3Weights[7].shape];
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert0] = f29 * f13 + f30 * f14 + f31 * f15 + f32 * f16;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert1] = f29 * f17 + f30 * f18 + f31 * f19 + f32 * f20;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert2] = f29 * f21 + f30 * f22 + f31 * f23 + f32 * f24;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert3] = f29 * f25 + f30 * f26 + f31 * f27 + f32 * f28;
                int i2 = this.getAoBrightness(l, i, j1, i3);
                int j2 = this.getAoBrightness(k, i, i1, i3);
                int k2 = this.getAoBrightness(k, j, k1, i3);
                int l2 = this.getAoBrightness(l, j, l1, i3);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert0] = this.getVertexBrightness(i2, j2, k2, l2, f13, f14, f15, f16);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert1] = this.getVertexBrightness(i2, j2, k2, l2, f17, f18, f19, f20);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert2] = this.getVertexBrightness(i2, j2, k2, l2, f21, f22, f23, f24);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert3] = this.getVertexBrightness(i2, j2, k2, l2, f25, f26, f27, f28);
            } else {
                float f9 = (f3 + f + f5 + f8) * 0.25f;
                float f10 = (f2 + f + f4 + f8) * 0.25f;
                float f11 = (f2 + f1 + f6 + f8) * 0.25f;
                float f12 = (f3 + f1 + f7 + f8) * 0.25f;
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert0] = this.getAoBrightness(l, i, j1, i3);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert1] = this.getAoBrightness(k, i, i1, i3);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert2] = this.getAoBrightness(k, j, k1, i3);
                this.vertexBrightness[((VertexTranslations)vertexTranslations).vert3] = this.getAoBrightness(l, j, l1, i3);
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert0] = f9;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert1] = f10;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert2] = f11;
                this.vertexColorMultiplier[((VertexTranslations)vertexTranslations).vert3] = f12;
            }
        }

        private int getAoBrightness(int br1, int br2, int br3, int br4) {
            if (br1 == 0) {
                br1 = br4;
            }
            if (br2 == 0) {
                br2 = br4;
            }
            if (br3 == 0) {
                br3 = br4;
            }
            return br1 + br2 + br3 + br4 >> 2 & 0xFF00FF;
        }

        private int getVertexBrightness(int p_178203_1_, int p_178203_2_, int p_178203_3_, int p_178203_4_, float p_178203_5_, float p_178203_6_, float p_178203_7_, float p_178203_8_) {
            int i = (int)((float)(p_178203_1_ >> 16 & 0xFF) * p_178203_5_ + (float)(p_178203_2_ >> 16 & 0xFF) * p_178203_6_ + (float)(p_178203_3_ >> 16 & 0xFF) * p_178203_7_ + (float)(p_178203_4_ >> 16 & 0xFF) * p_178203_8_) & 0xFF;
            int j = (int)((float)(p_178203_1_ & 0xFF) * p_178203_5_ + (float)(p_178203_2_ & 0xFF) * p_178203_6_ + (float)(p_178203_3_ & 0xFF) * p_178203_7_ + (float)(p_178203_4_ & 0xFF) * p_178203_8_) & 0xFF;
            return i << 16 | j;
        }
    }
}

