/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.util.BlockInfoAlignment;
import fi.dy.masa.litematica.util.InventoryUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.List;
import java.util.Random;

public class RenderUtils {
    private static final Random RAND = new Random();

    public static int getMaxStringRenderLength(List<String> list) {
        int length = 0;
        for (String str : list) {
            length = Math.max(length, StringUtils.getStringWidth((String)str));
        }
        return length;
    }

    public static void renderBlockOutline(el pos, float expand, float lineWidth, Color4f color, aer renderViewEntity, float partialTicks) {
        cua.d((float)lineWidth);
        cea aabb = RenderUtils.createAABB(pos.o(), pos.p(), pos.q(), expand, partialTicks, renderViewEntity);
        cue.a((cea)aabb, (float)color.r, (float)color.g, (float)color.b, (float)color.a);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(el pos, Color4f color, double expand, ctq buffer, aer renderViewEntity, float partialTicks) {
        double dx = renderViewEntity.N + (renderViewEntity.q - renderViewEntity.N) * (double)partialTicks;
        double dy = renderViewEntity.O + (renderViewEntity.r - renderViewEntity.O) * (double)partialTicks;
        double dz = renderViewEntity.P + (renderViewEntity.s - renderViewEntity.P) * (double)partialTicks;
        double minX = (double)pos.o() - dx - expand;
        double minY = (double)pos.p() - dy - expand;
        double minZ = (double)pos.q() - dz - expand;
        double maxX = (double)pos.o() - dx + expand + 1.0;
        double maxY = (double)pos.p() - dy + expand + 1.0;
        double maxZ = (double)pos.q() - dz + expand + 1.0;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (ctq)buffer);
    }

    public static void drawConnectingLineBatchedLines(el pos1, el pos2, boolean center, Color4f color, ctq buffer, aer renderViewEntity, float partialTicks) {
        double dx = renderViewEntity.N + (renderViewEntity.q - renderViewEntity.N) * (double)partialTicks;
        double dy = renderViewEntity.O + (renderViewEntity.r - renderViewEntity.O) * (double)partialTicks;
        double dz = renderViewEntity.P + (renderViewEntity.s - renderViewEntity.P) * (double)partialTicks;
        double x1 = (double)pos1.o() - dx;
        double y1 = (double)pos1.p() - dy;
        double z1 = (double)pos1.q() - dz;
        double x2 = (double)pos2.o() - dx;
        double y2 = (double)pos2.p() - dy;
        double z2 = (double)pos2.q() - dz;
        if (center) {
            x1 += 0.5;
            y1 += 0.5;
            z1 += 0.5;
            x2 += 0.5;
            y2 += 0.5;
            z2 += 0.5;
        }
        buffer.b(x1, y1, z1).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x2, y2, z2).a(color.r, color.g, color.b, color.a).d();
    }

    public static void renderBlockOutlineOverlapping(el pos, float expand, float lineWidth, Color4f color1, Color4f color2, Color4f color3, aer renderViewEntity, float partialTicks) {
        double dx = renderViewEntity.N + (renderViewEntity.q - renderViewEntity.N) * (double)partialTicks;
        double dy = renderViewEntity.O + (renderViewEntity.r - renderViewEntity.O) * (double)partialTicks;
        double dz = renderViewEntity.P + (renderViewEntity.s - renderViewEntity.P) * (double)partialTicks;
        double minX = (double)pos.o() - dx - (double)expand;
        double minY = (double)pos.p() - dy - (double)expand;
        double minZ = (double)pos.q() - dz - (double)expand;
        double maxX = (double)pos.o() - dx + (double)expand + 1.0;
        double maxY = (double)pos.p() - dy + (double)expand + 1.0;
        double maxZ = (double)pos.q() - dz + (double)expand + 1.0;
        cua.d((float)lineWidth);
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        buffer.a(1, ddu.l);
        buffer.b(minX, minY, minZ).a(color1.r, color1.g, color1.b, color1.a).d();
        buffer.b(maxX, minY, minZ).a(color1.r, color1.g, color1.b, color1.a).d();
        buffer.b(minX, minY, minZ).a(color1.r, color1.g, color1.b, color1.a).d();
        buffer.b(minX, maxY, minZ).a(color1.r, color1.g, color1.b, color1.a).d();
        buffer.b(minX, minY, minZ).a(color1.r, color1.g, color1.b, color1.a).d();
        buffer.b(minX, minY, maxZ).a(color1.r, color1.g, color1.b, color1.a).d();
        buffer.b(minX, maxY, maxZ).a(color2.r, color2.g, color2.b, color2.a).d();
        buffer.b(maxX, maxY, maxZ).a(color2.r, color2.g, color2.b, color2.a).d();
        buffer.b(maxX, minY, maxZ).a(color2.r, color2.g, color2.b, color2.a).d();
        buffer.b(maxX, maxY, maxZ).a(color2.r, color2.g, color2.b, color2.a).d();
        buffer.b(maxX, maxY, minZ).a(color2.r, color2.g, color2.b, color2.a).d();
        buffer.b(maxX, maxY, maxZ).a(color2.r, color2.g, color2.b, color2.a).d();
        buffer.b(minX, maxY, minZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(maxX, maxY, minZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(minX, minY, maxZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(maxX, minY, maxZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(maxX, minY, minZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(maxX, maxY, minZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(minX, minY, maxZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(minX, maxY, maxZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(maxX, minY, minZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(maxX, minY, maxZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(minX, maxY, minZ).a(color3.r, color3.g, color3.b, color3.a).d();
        buffer.b(minX, maxY, maxZ).a(color3.r, color3.g, color3.b, color3.a).d();
        tessellator.b();
    }

    public static void renderAreaOutline(el pos1, el pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, aer renderViewEntity, float partialTicks) {
        cua.d((float)lineWidth);
        cea aabb = RenderUtils.createEnclosingAABB(pos1, pos2, renderViewEntity, partialTicks);
        RenderUtils.drawBoundingBoxEdges(aabb, colorX, colorY, colorZ);
    }

    private static void drawBoundingBoxEdges(cea box, Color4f colorX, Color4f colorY, Color4f colorZ) {
        RenderUtils.drawBoundingBoxEdges(box.a, box.b, box.c, box.d, box.e, box.f, colorX, colorY, colorZ);
    }

    private static void drawBoundingBoxEdges(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f colorX, Color4f colorY, Color4f colorZ) {
        cum tessellator = cum.a();
        ctq bufferbuilder = tessellator.c();
        bufferbuilder.a(1, ddu.l);
        RenderUtils.drawBoundingBoxLinesX(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, colorX);
        RenderUtils.drawBoundingBoxLinesY(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, colorY);
        RenderUtils.drawBoundingBoxLinesZ(bufferbuilder, minX, minY, minZ, maxX, maxY, maxZ, colorZ);
        tessellator.b();
    }

    private static void drawBoundingBoxLinesX(ctq buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color) {
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
    }

    private static void drawBoundingBoxLinesY(ctq buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color) {
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
    }

    private static void drawBoundingBoxLinesZ(ctq buffer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color) {
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
    }

    public static void renderAreaSides(el pos1, el pos2, Color4f color, aer renderViewEntity, float partialTicks) {
        cua.m();
        cua.r();
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        buffer.a(7, ddu.l);
        RenderUtils.renderAreaSidesBatched(pos1, pos2, color, 0.002, renderViewEntity, partialTicks, buffer);
        tessellator.b();
        cua.q();
        cua.l();
    }

    public static void renderAreaSidesBatched(el pos1, el pos2, Color4f color, double expand, aer renderViewEntity, float partialTicks, ctq buffer) {
        double dx = renderViewEntity.N + (renderViewEntity.q - renderViewEntity.N) * (double)partialTicks;
        double dy = renderViewEntity.O + (renderViewEntity.r - renderViewEntity.O) * (double)partialTicks;
        double dz = renderViewEntity.P + (renderViewEntity.s - renderViewEntity.P) * (double)partialTicks;
        double minX = (double)Math.min(pos1.o(), pos2.o()) - dx - expand;
        double minY = (double)Math.min(pos1.p(), pos2.p()) - dy - expand;
        double minZ = (double)Math.min(pos1.q(), pos2.q()) - dz - expand;
        double maxX = (double)(Math.max(pos1.o(), pos2.o()) + 1) - dx + expand;
        double maxY = (double)(Math.max(pos1.p(), pos2.p()) + 1) - dy + expand;
        double maxZ = (double)(Math.max(pos1.q(), pos2.q()) + 1) - dz + expand;
        fi.dy.masa.malilib.render.RenderUtils.drawBoxAllSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (ctq)buffer);
    }

    public static void renderAreaOutlineNoCorners(el pos1, el pos2, float lineWidth, Color4f colorX, Color4f colorY, Color4f colorZ, aer renderViewEntity, float partialTicks) {
        int end;
        int xMin = Math.min(pos1.o(), pos2.o());
        int yMin = Math.min(pos1.p(), pos2.p());
        int zMin = Math.min(pos1.q(), pos2.q());
        int xMax = Math.max(pos1.o(), pos2.o());
        int yMax = Math.max(pos1.p(), pos2.p());
        int zMax = Math.max(pos1.q(), pos2.q());
        double expand = 0.001;
        double dx = renderViewEntity.N + (renderViewEntity.q - renderViewEntity.N) * (double)partialTicks;
        double dy = renderViewEntity.O + (renderViewEntity.r - renderViewEntity.O) * (double)partialTicks;
        double dz = renderViewEntity.P + (renderViewEntity.s - renderViewEntity.P) * (double)partialTicks;
        double dxMin = -dx - 0.001;
        double dyMin = -dy - 0.001;
        double dzMin = -dz - 0.001;
        double dxMax = -dx + 0.001;
        double dyMax = -dy + 0.001;
        double dzMax = -dz + 0.001;
        double minX = (double)xMin + dxMin;
        double minY = (double)yMin + dyMin;
        double minZ = (double)zMin + dzMin;
        double maxX = (double)xMax + dxMax;
        double maxY = (double)yMax + dyMax;
        double maxZ = (double)zMax + dzMax;
        cua.d((float)lineWidth);
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        buffer.a(1, ddu.l);
        int start = pos1.o() == xMin && pos1.p() == yMin && pos1.q() == zMin || pos2.o() == xMin && pos2.p() == yMin && pos2.q() == zMin ? xMin + 1 : xMin;
        int n = end = pos1.o() == xMax && pos1.p() == yMin && pos1.q() == zMin || pos2.o() == xMax && pos2.p() == yMin && pos2.q() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.b((double)start + dxMin, minY, minZ).a(colorX.r, colorX.g, colorX.b, colorX.a).d();
            buffer.b((double)end + dxMax, minY, minZ).a(colorX.r, colorX.g, colorX.b, colorX.a).d();
        }
        start = pos1.o() == xMin && pos1.p() == yMax && pos1.q() == zMin || pos2.o() == xMin && pos2.p() == yMax && pos2.q() == zMin ? xMin + 1 : xMin;
        int n2 = end = pos1.o() == xMax && pos1.p() == yMax && pos1.q() == zMin || pos2.o() == xMax && pos2.p() == yMax && pos2.q() == zMin ? xMax : xMax + 1;
        if (end > start) {
            buffer.b((double)start + dxMin, maxY + 1.0, minZ).a(colorX.r, colorX.g, colorX.b, colorX.a).d();
            buffer.b((double)end + dxMax, maxY + 1.0, minZ).a(colorX.r, colorX.g, colorX.b, colorX.a).d();
        }
        start = pos1.o() == xMin && pos1.p() == yMin && pos1.q() == zMax || pos2.o() == xMin && pos2.p() == yMin && pos2.q() == zMax ? xMin + 1 : xMin;
        int n3 = end = pos1.o() == xMax && pos1.p() == yMin && pos1.q() == zMax || pos2.o() == xMax && pos2.p() == yMin && pos2.q() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.b((double)start + dxMin, minY, maxZ + 1.0).a(colorX.r, colorX.g, colorX.b, colorX.a).d();
            buffer.b((double)end + dxMax, minY, maxZ + 1.0).a(colorX.r, colorX.g, colorX.b, colorX.a).d();
        }
        start = pos1.o() == xMin && pos1.p() == yMax && pos1.q() == zMax || pos2.o() == xMin && pos2.p() == yMax && pos2.q() == zMax ? xMin + 1 : xMin;
        int n4 = end = pos1.o() == xMax && pos1.p() == yMax && pos1.q() == zMax || pos2.o() == xMax && pos2.p() == yMax && pos2.q() == zMax ? xMax : xMax + 1;
        if (end > start) {
            buffer.b((double)start + dxMin, maxY + 1.0, maxZ + 1.0).a(colorX.r, colorX.g, colorX.b, colorX.a).d();
            buffer.b((double)end + dxMax, maxY + 1.0, maxZ + 1.0).a(colorX.r, colorX.g, colorX.b, colorX.a).d();
        }
        start = pos1.o() == xMin && pos1.p() == yMin && pos1.q() == zMin || pos2.o() == xMin && pos2.p() == yMin && pos2.q() == zMin ? yMin + 1 : yMin;
        int n5 = end = pos1.o() == xMin && pos1.p() == yMax && pos1.q() == zMin || pos2.o() == xMin && pos2.p() == yMax && pos2.q() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.b(minX, (double)start + dyMin, minZ).a(colorY.r, colorY.g, colorY.b, colorY.a).d();
            buffer.b(minX, (double)end + dyMax, minZ).a(colorY.r, colorY.g, colorY.b, colorY.a).d();
        }
        start = pos1.o() == xMax && pos1.p() == yMin && pos1.q() == zMin || pos2.o() == xMax && pos2.p() == yMin && pos2.q() == zMin ? yMin + 1 : yMin;
        int n6 = end = pos1.o() == xMax && pos1.p() == yMax && pos1.q() == zMin || pos2.o() == xMax && pos2.p() == yMax && pos2.q() == zMin ? yMax : yMax + 1;
        if (end > start) {
            buffer.b(maxX + 1.0, (double)start + dyMin, minZ).a(colorY.r, colorY.g, colorY.b, colorY.a).d();
            buffer.b(maxX + 1.0, (double)end + dyMax, minZ).a(colorY.r, colorY.g, colorY.b, colorY.a).d();
        }
        start = pos1.o() == xMin && pos1.p() == yMin && pos1.q() == zMax || pos2.o() == xMin && pos2.p() == yMin && pos2.q() == zMax ? yMin + 1 : yMin;
        int n7 = end = pos1.o() == xMin && pos1.p() == yMax && pos1.q() == zMax || pos2.o() == xMin && pos2.p() == yMax && pos2.q() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.b(minX, (double)start + dyMin, maxZ + 1.0).a(colorY.r, colorY.g, colorY.b, colorY.a).d();
            buffer.b(minX, (double)end + dyMax, maxZ + 1.0).a(colorY.r, colorY.g, colorY.b, colorY.a).d();
        }
        start = pos1.o() == xMax && pos1.p() == yMin && pos1.q() == zMax || pos2.o() == xMax && pos2.p() == yMin && pos2.q() == zMax ? yMin + 1 : yMin;
        int n8 = end = pos1.o() == xMax && pos1.p() == yMax && pos1.q() == zMax || pos2.o() == xMax && pos2.p() == yMax && pos2.q() == zMax ? yMax : yMax + 1;
        if (end > start) {
            buffer.b(maxX + 1.0, (double)start + dyMin, maxZ + 1.0).a(colorY.r, colorY.g, colorY.b, colorY.a).d();
            buffer.b(maxX + 1.0, (double)end + dyMax, maxZ + 1.0).a(colorY.r, colorY.g, colorY.b, colorY.a).d();
        }
        start = pos1.o() == xMin && pos1.p() == yMin && pos1.q() == zMin || pos2.o() == xMin && pos2.p() == yMin && pos2.q() == zMin ? zMin + 1 : zMin;
        int n9 = end = pos1.o() == xMin && pos1.p() == yMin && pos1.q() == zMax || pos2.o() == xMin && pos2.p() == yMin && pos2.q() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.b(minX, minY, (double)start + dzMin).a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).d();
            buffer.b(minX, minY, (double)end + dzMax).a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).d();
        }
        start = pos1.o() == xMax && pos1.p() == yMin && pos1.q() == zMin || pos2.o() == xMax && pos2.p() == yMin && pos2.q() == zMin ? zMin + 1 : zMin;
        int n10 = end = pos1.o() == xMax && pos1.p() == yMin && pos1.q() == zMax || pos2.o() == xMax && pos2.p() == yMin && pos2.q() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.b(maxX + 1.0, minY, (double)start + dzMin).a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).d();
            buffer.b(maxX + 1.0, minY, (double)end + dzMax).a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).d();
        }
        start = pos1.o() == xMin && pos1.p() == yMax && pos1.q() == zMin || pos2.o() == xMin && pos2.p() == yMax && pos2.q() == zMin ? zMin + 1 : zMin;
        int n11 = end = pos1.o() == xMin && pos1.p() == yMax && pos1.q() == zMax || pos2.o() == xMin && pos2.p() == yMax && pos2.q() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.b(minX, maxY + 1.0, (double)start + dzMin).a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).d();
            buffer.b(minX, maxY + 1.0, (double)end + dzMax).a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).d();
        }
        start = pos1.o() == xMax && pos1.p() == yMax && pos1.q() == zMin || pos2.o() == xMax && pos2.p() == yMax && pos2.q() == zMin ? zMin + 1 : zMin;
        int n12 = end = pos1.o() == xMax && pos1.p() == yMax && pos1.q() == zMax || pos2.o() == xMax && pos2.p() == yMax && pos2.q() == zMax ? zMax : zMax + 1;
        if (end > start) {
            buffer.b(maxX + 1.0, maxY + 1.0, (double)start + dzMin).a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).d();
            buffer.b(maxX + 1.0, maxY + 1.0, (double)end + dzMax).a(colorZ.r, colorZ.g, colorZ.b, colorZ.a).d();
        }
        tessellator.b();
    }

    public static void drawBlockModelOutlinesBatched(dez model, blc state, el pos, Color4f color, double expand, ctq buffer) {
        for (eq side : PositionUtils.FACING_ALL) {
            RenderUtils.renderModelQuadOutlines(pos, buffer, color, model.a(state, side, RAND));
        }
        RenderUtils.renderModelQuadOutlines(pos, buffer, color, model.a(state, null, RAND));
    }

    private static void renderModelQuadOutlines(el pos, ctq buffer, Color4f color, List<cux> quads) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderQuadOutlinesBatched(pos, buffer, color, quads.get(i).b());
        }
    }

    private static void renderQuadOutlinesBatched(el pos, ctq buffer, Color4f color, int[] vertexData) {
        int x = pos.o();
        int y = pos.p();
        int z = pos.q();
        float[] fx = new float[4];
        float[] fy = new float[4];
        float[] fz = new float[4];
        for (int index = 0; index < 4; ++index) {
            fx[index] = (float)x + Float.intBitsToFloat(vertexData[index * 7 + 0]);
            fy[index] = (float)y + Float.intBitsToFloat(vertexData[index * 7 + 1]);
            fz[index] = (float)z + Float.intBitsToFloat(vertexData[index * 7 + 2]);
        }
        buffer.b((double)fx[0], (double)fy[0], (double)fz[0]).a(color.r, color.g, color.b, color.a).d();
        buffer.b((double)fx[1], (double)fy[1], (double)fz[1]).a(color.r, color.g, color.b, color.a).d();
        buffer.b((double)fx[1], (double)fy[1], (double)fz[1]).a(color.r, color.g, color.b, color.a).d();
        buffer.b((double)fx[2], (double)fy[2], (double)fz[2]).a(color.r, color.g, color.b, color.a).d();
        buffer.b((double)fx[2], (double)fy[2], (double)fz[2]).a(color.r, color.g, color.b, color.a).d();
        buffer.b((double)fx[3], (double)fy[3], (double)fz[3]).a(color.r, color.g, color.b, color.a).d();
        buffer.b((double)fx[3], (double)fy[3], (double)fz[3]).a(color.r, color.g, color.b, color.a).d();
        buffer.b((double)fx[0], (double)fy[0], (double)fz[0]).a(color.r, color.g, color.b, color.a).d();
    }

    public static void drawBlockModelQuadOverlayBatched(dez model, blc state, el pos, Color4f color, double expand, ctq buffer) {
        for (eq side : PositionUtils.FACING_ALL) {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, model.a(state, side, RAND));
        }
        RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, model.a(state, null, RAND));
    }

    public static void drawBlockModelQuadOverlayBatched(dez model, blc state, el pos, eq side, Color4f color, double expand, ctq buffer) {
        RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, model.a(state, side, RAND));
    }

    private static void renderModelQuadOverlayBatched(el pos, ctq buffer, Color4f color, List<cux> quads) {
        int size = quads.size();
        for (int i = 0; i < size; ++i) {
            RenderUtils.renderModelQuadOverlayBatched(pos, buffer, color, quads.get(i).b());
        }
    }

    private static void renderModelQuadOverlayBatched(el pos, ctq buffer, Color4f color, int[] vertexData) {
        int x = pos.o();
        int y = pos.p();
        int z = pos.q();
        for (int index = 0; index < 4; ++index) {
            float fx = (float)x + Float.intBitsToFloat(vertexData[index * 7 + 0]);
            float fy = (float)y + Float.intBitsToFloat(vertexData[index * 7 + 1]);
            float fz = (float)z + Float.intBitsToFloat(vertexData[index * 7 + 2]);
            buffer.b((double)fx, (double)fy, (double)fz).a(color.r, color.g, color.b, color.a).d();
        }
    }

    public static void drawBlockBoxSideBatchedQuads(el pos, eq side, Color4f color, double expand, ctq buffer) {
        double minX = (double)pos.o() - expand;
        double minY = (double)pos.p() - expand;
        double minZ = (double)pos.q() - expand;
        double maxX = (double)pos.o() + expand + 1.0;
        double maxY = (double)pos.p() + expand + 1.0;
        double maxZ = (double)pos.q() + expand + 1.0;
        switch (side) {
            case a: {
                buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case b: {
                buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case c: {
                buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case d: {
                buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case e: {
                buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(minX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(minX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(minX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case f: {
                buffer.b(maxX, minY, maxZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(maxX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(maxX, maxY, minZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
            }
        }
    }

    public static void drawBlockBoxEdgeBatchedLines(el pos, eq.a axis, int cornerIndex, Color4f color, ctq buffer) {
        ff offset = PositionUtils.getEdgeNeighborOffsets(axis, cornerIndex)[cornerIndex];
        double minX = pos.o() + offset.o();
        double minY = pos.p() + offset.p();
        double minZ = pos.q() + offset.q();
        double maxX = pos.o() + offset.o() + (axis == eq.a.a ? 1 : 0);
        double maxY = pos.p() + offset.p() + (axis == eq.a.b ? 1 : 0);
        double maxZ = pos.q() + offset.q() + (axis == eq.a.c ? 1 : 0);
        buffer.b(minX, minY, minZ).a(color.r, color.g, color.b, color.a).d();
        buffer.b(maxX, maxY, maxZ).a(color.r, color.g, color.b, color.a).d();
    }

    public static int renderInventoryOverlays(BlockInfoAlignment align, int offY, axy worldSchematic, axy worldClient, el pos, cft mc) {
        int heightSch = RenderUtils.renderInventoryOverlay(align, LeftRight.LEFT, offY, worldSchematic, pos, mc);
        int heightCli = RenderUtils.renderInventoryOverlay(align, LeftRight.RIGHT, offY, worldClient, pos, mc);
        return Math.max(heightSch, heightCli);
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, axy world, el pos, cft mc) {
        ade inv = InventoryUtils.getInventory(world, pos);
        if (inv != null) {
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType((ade)inv);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)inv.T_());
            return RenderUtils.renderInventoryOverlay(align, side, offY, inv, type, props, mc);
        }
        return 0;
    }

    public static int renderInventoryOverlay(BlockInfoAlignment align, LeftRight side, int offY, ade inv, InventoryOverlay.InventoryRenderType type, InventoryOverlay.InventoryProperties props, cft mc) {
        int xInv = 0;
        int yInv = 0;
        switch (align) {
            case CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = GuiUtils.getScaledWindowHeight() / 2 - props.height - offY;
                break;
            }
            case TOP_CENTER: {
                xInv = GuiUtils.getScaledWindowWidth() / 2 - props.width / 2;
                yInv = offY;
            }
        }
        if (side == LeftRight.LEFT) {
            xInv -= props.width / 2 + 4;
        } else if (side == LeftRight.RIGHT) {
            xInv += props.width / 2 + 4;
        }
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)props.totalSlots, (cft)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (ade)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)0, (int)-1, (cft)mc);
        return props.height;
    }

    public static cea createEnclosingAABB(el pos1, el pos2, aer renderViewEntity, float partialTicks) {
        int minX = Math.min(pos1.o(), pos2.o());
        int minY = Math.min(pos1.p(), pos2.p());
        int minZ = Math.min(pos1.q(), pos2.q());
        int maxX = Math.max(pos1.o(), pos2.o()) + 1;
        int maxY = Math.max(pos1.p(), pos2.p()) + 1;
        int maxZ = Math.max(pos1.q(), pos2.q()) + 1;
        return RenderUtils.createAABB(minX, minY, minZ, maxX, maxY, maxZ, 0.0, partialTicks, renderViewEntity);
    }

    public static cea createAABB(int x, int y, int z, double expand, double partialTicks, aer renderViewEntity) {
        return RenderUtils.createAABB(x, y, z, x + 1, y + 1, z + 1, expand, partialTicks, renderViewEntity);
    }

    public static cea createAABB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, double expand, double partialTicks, aer entity) {
        double dx = entity.N + (entity.q - entity.N) * partialTicks;
        double dy = entity.O + (entity.r - entity.O) * partialTicks;
        double dz = entity.P + (entity.s - entity.P) * partialTicks;
        return new cea((double)minX - dx - expand, (double)minY - dy - expand, (double)minZ - dz - expand, (double)maxX - dx + expand, (double)maxY - dy + expand, (double)maxZ - dz + expand);
    }
}

