/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.widgets.WidgetSchematicVerificationResult;
import fi.dy.masa.litematica.render.BlockInfo;
import fi.dy.masa.litematica.render.RenderUtils;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.schematic.projects.SchematicProject;
import fi.dy.masa.litematica.schematic.verifier.SchematicVerifier;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.util.BlockInfoAlignment;
import fi.dy.masa.litematica.util.ItemUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.RayTraceUtils;
import fi.dy.masa.litematica.world.SchematicWorldHandler;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class OverlayRenderer {
    private static final OverlayRenderer INSTANCE = new OverlayRenderer();
    public static final int[] KELLY_COLORS = new int[]{16757504, 8404597, 16738304, 10927575, 12648480, 13541986, 8482918, 32052, 16152206, 21386, 16743004, 5453690, 16748032, 11741265, 16041984, 8329229, 9677312, 5845781, 15809043, 2305046};
    private final cft mc;
    private final Map<SchematicPlacement, ImmutableMap<String, Box>> placements = new HashMap<SchematicPlacement, ImmutableMap<String, Box>>();
    private Color4f colorPos1 = new Color4f(1.0f, 0.0625f, 0.0625f);
    private Color4f colorPos2 = new Color4f(0.0625f, 0.0625f, 1.0f);
    private Color4f colorOverlapping = new Color4f(1.0f, 0.0625f, 1.0f);
    private Color4f colorX = new Color4f(1.0f, 0.25f, 0.25f);
    private Color4f colorY = new Color4f(0.25f, 1.0f, 0.25f);
    private Color4f colorZ = new Color4f(0.25f, 0.25f, 1.0f);
    private Color4f colorArea = new Color4f(1.0f, 1.0f, 1.0f);
    private Color4f colorBoxPlacementSelected = new Color4f(0.08627451f, 1.0f, 1.0f);
    private Color4f colorSelectedCorner = new Color4f(0.0f, 1.0f, 1.0f);
    private Color4f colorAreaOrigin = new Color4f(1.0f, 0.5647059f, 0.0627451f);
    private long infoUpdateTime;
    private List<String> blockInfoLines = new ArrayList<String>();
    private int blockInfoX;
    private int blockInfoY;

    private OverlayRenderer() {
        this.mc = cft.s();
    }

    public static OverlayRenderer getInstance() {
        return INSTANCE;
    }

    public void updatePlacementCache() {
        this.placements.clear();
        List<SchematicPlacement> list = DataManager.getSchematicPlacementManager().getAllSchematicsPlacements();
        for (SchematicPlacement placement : list) {
            if (!placement.isEnabled()) continue;
            this.placements.put(placement, placement.getSubRegionBoxes(SubRegionPlacement.RequiredEnabled.PLACEMENT_ENABLED));
        }
    }

    public void renderBoxes(float partialTicks) {
        float lineWidthArea;
        aer renderViewEntity = this.mc.S();
        SelectionManager sm = DataManager.getSelectionManager();
        AreaSelection currentSelection = sm.getCurrentSelection();
        boolean renderAreas = currentSelection != null && Configs.Visuals.ENABLE_AREA_SELECTION_RENDERING.getBooleanValue();
        boolean renderPlacements = !this.placements.isEmpty() && Configs.Visuals.ENABLE_PLACEMENT_BOXES_RENDERING.getBooleanValue();
        boolean isProjectMode = DataManager.getSchematicProjectsManager().hasProjectOpen();
        float expand = 0.001f;
        float lineWidthBlockBox = 2.0f;
        float f = lineWidthArea = isProjectMode ? 3.0f : 1.5f;
        if (renderAreas || renderPlacements || isProjectMode) {
            SchematicProject project;
            cua.a((boolean)true);
            cua.g();
            cua.z();
            cua.a((int)516, (float)0.01f);
            cua.G();
            fi.dy.masa.malilib.render.RenderUtils.setupBlend();
            if (renderAreas) {
                cua.s();
                cua.a((float)-1.2f, (float)-0.2f);
                cua.a((boolean)false);
                Box currentBox = currentSelection.getSelectedSubRegionBox();
                for (Box box : currentSelection.getAllSubRegionBoxes()) {
                    BoxType type = box == currentBox ? BoxType.AREA_SELECTED : BoxType.AREA_UNSELECTED;
                    this.renderSelectionBox(box, type, expand, lineWidthBlockBox, lineWidthArea, renderViewEntity, partialTicks, null);
                }
                el origin = currentSelection.getExplicitOrigin();
                if (origin != null) {
                    if (currentSelection.isOriginSelected()) {
                        Color4f colorTmp = Color4f.fromColor((Color4f)this.colorAreaOrigin, (float)0.4f);
                        RenderUtils.renderAreaSides(origin, origin, colorTmp, renderViewEntity, partialTicks);
                    }
                    Color4f color = currentSelection.isOriginSelected() ? this.colorSelectedCorner : this.colorAreaOrigin;
                    RenderUtils.renderBlockOutline(origin, expand, lineWidthBlockBox, color, renderViewEntity, partialTicks);
                }
                cua.a((boolean)true);
                cua.a((float)0.0f, (float)0.0f);
                cua.t();
            }
            if (renderPlacements) {
                SchematicPlacementManager spm = DataManager.getSchematicPlacementManager();
                SchematicPlacement currentPlacement = spm.getSelectedSchematicPlacement();
                for (Map.Entry<SchematicPlacement, ImmutableMap<String, Box>> entry : this.placements.entrySet()) {
                    SchematicPlacement schematicPlacement = entry.getKey();
                    ImmutableMap<String, Box> boxMap = entry.getValue();
                    boolean origin = schematicPlacement.getSelectedSubRegionPlacement() == null;
                    for (Map.Entry entryBox : boxMap.entrySet()) {
                        String boxName = (String)entryBox.getKey();
                        boolean boxSelected = schematicPlacement == currentPlacement && (origin || boxName.equals(schematicPlacement.getSelectedSubRegionName()));
                        BoxType type = boxSelected ? BoxType.PLACEMENT_SELECTED : BoxType.PLACEMENT_UNSELECTED;
                        this.renderSelectionBox((Box)entryBox.getValue(), type, expand, 1.0f, 1.0f, renderViewEntity, partialTicks, schematicPlacement);
                    }
                    Color4f color = schematicPlacement == currentPlacement && origin ? this.colorSelectedCorner : schematicPlacement.getBoxesBBColor();
                    RenderUtils.renderBlockOutline(schematicPlacement.getOrigin(), expand, lineWidthBlockBox, color, renderViewEntity, partialTicks);
                    if (!Configs.Visuals.RENDER_PLACEMENT_ENCLOSING_BOX.getBooleanValue()) continue;
                    Box box = schematicPlacement.getEclosingBox();
                    if (!schematicPlacement.shouldRenderEnclosingBox() || box == null) continue;
                    RenderUtils.renderAreaOutline(box.getPos1(), box.getPos2(), 1.0f, color, color, color, renderViewEntity, partialTicks);
                    if (!Configs.Visuals.RENDER_PLACEMENT_ENCLOSING_BOX_SIDES.getBooleanValue()) continue;
                    float alpha = (float)Configs.Visuals.PLACEMENT_BOX_SIDE_ALPHA.getDoubleValue();
                    color = new Color4f(color.r, color.g, color.b, alpha);
                    RenderUtils.renderAreaSides(box.getPos1(), box.getPos2(), color, renderViewEntity, partialTicks);
                }
            }
            if (isProjectMode && (project = DataManager.getSchematicProjectsManager().getCurrentProject()) != null) {
                RenderUtils.renderBlockOutline(project.getOrigin(), expand, 4.0f, this.colorOverlapping, renderViewEntity, partialTicks);
            }
            cua.H();
            cua.y();
            cua.q();
            cua.f();
            cua.a((boolean)true);
        }
    }

    public void renderSelectionBox(Box box, BoxType boxType, float expand, float lineWidthBlockBox, float lineWidthArea, aer renderViewEntity, float partialTicks, @Nullable SchematicPlacement placement) {
        Color4f sideColor;
        float alpha;
        Color4f color2;
        Color4f color1;
        Color4f colorZ;
        Color4f colorY;
        Color4f colorX;
        el pos1 = box.getPos1();
        el pos2 = box.getPos2();
        if (pos1 == null && pos2 == null) {
            return;
        }
        switch (boxType) {
            case AREA_SELECTED: {
                colorX = this.colorX;
                colorY = this.colorY;
                colorZ = this.colorZ;
                break;
            }
            case AREA_UNSELECTED: {
                colorX = this.colorArea;
                colorY = this.colorArea;
                colorZ = this.colorArea;
                break;
            }
            case PLACEMENT_SELECTED: {
                colorX = this.colorBoxPlacementSelected;
                colorY = this.colorBoxPlacementSelected;
                colorZ = this.colorBoxPlacementSelected;
                break;
            }
            case PLACEMENT_UNSELECTED: {
                Color4f color;
                colorX = color = placement.getBoxesBBColor();
                colorY = color;
                colorZ = color;
                break;
            }
            default: {
                return;
            }
        }
        if (boxType == BoxType.PLACEMENT_SELECTED) {
            color2 = color1 = this.colorBoxPlacementSelected;
            alpha = (float)Configs.Visuals.PLACEMENT_BOX_SIDE_ALPHA.getDoubleValue();
            sideColor = new Color4f(color1.r, color1.g, color1.b, alpha);
        } else if (boxType == BoxType.PLACEMENT_UNSELECTED) {
            color2 = color1 = placement.getBoxesBBColor();
            alpha = (float)Configs.Visuals.PLACEMENT_BOX_SIDE_ALPHA.getDoubleValue();
            sideColor = new Color4f(color1.r, color1.g, color1.b, alpha);
        } else {
            color1 = box.getSelectedCorner() == PositionUtils.Corner.CORNER_1 ? this.colorSelectedCorner : this.colorPos1;
            color2 = box.getSelectedCorner() == PositionUtils.Corner.CORNER_2 ? this.colorSelectedCorner : this.colorPos2;
            sideColor = Color4f.fromColor((int)Configs.Colors.AREA_SELECTION_BOX_SIDE_COLOR.getIntegerValue());
        }
        if (pos1 != null && pos2 != null) {
            if (!pos1.equals((Object)pos2)) {
                RenderUtils.renderAreaOutlineNoCorners(pos1, pos2, lineWidthArea, colorX, colorY, colorZ, renderViewEntity, partialTicks);
                if ((boxType == BoxType.AREA_SELECTED || boxType == BoxType.AREA_UNSELECTED) && Configs.Visuals.RENDER_AREA_SELECTION_BOX_SIDES.getBooleanValue() || (boxType == BoxType.PLACEMENT_SELECTED || boxType == BoxType.PLACEMENT_UNSELECTED) && Configs.Visuals.RENDER_PLACEMENT_BOX_SIDES.getBooleanValue()) {
                    RenderUtils.renderAreaSides(pos1, pos2, sideColor, renderViewEntity, partialTicks);
                }
                if (box.getSelectedCorner() == PositionUtils.Corner.CORNER_1) {
                    Color4f color = Color4f.fromColor((Color4f)this.colorPos1, (float)0.4f);
                    RenderUtils.renderAreaSides(pos1, pos1, color, renderViewEntity, partialTicks);
                } else if (box.getSelectedCorner() == PositionUtils.Corner.CORNER_2) {
                    Color4f color = Color4f.fromColor((Color4f)this.colorPos2, (float)0.4f);
                    RenderUtils.renderAreaSides(pos2, pos2, color, renderViewEntity, partialTicks);
                }
                RenderUtils.renderBlockOutline(pos1, expand, lineWidthBlockBox, color1, renderViewEntity, partialTicks);
                RenderUtils.renderBlockOutline(pos2, expand, lineWidthBlockBox, color2, renderViewEntity, partialTicks);
            } else {
                RenderUtils.renderBlockOutlineOverlapping(pos1, expand, lineWidthBlockBox, color1, color2, this.colorOverlapping, renderViewEntity, partialTicks);
            }
        } else {
            if (pos1 != null) {
                RenderUtils.renderBlockOutline(pos1, expand, lineWidthBlockBox, color1, renderViewEntity, partialTicks);
            }
            if (pos2 != null) {
                RenderUtils.renderBlockOutline(pos2, expand, lineWidthBlockBox, color2, renderViewEntity, partialTicks);
            }
        }
    }

    public void renderSchematicVerifierMismatches(float partialTicks) {
        SchematicVerifier verifier;
        List<SchematicVerifier.MismatchRenderPos> list;
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (placement != null && placement.hasVerifier() && !(list = (verifier = placement.getSchematicVerifier()).getSelectedMismatchPositionsForRender()).isEmpty()) {
            List<el> posList = verifier.getSelectedMismatchBlockPositionsForRender();
            ceb trace = RayTraceUtils.traceToPositions(posList, (aer)this.mc.i, 128.0);
            el posLook = trace != null && trace.a == ceb.a.b ? trace.a() : null;
            this.renderSchematicMismatches(list, posLook, partialTicks);
        }
    }

    private void renderSchematicMismatches(List<SchematicVerifier.MismatchRenderPos> posList, @Nullable el lookPos, float partialTicks) {
        cua.j();
        cua.a((boolean)false);
        cua.g();
        cua.z();
        cua.G();
        cua.d((float)2.0f);
        ctj player = this.mc.i;
        cum tessellator = cum.a();
        ctq buffer = tessellator.c();
        buffer.a(1, ddu.l);
        SchematicVerifier.MismatchRenderPos lookedEntry = null;
        SchematicVerifier.MismatchRenderPos prevEntry = null;
        boolean connections = Configs.Visuals.RENDER_ERROR_MARKER_CONNECTIONS.getBooleanValue();
        for (SchematicVerifier.MismatchRenderPos entry : posList) {
            Color4f color = entry.type.getColor();
            if (!entry.pos.equals((Object)lookPos)) {
                RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(entry.pos, color, 0.002, buffer, (aer)player, partialTicks);
            } else {
                lookedEntry = entry;
            }
            if (connections && prevEntry != null) {
                RenderUtils.drawConnectingLineBatchedLines(prevEntry.pos, entry.pos, false, color, buffer, (aer)player, partialTicks);
            }
            prevEntry = entry;
        }
        if (lookedEntry != null) {
            if (connections && prevEntry != null) {
                RenderUtils.drawConnectingLineBatchedLines(prevEntry.pos, lookedEntry.pos, false, lookedEntry.type.getColor(), buffer, (aer)player, partialTicks);
            }
            tessellator.b();
            buffer.a(1, ddu.l);
            cua.d((float)6.0f);
            RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines(lookPos, lookedEntry.type.getColor(), 0.002, buffer, (aer)player, partialTicks);
        }
        tessellator.b();
        if (Configs.Visuals.RENDER_ERROR_MARKER_SIDES.getBooleanValue()) {
            cua.m();
            cua.r();
            buffer.a(7, ddu.l);
            float alpha = (float)Configs.InfoOverlays.VERIFIER_ERROR_HILIGHT_ALPHA.getDoubleValue();
            for (SchematicVerifier.MismatchRenderPos entry : posList) {
                Color4f color = entry.type.getColor();
                color = new Color4f(color.r, color.g, color.b, alpha);
                RenderUtils.renderAreaSidesBatched(entry.pos, entry.pos, color, 0.002, (aer)this.mc.i, partialTicks, buffer);
            }
            tessellator.b();
            cua.l();
        }
        cua.H();
        cua.y();
        cua.q();
        cua.f();
        cua.a((boolean)true);
        cua.k();
    }

    public void renderHoverInfo(cft mc) {
        if (mc.g != null && mc.i != null) {
            boolean infoOverlayKeyActive = Hotkeys.RENDER_INFO_OVERLAY.getKeybind().isKeybindHeld();
            boolean verifierOverlayRendered = false;
            if (infoOverlayKeyActive && Configs.InfoOverlays.VERIFIER_OVERLAY_ENABLED.getBooleanValue() && Configs.InfoOverlays.BLOCK_INFO_OVERLAY_ENABLED.getBooleanValue()) {
                verifierOverlayRendered = this.renderVerifierOverlay(mc);
            }
            boolean renderBlockInfoLines = Configs.InfoOverlays.BLOCK_INFO_LINES_ENABLED.getBooleanValue();
            boolean renderInfoOverlay = !verifierOverlayRendered && infoOverlayKeyActive && Configs.InfoOverlays.BLOCK_INFO_OVERLAY_ENABLED.getBooleanValue();
            RayTraceUtils.RayTraceWrapper traceWrapper = null;
            if (renderBlockInfoLines || renderInfoOverlay) {
                traceWrapper = RayTraceUtils.getGenericTrace((axy)mc.g, (aer)mc.i, 10.0, true);
            }
            if (traceWrapper != null) {
                if (renderBlockInfoLines) {
                    this.renderBlockInfoLines(traceWrapper, mc);
                }
                if (renderInfoOverlay) {
                    this.renderBlockInfoOverlay(traceWrapper, mc);
                }
            }
        }
    }

    private void renderBlockInfoLines(RayTraceUtils.RayTraceWrapper traceWrapper, cft mc) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.infoUpdateTime >= 50L) {
            this.updateBlockInfoLines(traceWrapper, mc);
            this.infoUpdateTime = currentTime;
        }
        int x = Configs.InfoOverlays.BLOCK_INFO_LINES_OFFSET_X.getIntegerValue();
        int y = Configs.InfoOverlays.BLOCK_INFO_LINES_OFFSET_Y.getIntegerValue();
        double fontScale = Configs.InfoOverlays.BLOCK_INFO_LINES_FONT_SCALE.getDoubleValue();
        int textColor = -1;
        int bgColor = -1605349296;
        HudAlignment alignment = (HudAlignment)Configs.InfoOverlays.BLOCK_INFO_LINES_ALIGNMENT.getOptionListValue();
        boolean useBackground = true;
        boolean useShadow = false;
        fi.dy.masa.malilib.render.RenderUtils.renderText((int)x, (int)y, (double)fontScale, (int)textColor, (int)bgColor, (HudAlignment)alignment, (boolean)useBackground, (boolean)useShadow, this.blockInfoLines);
    }

    private boolean renderVerifierOverlay(cft mc) {
        SchematicVerifier.BlockMismatch mismatch;
        SchematicVerifier verifier;
        List<el> posList;
        ceb trace;
        SchematicPlacement placement = DataManager.getSchematicPlacementManager().getSelectedSchematicPlacement();
        if (placement != null && placement.hasVerifier() && (trace = RayTraceUtils.traceToPositions(posList = (verifier = placement.getSchematicVerifier()).getSelectedMismatchBlockPositionsForRender(), (aer)mc.i, 128.0)) != null && trace.a == ceb.a.b && (mismatch = verifier.getMismatchForPosition(trace.a())) != null) {
            WidgetSchematicVerificationResult.BlockMismatchInfo info = new WidgetSchematicVerificationResult.BlockMismatchInfo(mismatch.stateExpected, mismatch.stateFound);
            info.render(GuiUtils.getScaledWindowWidth() / 2 - info.getTotalWidth() / 2, GuiUtils.getScaledWindowHeight() / 2 + 6, mc);
            return true;
        }
        return false;
    }

    private void renderBlockInfoOverlay(RayTraceUtils.RayTraceWrapper traceWrapper, cft mc) {
        blc air = bct.a.p();
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        axy worldClient = WorldUtils.getBestWorld((cft)mc);
        el pos = traceWrapper.getRayTraceResult().a();
        blc stateClient = mc.g.a_(pos);
        blc stateSchematic = worldSchematic.a_(pos);
        int offY = Configs.InfoOverlays.BLOCK_INFO_OVERLAY_OFFSET_Y.getIntegerValue();
        BlockInfoAlignment align = (BlockInfoAlignment)Configs.InfoOverlays.BLOCK_INFO_OVERLAY_ALIGNMENT.getOptionListValue();
        ItemUtils.setItemForBlock((axy)worldSchematic, pos, stateSchematic);
        ItemUtils.setItemForBlock((axy)mc.g, pos, stateClient);
        if (stateSchematic != stateClient && stateClient != air && stateSchematic != air) {
            int invHeight = RenderUtils.renderInventoryOverlays(align, offY, (axy)worldSchematic, worldClient, pos, mc);
            WidgetSchematicVerificationResult.BlockMismatchInfo info = new WidgetSchematicVerificationResult.BlockMismatchInfo(stateSchematic, stateClient);
            this.getOverlayPosition(info.getTotalWidth(), info.getTotalHeight(), offY, invHeight, mc);
            info.render(this.blockInfoX, this.blockInfoY, mc);
        } else if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.VANILLA) {
            int invHeight = RenderUtils.renderInventoryOverlay(align, LeftRight.CENTER, offY, worldClient, pos, mc);
            BlockInfo info = new BlockInfo(stateClient, "litematica.gui.label.block_info.state_client");
            this.getOverlayPosition(info.getTotalWidth(), info.getTotalHeight(), offY, invHeight, mc);
            info.render(this.blockInfoX, this.blockInfoY, mc);
        } else if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            bji te = worldClient.f(pos);
            if (te instanceof ade) {
                int invHeight = RenderUtils.renderInventoryOverlays(align, offY, (axy)worldSchematic, worldClient, pos, mc);
                BlockInfo info = new BlockInfo(stateClient, "litematica.gui.label.block_info.state_client");
                this.getOverlayPosition(info.getTotalWidth(), info.getTotalHeight(), offY, invHeight, mc);
                info.render(this.blockInfoX, this.blockInfoY, mc);
            } else {
                int invHeight = RenderUtils.renderInventoryOverlay(align, LeftRight.CENTER, offY, (axy)worldSchematic, pos, mc);
                BlockInfo info = new BlockInfo(stateSchematic, "litematica.gui.label.block_info.state_schematic");
                this.getOverlayPosition(info.getTotalWidth(), info.getTotalHeight(), offY, invHeight, mc);
                info.render(this.blockInfoX, this.blockInfoY, mc);
            }
        }
    }

    protected void getOverlayPosition(int width, int height, int offY, int invHeight, cft mc) {
        BlockInfoAlignment align = (BlockInfoAlignment)Configs.InfoOverlays.BLOCK_INFO_OVERLAY_ALIGNMENT.getOptionListValue();
        switch (align) {
            case CENTER: {
                this.blockInfoX = GuiUtils.getScaledWindowWidth() / 2 - width / 2;
                this.blockInfoY = GuiUtils.getScaledWindowHeight() / 2 + offY;
                break;
            }
            case TOP_CENTER: {
                this.blockInfoX = GuiUtils.getScaledWindowWidth() / 2 - width / 2;
                this.blockInfoY = invHeight + offY + (invHeight > 0 ? offY : 0);
            }
        }
    }

    private void updateBlockInfoLines(RayTraceUtils.RayTraceWrapper traceWrapper, cft mc) {
        this.blockInfoLines.clear();
        el pos = traceWrapper.getRayTraceResult().a();
        blc stateClient = mc.g.a_(pos);
        WorldSchematic worldSchematic = SchematicWorldHandler.getSchematicWorld();
        blc stateSchematic = worldSchematic.a_(pos);
        String ul = GuiBase.TXT_UNDERLINE;
        if (stateSchematic != stateClient && !stateClient.f() && !stateSchematic.f()) {
            this.blockInfoLines.add(ul + "Schematic:");
            this.addBlockInfoLines(stateSchematic);
            this.blockInfoLines.add("");
            this.blockInfoLines.add(ul + "Client:");
            this.addBlockInfoLines(stateClient);
        } else if (traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            this.blockInfoLines.add(ul + "Schematic:");
            this.addBlockInfoLines(stateSchematic);
        }
    }

    private <T extends Comparable<T>> void addBlockInfoLines(blc state) {
        this.blockInfoLines.add(String.valueOf(fc.g.b((Object)state.c())));
        for (String line : BlockUtils.getFormattedBlockStateProperties((blc)state)) {
            this.blockInfoLines.add(line);
        }
    }

    public void renderSchematicRebuildTargetingOverlay(float partialTicks) {
        RayTraceUtils.RayTraceWrapper traceWrapper = null;
        Color4f color = null;
        boolean direction = false;
        if (Hotkeys.SCHEMATIC_REBUILD_BREAK_ALL.getKeybind().isKeybindHeld()) {
            traceWrapper = RayTraceUtils.getGenericTrace((axy)this.mc.g, (aer)this.mc.i, 20.0, true);
            color = Configs.Colors.REBUILD_BREAK_OVERLAY_COLOR.getColor();
        } else if (Hotkeys.SCHEMATIC_REBUILD_BREAK_DIRECTION.getKeybind().isKeybindHeld()) {
            traceWrapper = RayTraceUtils.getGenericTrace((axy)this.mc.g, (aer)this.mc.i, 20.0, true);
            color = Configs.Colors.REBUILD_BREAK_OVERLAY_COLOR.getColor();
            direction = true;
        } else if (Hotkeys.SCHEMATIC_REBUILD_REPLACE_ALL.getKeybind().isKeybindHeld()) {
            traceWrapper = RayTraceUtils.getGenericTrace((axy)this.mc.g, (aer)this.mc.i, 20.0, true);
            color = Configs.Colors.REBUILD_REPLACE_OVERLAY_COLOR.getColor();
        } else if (Hotkeys.SCHEMATIC_REBUILD_REPLACE_DIRECTION.getKeybind().isKeybindHeld()) {
            traceWrapper = RayTraceUtils.getGenericTrace((axy)this.mc.g, (aer)this.mc.i, 20.0, true);
            color = Configs.Colors.REBUILD_REPLACE_OVERLAY_COLOR.getColor();
            direction = true;
        }
        if (traceWrapper != null && traceWrapper.getHitType() == RayTraceUtils.RayTraceWrapper.HitType.SCHEMATIC_BLOCK) {
            ctj entity = this.mc.i;
            ceb trace = traceWrapper.getRayTraceResult();
            el pos = trace.a();
            cua.a((boolean)false);
            cua.g();
            cua.r();
            cua.z();
            fi.dy.masa.malilib.render.RenderUtils.setupBlend();
            if (direction) {
                fi.dy.masa.malilib.render.RenderUtils.renderBlockTargetingOverlay((aer)entity, (el)pos, (eq)trace.b, (cee)trace.c, (Color4f)color, (float)partialTicks);
            } else {
                fi.dy.masa.malilib.render.RenderUtils.renderBlockTargetingOverlaySimple((aer)entity, (el)pos, (eq)trace.b, (Color4f)color, (float)partialTicks);
            }
            cua.y();
            cua.l();
            cua.q();
            cua.a((boolean)true);
        }
    }

    public void renderPreviewFrame(cft mc) {
        int height;
        int width = GuiUtils.getScaledWindowWidth();
        int x = width >= (height = GuiUtils.getScaledWindowHeight()) ? (width - height) / 2 : 0;
        int y = height >= width ? (height - width) / 2 : 0;
        int longerSide = Math.min(width, height);
        fi.dy.masa.malilib.render.RenderUtils.drawOutline((int)x, (int)y, (int)longerSide, (int)longerSide, (int)2, (int)-1);
    }

    private static enum BoxType {
        AREA_SELECTED,
        AREA_UNSELECTED,
        PLACEMENT_SELECTED,
        PLACEMENT_UNSELECTED;

    }
}

