/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.render.shader.ShaderProgram;
import javax.annotation.Nullable;
import org.lwjgl.opengl.GL20;

public class LitematicaRenderer {
    private static final LitematicaRenderer INSTANCE = new LitematicaRenderer();
    private static final ShaderProgram SHADER_ALPHA = new ShaderProgram("litematica", null, "shaders/alpha.frag");
    private cft mc;
    private WorldRendererSchematic worldRenderer;
    private int frameCount;
    private long finishTimeNano;
    private aer entity;
    private cwz camera;
    private boolean renderPiecewise;
    private boolean renderPiecewiseSchematic;
    private boolean renderPiecewiseBlocks;
    private boolean renderPiecewisePrepared;
    private boolean translucentSchematic;

    public static LitematicaRenderer getInstance() {
        return INSTANCE;
    }

    public WorldRendererSchematic getWorldRenderer() {
        if (this.worldRenderer == null) {
            this.mc = cft.s();
            this.worldRenderer = new WorldRendererSchematic(this.mc);
        }
        return this.worldRenderer;
    }

    public void loadRenderers() {
        this.getWorldRenderer().a();
    }

    public void onSchematicWorldChanged(@Nullable WorldSchematic worldClient) {
        this.getWorldRenderer().setWorldAndLoadRenderers(worldClient);
    }

    private void calculateFinishTime() {
        long fpsLimit = this.mc.t.h;
        long fpsMin = Math.min((long)cft.X(), fpsLimit);
        fpsMin = Math.max(fpsMin, 60L);
        this.finishTimeNano = Configs.Generic.RENDER_THREAD_NO_TIMEOUT.getBooleanValue() ? Long.MAX_VALUE : System.nanoTime() + Math.max(1000000000L / fpsMin / 2L, 0L);
    }

    public void renderSchematicWorld(float partialTicks) {
        if (!this.mc.r) {
            this.mc.y.a("litematica_schematic_world_render");
            if (this.mc.S() == null) {
                this.mc.a((aer)this.mc.i);
            }
            cua.G();
            cua.k();
            this.calculateFinishTime();
            this.renderWorld(partialTicks, this.finishTimeNano);
            this.cleanup();
            cua.H();
            this.mc.y.e();
        }
    }

    private void renderWorld(float partialTicks, long finishTimeNano) {
        this.mc.y.a("culling");
        aer entity = this.mc.S();
        cwz icamera = this.createCamera(entity, partialTicks);
        cua.j((int)7425);
        this.mc.y.c("prepare_terrain");
        this.mc.E().a(ddl.f);
        RenderUtils.disableItemLighting();
        WorldRendererSchematic worldRenderer = this.getWorldRenderer();
        this.mc.y.c("terrain_setup");
        worldRenderer.a(entity, partialTicks, icamera, this.frameCount++, this.mc.i.t());
        this.mc.y.c("update_chunks");
        worldRenderer.a(finishTimeNano);
        this.mc.y.c("terrain");
        cua.n((int)5888);
        cua.d();
        if (Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue()) {
            cua.G();
            if (Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
                cua.s();
                cua.a((float)-0.2f, (float)-0.4f);
            }
            this.startShaderIfEnabled();
            RenderUtils.setupBlend();
            worldRenderer.a(axl.a, partialTicks, entity);
            worldRenderer.a(axl.b, partialTicks, entity);
            this.mc.E().b(ddl.f).b(false, false);
            worldRenderer.a(axl.c, partialTicks, entity);
            this.mc.E().b(ddl.f).b();
            if (Configs.Visuals.RENDER_COLLIDING_SCHEMATIC_BLOCKS.getBooleanValue()) {
                cua.a((float)0.0f, (float)0.0f);
                cua.t();
            }
            cua.l();
            cua.j((int)7424);
            cua.a((int)516, (float)0.01f);
            cua.n((int)5888);
            cua.H();
            this.mc.y.c("entities");
            cua.G();
            RenderUtils.enableItemLighting();
            RenderUtils.setupBlend();
            worldRenderer.a(entity, icamera, partialTicks);
            cua.p();
            cua.l();
            RenderUtils.disableItemLighting();
            cua.n((int)5888);
            cua.H();
            cua.q();
            cua.a((int)516, (float)0.1f);
            this.mc.E().a(ddl.f);
            cua.j((int)7425);
            this.mc.y.c("translucent");
            cua.a((boolean)false);
            cua.G();
            RenderUtils.setupBlend();
            worldRenderer.a(axl.d, partialTicks, entity);
            cua.H();
            this.disableShader();
        }
        this.mc.y.c("overlay");
        this.renderSchematicOverlay();
        cua.e();
        cua.l();
        cua.a((boolean)true);
        cua.j((int)7424);
        cua.q();
        this.mc.y.e();
    }

    public void renderSchematicOverlay() {
        boolean invert = Hotkeys.INVERT_OVERLAY_RENDER_STATE.getKeybind().isKeybindHeld();
        if (Configs.Visuals.ENABLE_SCHEMATIC_OVERLAY.getBooleanValue() != invert) {
            boolean renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
            float lineWidth = (float)(renderThrough ? Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH_THROUGH.getDoubleValue() : Configs.Visuals.SCHEMATIC_OVERLAY_OUTLINE_WIDTH.getDoubleValue());
            cua.G();
            cua.z();
            cua.r();
            cua.a((int)516, (float)0.001f);
            cua.s();
            cua.a((float)-0.4f, (float)-0.8f);
            cua.d((float)lineWidth);
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            dhq.a((int)dhq.r, (float)240.0f, (float)240.0f);
            if (renderThrough) {
                cua.j();
            }
            this.getWorldRenderer().renderBlockOverlays();
            cua.k();
            cua.a((float)0.0f, (float)0.0f);
            cua.t();
            cua.y();
            cua.H();
        }
    }

    public void startShaderIfEnabled() {
        boolean bl = this.translucentSchematic = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue() && dhq.O;
        if (this.translucentSchematic) {
            float alpha = (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue();
            GL20.glUseProgram((int)SHADER_ALPHA.getProgram());
            GL20.glUniform1f((int)GL20.glGetUniformLocation((int)SHADER_ALPHA.getProgram(), (CharSequence)"alpha_multiplier"), (float)alpha);
        }
    }

    public void disableShader() {
        if (this.translucentSchematic) {
            GL20.glUseProgram((int)0);
        }
    }

    public void piecewisePrepareAndUpdate(float partialTicks) {
        this.renderPiecewise = Configs.Generic.BETTER_RENDER_ORDER.getBooleanValue() && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && this.mc.S() != null;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseBlocks = false;
        if (this.renderPiecewise) {
            boolean invert = Hotkeys.INVERT_GHOST_BLOCK_RENDER_STATE.getKeybind().isKeybindHeld();
            this.renderPiecewiseSchematic = Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue() != invert;
            this.renderPiecewiseBlocks = this.renderPiecewiseSchematic && Configs.Visuals.ENABLE_SCHEMATIC_BLOCKS.getBooleanValue();
            this.mc.y.a("litematica_culling");
            aer entity = this.mc.S();
            cwz icamera = this.createCamera(entity, partialTicks);
            this.calculateFinishTime();
            WorldRendererSchematic worldRenderer = this.getWorldRenderer();
            this.mc.y.c("litematica_terrain_setup");
            worldRenderer.a(entity, partialTicks, icamera, this.frameCount++, this.mc.i.t());
            this.mc.y.c("litematica_update_chunks");
            worldRenderer.a(this.finishTimeNano);
            this.mc.y.e();
            this.renderPiecewisePrepared = true;
        }
    }

    public void piecewiseRenderSolid(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.y.a("litematica_blocks_solid");
            if (renderColliding) {
                cua.s();
                cua.a((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().a(axl.a, partialTicks, this.entity);
            this.disableShader();
            if (renderColliding) {
                cua.a((float)0.0f, (float)0.0f);
                cua.t();
            }
            this.mc.y.e();
        }
    }

    public void piecewiseRenderCutoutMipped(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.y.a("litematica_blocks_cutout_mipped");
            if (renderColliding) {
                cua.s();
                cua.a((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().a(axl.b, partialTicks, this.entity);
            this.disableShader();
            if (renderColliding) {
                cua.a((float)0.0f, (float)0.0f);
                cua.t();
            }
            this.mc.y.e();
        }
    }

    public void piecewiseRenderCutout(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.y.a("litematica_blocks_cutout");
            if (renderColliding) {
                cua.s();
                cua.a((float)-0.3f, (float)-0.6f);
            }
            this.startShaderIfEnabled();
            this.getWorldRenderer().a(axl.c, partialTicks, this.entity);
            this.disableShader();
            if (renderColliding) {
                cua.a((float)0.0f, (float)0.0f);
                cua.t();
            }
            this.mc.y.e();
        }
    }

    public void piecewiseRenderTranslucent(boolean renderColliding, float partialTicks) {
        if (this.renderPiecewisePrepared) {
            if (this.renderPiecewiseBlocks) {
                this.mc.y.a("litematica_translucent");
                if (renderColliding) {
                    cua.s();
                    cua.a((float)-0.3f, (float)-0.6f);
                }
                this.startShaderIfEnabled();
                this.getWorldRenderer().a(axl.d, partialTicks, this.entity);
                this.disableShader();
                if (renderColliding) {
                    cua.a((float)0.0f, (float)0.0f);
                    cua.t();
                }
                this.mc.y.e();
            }
            if (this.renderPiecewiseSchematic) {
                this.mc.y.a("litematica_overlay");
                this.renderSchematicOverlay();
                this.mc.y.e();
            }
            this.cleanup();
        }
    }

    public void piecewiseRenderEntities(float partialTicks) {
        if (this.renderPiecewiseBlocks) {
            this.mc.y.a("litematica_entities");
            RenderUtils.setupBlend();
            this.startShaderIfEnabled();
            this.getWorldRenderer().a(this.entity, this.camera, partialTicks);
            this.disableShader();
            cua.l();
            this.mc.y.e();
        }
    }

    private cwz createCamera(aer entity, float partialTicks) {
        double x = entity.N + (entity.q - entity.N) * (double)partialTicks;
        double y = entity.O + (entity.r - entity.O) * (double)partialTicks;
        double z = entity.P + (entity.s - entity.P) * (double)partialTicks;
        this.entity = entity;
        this.camera = new cxb();
        this.camera.a(x, y, z);
        return this.camera;
    }

    private void cleanup() {
        this.entity = null;
        this.camera = null;
        this.renderPiecewise = false;
        this.renderPiecewisePrepared = false;
        this.renderPiecewiseBlocks = false;
    }

    static {
        int program = SHADER_ALPHA.getProgram();
        GL20.glUseProgram((int)program);
        GL20.glUniform1i((int)GL20.glGetUniformLocation((int)program, (CharSequence)"texture"), (int)0);
        GL20.glUseProgram((int)0);
    }
}

