/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import fi.dy.masa.litematica.materials.MaterialCache;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.ItemType;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MaterialListUtils {
    public static List<MaterialListEntry> createMaterialListFor(LitematicaSchematic schematic) {
        return MaterialListUtils.createMaterialListFor(schematic, schematic.getAreas().keySet());
    }

    public static List<MaterialListEntry> createMaterialListFor(LitematicaSchematic schematic, Collection<String> subRegions) {
        Object2IntOpenHashMap countsTotal = new Object2IntOpenHashMap();
        for (String regionName : subRegions) {
            LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
            if (container == null) continue;
            ff size = container.getSize();
            int sizeX = size.o();
            int sizeY = size.p();
            int sizeZ = size.q();
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        blc state = container.get(x, y, z);
                        countsTotal.addTo((Object)state, 1);
                    }
                }
            }
        }
        cft mc = cft.s();
        return MaterialListUtils.getMaterialList((Object2IntOpenHashMap<blc>)countsTotal, (Object2IntOpenHashMap<blc>)countsTotal, (Object2IntOpenHashMap<blc>)new Object2IntOpenHashMap(), (aog)mc.i);
    }

    public static List<MaterialListEntry> getMaterialList(Object2IntOpenHashMap<blc> countsTotal, Object2IntOpenHashMap<blc> countsMissing, Object2IntOpenHashMap<blc> countsMismatch, aog player) {
        ArrayList<MaterialListEntry> list = new ArrayList<MaterialListEntry>();
        if (!countsTotal.isEmpty()) {
            MaterialCache cache = MaterialCache.getInstance();
            Object2IntOpenHashMap itemTypesTotal = new Object2IntOpenHashMap();
            Object2IntOpenHashMap itemTypesMissing = new Object2IntOpenHashMap();
            Object2IntOpenHashMap itemTypesMismatch = new Object2IntOpenHashMap();
            MaterialListUtils.convertStatesToStacks(countsTotal, (Object2IntOpenHashMap<ItemType>)itemTypesTotal, cache);
            MaterialListUtils.convertStatesToStacks(countsMissing, (Object2IntOpenHashMap<ItemType>)itemTypesMissing, cache);
            MaterialListUtils.convertStatesToStacks(countsMismatch, (Object2IntOpenHashMap<ItemType>)itemTypesMismatch, cache);
            Object2IntOpenHashMap playerInvItems = InventoryUtils.getInventoryItemCounts((ade)player.bB);
            for (ItemType type : itemTypesTotal.keySet()) {
                list.add(new MaterialListEntry(type.getStack().i(), itemTypesTotal.getInt((Object)type), itemTypesMissing.getInt((Object)type), itemTypesMismatch.getInt((Object)type), playerInvItems.getInt((Object)type)));
            }
        }
        return list;
    }

    private static void convertStatesToStacks(Object2IntOpenHashMap<blc> blockStatesIn, Object2IntOpenHashMap<ItemType> itemTypesOut, MaterialCache cache) {
        for (blc state : blockStatesIn.keySet()) {
            if (cache.requiresMultipleItems(state)) {
                for (ate stack : cache.getItems(state)) {
                    ItemType type = new ItemType(stack, false, true);
                    itemTypesOut.addTo((Object)type, blockStatesIn.getInt((Object)state) * stack.C());
                }
                continue;
            }
            ate stack = cache.getItemForState(state);
            if (stack.a()) continue;
            ItemType type = new ItemType(stack, false, true);
            itemTypesOut.addTo((Object)type, blockStatesIn.getInt((Object)state) * stack.C());
        }
    }

    public static void updateAvailableCounts(List<MaterialListEntry> list, aog player) {
        Object2IntOpenHashMap playerInvItems = InventoryUtils.getInventoryItemCounts((ade)player.bB);
        for (MaterialListEntry entry : list) {
            ItemType type = new ItemType(entry.getStack(), false, true);
            int countAvailable = playerInvItems.getInt((Object)type);
            entry.setCountAvailable(countAvailable);
        }
    }
}

