/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.materials.MaterialListBase;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.materials.MaterialListSorter;
import fi.dy.masa.litematica.materials.MaterialListUtils;
import fi.dy.masa.litematica.render.infohud.IInfoHudRenderer;
import fi.dy.masa.litematica.render.infohud.RenderPhase;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Collections;
import java.util.List;

public class MaterialListHudRenderer
implements IInfoHudRenderer {
    protected final MaterialListBase materialList;
    protected final MaterialListSorter sorter;
    protected boolean shouldRender;
    protected long lastUpdateTime;

    public MaterialListHudRenderer(MaterialListBase materialList) {
        this.materialList = materialList;
        this.sorter = new MaterialListSorter(materialList);
    }

    @Override
    public boolean getShouldRenderText(RenderPhase phase) {
        return false;
    }

    @Override
    public boolean getShouldRenderCustom() {
        return this.shouldRender;
    }

    @Override
    public boolean shouldRenderInGuis() {
        return Configs.Generic.RENDER_MATERIALS_IN_GUI.getBooleanValue();
    }

    public void toggleShouldRender() {
        this.shouldRender = !this.shouldRender;
    }

    @Override
    public List<String> getText(RenderPhase phase) {
        return Collections.emptyList();
    }

    @Override
    public int render(int xOffset, int yOffset, HudAlignment alignment) {
        int i;
        List<MaterialListEntry> list;
        cft mc = cft.s();
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastUpdateTime > 2000L) {
            MaterialListUtils.updateAvailableCounts(this.materialList.getMaterialsAll(), (aog)mc.i);
            list = this.materialList.getMaterialsMissingOnly(true);
            Collections.sort(list, this.sorter);
            this.lastUpdateTime = currentTime;
        } else {
            list = this.materialList.getMaterialsMissingOnly(false);
        }
        if (list.size() == 0) {
            return 0;
        }
        cgk font = mc.l;
        double scale = Configs.InfoOverlays.MATERIAL_LIST_HUD_SCALE.getDoubleValue();
        int maxLines = Configs.InfoOverlays.MATERIAL_LIST_HUD_MAX_LINES.getIntegerValue();
        int bgMargin = 2;
        int lineHeight = 16;
        int contentHeight = Math.min(list.size(), maxLines) * lineHeight + bgMargin + 10;
        int maxTextLength = 0;
        int maxCountLength = 0;
        int posX = xOffset + bgMargin;
        int posY = yOffset + bgMargin;
        int bgColor = -1610612736;
        int textColor = -1;
        boolean useBackground = true;
        boolean useShadow = false;
        int size = Math.min(list.size(), maxLines);
        if (scale == 0.0) {
            return 0;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            MaterialListEntry entry = list.get(i2);
            maxTextLength = Math.max(maxTextLength, font.a(entry.getStack().q().getString()));
            int multiplier = this.materialList.getMultiplier();
            int count = multiplier == 1 ? entry.getCountMissing() - entry.getCountAvailable() : entry.getCountTotal();
            String strCount = GuiBase.TXT_RED + this.getFormattedCountString(count *= multiplier, entry.getStack().c()) + GuiBase.TXT_RST;
            maxCountLength = Math.max(maxCountLength, font.a(strCount));
        }
        int maxLineLength = maxTextLength + maxCountLength + 30;
        switch (alignment) {
            case TOP_RIGHT: 
            case BOTTOM_RIGHT: {
                posX = (int)((double)GuiUtils.getScaledWindowWidth() / scale - (double)maxLineLength - (double)xOffset - (double)bgMargin);
                break;
            }
            case CENTER: {
                posX = (int)((double)GuiUtils.getScaledWindowWidth() / scale / 2.0 - (double)(maxLineLength / 2) - (double)xOffset);
                break;
            }
        }
        if (scale != 1.0 && scale != 0.0) {
            yOffset = (int)((double)yOffset / scale);
        }
        posY = RenderUtils.getHudPosY((int)posY, (int)yOffset, (int)contentHeight, (double)scale, (HudAlignment)alignment);
        posY += RenderUtils.getHudOffsetForPotions((HudAlignment)alignment, (double)scale, (aog)mc.i);
        if (scale != 1.0) {
            cua.G();
            cua.a((double)scale, (double)scale, (double)scale);
        }
        if (useBackground) {
            RenderUtils.drawRect((int)(posX - bgMargin), (int)(posY - bgMargin), (int)(maxLineLength + bgMargin * 2), (int)(contentHeight + bgMargin), (int)bgColor);
        }
        String title = GuiBase.TXT_BOLD + StringUtils.translate((String)"litematica.gui.button.material_list", (Object[])new Object[0]) + GuiBase.TXT_RST;
        if (useShadow) {
            font.a(title, (float)(posX + 2), (float)(posY + 2), textColor);
        } else {
            font.b(title, (float)(posX + 2), (float)(posY + 2), textColor);
        }
        int itemCountTextColor = Configs.Colors.MATERIAL_LIST_HUD_ITEM_COUNTS.getIntegerValue();
        int x = posX + 18;
        int y = (posY += 12) + 4;
        for (i = 0; i < size; ++i) {
            MaterialListEntry entry = list.get(i);
            String text = entry.getStack().q().getString();
            int multiplier = this.materialList.getMultiplier();
            int count = multiplier == 1 ? entry.getCountMissing() - entry.getCountAvailable() : entry.getCountTotal();
            String strCount = this.getFormattedCountString(count *= multiplier, entry.getStack().c());
            int cntLen = font.a(strCount);
            int cntPosX = posX + maxLineLength - cntLen - 2;
            if (useShadow) {
                font.a(text, (float)x, (float)y, textColor);
                font.a(strCount, (float)cntPosX, (float)y, itemCountTextColor);
            } else {
                font.b(text, (float)x, (float)y, textColor);
                font.b(strCount, (float)cntPosX, (float)y, itemCountTextColor);
            }
            y += lineHeight;
        }
        x = posX;
        y = posY;
        cua.D();
        RenderUtils.setupBlend();
        RenderUtils.enableGuiItemLighting();
        for (i = 0; i < size; ++i) {
            mc.V().a((afa)mc.i, list.get(i).getStack(), x, y);
            y += lineHeight;
        }
        RenderUtils.disableItemLighting();
        cua.E();
        cua.l();
        if (scale != 1.0) {
            cua.H();
        }
        return contentHeight + 4;
    }

    protected String getFormattedCountString(int count, int maxStackSize) {
        int stacks = count / maxStackSize;
        int remainder = count % maxStackSize;
        double boxCount = (double)count / (27.0 * (double)maxStackSize);
        if (count > maxStackSize) {
            if (boxCount >= 1.0) {
                return String.format("%d (%.2f %s)", count, boxCount, StringUtils.translate((String)"litematica.gui.label.material_list.abbr.shulker_box", (Object[])new Object[0]));
            }
            if (remainder > 0) {
                return String.format("%d (%d x %d + %d)", count, stacks, maxStackSize, remainder);
            }
            return String.format("%d (%d x %d)", count, stacks, maxStackSize);
        }
        return String.format("%d", count);
    }
}

