/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.materials;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public class MaterialCache {
    private static final MaterialCache INSTANCE = new MaterialCache();
    protected final IdentityHashMap<blc, ate> itemsForStates = new IdentityHashMap();
    protected final WorldSchematic tempWorld;
    protected final el checkPos;
    protected boolean hasReadFromFile;
    protected boolean dirty;

    private MaterialCache() {
        ayd settings = new ayd(0L, axv.c, false, false, ayg.c);
        this.tempWorld = new WorldSchematic(null, settings, bod.b, adi.a, cft.s().y);
        this.checkPos = new el(8, 0, 8);
        WorldUtils.loadChunksSchematicWorld(this.tempWorld, this.checkPos, new ff(1, 1, 1));
    }

    public static MaterialCache getInstance() {
        if (!MaterialCache.INSTANCE.hasReadFromFile) {
            INSTANCE.readFromFile();
        }
        return INSTANCE;
    }

    public void clearCache() {
        this.itemsForStates.clear();
    }

    public ate getItemForState(blc state) {
        return this.getItemForState(state, (axy)this.tempWorld, this.checkPos);
    }

    public ate getItemForState(blc state, axy world, el pos) {
        ate stack = this.itemsForStates.get(state);
        if (stack == null) {
            stack = this.getItemForStateFromWorld(state, world, pos);
        }
        return stack;
    }

    protected ate getItemForStateFromWorld(blc state, axy world, el pos) {
        ate stack = this.getStateToItemOverride(state);
        if (stack == null) {
            world.a(pos, state, 20);
            stack = state.c().a((axk)world, pos, state);
        }
        if (stack == null || stack.a()) {
            stack = ate.a;
        } else {
            this.overrideStackSize(state, stack);
        }
        this.itemsForStates.put(state, stack);
        this.dirty = true;
        return stack;
    }

    public boolean requiresMultipleItems(blc state) {
        bcs block = state.c();
        return block instanceof bev && block != bct.ex;
    }

    public ImmutableList<ate> getItems(blc state) {
        return this.getItems(state, (axy)this.tempWorld, this.checkPos);
    }

    public ImmutableList<ate> getItems(blc state, axy world, el pos) {
        bcs block = state.c();
        if (block instanceof bev && block != bct.ex) {
            return ImmutableList.of((Object)new ate((axx)bct.ex), (Object)block.a((axk)world, pos, state));
        }
        return ImmutableList.of((Object)this.getItemForState(state, world, pos));
    }

    @Nullable
    protected ate getStateToItemOverride(blc state) {
        bcs block = state.c();
        if (block == bct.aX || block == bct.aX || block == bct.dh || block == bct.ee || block == bct.ig) {
            return ate.a;
        }
        if (block == bct.cq) {
            return new ate((axx)bct.j);
        }
        if (block == bct.dC) {
            return new ate((axx)bct.dC);
        }
        if (block == bct.dD) {
            return new ate((axx)bct.dD);
        }
        if (block == bct.C) {
            if ((Integer)state.c((bmm)bfu.a) == 0) {
                return new ate((axx)atf.ay);
            }
            return ate.a;
        }
        if (block == bct.A) {
            if ((Integer)state.c((bmm)bfu.a) == 0) {
                return new ate((axx)atf.ax);
            }
            return ate.a;
        }
        if (block instanceof bed && state.c((bmm)bed.p) == bmg.a) {
            return ate.a;
        }
        if (block instanceof bcq && state.c((bmm)bcq.a) == blz.a) {
            return ate.a;
        }
        if (block instanceof bee && state.c((bmm)bee.a) == bmg.a) {
            return ate.a;
        }
        return null;
    }

    protected void overrideStackSize(blc state, ate stack) {
        if (state.c() instanceof bhl && state.c((bmm)bhl.a) == bmp.c) {
            stack.e(2);
        } else if (state.c() == bct.cQ) {
            stack.e(((Integer)state.c((bmm)bho.a)).intValue());
        }
    }

    protected gy writeToNBT() {
        gy nbt = new gy();
        he list = new he();
        for (Map.Entry<blc, ate> entry : this.itemsForStates.entrySet()) {
            gy tag = new gy();
            gy stateTag = hk.a((blc)entry.getKey());
            tag.a("Block", (ho)stateTag);
            tag.a("Item", (ho)entry.getValue().b(new gy()));
            list.a((ho)tag);
        }
        nbt.a("MaterialCache", (ho)list);
        return nbt;
    }

    protected boolean readFromNBT(gy nbt) {
        this.itemsForStates.clear();
        if (nbt.c("MaterialCache", 9)) {
            he list = nbt.d("MaterialCache", 10);
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                blc state;
                gy tag = list.e(i);
                if (!tag.c("Block", 10) || !tag.c("Item", 10) || (state = hk.d((gy)tag.p("Block"))) == null) continue;
                ate stack = ate.a((gy)tag.p("Item"));
                this.itemsForStates.put(state, stack);
            }
            return true;
        }
        return false;
    }

    protected File getCacheDir() {
        return new File(FileUtils.getConfigDirectory(), "litematica");
    }

    protected File getCacheFile() {
        return new File(this.getCacheDir(), "material_cache.nbt");
    }

    public boolean writeToFile() {
        if (!this.dirty) {
            return false;
        }
        File dir = this.getCacheDir();
        File file = this.getCacheFile();
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath());
                return false;
            }
            FileOutputStream os = new FileOutputStream(file);
            hi.a((gy)this.writeToNBT(), (OutputStream)os);
            os.close();
            this.dirty = false;
            return true;
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to write the material list cache to file '{}'", (Object)file.getAbsolutePath(), (Object)e);
            return false;
        }
    }

    public void readFromFile() {
        File file = this.getCacheFile();
        if (!file.exists() || !file.canRead()) {
            return;
        }
        try {
            FileInputStream is = new FileInputStream(file);
            gy nbt = hi.a((InputStream)is);
            is.close();
            if (nbt != null) {
                this.readFromNBT(nbt);
                this.hasReadFromFile = true;
                this.dirty = false;
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("Failed to read the material list cache from file '{}'", (Object)file.getAbsolutePath(), (Object)e);
        }
    }
}

