/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.event;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.gui.GuiSchematicManager;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.selection.SelectionManager;
import fi.dy.masa.litematica.tool.ToolMode;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.SchematicUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IKeyboardInputHandler;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;

public class InputHandler
implements IKeybindProvider,
IKeyboardInputHandler,
IMouseInputHandler {
    private static final InputHandler INSTANCE = new InputHandler();

    private InputHandler() {
    }

    public static InputHandler getInstance() {
        return INSTANCE;
    }

    public void addKeysToMap(IKeybindManager manager) {
        for (IHotkey iHotkey : Hotkeys.HOTKEY_LIST) {
            manager.addKeybindToMap(iHotkey.getKeybind());
        }
    }

    public void addHotkeys(IKeybindManager manager) {
        manager.addHotkeysForCategory("Litematica", "litematica.hotkeys.category.generic_hotkeys", Hotkeys.HOTKEY_LIST);
    }

    public boolean onKeyInput(int keyCode, int scanCode, int modifiers, boolean eventKeyState) {
        if (eventKeyState) {
            cft mc = cft.s();
            if (mc.t.ah.a(keyCode, scanCode)) {
                return this.handleUseKey(mc);
            }
            if (mc.t.ai.a(keyCode, scanCode)) {
                return this.handleAttackKey(mc);
            }
            if (mc.t.an.a(keyCode, scanCode) && GuiSchematicManager.hasPendingPreviewTask()) {
                return GuiSchematicManager.setPreviewImage();
            }
        }
        return false;
    }

    public boolean onMouseClick(int mouseX, int mouseY, int eventButton, boolean eventButtonState) {
        cft mc = cft.s();
        if (GuiUtils.getCurrentScreen() == null && mc.g != null && mc.i != null && eventButtonState) {
            if (eventButtonState && mc.t.ah.a(eventButton)) {
                return this.handleUseKey(mc);
            }
            if (eventButtonState && mc.t.ai.a(eventButton)) {
                return this.handleAttackKey(mc);
            }
        }
        return false;
    }

    public boolean onMouseScroll(int mouseX, int mouseY, double dWheel) {
        cft mc = cft.s();
        if (GuiUtils.getCurrentScreen() == null && mc.g != null && mc.i != null) {
            return this.handleMouseScroll(dWheel, mc);
        }
        return false;
    }

    private boolean handleMouseScroll(double dWheel, cft mc) {
        boolean toolEnabled;
        ctj player = mc.i;
        boolean bl = toolEnabled = Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Generic.TOOL_ITEM_ENABLED.getBooleanValue();
        if (!toolEnabled || !EntityUtils.hasToolItem((afa)player)) {
            return false;
        }
        int amount = dWheel > 0.0 ? 1 : -1;
        ToolMode mode = DataManager.getToolMode();
        if (Hotkeys.SELECTION_GRAB_MODIFIER.getKeybind().isKeybindHeld() && mode.getUsesAreaSelection()) {
            SelectionManager sm = DataManager.getSelectionManager();
            if (sm.hasGrabbedElement()) {
                sm.changeGrabDistance((aer)player, amount);
                return true;
            }
            if (sm.hasSelectedOrigin()) {
                AreaSelection area = sm.getCurrentSelection();
                el old = area.getEffectiveOrigin();
                area.moveEntireSelectionTo(old.a(EntityUtils.getClosestLookingDirection((aer)player), amount), false);
                return true;
            }
            if (mode == ToolMode.MOVE) {
                SchematicUtils.moveCurrentlySelectedWorldRegionToLookingDirection(amount, (aog)player, mc);
                return true;
            }
        }
        if (Hotkeys.SELECTION_GROW_MODIFIER.getKeybind().isKeybindHeld()) {
            return this.growOrShrinkSelection(amount, mode);
        }
        if (Hotkeys.SELECTION_NUDGE_MODIFIER.getKeybind().isKeybindHeld()) {
            return InputHandler.nudgeSelection(amount, mode, (aog)player);
        }
        if (Hotkeys.OPERATION_MODE_CHANGE_MODIFIER.getKeybind().isKeybindHeld()) {
            DataManager.setToolMode(DataManager.getToolMode().cycle((aog)player, amount < 0));
            return true;
        }
        if (Hotkeys.SCHEMATIC_VERSION_CYCLE_MODIFIER.getKeybind().isKeybindHeld()) {
            if (DataManager.getSchematicProjectsManager().hasProjectOpen()) {
                DataManager.getSchematicProjectsManager().cycleVersion(amount * -1);
            }
            return true;
        }
        return false;
    }

    public static boolean nudgeSelection(int amount, ToolMode mode, aog player) {
        if (mode.getUsesAreaSelection()) {
            SelectionManager sm = DataManager.getSelectionManager();
            if (sm.hasSelectedElement()) {
                sm.moveSelectedElement(EntityUtils.getClosestLookingDirection((aer)player), amount);
                return true;
            }
        } else if (mode.getUsesSchematic()) {
            eq direction = EntityUtils.getClosestLookingDirection((aer)player);
            DataManager.getSchematicPlacementManager().nudgePositionOfCurrentSelection(direction, amount);
            return true;
        }
        return false;
    }

    private boolean growOrShrinkSelection(int amount, ToolMode mode) {
        if (mode.getUsesAreaSelection()) {
            SelectionManager sm = DataManager.getSelectionManager();
            AreaSelection area = sm.getCurrentSelection();
            if (area != null) {
                Box box = area.getSelectedSubRegionBox();
                if (box != null) {
                    Box newBox = PositionUtils.growOrShrinkBox(box, amount);
                    area.setSelectedSubRegionCornerPos(newBox.getPos1(), PositionUtils.Corner.CORNER_1);
                    area.setSelectedSubRegionCornerPos(newBox.getPos2(), PositionUtils.Corner.CORNER_2);
                } else {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.area_selection.grow.no_sub_region_selected", (Object[])new Object[0]);
                }
            } else {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.message.error.no_area_selected", (Object[])new Object[0]);
            }
        }
        return true;
    }

    private boolean handleAttackKey(cft mc) {
        if (mc.i != null && DataManager.getToolMode() == ToolMode.REBUILD && KeybindMulti.getTriggeredCount() == 0) {
            if (Hotkeys.SCHEMATIC_REBUILD_BREAK_DIRECTION.getKeybind().isKeybindHeld()) {
                return SchematicUtils.breakSchematicBlocks(mc);
            }
            if (Hotkeys.SCHEMATIC_REBUILD_BREAK_ALL.getKeybind().isKeybindHeld()) {
                return SchematicUtils.breakAllIdenticalSchematicBlocks(mc);
            }
            return SchematicUtils.breakSchematicBlock(mc);
        }
        return false;
    }

    private boolean handleUseKey(cft mc) {
        if (mc.i != null) {
            if (DataManager.getToolMode() == ToolMode.REBUILD && KeybindMulti.getTriggeredCount() == 0) {
                if (Hotkeys.SCHEMATIC_REBUILD_REPLACE_DIRECTION.getKeybind().isKeybindHeld()) {
                    return SchematicUtils.replaceSchematicBlocksInDirection(mc);
                }
                if (Hotkeys.SCHEMATIC_REBUILD_REPLACE_ALL.getKeybind().isKeybindHeld()) {
                    return SchematicUtils.replaceAllIdenticalSchematicBlocks(mc);
                }
                if (Hotkeys.SCHEMATIC_REBUILD_BREAK_DIRECTION.getKeybind().isKeybindHeld()) {
                    return SchematicUtils.placeSchematicBlocksInDirection(mc);
                }
                if (Hotkeys.SCHEMATIC_REBUILD_BREAK_ALL.getKeybind().isKeybindHeld()) {
                    return SchematicUtils.fillAirWithBlocks(mc);
                }
                return SchematicUtils.placeSchematicBlock(mc);
            }
            if (Configs.Generic.EASY_PLACE_MODE.getBooleanValue() && Hotkeys.EASY_PLACE_ACTIVATION.getKeybind().isKeybindHeld()) {
                return WorldUtils.handleEasyPlace(mc);
            }
            if (Configs.Generic.PICK_BLOCK_ENABLED.getBooleanValue() && KeybindMulti.hotkeyMatchesKeybind((IHotkey)Hotkeys.PICK_BLOCK_LAST, (cfp)mc.t.ah)) {
                WorldUtils.doSchematicWorldPickBlock(false, mc);
            }
            if (Configs.Generic.PLACEMENT_RESTRICTION.getBooleanValue()) {
                return WorldUtils.handlePlacementRestriction(mc);
            }
        }
        return false;
    }

    public static void onTick(cft mc) {
        SelectionManager sm = DataManager.getSelectionManager();
        if (sm.hasGrabbedElement()) {
            sm.moveGrabbedElement((aer)mc.i);
        } else {
            WorldUtils.easyPlaceOnUseTick(mc);
        }
    }
}

