/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import fi.dy.masa.malilib.util.IntBoundingBox;
import java.util.Random;
import javax.annotation.Nullable;

public class MiscUtils {
    private static final Random RAND = new Random();

    public static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static boolean canSlimeSpawnAt(int posX, int posZ, long worldSeed) {
        return MiscUtils.canSlimeSpawnInChunk(posX >> 4, posZ >> 4, worldSeed);
    }

    public static boolean canSlimeSpawnInChunk(int chunkX, int chunkZ, long worldSeed) {
        long slimeSeed = 987234911L;
        long rngSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ slimeSeed;
        RAND.setSeed(rngSeed);
        return RAND.nextInt(10) == 0;
    }

    public static boolean isStructureWithinRange(@Nullable bwf bb, el playerPos, int maxRange) {
        return bb != null && playerPos.o() >= bb.a - maxRange && playerPos.o() <= bb.d + maxRange && playerPos.q() >= bb.c - maxRange && playerPos.q() <= bb.f + maxRange;
    }

    public static boolean isStructureWithinRange(@Nullable IntBoundingBox bb, el playerPos, int maxRange) {
        return bb != null && playerPos.o() >= bb.minX - maxRange && playerPos.o() <= bb.maxX + maxRange && playerPos.q() >= bb.minZ - maxRange && playerPos.q() <= bb.maxZ + maxRange;
    }

    public static boolean areBoxesEqual(IntBoundingBox bb1, IntBoundingBox bb2) {
        return bb1.minX == bb2.minX && bb1.minY == bb2.minY && bb1.minZ == bb2.minZ && bb1.maxX == bb2.maxX && bb1.maxY == bb2.maxY && bb1.maxZ == bb2.maxZ;
    }
}

