/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.MapMaker;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinDebugRenderer;
import fi.dy.masa.minihud.mixin.IMixinPathNavigate;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import net.minecraft.server.MinecraftServer;

public class DebugInfoUtils {
    private static boolean neighborUpdateEnabled;
    private static boolean pathfindingEnabled;
    private static int tickCounter;
    private static final Map<aer, cbe> OLD_PATHS;

    public static void sendPacketDebugPath(MinecraftServer server, int entityId, cbe path, float maxDistance) {
        hy buffer = new hy(Unpooled.buffer());
        buffer.writeInt(entityId);
        buffer.writeFloat(maxDistance);
        DebugInfoUtils.writePathToBuffer(buffer, path);
        jy packet = new jy(jy.d, buffer);
        server.ac().a((iv)packet);
    }

    private static void writePathPointToBuffer(hy buf, cbc point) {
        buf.writeInt(point.a);
        buf.writeInt(point.b);
        buf.writeInt(point.c);
        buf.writeFloat(point.j);
        buf.writeFloat(point.k);
        buf.writeFloat(point.l);
        buf.writeBoolean(point.i);
        buf.writeInt(point.m.ordinal());
        buf.writeFloat(point.g);
    }

    public static hy writePathTobuffer(cbe path) {
        hy buffer = new hy(Unpooled.buffer());
        DebugInfoUtils.writePathToBuffer(buffer, path);
        return buffer;
    }

    private static void writePathToBuffer(hy buf, cbe path) {
        cbc target = path.c();
        if (target != null) {
            buf.writeInt(path.e());
            DebugInfoUtils.writePathPointToBuffer(buf, target);
            int countTotal = path.d();
            ArrayList<cbc> openSet = new ArrayList<cbc>();
            ArrayList<cbc> closedSet = new ArrayList<cbc>();
            ArrayList<cbc> allSet = new ArrayList<cbc>();
            for (int i = 0; i < countTotal; ++i) {
                cbc point = path.a(i);
                if (point.m.a() < 0.0f) {
                    closedSet.add(point);
                } else if (point.m.a() > 0.0f) {
                    openSet.add(point);
                }
                allSet.add(point);
            }
            buf.writeInt(allSet.size());
            for (cbc point : allSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(openSet.size());
            for (cbc point : openSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(closedSet.size());
            for (cbc point : closedSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
        }
    }

    public static void onNeighborNotify(axy world, final el pos, final EnumSet<eq> notifiedSides) {
        if (neighborUpdateEnabled && !world.B) {
            final long time = world.V();
            cft.s().a(new Runnable(){

                @Override
                public void run() {
                    for (eq side : notifiedSides) {
                        ((cxk)cft.s().o.f).a(time, pos.a(side));
                    }
                }
            });
        }
    }

    public static void onServerTickEnd(MinecraftServer server) {
        cft mc = cft.s();
        if (pathfindingEnabled && mc.g != null && ++tickCounter >= 10) {
            tickCounter = 0;
            td world = server.a(mc.g.t.q());
            if (world != null) {
                for (aer entity : world.f) {
                    boolean isSamepath;
                    aiw navigator = entity instanceof afb ? ((afb)entity).t() : null;
                    if (navigator == null || !DebugInfoUtils.isAnyPlayerWithinRange((axy)world, entity, 64.0)) continue;
                    cbe path = navigator.m();
                    cbe old = OLD_PATHS.get(entity);
                    if (path == null) continue;
                    boolean bl = isSamepath = old != null && old.a(path);
                    if (old != null && isSamepath && old.e() == path.e()) continue;
                    int id = entity.Q();
                    float maxDistance = Configs.Generic.DEBUG_RENDERER_PATH_MAX_DIST.getBooleanValue() ? ((IMixinPathNavigate)navigator).getMaxDistanceToWaypoint() : 0.0f;
                    DebugInfoUtils.sendPacketDebugPath(server, id, path, maxDistance);
                    if (!isSamepath) {
                        hy buf = DebugInfoUtils.writePathTobuffer(path);
                        OLD_PATHS.put(entity, cbe.b((hy)buf));
                        continue;
                    }
                    if (old == null) continue;
                    old.c(path.e());
                }
            }
        }
    }

    private static boolean isAnyPlayerWithinRange(axy world, aer entity, double range) {
        for (int i = 0; i < world.j.size(); ++i) {
            aog player = (aog)world.j.get(i);
            double distSq = player.d(entity.q, entity.r, entity.s);
            if (!(range < 0.0) && !(distSq < range * range)) continue;
            return true;
        }
        return false;
    }

    public static void toggleDebugRenderer(RendererToggle config) {
        cft mc = cft.s();
        boolean enabled = config.getBooleanValue();
        if (config == RendererToggle.DEBUG_COLLISION_BOXES) {
            ((IMixinDebugRenderer)mc.o).setCollisionBoxEnabled(enabled);
        } else if (config != RendererToggle.DEBUG_HEIGHT_MAP) {
            if (config == RendererToggle.DEBUG_NEIGHBOR_UPDATES) {
                ((IMixinDebugRenderer)mc.o).setNeighborsUpdateEnabled(enabled);
                neighborUpdateEnabled = enabled;
            } else if (config == RendererToggle.DEBUG_PATH_FINDING) {
                ((IMixinDebugRenderer)mc.o).setPathfindingEnabled(enabled);
                pathfindingEnabled = enabled;
            } else if (config == RendererToggle.DEBUG_SOLID_FACES) {
                ((IMixinDebugRenderer)mc.o).setSolidFaceEnabled(enabled);
            } else if (config == RendererToggle.DEBUG_WATER) {
                ((IMixinDebugRenderer)mc.o).setWaterEnabled(enabled);
            }
        }
    }

    static {
        OLD_PATHS = new MapMaker().weakKeys().weakValues().makeMap();
    }
}

