/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.renderer.OverlayRendererLightLevel;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class DataStorage {
    private static final Pattern PATTERN_CARPET_TPS = Pattern.compile("TPS: (?<tps>[0-9]+[\\.,][0-9]) MSPT: (?<mspt>[0-9]+[\\.,][0-9])");
    private static final DataStorage INSTANCE = new DataStorage();
    public static final int CARPET_ID_BOUNDINGBOX_MARKERS = 3;
    public static final int CARPET_ID_LARGE_BOUNDINGBOX_MARKERS_START = 7;
    public static final int CARPET_ID_LARGE_BOUNDINGBOX_MARKERS = 8;
    private boolean worldSeedValid;
    private boolean serverTPSValid;
    private boolean carpetServer;
    private boolean worldSpawnValid;
    private boolean structuresDirty;
    private boolean structuresNeedUpdating;
    private long worldSeed;
    private long lastServerTick;
    private long lastServerTimeUpdate;
    private el lastStructureUpdatePos;
    private double serverTPS;
    private double serverMSPT;
    private el worldSpawn = el.a;
    private cee distanceReferencePoint = cee.a;
    private final Set<axm> chunkHeightmapsToCheck = new HashSet<axm>();
    private final Map<axm, Integer> spawnableSubChunks = new HashMap<axm, Integer>();
    private final ArrayListMultimap<StructureType, StructureData> structures = ArrayListMultimap.create();
    private final cft mc = cft.s();

    public static DataStorage getInstance() {
        return INSTANCE;
    }

    public void reset() {
        this.worldSeedValid = false;
        this.serverTPSValid = false;
        this.carpetServer = false;
        this.worldSpawnValid = false;
        this.structuresNeedUpdating = true;
        this.structuresDirty = false;
        this.lastStructureUpdatePos = null;
        this.structures.clear();
        this.worldSeed = 0L;
        this.worldSpawn = el.a;
    }

    public void setWorldSeed(long seed) {
        this.worldSeed = seed;
        this.worldSeedValid = true;
    }

    public void setWorldSpawn(el spawn) {
        this.worldSpawn = spawn;
        this.worldSpawnValid = true;
    }

    public void setWorldSpawnIfUnknown(el spawn) {
        if (!this.worldSpawnValid) {
            this.setWorldSpawn(spawn);
        }
    }

    public boolean isWorldSeedKnown(bod dimension) {
        if (this.worldSeedValid) {
            return true;
        }
        if (this.mc.x()) {
            dgh server = this.mc.y();
            td worldTmp = server.a(dimension);
            return worldTmp != null;
        }
        return false;
    }

    public long getWorldSeed(bod dimension) {
        dgh server;
        td worldTmp;
        if (!this.worldSeedValid && this.mc.x() && (worldTmp = (server = this.mc.y()).a(dimension)) != null) {
            this.setWorldSeed(worldTmp.r_());
        }
        return this.worldSeed;
    }

    public boolean isWorldSpawnKnown() {
        return this.worldSpawnValid;
    }

    public el getWorldSpawn() {
        return this.worldSpawn;
    }

    public boolean isServerTPSValid() {
        return this.serverTPSValid;
    }

    public boolean isCarpetServer() {
        return this.carpetServer;
    }

    public double getServerTPS() {
        return this.serverTPS;
    }

    public double getServerMSPT() {
        return this.serverMSPT;
    }

    public boolean hasStructureDataChanged() {
        return this.structuresDirty;
    }

    public void setStructuresNeedUpdating() {
        this.structuresNeedUpdating = true;
    }

    public void setStructuresDirty() {
        this.structuresDirty = true;
    }

    public cee getDistanceReferencePoint() {
        return this.distanceReferencePoint;
    }

    public void setDistanceReferencePoint(cee pos) {
        this.distanceReferencePoint = pos;
        String str = String.format("x: %.2f, y: %.2f, z: %.2f", pos.b, pos.c, pos.d);
        InfoUtils.printActionbarMessage((String)"minihud.message.distance_reference_point_set", (Object[])new Object[]{str});
    }

    public void markChunkForHeightmapCheck(int chunkX, int chunkZ) {
        OverlayRendererSpawnableColumnHeights.markChunkChanged(chunkX, chunkZ);
        this.chunkHeightmapsToCheck.add(new axm(chunkX, chunkZ));
        OverlayRendererLightLevel.setNeedsUpdate();
    }

    public void checkQueuedDirtyChunkHeightmaps() {
        crg world = this.mc.g;
        if (world != null) {
            if (!this.chunkHeightmapsToCheck.isEmpty()) {
                for (axm pos : this.chunkHeightmapsToCheck) {
                    bnj chunk = world.c(pos.a, pos.b);
                    bor hm = chunk.b(bor.a.c);
                    int maxHeight = -1;
                    for (int x = 0; x < 16; ++x) {
                        for (int z = 0; z < 16; ++z) {
                            int h = hm.a(x, z);
                            if (h <= maxHeight) continue;
                            maxHeight = h;
                        }
                    }
                    int subChunks = maxHeight >= 0 ? xq.a((int)(maxHeight / 16 + 1), (int)1, (int)16) : xq.a((int)((chunk.b() + 16) / 16), (int)1, (int)16);
                    this.spawnableSubChunks.put(pos, subChunks);
                }
            }
        } else {
            this.spawnableSubChunks.clear();
        }
        this.chunkHeightmapsToCheck.clear();
    }

    public void onChunkUnload(int chunkX, int chunkZ) {
        axm pos = new axm(chunkX, chunkZ);
        this.chunkHeightmapsToCheck.remove(pos);
        this.spawnableSubChunks.remove(pos);
    }

    public int getSpawnableSubChunkCountFor(int chunkX, int chunkZ) {
        Integer count = this.spawnableSubChunks.get(new axm(chunkX, chunkZ));
        return count != null ? count : -1;
    }

    public boolean onSendChatMessage(aog player, String message) {
        String[] parts = message.split(" ");
        if (parts[0].equals("minihud-seed")) {
            if (parts.length == 2) {
                try {
                    this.setWorldSeed(Long.parseLong(parts[1]));
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (NumberFormatException e) {
                    InfoUtils.printActionbarMessage((String)"minihud.message.error.invalid_seed", (Object[])new Object[0]);
                }
            } else if (this.worldSeedValid && parts.length == 1) {
                InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
            }
            return true;
        }
        return false;
    }

    public void onChatMessage(ij message) {
        if (message instanceof ir) {
            ir text = (ir)message;
            if ("commands.seed.success".equals(text.k())) {
                try {
                    String str = text.getString();
                    int i1 = str.indexOf("[");
                    int i2 = str.indexOf("]");
                    if (i1 != -1 && i2 != -1) {
                        this.setWorldSeed(Long.parseLong(str.substring(i1 + 1, i2)));
                        MiniHUD.logger.info("Received world seed from the vanilla /seed command: {}", (Object)this.worldSeed);
                        InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                    }
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world seed from '{}'", text.l()[0], (Object)e);
                }
            } else if ("jed.commands.seed.success".equals(text.k())) {
                try {
                    this.setWorldSeed(Long.parseLong(text.l()[1].toString()));
                    MiniHUD.logger.info("Received world seed from the JED '/jed seed' command: {}", (Object)this.worldSeed);
                    InfoUtils.printActionbarMessage((String)"minihud.message.seed_set", (Object[])new Object[]{this.worldSeed});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world seed from '{}'", text.l()[1], (Object)e);
                }
            } else if ("commands.setworldspawn.success".equals(text.k()) && text.l().length == 3) {
                try {
                    Object[] o = text.l();
                    int x = Integer.parseInt(o[0].toString());
                    int y = Integer.parseInt(o[1].toString());
                    int z = Integer.parseInt(o[2].toString());
                    this.setWorldSpawn(new el(x, y, z));
                    String spawnStr = String.format("x: %d, y: %d, z: %d", this.worldSpawn.o(), this.worldSpawn.p(), this.worldSpawn.q());
                    MiniHUD.logger.info("Received world spawn from the vanilla /setworldspawn command: {}", (Object)spawnStr);
                    InfoUtils.printActionbarMessage((String)"minihud.message.spawn_set", (Object[])new Object[]{spawnStr});
                }
                catch (Exception e) {
                    MiniHUD.logger.warn("Failed to read the world spawn point from '{}'", (Object)text.l(), (Object)e);
                }
            }
        }
    }

    public void onServerTimeUpdate(long totalWorldTime) {
        if (!this.carpetServer && !this.mc.x()) {
            long elapsedTicks;
            long currentTime = System.nanoTime();
            if (this.serverTPSValid && (elapsedTicks = totalWorldTime - this.lastServerTick) > 0L) {
                this.serverMSPT = (double)(currentTime - this.lastServerTimeUpdate) / (double)elapsedTicks / 1000000.0;
                this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
            }
            this.lastServerTick = totalWorldTime;
            this.lastServerTimeUpdate = currentTime;
            this.serverTPSValid = true;
        }
    }

    public void updateIntegratedServerTPS() {
        if (this.mc != null && this.mc.i != null && this.mc.y() != null) {
            this.serverMSPT = xq.a((long[])this.mc.y().d) / 1000000.0;
            this.serverTPS = this.serverMSPT <= 50.0 ? 20.0 : 1000.0 / this.serverMSPT;
            this.serverTPSValid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayListMultimap<StructureType, StructureData> getCopyOfStructureData() {
        ArrayListMultimap copy = ArrayListMultimap.create();
        ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
        synchronized (arrayListMultimap) {
            for (StructureType type : StructureType.values()) {
                List values = this.structures.get((Object)type);
                if (values.isEmpty()) continue;
                copy.putAll((Object)type, (Iterable)values);
            }
            this.structuresDirty = false;
        }
        return copy;
    }

    public void requestStructureDataFromServer() {
        if (!cft.s().x()) {
            // empty if block
        }
    }

    public void updateStructureData() {
        if (this.mc != null && this.mc.g != null && this.mc.i != null) {
            el playerPos = new el((aer)this.mc.i);
            if (this.mc.x()) {
                if (this.structuresNeedUpdating(playerPos, 32)) {
                    this.updateStructureDataFromIntegratedServer(playerPos);
                }
            } else if (this.structuresNeedUpdating(playerPos, 256)) {
                this.requestStructureDataFromServer();
            }
        }
    }

    private boolean structuresNeedUpdating(el playerPos, int hysteresis) {
        return this.structuresNeedUpdating || this.lastStructureUpdatePos == null || Math.abs(playerPos.o() - this.lastStructureUpdatePos.o()) >= hysteresis || Math.abs(playerPos.p() - this.lastStructureUpdatePos.p()) >= hysteresis || Math.abs(playerPos.q() - this.lastStructureUpdatePos.q()) >= hysteresis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStructureDataFromIntegratedServer(final el playerPos) {
        bod dimension = this.mc.i.ap;
        td world = this.mc.y().a(dimension);
        ArrayListMultimap<StructureType, StructureData> arrayListMultimap = this.structures;
        synchronized (arrayListMultimap) {
            this.structures.clear();
        }
        if (world != null) {
            final bmy chunkGenerator = world.v().f();
            final bod dimensionType = world.t.q();
            final DataStorage storage = this;
            final int maxRange = (this.mc.t.e + 4) * 16;
            world.a(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ArrayListMultimap arrayListMultimap = storage.structures;
                    synchronized (arrayListMultimap) {
                        storage.addStructureDataFromGenerator(chunkGenerator, dimensionType, playerPos, maxRange);
                    }
                }
            });
        }
        this.lastStructureUpdatePos = playerPos;
        this.structuresNeedUpdating = false;
    }

    private void addStructureDataFromGenerator(bmy<?> chunkGenerator, bod dimensionType, el playerPos, int maxRange) {
        for (StructureType type : StructureType.values()) {
            if (!type.isEnabled() || !type.existsInDimension(dimensionType)) continue;
            this.addStructuresWithinRange(type, chunkGenerator, playerPos, maxRange);
        }
        this.structuresDirty = true;
    }

    private void addStructuresWithinRange(StructureType type, bmy<?> chunkGen, el playerPos, int maxRange) {
        Long2ObjectMap structureMap = chunkGen.a(type.getStructure());
        for (bxc start : structureMap.values()) {
            if (!MiscUtils.isStructureWithinRange(start.c(), playerPos, maxRange)) continue;
            this.structures.put((Object)type, (Object)StructureData.fromStructure(start));
        }
    }

    public void handleCarpetServerTPSData(ij textComponent) {
        if (!textComponent.e().isEmpty()) {
            String[] lines;
            String text = a.b((String)textComponent.getString());
            for (String line : lines = text.split("\n")) {
                Matcher matcher = PATTERN_CARPET_TPS.matcher(line);
                if (!matcher.matches()) continue;
                try {
                    this.serverTPS = Double.parseDouble(matcher.group("tps"));
                    this.serverMSPT = Double.parseDouble(matcher.group("mspt"));
                    this.serverTPSValid = true;
                    this.carpetServer = true;
                    return;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        this.serverTPSValid = false;
    }

    @Nullable
    private File getLocalStructureFileDirectory() {
        String dirName = StringUtils.getWorldOrServerName();
        if (dirName != null) {
            File dir = new File(new File(FileUtils.getConfigDirectory(), "minihud"), "structures");
            return new File(dir, dirName);
        }
        return null;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("distance_pos", (JsonElement)JsonUtils.vec3dToJson((cee)this.distanceReferencePoint));
        return obj;
    }

    public void fromJson(JsonObject obj) {
        cee pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"distance_pos");
        this.distanceReferencePoint = pos != null ? pos : cee.a;
    }
}

