/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.BlockSnap;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.Quadrant;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class ShapeDespawnSphere
extends ShapeBase {
    private static final eq[] FACING_ALL = new eq[]{eq.a, eq.b, eq.c, eq.d, eq.e, eq.f};
    protected cee center = cee.a;
    protected cee effectiveCenter = cee.a;
    protected final cee[] quadrantCenters = new cee[4];
    protected cee lastUpdatePos = cee.a;
    protected BlockSnap snap = BlockSnap.NONE;
    protected double margin = 0.0;
    protected long lastUpdateTime;

    public ShapeDespawnSphere() {
        super(ShapeManager.ShapeTypes.DESPAWN_SPHERE, Configs.Colors.DESPAWN_SPHERE_OVERLAY_COLOR.getColor());
        if (this.mc.i != null) {
            this.setCenter(this.mc.i.bI());
        } else {
            this.setCenter(cee.a);
        }
    }

    public cee getCenter() {
        return this.center;
    }

    public void setCenter(cee center) {
        this.center = center;
        this.updateEffectiveCenter();
    }

    private void updateQuadrantPoints() {
        cee center = this.effectiveCenter;
        this.quadrantCenters[Quadrant.NORTH_WEST.ordinal()] = new cee(center.b - this.margin, center.c, center.d - this.margin);
        this.quadrantCenters[Quadrant.NORTH_EAST.ordinal()] = new cee(center.b + this.margin, center.c, center.d - this.margin);
        this.quadrantCenters[Quadrant.SOUTH_WEST.ordinal()] = new cee(center.b - this.margin, center.c, center.d + this.margin);
        this.quadrantCenters[Quadrant.SOUTH_EAST.ordinal()] = new cee(center.b + this.margin, center.c, center.d + this.margin);
        this.setNeedsUpdate();
    }

    private void updateEffectiveCenter() {
        cee center = this.center;
        this.effectiveCenter = this.snap == BlockSnap.CENTER ? new cee(Math.floor(center.b) + 0.5, Math.floor(center.c), Math.floor(center.d) + 0.5) : (this.snap == BlockSnap.CORNER ? new cee(Math.floor(center.b), Math.floor(center.c), Math.floor(center.d)) : center);
        this.updateQuadrantPoints();
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
        this.updateQuadrantPoints();
    }

    public BlockSnap getBlockSnap() {
        return this.snap;
    }

    public void setBlockSnap(BlockSnap snap) {
        this.snap = snap;
        this.updateEffectiveCenter();
    }

    @Override
    public void update(aer entity, cft mc) {
        this.renderSphereBlock();
        this.needsUpdate = false;
        this.lastUpdatePos = entity.bI();
        this.lastUpdateTime = System.currentTimeMillis();
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
    }

    @Override
    public void draw(double x, double y, double z) {
        cua.G();
        this.preRender(x, y, z);
        ((RenderObjectBase)this.renderObjects.get(0)).draw();
        cua.d((int)1032, (int)6913);
        cua.l();
        ((RenderObjectBase)this.renderObjects.get(0)).draw();
        cua.d((int)1032, (int)6914);
        cua.m();
        cua.H();
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        obj.add("center", (JsonElement)JsonUtils.vec3dToJson((cee)this.center));
        obj.add("snap", (JsonElement)new JsonPrimitive(this.snap.getStringValue()));
        obj.add("margin", (JsonElement)new JsonPrimitive((Number)this.margin));
        obj.add("color", (JsonElement)new JsonPrimitive((Number)this.color.intValue));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        cee center;
        super.fromJson(obj);
        this.margin = JsonUtils.getDouble((JsonObject)obj, (String)"margin");
        if (JsonUtils.hasString((JsonObject)obj, (String)"snap")) {
            this.snap = BlockSnap.fromStringStatic((String)JsonUtils.getString((JsonObject)obj, (String)"snap"));
        }
        if ((center = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"center")) != null) {
            this.setCenter(center);
        }
        if (JsonUtils.hasInteger((JsonObject)obj, (String)"color")) {
            this.color = Color4f.fromColor((int)JsonUtils.getInteger((JsonObject)obj, (String)"color"));
        }
    }

    @Override
    public List<String> getWidgetHoverLines() {
        ArrayList<String> lines = new ArrayList<String>();
        cee c2 = this.center;
        lines.add(StringUtils.translate((String)"minihud.gui.label.center_value", (Object[])new Object[]{String.format("x: %.2f, y: %.2f, z: %.2f", c2.b, c2.c, c2.d)}));
        lines.add(StringUtils.translate((String)"minihud.gui.label.block_snap", (Object[])new Object[]{this.snap.getDisplayName()}));
        lines.add(StringUtils.translate((String)"minihud.gui.label.margin_value", (Object[])new Object[]{String.format("%.2f", this.margin)}));
        if (this.snap != BlockSnap.NONE) {
            c2 = this.effectiveCenter;
            lines.add(StringUtils.translate((String)"minihud.gui.label.effective_center_value", (Object[])new Object[]{String.format("x: %.2f, y: %.2f, z: %.2f", c2.b, c2.c, c2.d)}));
        }
        return lines;
    }

    protected void renderSphereBlock() {
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.a(renderQuads.getGlMode(), ddu.l);
        Color4f colorQuad = this.color;
        el posCenter = new el(this.effectiveCenter);
        el.a posMutable = new el.a();
        HashSet<el> spherePositions = new HashSet<el>();
        this.setPosition(posCenter);
        posMutable.g((ff)posCenter);
        this.addPositionsOnRing(spherePositions, posMutable, eq.f);
        posMutable.g((ff)posCenter);
        this.addPositionsOnRing(spherePositions, posMutable, eq.b);
        for (int i = 1; i < 130; ++i) {
            posMutable.c(posCenter.o(), posCenter.p() - i, posCenter.q());
            this.addPositionsOnRing(spherePositions, posMutable, eq.f);
            posMutable.c(posCenter.o(), posCenter.p() + i, posCenter.q());
            this.addPositionsOnRing(spherePositions, posMutable, eq.f);
            posMutable.c(posCenter.o() - i, posCenter.p(), posCenter.q());
            this.addPositionsOnRing(spherePositions, posMutable, eq.b);
            posMutable.c(posCenter.o() + i, posCenter.p(), posCenter.q());
            this.addPositionsOnRing(spherePositions, posMutable, eq.b);
        }
        for (el pos : spherePositions) {
            for (int i = 0; i < 6; ++i) {
                eq side = FACING_ALL[i];
                posMutable.g((ff)pos).c(side);
                if (!this.layerRange.isPositionWithinRange(pos) || spherePositions.contains(posMutable) || !this.isAdjacentPositionOutside(pos, side)) continue;
                ShapeDespawnSphere.renderBlockSideQuads(pos, side, BUFFER_1, colorQuad);
            }
        }
        BUFFER_1.e();
        renderQuads.uploadData(BUFFER_1);
    }

    private void addPositionsOnRing(HashSet<el> positions, el.a posMutable, eq direction) {
        if (this.movePositionToRing(posMutable, direction)) {
            el posFirst = posMutable.h();
            positions.add(posFirst);
            int failsafe = 860;
            eq.a axis = direction.k();
            while (--failsafe > 0 && (direction = axis == eq.a.b ? this.getNextPositionOnRingVertical(posMutable, direction) : this.getNextPositionOnRing(posMutable, direction)) != null && !posMutable.equals((Object)posFirst)) {
                positions.add(posMutable.h());
            }
        }
    }

    private boolean movePositionToRing(el.a posMutable, eq dir) {
        int x = posMutable.o();
        int y = posMutable.p();
        int z = posMutable.q();
        int xNext = x;
        int yNext = y;
        int zNext = z;
        int failsafe = 0;
        int failsafeMax = 140;
        while (this.isPositionWithinRange(xNext, yNext, zNext) && ++failsafe < 140) {
            x = xNext;
            y = yNext;
            z = zNext;
            xNext += dir.g();
            yNext += dir.h();
            zNext += dir.i();
        }
        if (failsafe > 0) {
            posMutable.c(x, y, z);
            return true;
        }
        return false;
    }

    @Nullable
    private eq getNextPositionOnRing(el.a posMutable, eq dir) {
        eq dirOut = dir;
        eq ccw90 = ShapeDespawnSphere.getNextDirRotating(dir);
        int y = posMutable.p();
        for (int i = 0; i < 4; ++i) {
            int z;
            int x = posMutable.o() + dir.g();
            if (this.isPositionWithinRange(x, y, z = posMutable.q() + dir.i())) {
                posMutable.c(x, y, z);
                return dirOut;
            }
            x = posMutable.o() + dir.g() + ccw90.g();
            if (this.isPositionWithinRange(x, y, z = posMutable.q() + dir.i() + ccw90.i())) {
                posMutable.c(x, y, z);
                return dirOut;
            }
            dirOut = dir;
            dir = ShapeDespawnSphere.getNextDirRotating(dir);
            ccw90 = ShapeDespawnSphere.getNextDirRotating(dir);
        }
        return null;
    }

    @Nullable
    private eq getNextPositionOnRingVertical(el.a posMutable, eq dir) {
        eq dirOut = dir;
        eq ccw90 = ShapeDespawnSphere.getNextDirRotatingVertical(dir);
        for (int i = 0; i < 4; ++i) {
            int z;
            int y;
            int x = posMutable.o() + dir.g();
            if (this.isPositionWithinRange(x, y = posMutable.p() + dir.h(), z = posMutable.q() + dir.i())) {
                posMutable.c(x, y, z);
                return dirOut;
            }
            x = posMutable.o() + dir.g() + ccw90.g();
            if (this.isPositionWithinRange(x, y = posMutable.p() + dir.h() + ccw90.h(), z = posMutable.q() + dir.i() + ccw90.i())) {
                posMutable.c(x, y, z);
                return dirOut;
            }
            dirOut = dir;
            dir = ShapeDespawnSphere.getNextDirRotatingVertical(dir);
            ccw90 = ShapeDespawnSphere.getNextDirRotatingVertical(dir);
        }
        return null;
    }

    private boolean isPositionWithinRange(int x, int y, int z) {
        double dz;
        double dy;
        double dx;
        double maxDistSq = 16384.0;
        cee quadrantCenter = this.quadrantCenters[Quadrant.getQuadrant((int)x, (int)z, (cee)this.effectiveCenter).ordinal()];
        return quadrantCenter.c(dx = (double)x + 0.5, dy = (double)(y + 1), dz = (double)z + 0.5) < 16384.0 || this.effectiveCenter.c(dx, dy, dz) < 16384.0;
    }

    private boolean isAdjacentPositionOutside(el pos, eq dir) {
        double z;
        double y;
        double x;
        double maxDistSq = 16384.0;
        cee quadrantCenter = this.quadrantCenters[Quadrant.getQuadrant((int)pos.o(), (int)pos.q(), (cee)this.effectiveCenter).ordinal()];
        return quadrantCenter.c(x = (double)(pos.o() + dir.g()) + 0.5, y = (double)(pos.p() + dir.h() + 1), z = (double)(pos.q() + dir.i()) + 0.5) >= 16384.0 && this.effectiveCenter.c(x, y, z) >= 16384.0;
    }

    private static eq getNextDirRotating(eq dirIn) {
        switch (dirIn) {
            case f: {
                return eq.c;
            }
            case c: {
                return eq.e;
            }
            case e: {
                return eq.d;
            }
            case d: {
                return eq.f;
            }
        }
        return eq.c;
    }

    private static eq getNextDirRotatingVertical(eq dirIn) {
        switch (dirIn) {
            case b: {
                return eq.c;
            }
            case c: {
                return eq.a;
            }
            case a: {
                return eq.d;
            }
            case d: {
                return eq.b;
            }
        }
        return eq.c;
    }

    public static void renderBlockSideQuads(el pos, eq side, ctq buffer, Color4f color) {
        double x = pos.o();
        double y = pos.p();
        double z = pos.q();
        switch (side) {
            case a: {
                buffer.b(x, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case b: {
                buffer.b(x, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case c: {
                buffer.b(x, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case d: {
                buffer.b(x, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case e: {
                buffer.b(x, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case f: {
                buffer.b(x + 1.0, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
            }
        }
    }

    public static void renderBlockSideLines(el pos, eq side, ctq buffer, Color4f color) {
        double x = pos.o();
        double y = pos.p();
        double z = pos.q();
        switch (side) {
            case a: {
                buffer.b(x, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case b: {
                buffer.b(x, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case c: {
                buffer.b(x, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case d: {
                buffer.b(x, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case e: {
                buffer.b(x, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case f: {
                buffer.b(x + 1.0, y, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y + 1.0, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(color.r, color.g, color.b, color.a).d();
            }
        }
    }
}

