/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.IOverlayRenderer;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.OverlayRendererBlockGrid;
import fi.dy.masa.minihud.renderer.OverlayRendererRandomTickableChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererRegion;
import fi.dy.masa.minihud.renderer.OverlayRendererSlimeChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableChunks;
import fi.dy.masa.minihud.renderer.OverlayRendererSpawnableColumnHeights;
import fi.dy.masa.minihud.renderer.OverlayRendererStructures;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import java.util.ArrayList;
import java.util.List;

public class RenderContainer {
    public static final RenderContainer INSTANCE = new RenderContainer();
    protected final List<OverlayRendererBase> renderers = new ArrayList<OverlayRendererBase>();
    protected boolean resourcesAllocated;
    protected boolean useVbo;
    protected int countActive;

    private RenderContainer() {
        this.renderers.add(new OverlayRendererBlockGrid());
        this.renderers.add(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_FIXED));
        this.renderers.add(new OverlayRendererRandomTickableChunks(RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER));
        this.renderers.add(new OverlayRendererRegion());
        this.renderers.add(new OverlayRendererSlimeChunks());
        this.renderers.add(new OverlayRendererSpawnableColumnHeights());
        this.renderers.add(new OverlayRendererSpawnableChunks(RendererToggle.OVERLAY_SPAWNABLE_CHUNKS_FIXED));
        this.renderers.add(new OverlayRendererSpawnableChunks(RendererToggle.OVERLAY_SPAWNABLE_CHUNKS_PLAYER));
        this.renderers.add(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL));
        this.renderers.add(new OverlayRendererSpawnChunks(RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER));
        this.renderers.add(new OverlayRendererStructures());
    }

    public void addShapeRenderer(ShapeBase renderer) {
        if (this.resourcesAllocated) {
            renderer.allocateGlResources();
        }
        this.renderers.add(renderer);
    }

    public void removeShapeRenderer(ShapeBase renderer) {
        this.renderers.remove(renderer);
        if (this.resourcesAllocated) {
            renderer.deleteGlResources();
        }
    }

    public void render(aer entity, cft mc, float partialTicks) {
        this.update(entity, mc);
        this.draw(entity, mc, partialTicks);
    }

    protected void update(aer entity, cft mc) {
        this.checkVideoSettings();
        this.countActive = 0;
        for (int i = 0; i < this.renderers.size(); ++i) {
            OverlayRendererBase renderer = this.renderers.get(i);
            if (!renderer.shouldRender(mc)) continue;
            if (renderer.needsUpdate(entity, mc)) {
                renderer.lastUpdatePos = new el(entity);
                renderer.setPosition(renderer.lastUpdatePos);
                renderer.update(entity, mc);
            }
            ++this.countActive;
        }
    }

    protected void draw(aer entity, cft mc, float partialTicks) {
        if (this.resourcesAllocated && this.countActive > 0) {
            cua.G();
            cua.z();
            cua.a((int)516, (float)0.01f);
            cua.r();
            cua.g();
            cua.a((boolean)false);
            cua.a((float)-3.0f, (float)-3.0f);
            cua.s();
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (dhq.f()) {
                cua.q((int)32884);
                cua.q((int)32886);
            }
            double x = entity.N + (entity.q - entity.N) * (double)partialTicks;
            double y = entity.O + (entity.r - entity.O) * (double)partialTicks;
            double z = entity.P + (entity.s - entity.P) * (double)partialTicks;
            for (int i = 0; i < this.renderers.size(); ++i) {
                IOverlayRenderer renderer = this.renderers.get(i);
                if (!renderer.shouldRender(mc)) continue;
                renderer.draw(x, y, z);
            }
            if (dhq.f()) {
                dhq.g((int)dhq.R, (int)0);
                cua.I();
                for (ddx element : ddu.l.h()) {
                    ddx.b usage = element.b();
                    switch (usage) {
                        case a: {
                            cua.p((int)32884);
                            break;
                        }
                        case c: {
                            cua.p((int)32886);
                            cua.I();
                        }
                    }
                }
            }
            cua.a((float)0.0f, (float)0.0f);
            cua.t();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            cua.l();
            cua.k();
            cua.f();
            cua.q();
            cua.a((boolean)true);
            cua.y();
            cua.H();
        }
    }

    protected void checkVideoSettings() {
        boolean vboLast = this.useVbo;
        this.useVbo = dhq.f();
        if (vboLast != this.useVbo || !this.resourcesAllocated) {
            this.deleteGlResources();
            this.allocateGlResources();
        }
    }

    protected void allocateGlResources() {
        if (!this.resourcesAllocated) {
            for (int i = 0; i < this.renderers.size(); ++i) {
                this.renderers.get(i).allocateGlResources();
            }
            this.resourcesAllocated = true;
        }
    }

    protected void deleteGlResources() {
        if (this.resourcesAllocated) {
            for (int i = 0; i < this.renderers.size(); ++i) {
                this.renderers.get(i).deleteGlResources();
            }
            this.resourcesAllocated = false;
        }
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < this.renderers.size(); ++i) {
            OverlayRendererBase renderer = this.renderers.get(i);
            String id = renderer.getSaveId();
            if (id.isEmpty()) continue;
            obj.add(id, (JsonElement)renderer.toJson());
        }
        return obj;
    }

    public void fromJson(JsonObject obj) {
        for (int i = 0; i < this.renderers.size(); ++i) {
            OverlayRendererBase renderer = this.renderers.get(i);
            String id = renderer.getSaveId();
            if (id.isEmpty() || !JsonUtils.hasObject((JsonObject)obj, (String)id)) continue;
            renderer.fromJson(obj.get(id).getAsJsonObject());
        }
    }
}

