/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import fi.dy.masa.minihud.util.StructureData;
import fi.dy.masa.minihud.util.StructureType;
import java.util.Collection;
import java.util.List;

public class OverlayRendererStructures
extends OverlayRendererBase {
    @Override
    public boolean shouldRender(cft mc) {
        if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
            return false;
        }
        if (mc.g.t.o()) {
            return StructureType.DESERT_PYRAMID.isEnabled() || StructureType.IGLOO.isEnabled() || StructureType.JUNGLE_TEMPLE.isEnabled() || StructureType.MANSION.isEnabled() || StructureType.OCEAN_MONUMENT.isEnabled() || StructureType.STRONGHOLD.isEnabled() || StructureType.VILLAGE.isEnabled() || StructureType.WITCH_HUT.isEnabled();
        }
        if (mc.g.t.h()) {
            return StructureType.NETHER_FORTRESS.isEnabled();
        }
        return StructureType.END_CITY.isEnabled();
    }

    @Override
    public boolean needsUpdate(aer entity, cft mc) {
        int hysteresis = 16;
        return DataStorage.getInstance().hasStructureDataChanged() || Math.abs(entity.q - (double)this.lastUpdatePos.o()) > (double)hysteresis || Math.abs(entity.r - (double)this.lastUpdatePos.p()) > (double)hysteresis || Math.abs(entity.s - (double)this.lastUpdatePos.q()) > (double)hysteresis;
    }

    @Override
    public void update(aer entity, cft mc) {
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.a(renderQuads.getGlMode(), ddu.l);
        BUFFER_2.a(renderLines.getGlMode(), ddu.l);
        this.updateStructures(mc.g.t.q(), this.lastUpdatePos, mc);
        BUFFER_1.e();
        BUFFER_2.e();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }

    private void updateStructures(bod dimensionType, el playerPos, cft mc) {
        ArrayListMultimap<StructureType, StructureData> structures = DataStorage.getInstance().getCopyOfStructureData();
        int maxRange = (mc.t.e + 4) * 16;
        for (StructureType type : StructureType.values()) {
            List structureData;
            if (!type.isEnabled() || !type.existsInDimension(dimensionType) || (structureData = structures.get((Object)type)).isEmpty()) continue;
            this.renderStructuresWithinRange(type, structureData, playerPos, maxRange);
        }
    }

    private void renderStructuresWithinRange(StructureType type, Collection<StructureData> structureData, el playerPos, int maxRange) {
        for (StructureData structure : structureData) {
            if (!MiscUtils.isStructureWithinRange(structure.getBoundingBox(), playerPos, maxRange)) continue;
            this.renderStructure(type, structure);
        }
    }

    private void renderStructure(StructureType type, StructureData structure) {
        Color4f color = type.getToggle().getColorMain().getColor();
        ImmutableList<IntBoundingBox> components = structure.getComponents();
        RenderUtils.drawBox((IntBoundingBox)structure.getBoundingBox(), (Color4f)color, (ctq)BUFFER_1, (ctq)BUFFER_2);
        if (!(components.isEmpty() || components.size() <= 1 && MiscUtils.areBoxesEqual((IntBoundingBox)components.get(0), structure.getBoundingBox()))) {
            color = type.getToggle().getColorComponents().getColor();
            for (IntBoundingBox bb : components) {
                RenderUtils.drawBox((IntBoundingBox)bb, (Color4f)color, (ctq)BUFFER_1, (ctq)BUFFER_2);
            }
        }
    }
}

