/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import java.util.HashSet;
import java.util.Set;

public class OverlayRendererSpawnableColumnHeights
extends OverlayRendererBase {
    private static final Set<Long> DIRTY_CHUNKS = new HashSet<Long>();
    private long lastCheckTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markChunkChanged(int cx, int cz) {
        if (RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue()) {
            Set<Long> set = DIRTY_CHUNKS;
            synchronized (set) {
                DIRTY_CHUNKS.add(axm.a((int)cx, (int)cz));
            }
        }
    }

    @Override
    public boolean shouldRender(cft mc) {
        return RendererToggle.OVERLAY_SPAWNABLE_COLUMN_HEIGHTS.getBooleanValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean needsUpdate(aer entity, cft mc) {
        int ex = (int)Math.floor(entity.q);
        int ez = (int)Math.floor(entity.s);
        int lx = this.lastUpdatePos.o();
        int lz = this.lastUpdatePos.q();
        if (Math.abs(lx - ex) > 8 || Math.abs(lz - ez) > 8) {
            return true;
        }
        if (System.currentTimeMillis() - this.lastCheckTime > 1000L) {
            int radius = xq.a((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
            int xStart = ((int)entity.q >> 4) - radius;
            int zStart = ((int)entity.s >> 4) - radius;
            int xEnd = ((int)entity.q >> 4) + radius;
            int zEnd = ((int)entity.s >> 4) + radius;
            Set<Long> set = DIRTY_CHUNKS;
            synchronized (set) {
                for (int cx = xStart; cx <= xEnd; ++cx) {
                    for (int cz = zStart; cz <= zEnd; ++cz) {
                        if (!DIRTY_CHUNKS.contains(axm.a((int)cx, (int)cz))) continue;
                        return true;
                    }
                }
            }
            this.lastCheckTime = System.currentTimeMillis();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(aer entity, cft mc) {
        Color4f color = Configs.Colors.SPAWNABLE_COLUMNS_OVERLAY_COLOR.getColor();
        int radius = xq.a((int)Configs.Generic.SPAWNABLE_COLUMNS_OVERLAY_RADIUS.getIntegerValue(), (int)0, (int)128);
        int xStart = (int)entity.q - radius;
        int zStart = (int)entity.s - radius;
        int xEnd = (int)entity.q + radius;
        int zEnd = (int)entity.s + radius;
        crg world = mc.g;
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.a(renderQuads.getGlMode(), ddu.l);
        BUFFER_2.a(renderLines.getGlMode(), ddu.l);
        for (int x = xStart; x <= xEnd; ++x) {
            for (int z = zStart; z <= zEnd; ++z) {
                int height = world.a(bor.a.c, x, z);
                double minY = height;
                double maxY = (double)height + 0.09375;
                double minX = (double)x + 0.25;
                double minZ = (double)z + 0.25;
                double maxX = (double)x + 0.75;
                double maxZ = (double)z + 0.75;
                RenderUtils.drawBoxHorizontalSidesBatchedQuads((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (ctq)BUFFER_1);
                RenderUtils.drawBoxTopBatchedQuads((double)minX, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (ctq)BUFFER_1);
                RenderUtils.drawBoxAllEdgesBatchedLines((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (Color4f)color, (ctq)BUFFER_2);
            }
        }
        BUFFER_1.e();
        BUFFER_2.e();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        this.lastCheckTime = System.currentTimeMillis();
        Set<Long> set = DIRTY_CHUNKS;
        synchronized (set) {
            DIRTY_CHUNKS.clear();
        }
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }
}

