/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import javax.annotation.Nullable;

public class OverlayRendererSpawnableChunks
extends OverlayRendererBase {
    @Nullable
    public static el newPos;
    public static double overlayTopY;
    protected final RendererToggle toggle;
    protected el posCenter = el.a;
    protected double topY = 256.0;

    public OverlayRendererSpawnableChunks(RendererToggle toggle) {
        this.toggle = toggle;
    }

    @Override
    public boolean shouldRender(cft mc) {
        return this.toggle.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(aer entity, cft mc) {
        if (this.toggle == RendererToggle.OVERLAY_SPAWNABLE_CHUNKS_FIXED) {
            return newPos != null;
        }
        int ex = (int)Math.floor(entity.q) >> 4;
        int ez = (int)Math.floor(entity.s) >> 4;
        int lx = this.lastUpdatePos.o();
        int lz = this.lastUpdatePos.q();
        return ex != lx || ez != lz;
    }

    @Override
    public void update(aer entity, cft mc) {
        if (this.toggle == RendererToggle.OVERLAY_SPAWNABLE_CHUNKS_FIXED) {
            if (newPos != null) {
                this.posCenter = newPos;
                newPos = null;
            } else {
                this.posCenter = new el(this.lastUpdatePos.o() << 4, 0, this.lastUpdatePos.q() << 4);
            }
        } else {
            this.posCenter = new el(entity);
        }
        int centerX = this.posCenter.o() >> 4;
        int centerZ = this.posCenter.q() >> 4;
        int r = 7;
        int color = this.toggle == RendererToggle.OVERLAY_SPAWNABLE_CHUNKS_FIXED ? Configs.Colors.SPAWNABLE_CHUNKS_FIXED_OVERLAY_COLOR.getIntegerValue() : Configs.Colors.SPAWNABLE_CHUNKS_PLAYER_OVERLAY_COLOR.getIntegerValue();
        this.lastUpdatePos = new el(centerX, 0, centerZ);
        this.setPosition(this.lastUpdatePos);
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.a(renderQuads.getGlMode(), ddu.l);
        BUFFER_2.a(renderLines.getGlMode(), ddu.l);
        el pos1 = new el(centerX - r << 4, 0, centerZ - r << 4);
        el pos2 = new el((double)((centerX + r + 1 << 4) - 1), this.topY, (double)((centerZ + r + 1 << 4) - 1));
        RenderUtils.renderVerticalWallsOfLinesWithinRange(BUFFER_1, BUFFER_2, pos1, pos2, 256.0f, 256.0f, 16.0f, 16.0f, entity, color);
        BUFFER_1.e();
        BUFFER_2.e();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }

    @Override
    public String getSaveId() {
        if (this.toggle == RendererToggle.OVERLAY_SPAWNABLE_CHUNKS_FIXED) {
            return "spawnable_chunks_fixed";
        }
        return "spawnable_chunks_player";
    }

    @Override
    @Nullable
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("pos", (JsonElement)JsonUtils.blockPosToJson((el)this.posCenter));
        obj.add("y_top", (JsonElement)new JsonPrimitive((Number)this.topY));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        this.topY = JsonUtils.getDouble((JsonObject)obj, (String)"y_top");
        el pos = JsonUtils.blockPosFromJson((JsonObject)obj, (String)"pos");
        if (pos != null && this.toggle == RendererToggle.OVERLAY_SPAWNABLE_CHUNKS_FIXED) {
            newPos = pos;
        }
    }
}

