/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.util.DataStorage;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayRendererSpawnChunks
extends OverlayRendererBase {
    protected static boolean needsUpdate = true;
    protected final RendererToggle toggle;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public OverlayRendererSpawnChunks(RendererToggle toggle) {
        this.toggle = toggle;
    }

    @Override
    public boolean shouldRender(cft mc) {
        return this.toggle.getBooleanValue() && (this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER || mc.g != null && mc.g.t instanceof bof && DataStorage.getInstance().isWorldSpawnKnown());
    }

    @Override
    public boolean needsUpdate(aer entity, cft mc) {
        if (needsUpdate) {
            return true;
        }
        int ex = (int)Math.floor(entity.q);
        int ez = (int)Math.floor(entity.s);
        int lx = this.lastUpdatePos.o();
        int lz = this.lastUpdatePos.q();
        if (this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER) {
            return ex != lx || ez != lz;
        }
        return Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(aer entity, cft mc) {
        DataStorage data = DataStorage.getInstance();
        el spawn = this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_PLAYER ? new el(entity) : data.getWorldSpawn();
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.a(renderQuads.getGlMode(), ddu.l);
        BUFFER_2.a(renderLines.getGlMode(), ddu.l);
        int colorEntity = this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL ? Configs.Colors.SPAWN_REAL_ENTITY_OVERLAY_COLOR.getIntegerValue() : Configs.Colors.SPAWN_PLAYER_ENTITY_OVERLAY_COLOR.getIntegerValue();
        int colorLazy = this.toggle == RendererToggle.OVERLAY_SPAWN_CHUNK_OVERLAY_REAL ? Configs.Colors.SPAWN_REAL_LAZY_OVERLAY_COLOR.getIntegerValue() : Configs.Colors.SPAWN_PLAYER_LAZY_OVERLAY_COLOR.getIntegerValue();
        int rangeH = (mc.t.e + 1) * 16;
        Pair<el, el> corners = this.getSpawnChunkCorners(spawn, 128);
        RenderUtils.renderVerticalWallsOfLinesWithinRange(BUFFER_1, BUFFER_2, (el)corners.getLeft(), (el)corners.getRight(), rangeH, 256.0f, 16.0f, 16.0f, entity, colorLazy);
        corners = this.getSpawnChunkCorners(spawn, 96);
        RenderUtils.renderVerticalWallsOfLinesWithinRange(BUFFER_1, BUFFER_2, (el)corners.getLeft(), (el)corners.getRight(), rangeH, 256.0f, 16.0f, 16.0f, entity, colorEntity);
        BUFFER_1.e();
        BUFFER_2.e();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
        needsUpdate = false;
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }

    protected Pair<el, el> getSpawnChunkCorners(el worldSpawn, int spawnChunkRange) {
        int x = worldSpawn.o() - (spawnChunkRange - 7) & 0xFFFFFFF0;
        int z = worldSpawn.q() - (spawnChunkRange - 7) & 0xFFFFFFF0;
        el pos1 = new el(x, 0, z);
        x = (worldSpawn.o() + (spawnChunkRange - 8) & 0xFFFFFFF0) + 16 - 1;
        z = (worldSpawn.q() + (spawnChunkRange - 8) & 0xFFFFFFF0) + 16 - 1;
        el pos2 = new el(x, 256, z);
        return Pair.of((Object)pos1, (Object)pos2);
    }
}

