/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;

public class OverlayRendererSlimeChunks
extends OverlayRendererBase {
    public static double overlayTopY;
    protected double topY;

    @Override
    public boolean shouldRender(cft mc) {
        return RendererToggle.OVERLAY_SLIME_CHUNKS_OVERLAY.getBooleanValue() && mc.g.t.o();
    }

    @Override
    public boolean needsUpdate(aer entity, cft mc) {
        if (this.topY != overlayTopY) {
            return true;
        }
        int ex = (int)Math.floor(entity.q);
        int ez = (int)Math.floor(entity.s);
        int lx = this.lastUpdatePos.o();
        int lz = this.lastUpdatePos.q();
        return Math.abs(lx - ex) > 16 || Math.abs(lz - ez) > 16;
    }

    @Override
    public void update(aer entity, cft mc) {
        DataStorage data = DataStorage.getInstance();
        this.topY = overlayTopY;
        if (data.isWorldSeedKnown(entity.ap)) {
            int centerX = xq.c((double)entity.q) >> 4;
            int centerZ = xq.c((double)entity.s) >> 4;
            long worldSeed = data.getWorldSeed(entity.ap);
            Color4f colorLines = Configs.Colors.SLIME_CHUNKS_OVERLAY_COLOR.getColor();
            Color4f colorSides = Color4f.fromColor((Color4f)colorLines, (float)(colorLines.a / 6.0f));
            el.b pos1 = el.b.r();
            el.b pos2 = el.b.r();
            int r = xq.a((int)Configs.Generic.SLIME_CHUNK_OVERLAY_RADIUS.getIntegerValue(), (int)-1, (int)40);
            if (r == -1) {
                r = mc.t.e;
            }
            RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
            RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
            BUFFER_1.a(renderQuads.getGlMode(), ddu.l);
            BUFFER_2.a(renderLines.getGlMode(), ddu.l);
            int topY = (int)Math.floor(this.topY);
            for (int xOff = -r; xOff <= r; ++xOff) {
                for (int zOff = -r; zOff <= r; ++zOff) {
                    int cx = centerX + xOff;
                    int cz = centerZ + zOff;
                    if (!MiscUtils.canSlimeSpawnInChunk(cx, cz, worldSeed)) continue;
                    pos1.f(cx << 4, 0, cz << 4);
                    pos2.f((cx << 4) + 15, topY, (cz << 4) + 15);
                    RenderUtils.drawBoxWithEdgesBatched((el)pos1, (el)pos2, (Color4f)colorLines, (Color4f)colorSides, (ctq)BUFFER_1, (ctq)BUFFER_2);
                }
            }
            pos1.close();
            pos2.close();
            BUFFER_1.e();
            BUFFER_2.e();
            renderQuads.uploadData(BUFFER_1);
            renderLines.uploadData(BUFFER_2);
        }
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }

    @Override
    public String getSaveId() {
        return "slime_chunks";
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("y_top", (JsonElement)new JsonPrimitive((Number)overlayTopY));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        overlayTopY = JsonUtils.getFloat((JsonObject)obj, (String)"y_top");
    }
}

