/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.renderer.RenderUtils;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class OverlayRendererRandomTickableChunks
extends OverlayRendererBase {
    @Nullable
    public static cee newPos;
    private static final eq[] HORIZONTALS;
    protected final RendererToggle toggle;
    protected cee pos = cee.a;

    public OverlayRendererRandomTickableChunks(RendererToggle toggle) {
        this.toggle = toggle;
    }

    @Override
    public boolean shouldRender(cft mc) {
        return this.toggle.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(aer entity, cft mc) {
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            return newPos != null;
        }
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            return entity.q != this.pos.b || entity.s != this.pos.d;
        }
        return false;
    }

    @Override
    public void update(aer entity, cft mc) {
        if (this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER) {
            this.pos = entity.bI();
        } else if (newPos != null) {
            this.pos = newPos;
            newPos = null;
        }
        this.setPosition(new el(this.pos));
        int color = this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_PLAYER ? Configs.Colors.RANDOM_TICKS_PLAYER_OVERLAY_COLOR.getIntegerValue() : Configs.Colors.RANDOM_TICKS_FIXED_OVERLAY_COLOR.getIntegerValue();
        RenderObjectBase renderQuads = (RenderObjectBase)this.renderObjects.get(0);
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(1);
        BUFFER_1.a(renderQuads.getGlMode(), ddu.l);
        BUFFER_2.a(renderLines.getGlMode(), ddu.l);
        Set<axm> chunks = this.getRandomTickableChunks(this.pos);
        for (axm pos : chunks) {
            this.renderChunkEdgesIfApplicable(pos, chunks, entity, color);
        }
        BUFFER_1.e();
        BUFFER_2.e();
        renderQuads.uploadData(BUFFER_1);
        renderLines.uploadData(BUFFER_2);
    }

    protected Set<axm> getRandomTickableChunks(cee posCenter) {
        HashSet<axm> set = new HashSet<axm>();
        int centerChunkX = (int)Math.floor(posCenter.b) >> 4;
        int centerChunkZ = (int)Math.floor(posCenter.d) >> 4;
        double maxRange = 16384.0;
        int r = 9;
        for (int cz = centerChunkZ - 9; cz <= centerChunkZ + 9; ++cz) {
            for (int cx = centerChunkX - 9; cx <= centerChunkX + 9; ++cx) {
                double dx = (double)(cx * 16 + 8) - posCenter.b;
                double dz = (double)(cz * 16 + 8) - posCenter.d;
                if (!(dx * dx + dz * dz < 16384.0)) continue;
                set.add(new axm(cx, cz));
            }
        }
        return set;
    }

    protected void renderChunkEdgesIfApplicable(axm pos, Set<axm> chunks, aer entity, int color) {
        for (eq side : HORIZONTALS) {
            axm posTmp = new axm(pos.a + side.g(), pos.b + side.i());
            if (chunks.contains(posTmp)) continue;
            RenderUtils.renderVerticalWallsOfLinesWithinRange(BUFFER_1, BUFFER_2, side.k(), this.getStartPos(pos, side), this.getEndPos(pos, side), 512.0f, 256.0f, 16.0f, 16.0f, entity, color);
        }
    }

    protected el getStartPos(axm chunkPos, eq side) {
        switch (side) {
            case c: {
                return new el(chunkPos.a << 4, 0, chunkPos.b << 4);
            }
            case d: {
                return new el(chunkPos.a << 4, 0, (chunkPos.b << 4) + 16);
            }
            case e: {
                return new el(chunkPos.a << 4, 0, chunkPos.b << 4);
            }
            case f: {
                return new el((chunkPos.a << 4) + 16, 0, chunkPos.b << 4);
            }
        }
        return el.a;
    }

    protected el getEndPos(axm chunkPos, eq side) {
        switch (side) {
            case c: {
                return new el((chunkPos.a << 4) + 16, 256, chunkPos.b << 4);
            }
            case d: {
                return new el((chunkPos.a << 4) + 16, 256, (chunkPos.b << 4) + 16);
            }
            case e: {
                return new el(chunkPos.a << 4, 256, (chunkPos.b << 4) + 16);
            }
            case f: {
                return new el((chunkPos.a << 4) + 16, 256, (chunkPos.b << 4) + 16);
            }
        }
        return el.a;
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(7);
        this.allocateBuffer(1);
    }

    @Override
    public String getSaveId() {
        return this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED ? "random_tickable_chunks" : "";
    }

    @Override
    @Nullable
    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("pos", (JsonElement)JsonUtils.vec3dToJson((cee)this.pos));
        return obj;
    }

    @Override
    public void fromJson(JsonObject obj) {
        cee pos = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"pos");
        if (pos != null && this.toggle == RendererToggle.OVERLAY_RANDOM_TICKS_FIXED) {
            newPos = pos;
        }
    }

    static {
        HORIZONTALS = new eq[]{eq.c, eq.d, eq.e, eq.f};
    }
}

