/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.util.LightLevelMarkerMode;
import fi.dy.masa.minihud.util.LightLevelNumberMode;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class OverlayRendererLightLevel {
    private static final pc TEXTURE_NUMBERS = new pc("minihud", "textures/misc/light_level_numbers.png");
    private static final List<LightLevelInfo> LIGHT_INFOS = new ArrayList<LightLevelInfo>();
    private static boolean needsUpdate;
    private static el lastUpdatePos;

    public static void setNeedsUpdate() {
        needsUpdate = true;
    }

    public static void render(double dx, double dy, double dz, aer entity, cft mc) {
        if (needsUpdate || lastUpdatePos == null || Math.abs(entity.q - (double)lastUpdatePos.o()) > 4.0 || Math.abs(entity.r - (double)lastUpdatePos.p()) > 4.0 || Math.abs(entity.s - (double)lastUpdatePos.q()) > 4.0) {
            OverlayRendererLightLevel.updateLightLevels((axy)mc.g, new el(entity));
        }
        OverlayRendererLightLevel.renderLightLevels(dx, dy, dz, mc);
    }

    private static void renderLightLevels(double dx, double dy, double dz, cft mc) {
        int count = LIGHT_INFOS.size();
        if (count > 0) {
            LightLevelInfo info;
            double offset2;
            double offset1;
            double markerSize;
            double tmpZ;
            double tmpX;
            Color4f colorDark;
            Color4f colorLit;
            double oz;
            double ox;
            mc.E().a(TEXTURE_NUMBERS);
            cua.e();
            cua.a((int)516, (float)0.01f);
            cua.g();
            RenderUtils.setupBlend();
            RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            cum tessellator = cum.a();
            ctq buffer = tessellator.c();
            eq numberFacing = Configs.Generic.LIGHT_LEVEL_NUMBER_ROTATION.getBooleanValue() ? mc.i.bA() : eq.c;
            LightLevelNumberMode numberMode = (LightLevelNumberMode)Configs.Generic.LIGHT_LEVEL_NUMBER_MODE.getOptionListValue();
            LightLevelMarkerMode markerMode = (LightLevelMarkerMode)Configs.Generic.LIGHT_LEVEL_MARKER_MODE.getOptionListValue();
            boolean useColoredNumbers = Configs.Generic.LIGHT_LEVEL_COLORED_NUMBERS.getBooleanValue();
            int lightThreshold = Configs.Generic.LIGHT_LEVEL_THRESHOLD.getIntegerValue();
            if (numberMode == LightLevelNumberMode.BLOCK || numberMode == LightLevelNumberMode.BOTH) {
                ox = Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_X.getDoubleValue();
                oz = Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_BLOCK_Y.getDoubleValue();
                colorLit = null;
                colorDark = null;
                switch (numberFacing) {
                    case c: {
                        tmpX = dx - ox;
                        tmpZ = dz - oz;
                        break;
                    }
                    case d: {
                        tmpX = dx + ox;
                        tmpZ = dz + oz;
                        break;
                    }
                    case e: {
                        tmpX = dx - oz;
                        tmpZ = dz + ox;
                        break;
                    }
                    case f: {
                        tmpX = dx + oz;
                        tmpZ = dz - ox;
                        break;
                    }
                    default: {
                        tmpX = dx - ox;
                        tmpZ = dz - oz;
                    }
                }
                if (useColoredNumbers) {
                    colorLit = Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_LIT.getColor();
                    colorDark = Configs.Colors.LIGHT_LEVEL_NUMBER_BLOCK_DARK.getColor();
                }
                OverlayRendererLightLevel.renderLightLevelNumbers(tmpX, dy, tmpZ, numberFacing, lightThreshold, LightLevelNumberMode.BLOCK, colorLit, colorDark, buffer);
                tessellator.b();
            }
            if (numberMode == LightLevelNumberMode.SKY || numberMode == LightLevelNumberMode.BOTH) {
                ox = Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_X.getDoubleValue();
                oz = Configs.Generic.LIGHT_LEVEL_NUMBER_OFFSET_SKY_Y.getDoubleValue();
                colorLit = null;
                colorDark = null;
                switch (numberFacing) {
                    case c: {
                        tmpX = dx - ox;
                        tmpZ = dz - oz;
                        break;
                    }
                    case d: {
                        tmpX = dx + ox;
                        tmpZ = dz + oz;
                        break;
                    }
                    case e: {
                        tmpX = dx - oz;
                        tmpZ = dz + ox;
                        break;
                    }
                    case f: {
                        tmpX = dx + oz;
                        tmpZ = dz - ox;
                        break;
                    }
                    default: {
                        tmpX = dx - ox;
                        tmpZ = dz - oz;
                    }
                }
                if (useColoredNumbers) {
                    colorLit = Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_LIT.getColor();
                    colorDark = Configs.Colors.LIGHT_LEVEL_NUMBER_SKY_DARK.getColor();
                }
                OverlayRendererLightLevel.renderLightLevelNumbers(tmpX, dy, tmpZ, numberFacing, lightThreshold, LightLevelNumberMode.SKY, colorLit, colorDark, buffer);
                tessellator.b();
            }
            if (markerMode == LightLevelMarkerMode.SQUARE) {
                markerSize = Configs.Generic.LIGHT_LEVEL_MARKER_SIZE.getDoubleValue();
                Color4f colorLit2 = Configs.Colors.LIGHT_LEVEL_MARKER_LIT.getColor();
                Color4f colorDark2 = Configs.Colors.LIGHT_LEVEL_MARKER_DARK.getColor();
                offset1 = (1.0 - markerSize) / 2.0;
                offset2 = 1.0 - offset1;
                cua.z();
                buffer.a(1, ddu.l);
                for (int i = 0; i < count; ++i) {
                    info = LIGHT_INFOS.get(i);
                    if (info.block >= lightThreshold) continue;
                    el pos = info.pos;
                    Color4f color = info.sky >= lightThreshold ? colorLit2 : colorDark2;
                    OverlayRendererLightLevel.renderLightLevelSquare((double)pos.o() - dx, (double)pos.p() - dy, (double)pos.q() - dz, color, offset1, offset2, buffer);
                }
                tessellator.b();
                cua.y();
            } else if (markerMode == LightLevelMarkerMode.CROSS) {
                markerSize = Configs.Generic.LIGHT_LEVEL_MARKER_SIZE.getDoubleValue();
                Color4f colorLit3 = Configs.Colors.LIGHT_LEVEL_MARKER_LIT.getColor();
                Color4f colorDark3 = Configs.Colors.LIGHT_LEVEL_MARKER_DARK.getColor();
                offset1 = (1.0 - markerSize) / 2.0;
                offset2 = 1.0 - offset1;
                cua.z();
                buffer.a(1, ddu.l);
                for (int i = 0; i < count; ++i) {
                    info = LIGHT_INFOS.get(i);
                    if (info.block >= lightThreshold) continue;
                    el pos = info.pos;
                    Color4f color = info.sky >= lightThreshold ? colorLit3 : colorDark3;
                    OverlayRendererLightLevel.renderLightLevelCross((double)pos.o() - dx, (double)pos.p() - dy, (double)pos.q() - dz, color, offset1, offset2, buffer);
                }
                tessellator.b();
                cua.y();
            }
            cua.l();
            cua.f();
        }
    }

    private static void renderLightLevelNumbers(double dx, double dy, double dz, eq facing, int lightThreshold, LightLevelNumberMode numberMode, @Nullable Color4f colorLit, @Nullable Color4f colorDark, ctq buffer) {
        int count = LIGHT_INFOS.size();
        if (colorLit != null) {
            buffer.a(7, ddu.o);
            for (int i = 0; i < count; ++i) {
                LightLevelInfo info = LIGHT_INFOS.get(i);
                el pos = info.pos;
                double x = (double)pos.o() - dx;
                double z = (double)pos.q() - dz;
                int lightLevel = numberMode == LightLevelNumberMode.BLOCK ? info.block : info.sky;
                Color4f color = lightLevel >= lightThreshold ? colorLit : colorDark;
                OverlayRendererLightLevel.renderLightLevelTextureColor(x, (double)pos.p() - dy, z, facing, lightLevel, color, buffer);
            }
        } else {
            buffer.a(7, ddu.m);
            for (int i = 0; i < count; ++i) {
                LightLevelInfo info = LIGHT_INFOS.get(i);
                el pos = info.pos;
                double x = (double)pos.o() - dx;
                double z = (double)pos.q() - dz;
                int lightLevel = numberMode == LightLevelNumberMode.BLOCK ? info.block : info.sky;
                OverlayRendererLightLevel.renderLightLevelTexture(x, (double)pos.p() - dy, z, facing, lightLevel, buffer);
            }
        }
    }

    private static void renderLightLevelTexture(double x, double y, double z, eq facing, int lightLevel, ctq buffer) {
        double u = (double)(lightLevel & 3) * 0.25;
        double v = (double)(lightLevel >> 2) * 0.25;
        y += 0.005;
        switch (facing) {
            case c: {
                buffer.b(x, y, z).a(u, v).d();
                buffer.b(x, y, z + 1.0).a(u, v + 0.25).d();
                buffer.b(x + 1.0, y, z + 1.0).a(u + 0.25, v + 0.25).d();
                buffer.b(x + 1.0, y, z).a(u + 0.25, v).d();
                break;
            }
            case d: {
                buffer.b(x + 1.0, y, z + 1.0).a(u, v).d();
                buffer.b(x + 1.0, y, z).a(u, v + 0.25).d();
                buffer.b(x, y, z).a(u + 0.25, v + 0.25).d();
                buffer.b(x, y, z + 1.0).a(u + 0.25, v).d();
                break;
            }
            case f: {
                buffer.b(x + 1.0, y, z).a(u, v).d();
                buffer.b(x, y, z).a(u, v + 0.25).d();
                buffer.b(x, y, z + 1.0).a(u + 0.25, v + 0.25).d();
                buffer.b(x + 1.0, y, z + 1.0).a(u + 0.25, v).d();
                break;
            }
            case e: {
                buffer.b(x, y, z + 1.0).a(u, v).d();
                buffer.b(x + 1.0, y, z + 1.0).a(u, v + 0.25).d();
                buffer.b(x + 1.0, y, z).a(u + 0.25, v + 0.25).d();
                buffer.b(x, y, z).a(u + 0.25, v).d();
                break;
            }
        }
    }

    private static void renderLightLevelTextureColor(double x, double y, double z, eq facing, int lightLevel, Color4f color, ctq buffer) {
        double u = (double)(lightLevel & 3) * 0.25;
        double v = (double)(lightLevel >> 2) * 0.25;
        y += 0.005;
        switch (facing) {
            case c: {
                buffer.b(x, y, z).a(u, v).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(u, v + 0.25).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(u + 0.25, v + 0.25).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(u + 0.25, v).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case d: {
                buffer.b(x + 1.0, y, z + 1.0).a(u, v).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(u, v + 0.25).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z).a(u + 0.25, v + 0.25).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(u + 0.25, v).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case f: {
                buffer.b(x + 1.0, y, z).a(u, v).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z).a(u, v + 0.25).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z + 1.0).a(u + 0.25, v + 0.25).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(u + 0.25, v).a(color.r, color.g, color.b, color.a).d();
                break;
            }
            case e: {
                buffer.b(x, y, z + 1.0).a(u, v).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z + 1.0).a(u, v + 0.25).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x + 1.0, y, z).a(u + 0.25, v + 0.25).a(color.r, color.g, color.b, color.a).d();
                buffer.b(x, y, z).a(u + 0.25, v).a(color.r, color.g, color.b, color.a).d();
                break;
            }
        }
    }

    private static void renderLightLevelCross(double x, double y, double z, Color4f color, double offset1, double offset2, ctq buffer) {
        buffer.b(x + offset1, y += 0.005, z + offset1).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset2, y, z + offset2).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset1, y, z + offset2).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset2, y, z + offset1).a(color.r, color.g, color.b, color.a).d();
    }

    private static void renderLightLevelSquare(double x, double y, double z, Color4f color, double offset1, double offset2, ctq buffer) {
        buffer.b(x + offset1, y += 0.005, z + offset1).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset1, y, z + offset2).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset1, y, z + offset2).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset2, y, z + offset2).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset2, y, z + offset2).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset2, y, z + offset1).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset2, y, z + offset1).a(color.r, color.g, color.b, color.a).d();
        buffer.b(x + offset1, y, z + offset1).a(color.r, color.g, color.b, color.a).d();
    }

    private static void updateLightLevels(axy world, el center) {
        LIGHT_INFOS.clear();
        int radius = Configs.Generic.LIGHT_LEVEL_RANGE.getIntegerValue();
        int minX = center.o() - radius;
        int minY = center.p() - radius;
        int minZ = center.q() - radius;
        int maxX = center.o() + radius;
        int maxY = center.p() + radius;
        int maxZ = center.q() + radius;
        int minCX = minX >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCZ = maxZ >> 4;
        el.a posMutable = new el.a();
        for (int cx = minCX; cx <= maxCX; ++cx) {
            int startX = Math.max(cx << 4, minX);
            int endX = Math.min((cx << 4) + 15, maxX);
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                int startZ = Math.max(cz << 4, minZ);
                int endZ = Math.min((cz << 4) + 15, maxZ);
                bnj chunk = world.c(cx, cz);
                for (int x = startX; x <= endX; ++x) {
                    for (int z = startZ; z <= endZ; ++z) {
                        int startY = Math.max(minY, 0);
                        int endY = Math.min(maxY, chunk.b() + 15);
                        for (int y = startY; y <= endY; ++y) {
                            if (!OverlayRendererLightLevel.canSpawnAt(x, y, z, chunk)) continue;
                            posMutable.c(x, y, z);
                            int block = chunk.a(ayi.b, (el)posMutable);
                            int sky = chunk.a(ayi.a, (el)posMutable);
                            LIGHT_INFOS.add(new LightLevelInfo(new el(x, y, z), block, sky));
                        }
                    }
                }
            }
        }
        needsUpdate = false;
        lastUpdatePos = center;
    }

    public static boolean canSpawnAt(int x, int y, int z, bnj chunk) {
        blc state = chunk.a(x, y - 1, z);
        if (!state.q()) {
            return false;
        }
        bcs block = state.c();
        boolean spawnable = block != bct.z && block != bct.fU;
        blc state1 = chunk.a(x, y, z);
        blc state2 = chunk.a(x, y + 1, z);
        return spawnable && ayj.a((blc)state1, (byw)state1.s()) && ayj.a((blc)state2, (byw)state2.s());
    }

    static {
        lastUpdatePos = null;
    }

    public static class LightLevelInfo {
        public final el pos;
        public final int block;
        public final int sky;

        public LightLevelInfo(el pos, int block, int sky) {
            this.pos = pos;
            this.block = block;
            this.sky = sky;
        }
    }
}

