/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.renderer.OverlayRendererBase;
import fi.dy.masa.minihud.renderer.RenderObjectBase;
import fi.dy.masa.minihud.util.BlockGridMode;

public class OverlayRendererBlockGrid
extends OverlayRendererBase {
    @Override
    public boolean shouldRender(cft mc) {
        return RendererToggle.OVERLAY_BLOCK_GRID.getBooleanValue();
    }

    @Override
    public boolean needsUpdate(aer entity, cft mc) {
        if (this.lastUpdatePos == null) {
            return true;
        }
        return Math.abs(entity.q - (double)this.lastUpdatePos.o()) > 8.0 || Math.abs(entity.r - (double)this.lastUpdatePos.p()) > 8.0 || Math.abs(entity.s - (double)this.lastUpdatePos.q()) > 8.0;
    }

    @Override
    public void update(aer entity, cft mc) {
        Color4f color = Configs.Colors.BLOCK_GRID_OVERLAY_COLOR.getColor();
        int radius = Configs.Generic.BLOCK_GRID_OVERLAY_RADIUS.getIntegerValue();
        RenderObjectBase renderLines = (RenderObjectBase)this.renderObjects.get(0);
        BUFFER_1.a(renderLines.getGlMode(), ddu.l);
        BlockGridMode mode = (BlockGridMode)Configs.Generic.BLOCK_GRID_OVERLAY_MODE.getOptionListValue();
        switch (mode) {
            case ALL: {
                this.renderLinesAll(this.lastUpdatePos, radius, color, BUFFER_1);
                break;
            }
            case NON_AIR: {
                this.renderLinesNonAir(entity.bJ(), this.lastUpdatePos, radius, color, BUFFER_1);
                break;
            }
            case ADJACENT: {
                this.renderLinesAdjacentToNonAir(entity.bJ(), this.lastUpdatePos, radius, color, BUFFER_1);
            }
        }
        BUFFER_1.e();
        renderLines.uploadData(BUFFER_1);
    }

    @Override
    public void allocateGlResources() {
        this.allocateBuffer(1);
    }

    protected void renderLinesAll(el center, int radius, Color4f color, ctq buffer) {
        int y;
        int x;
        int startX = center.o() - radius;
        int startY = center.p() - radius;
        int startZ = center.q() - radius;
        int endX = center.o() + radius;
        int endY = center.p() + radius;
        int endZ = center.q() + radius;
        for (x = startX; x <= endX; ++x) {
            for (y = startY; y <= endY; ++y) {
                buffer.b((double)x, (double)y, (double)startZ).a(color.r, color.g, color.b, color.a).d();
                buffer.b((double)x, (double)y, (double)endZ).a(color.r, color.g, color.b, color.a).d();
            }
        }
        for (x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                buffer.b((double)x, (double)startY, (double)z).a(color.r, color.g, color.b, color.a).d();
                buffer.b((double)x, (double)endY, (double)z).a(color.r, color.g, color.b, color.a).d();
            }
        }
        for (int z = startZ; z <= endZ; ++z) {
            for (y = startY; y <= endY; ++y) {
                buffer.b((double)startX, (double)y, (double)z).a(color.r, color.g, color.b, color.a).d();
                buffer.b((double)endX, (double)y, (double)z).a(color.r, color.g, color.b, color.a).d();
            }
        }
    }

    protected void renderLinesNonAir(axy world, el center, int radius, Color4f color, ctq buffer) {
        int startX = center.o() - radius;
        int startY = center.p() - radius;
        int startZ = center.q() - radius;
        int endX = center.o() + radius;
        int endY = center.p() + radius;
        int endZ = center.q() + radius;
        el.a posMutable = new el.a();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int y = startY; y <= endY; ++y) {
                    posMutable.c(x, y, z);
                    if (world.c((el)posMutable)) continue;
                    RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((el)posMutable, (Color4f)color, (double)0.001, (ctq)buffer);
                }
            }
        }
    }

    protected void renderLinesAdjacentToNonAir(axy world, el center, int radius, Color4f color, ctq buffer) {
        int startX = center.o() - radius;
        int startY = center.p() - radius;
        int startZ = center.q() - radius;
        int endX = center.o() + radius;
        int endY = center.p() + radius;
        int endZ = center.q() + radius;
        el.a posMutable = new el.a();
        el.a posMutable2 = new el.a();
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                block2: for (int y = startY; y <= endY; ++y) {
                    posMutable.c(x, y, z);
                    if (!world.c((el)posMutable)) continue;
                    for (eq side : eq.values()) {
                        posMutable2.c(posMutable.o() + side.g(), posMutable.p() + side.h(), posMutable.q() + side.i());
                        if (world.c((el)posMutable2)) continue;
                        RenderUtils.drawBlockBoundingBoxOutlinesBatchedLines((el)posMutable, (Color4f)color, (double)0.001, (ctq)buffer);
                        continue block2;
                    }
                }
            }
        }
    }
}

