/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.gui;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetBase;
import fi.dy.masa.malilib.gui.widgets.WidgetDropDownList;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.gui.GuiConfigs;
import fi.dy.masa.minihud.gui.widgets.WidgetListShapes;
import fi.dy.masa.minihud.gui.widgets.WidgetShapeEntry;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeDespawnSphere;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import java.util.List;
import javax.annotation.Nullable;

public class GuiShapeManager
extends GuiListBase<ShapeBase, WidgetShapeEntry, WidgetListShapes>
implements ISelectionListener<ShapeBase> {
    public GuiShapeManager() {
        super(10, 64);
        this.title = StringUtils.translate((String)"minihud.gui.title.shape_manager", (Object[])new Object[0]);
    }

    protected int getBrowserWidth() {
        return this.m - 20;
    }

    protected int getBrowserHeight() {
        return this.n - this.getListY() - 6;
    }

    public void c() {
        super.c();
        int x = 10;
        int y = 26;
        int rows = 1;
        for (GuiConfigs.ConfigGuiTab tab : GuiConfigs.ConfigGuiTab.values()) {
            int width = this.getStringWidth(tab.getDisplayName()) + 10;
            if (x >= this.m - width - 10) {
                x = 10;
                y += 22;
                ++rows;
            }
            x += this.createTabButton(x, y, width, tab);
        }
        this.setListPosition(this.getListX(), 68 + (rows - 1) * 22);
        this.reCreateListWidget();
        this.addButton(this.m - 10, y += 24, ButtonListener.Type.ADD_SHAPE);
    }

    protected int addButton(int x, int y, ButtonListener.Type type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, true, type.getDisplayName(), new Object[0]);
        this.addButton((ButtonBase)button, new ButtonListener(ButtonListener.Type.ADD_SHAPE, this));
        WidgetDropDownList dd = new WidgetDropDownList(button.getX() - 160, y, 140, 18, 200, 6, (List)ImmutableList.copyOf((Object[])InfoToggle.values()));
        dd.setZLevel(this.e + 1.0f);
        this.addWidget((WidgetBase)dd);
        return button.getWidth();
    }

    private int createTabButton(int x, int y, int width, GuiConfigs.ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(GuiConfigs.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListenerTab(tab));
        return button.getWidth() + 2;
    }

    public void onSelectionChange(@Nullable ShapeBase entry) {
        ShapeBase old = ShapeManager.INSTANCE.getSelectedShape();
        ShapeManager.INSTANCE.setSelectedShape(old == entry ? null : entry);
    }

    protected WidgetListShapes createListWidget(int listX, int listY) {
        return new WidgetListShapes(listX, listY, this.getBrowserWidth(), this.getBrowserHeight(), this.e, this);
    }

    private static class ButtonListenerTab
    implements IButtonActionListener {
        private final GuiConfigs.ConfigGuiTab tab;

        public ButtonListenerTab(GuiConfigs.ConfigGuiTab tab) {
            this.tab = tab;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            GuiConfigs.tab = this.tab;
            GuiBase.openGui((ckd)new GuiConfigs());
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final Type type;
        private final GuiShapeManager gui;

        public ButtonListener(Type type, GuiShapeManager gui) {
            this.type = type;
            this.gui = gui;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == Type.ADD_SHAPE) {
                ShapeManager.INSTANCE.addShape(new ShapeDespawnSphere());
                ((WidgetListShapes)this.gui.getListWidget()).refreshEntries();
            }
        }

        public static enum Type {
            ADD_SHAPE("minihud.gui.button.add_shape");

            private final String translationKey;

            private Type(String translationKey) {
                this.translationKey = translationKey;
            }

            public String getDisplayName() {
                return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
            }
        }
    }
}

