/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.interfaces.IRenderer;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.BlockUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinWorldRenderer;
import fi.dy.masa.minihud.renderer.OverlayRenderer;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.MiscUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RenderHandler
implements IRenderer {
    private static final RenderHandler INSTANCE = new RenderHandler();
    private final DataStorage data;
    private final Date date;
    private int fps;
    private int fpsCounter;
    private long fpsUpdateTime = System.currentTimeMillis();
    private long infoUpdateTime;
    private double fontScale = 0.5;
    private Set<InfoToggle> addedTypes = new HashSet<InfoToggle>();
    private final List<StringHolder> lineWrappers = new ArrayList<StringHolder>();
    private final List<String> lines = new ArrayList<String>();

    public RenderHandler() {
        this.data = DataStorage.getInstance();
        this.date = new Date();
    }

    public static RenderHandler getInstance() {
        return INSTANCE;
    }

    public DataStorage getDataStorage() {
        return this.data;
    }

    public static void fixDebugRendererState() {
        if (Configs.Generic.FIX_VANILLA_DEBUG_RENDERERS.getBooleanValue()) {
            cua.g();
        }
    }

    public void onRenderGameOverlayPost(float partialTicks) {
        cft mc = cft.s();
        if (Configs.Generic.ENABLED.getBooleanValue() && !mc.t.aB && mc.i != null && (!Configs.Generic.REQUIRE_SNEAK.getBooleanValue() || mc.i.aZ()) && Configs.Generic.REQUIRED_KEY.getKeybind().isKeybindHeld()) {
            long currentTime;
            if (InfoToggle.FPS.getBooleanValue()) {
                this.updateFps();
            }
            if ((currentTime = System.currentTimeMillis()) - this.infoUpdateTime >= 50L) {
                this.updateLines();
                this.infoUpdateTime = currentTime;
            }
            int x = Configs.Generic.TEXT_POS_X.getIntegerValue();
            int y = Configs.Generic.TEXT_POS_Y.getIntegerValue();
            int textColor = Configs.Colors.TEXT_COLOR.getIntegerValue();
            int bgColor = Configs.Colors.TEXT_BACKGROUND_COLOR.getIntegerValue();
            HudAlignment alignment = (HudAlignment)Configs.Generic.HUD_ALIGNMENT.getOptionListValue();
            boolean useBackground = Configs.Generic.USE_TEXT_BACKGROUND.getBooleanValue();
            boolean useShadow = Configs.Generic.USE_FONT_SHADOW.getBooleanValue();
            RenderUtils.renderText((int)x, (int)y, (double)this.fontScale, (int)textColor, (int)bgColor, (HudAlignment)alignment, (boolean)useBackground, (boolean)useShadow, this.lines);
        }
    }

    public void onRenderTooltipLast(ate stack, int x, int y) {
        if (stack.b() instanceof atj) {
            if (Configs.Generic.MAP_PREVIEW.getBooleanValue()) {
                RenderUtils.renderMapPreview((ate)stack, (int)x, (int)y, (int)Configs.Generic.MAP_PREVIEW_SIZE.getIntegerValue());
            }
        } else if (Configs.Generic.SHULKER_BOX_PREVIEW.getBooleanValue()) {
            boolean render;
            boolean bl = render = !Configs.Generic.SHULKER_DISPLAY_REQUIRE_SHIFT.getBooleanValue() || GuiBase.isShiftDown();
            if (render) {
                RenderUtils.renderShulkerBoxPreview((ate)stack, (int)x, (int)y, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            }
        }
    }

    public void onRenderWorldLast(float partialTicks) {
        cft mc = cft.s();
        if (Configs.Generic.ENABLED.getBooleanValue() && mc.g != null && mc.i != null) {
            OverlayRenderer.renderOverlays(mc, partialTicks);
        }
    }

    public void setFontScale(double scale) {
        this.fontScale = xq.a((double)scale, (double)0.0, (double)10.0);
    }

    public int getSubtitleOffset() {
        HudAlignment align = (HudAlignment)Configs.Generic.HUD_ALIGNMENT.getOptionListValue();
        if (align == HudAlignment.BOTTOM_RIGHT) {
            int offset = (int)((double)(this.lineWrappers.size() * (StringUtils.getFontHeight() + 2)) * this.fontScale);
            return -(offset - 16);
        }
        return 0;
    }

    private void updateFps() {
        ++this.fpsCounter;
        long time = System.currentTimeMillis();
        if (time >= this.fpsUpdateTime + 1000L) {
            this.fpsUpdateTime = time;
            this.fps = this.fpsCounter;
            this.fpsCounter = 0;
        }
    }

    public void updateData(cft mc) {
        if (mc.g != null) {
            if (InfoToggle.SPAWNABLE_SUB_CHUNKS.getBooleanValue() && mc.g.V() % (long)Configs.Generic.SPAWNABLE_SUB_CHUNK_CHECK_INTERVAL.getIntegerValue() == 0L) {
                DataStorage.getInstance().checkQueuedDirtyChunkHeightmaps();
            }
            if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue() && mc.g.V() % 20L == 0L) {
                DataStorage.getInstance().updateStructureData();
            }
        }
    }

    private void updateLines() {
        this.lineWrappers.clear();
        this.addedTypes.clear();
        ArrayList<LinePos> positions = new ArrayList<LinePos>();
        for (InfoToggle toggle : InfoToggle.values()) {
            if (!toggle.getBooleanValue()) continue;
            positions.add(new LinePos(toggle.getIntegerValue(), toggle));
        }
        Collections.sort(positions);
        for (LinePos pos : positions) {
            try {
                this.addLine(pos.type);
            }
            catch (Exception e) {
                this.addLine(pos.type.getName() + ": exception");
            }
        }
        if (Configs.Generic.SORT_LINES_BY_LENGTH.getBooleanValue()) {
            Collections.sort(this.lineWrappers);
            if (Configs.Generic.SORT_LINES_REVERSED.getBooleanValue()) {
                Collections.reverse(this.lineWrappers);
            }
        }
        this.lines.clear();
        for (StringHolder holder : this.lineWrappers) {
            this.lines.add(holder.str);
        }
    }

    private void addLine(String text) {
        this.lineWrappers.add(new StringHolder(text));
    }

    private void addLine(InfoToggle type) {
        cft mc = cft.s();
        aer entity = mc.S();
        axy world = entity.bJ();
        el pos = new el(entity.q, entity.bD().b, entity.s);
        if (type == InfoToggle.FPS) {
            this.addLine(String.format("%d fps", this.fps));
        } else if (type == InfoToggle.MEMORY_USAGE) {
            long memMax = Runtime.getRuntime().maxMemory();
            long memTotal = Runtime.getRuntime().totalMemory();
            long memFree = Runtime.getRuntime().freeMemory();
            long memUsed = memTotal - memFree;
            this.addLine(String.format("Mem: % 2d%% %03d/%03dMB | Allocated: % 2d%% %03dMB", memUsed * 100L / memMax, MiscUtils.bytesToMb(memUsed), MiscUtils.bytesToMb(memMax), memTotal * 100L / memMax, MiscUtils.bytesToMb(memTotal)));
        } else if (type == InfoToggle.TIME_REAL) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat(Configs.Generic.DATE_FORMAT_REAL.getStringValue());
                this.date.setTime(System.currentTimeMillis());
                this.addLine(sdf.format(this.date));
            }
            catch (Exception e) {
                this.addLine("Date formatting failed - Invalid date format string?");
            }
        } else if (type == InfoToggle.TIME_WORLD) {
            long current = world.W();
            long total = world.V();
            this.addLine(String.format("World time: %5d - total: %d", current, total));
        } else if (type == InfoToggle.TIME_WORLD_FORMATTED) {
            try {
                long timeDay = world.W();
                long day = (int)(timeDay / 24000L) + 1;
                int dayTicks = (int)(timeDay % 24000L);
                int hour = (dayTicks / 1000 + 6) % 24;
                int min = (int)((double)dayTicks / 16.666666) % 60;
                int sec = (int)((double)dayTicks / 0.277777) % 60;
                String str = Configs.Generic.DATE_FORMAT_MINECRAFT.getStringValue();
                str = str.replace("{DAY}", String.format("%d", day));
                str = str.replace("{HOUR}", String.format("%02d", hour));
                str = str.replace("{MIN}", String.format("%02d", min));
                str = str.replace("{SEC}", String.format("%02d", sec));
                this.addLine(str);
            }
            catch (Exception e) {
                this.addLine("Date formatting failed - Invalid date format string?");
            }
        } else if (type == InfoToggle.TIME_DAY_MODULO) {
            int mod = Configs.Generic.TIME_DAY_DIVISOR.getIntegerValue();
            long current = world.W() % (long)mod;
            this.addLine(String.format("Day time %% %d: %5d", mod, current));
        } else if (type == InfoToggle.TIME_TOTAL_MODULO) {
            int mod = Configs.Generic.TIME_TOTAL_DIVISOR.getIntegerValue();
            long current = world.V() % (long)mod;
            this.addLine(String.format("Total time %% %d: %5d", mod, current));
        } else if (type == InfoToggle.SERVER_TPS) {
            if (mc.x() && mc.y().ah() % 10 == 0) {
                this.data.updateIntegratedServerTPS();
            }
            if (this.data.isServerTPSValid()) {
                String preTps;
                double tps = this.data.getServerTPS();
                double mspt = this.data.getServerMSPT();
                String rst = GuiBase.TXT_RST;
                String string = preTps = tps >= 20.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                if (this.data.isCarpetServer() || mc.x()) {
                    String preMspt = mspt <= 40.0 ? GuiBase.TXT_GREEN : (mspt <= 45.0 ? GuiBase.TXT_YELLOW : (mspt <= 50.0 ? GuiBase.TXT_GOLD : GuiBase.TXT_RED));
                    this.addLine(String.format("Server TPS: %s%.1f%s MSPT: %s%.1f%s", preTps, tps, rst, preMspt, mspt, rst));
                } else {
                    String preMspt = mspt <= 51.0 ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                    this.addLine(String.format("Server TPS: %s%.1f%s (MSPT*: %s%.1f%s)", preTps, tps, rst, preMspt, mspt, rst));
                }
            } else {
                this.addLine("Server TPS: <no valid data>");
            }
        } else if (type == InfoToggle.PING) {
            crh info = mc.i.d.a(mc.i.bt());
            if (info != null) {
                this.addLine("Ping: " + info.c() + " ms");
            }
        } else if (type == InfoToggle.COORDINATES || type == InfoToggle.DIMENSION) {
            if (this.addedTypes.contains((Object)InfoToggle.COORDINATES) || this.addedTypes.contains((Object)InfoToggle.DIMENSION)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            if (InfoToggle.COORDINATES.getBooleanValue()) {
                if (Configs.Generic.USE_CUSTOMIZED_COORDINATES.getBooleanValue()) {
                    try {
                        str.append(String.format(Configs.Generic.COORDINATE_FORMAT_STRING.getStringValue(), entity.q, entity.bD().b, entity.s));
                    }
                    catch (Exception e) {
                        str.append("broken coordinate format string!");
                    }
                } else {
                    str.append(String.format("XYZ: %.2f / %.4f / %.2f", entity.q, entity.bD().b, entity.s));
                }
                pre = " / ";
            }
            if (InfoToggle.DIMENSION.getBooleanValue()) {
                int dimension = world.t.q().c();
                str.append(String.format(String.format("%sDimType ID: %d", pre, dimension), new Object[0]));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.COORDINATES);
            this.addedTypes.add(InfoToggle.DIMENSION);
        } else if (type == InfoToggle.BLOCK_POS || type == InfoToggle.CHUNK_POS || type == InfoToggle.REGION_FILE) {
            if (this.addedTypes.contains((Object)InfoToggle.BLOCK_POS) || this.addedTypes.contains((Object)InfoToggle.CHUNK_POS) || this.addedTypes.contains((Object)InfoToggle.REGION_FILE)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(256);
            if (InfoToggle.BLOCK_POS.getBooleanValue()) {
                str.append(String.format("Block: %d, %d, %d", pos.o(), pos.p(), pos.q()));
                pre = " / ";
            }
            if (InfoToggle.CHUNK_POS.getBooleanValue()) {
                str.append(pre).append(String.format("Sub-Chunk: %d, %d, %d", pos.o() >> 4, pos.p() >> 4, pos.q() >> 4));
                pre = " / ";
            }
            if (InfoToggle.REGION_FILE.getBooleanValue()) {
                str.append(pre).append(String.format("Region: r.%d.%d", pos.o() >> 9, pos.q() >> 9));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.BLOCK_POS);
            this.addedTypes.add(InfoToggle.CHUNK_POS);
            this.addedTypes.add(InfoToggle.REGION_FILE);
        } else if (type == InfoToggle.BLOCK_IN_CHUNK) {
            this.addLine(String.format("Block: %d, %d, %d within Sub-Chunk: %d, %d, %d", pos.o() & 0xF, pos.p() & 0xF, pos.q() & 0xF, pos.o() >> 4, pos.p() >> 4, pos.q() >> 4));
        } else if (type == InfoToggle.DISTANCE) {
            cee ref = DataStorage.getInstance().getDistanceReferencePoint();
            double dist = xq.a((double)ref.c(entity.q, entity.r, entity.s));
            this.addLine(String.format("Distance: %.2f (x: %.2f y: %.2f z: %.2f) [to x: %.2f y: %.2f z: %.2f]", dist, entity.q - ref.b, entity.r - ref.c, entity.s - ref.d, ref.b, ref.c, ref.d));
        } else if (type == InfoToggle.FACING) {
            eq facing = entity.bA();
            String str = "Invalid";
            switch (facing) {
                case c: {
                    str = "Negative Z";
                    break;
                }
                case d: {
                    str = "Positive Z";
                    break;
                }
                case e: {
                    str = "Negative X";
                    break;
                }
                case f: {
                    str = "Positive X";
                    break;
                }
            }
            this.addLine(String.format("Facing: %s (%s)", facing, str));
        } else if (type == InfoToggle.LIGHT_LEVEL) {
            bnj chunk;
            if (pos.p() >= 0 && pos.p() < 256 && mc.g.D(pos) && !(chunk = mc.g.l(pos)).s()) {
                this.addLine(String.format("Light: %d (block: %d, sky: %d)", chunk.a(pos, 0), chunk.a(ayi.b, pos), chunk.a(ayi.a, pos)));
            }
        } else if (type == InfoToggle.ROTATION_YAW || type == InfoToggle.ROTATION_PITCH || type == InfoToggle.SPEED) {
            if (this.addedTypes.contains((Object)InfoToggle.ROTATION_YAW) || this.addedTypes.contains((Object)InfoToggle.ROTATION_PITCH) || this.addedTypes.contains((Object)InfoToggle.SPEED)) {
                return;
            }
            String pre = "";
            StringBuilder str = new StringBuilder(128);
            if (InfoToggle.ROTATION_YAW.getBooleanValue()) {
                str.append(String.format("yaw: %.1f", Float.valueOf(xq.g((float)entity.w))));
                pre = " / ";
            }
            if (InfoToggle.ROTATION_PITCH.getBooleanValue()) {
                str.append(pre).append(String.format("pitch: %.1f", Float.valueOf(xq.g((float)entity.x))));
                pre = " / ";
            }
            if (InfoToggle.SPEED.getBooleanValue()) {
                double dx = entity.q - entity.N;
                double dy = entity.r - entity.O;
                double dz = entity.s - entity.P;
                double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                str.append(pre).append(String.format("speed: %.3f m/s", dist * 20.0));
            }
            this.addLine(str.toString());
            this.addedTypes.add(InfoToggle.ROTATION_YAW);
            this.addedTypes.add(InfoToggle.ROTATION_PITCH);
            this.addedTypes.add(InfoToggle.SPEED);
        } else if (type == InfoToggle.SPEED_AXIS) {
            double dx = entity.q - entity.N;
            double dy = entity.r - entity.O;
            double dz = entity.s - entity.P;
            this.addLine(String.format("speed: x: %.3f y: %.3f z: %.3f m/s", dx * 20.0, dy * 20.0, dz * 20.0));
        } else if (type == InfoToggle.CHUNK_SECTIONS) {
            this.addLine(String.format("C: %d", ((IMixinWorldRenderer)mc.h).getRenderedChunksInvoker()));
        } else if (type == InfoToggle.CHUNK_SECTIONS_FULL) {
            this.addLine(mc.h.f());
        } else if (type == InfoToggle.CHUNK_UPDATES) {
            this.addLine(String.format("Chunk updates: %d", cwt.a));
        } else if (type == InfoToggle.LOADED_CHUNKS_COUNT) {
            String chunksClient = mc.g.O();
            axy worldServer = WorldUtils.getBestWorld((cft)mc);
            if (worldServer != null && worldServer != mc.g) {
                String chunksServer = worldServer.H().e();
                this.addLine(String.format("Server: %s - Client: %s", chunksServer, chunksClient));
            } else {
                this.addLine(chunksClient);
            }
        } else if (type == InfoToggle.PARTICLE_COUNT) {
            this.addLine(String.format("P: %s", mc.k.b()));
        } else if (type == InfoToggle.DIFFICULTY) {
            if (mc.g.D(pos)) {
                tf player;
                adj diff = mc.g.h(pos);
                if (mc.w() && mc.y() != null && (player = mc.y().ac().a(mc.i.bt())) != null) {
                    diff = player.m.h(new el((aer)player));
                }
                this.addLine(String.format("Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(diff.b()), Float.valueOf(diff.d()), mc.g.W() / 24000L));
            }
        } else if (type == InfoToggle.BIOME) {
            bnj chunk;
            if (pos.p() >= 0 && pos.p() < 256 && mc.g.D(pos) && !(chunk = mc.g.l(pos)).s()) {
                this.addLine("Biome: " + chunk.i(pos).j().getString());
            }
        } else if (type == InfoToggle.BIOME_REG_NAME) {
            bnj chunk;
            if (pos.p() >= 0 && pos.p() < 256 && mc.g.D(pos) && !(chunk = mc.g.l(pos)).s()) {
                ayu biome = chunk.i(pos);
                pc rl = fc.m.b((Object)biome);
                String name = rl != null ? rl.toString() : "?";
                this.addLine("Biome reg name: " + name);
            }
        } else if (type == InfoToggle.ENTITIES) {
            String ent = mc.h.h();
            int p = ent.indexOf(",");
            if (p != -1) {
                ent = ent.substring(0, p);
            }
            this.addLine(ent);
        } else if (type == InfoToggle.TILE_ENTITIES) {
            this.addLine(String.format("Client world TE - L: %d, T: %d", mc.g.h.size(), mc.g.i.size()));
        } else if (type == InfoToggle.ENTITIES_CLIENT_WORLD) {
            axy serverWorld;
            int countClient = mc.g.f.size();
            if (mc.w() && (serverWorld = WorldUtils.getBestWorld((cft)mc)) != null && serverWorld instanceof td) {
                int countServer = serverWorld.f.size();
                this.addLine(String.format("Entities - Client: %d, Server: %d", countClient, countServer));
                return;
            }
            this.addLine(String.format("Entities - Client: %d", countClient));
        } else if (type == InfoToggle.SLIME_CHUNK) {
            String result;
            if (!world.t.o()) {
                return;
            }
            bod dimension = entity.ap;
            if (this.data.isWorldSeedKnown(dimension)) {
                long seed = this.data.getWorldSeed(dimension);
                result = MiscUtils.canSlimeSpawnAt(pos.o(), pos.q(), seed) ? GuiBase.TXT_GREEN + "YES" + GuiBase.TXT_RST : GuiBase.TXT_RED + "NO" + GuiBase.TXT_RST;
            } else {
                result = "<world seed not known>";
            }
            this.addLine("Slime chunk: " + result);
        } else if (type == InfoToggle.LOOKING_AT_ENTITY) {
            if (mc.s != null && mc.s.a == ceb.a.c && mc.s.d != null) {
                aer target = mc.s.d;
                if (target instanceof afa) {
                    afa living = (afa)target;
                    this.addLine(String.format("Entity: %s - HP: %.1f / %.1f", target.N_().getString(), Float.valueOf(living.cq()), Float.valueOf(living.cw())));
                } else {
                    this.addLine(String.format("Entity: %s", target.N_().getString()));
                }
            }
        } else if (type == InfoToggle.ENTITY_REG_NAME) {
            pc regName;
            if (mc.s != null && mc.s.a == ceb.a.c && mc.s.d != null && (regName = aev.a((aev)mc.s.d.P())) != null) {
                this.addLine(String.format("Entity reg name: %s", regName.toString()));
            }
        } else if (type == InfoToggle.LOOKING_AT_BLOCK || type == InfoToggle.LOOKING_AT_BLOCK_CHUNK) {
            if (this.addedTypes.contains((Object)InfoToggle.LOOKING_AT_BLOCK) || this.addedTypes.contains((Object)InfoToggle.LOOKING_AT_BLOCK_CHUNK)) {
                return;
            }
            if (mc.s != null && mc.s.a == ceb.a.b && mc.s.a() != null) {
                el lookPos = mc.s.a();
                String pre = "";
                StringBuilder str = new StringBuilder(128);
                if (InfoToggle.LOOKING_AT_BLOCK.getBooleanValue()) {
                    str.append(String.format("Looking at block: %d, %d, %d", lookPos.o(), lookPos.p(), lookPos.q()));
                    pre = " // ";
                }
                if (InfoToggle.LOOKING_AT_BLOCK_CHUNK.getBooleanValue()) {
                    str.append(pre).append(String.format("Block: %d, %d, %d in Sub-Chunk: %d, %d, %d", lookPos.o() & 0xF, lookPos.p() & 0xF, lookPos.q() & 0xF, lookPos.o() >> 4, lookPos.p() >> 4, lookPos.q() >> 4));
                }
                this.addLine(str.toString());
                this.addedTypes.add(InfoToggle.LOOKING_AT_BLOCK);
                this.addedTypes.add(InfoToggle.LOOKING_AT_BLOCK_CHUNK);
            }
        } else if (type == InfoToggle.BLOCK_PROPS) {
            this.getBlockProperties(mc);
        } else if (type == InfoToggle.SPAWNABLE_SUB_CHUNKS) {
            int value = DataStorage.getInstance().getSpawnableSubChunkCountFor(pos.o() >> 4, pos.q() >> 4);
            if (value >= 0) {
                this.addLine(String.format("Spawnable sub-chunks: %d (y: 0 - %d)", value, value * 16 - 1));
            } else {
                this.addLine(String.format("Spawnable sub-chunks: <no data>", new Object[0]));
            }
        }
    }

    private <T extends Comparable<T>> void getBlockProperties(cft mc) {
        if (mc.s != null && mc.s.a == ceb.a.b && mc.s.a() != null) {
            el posLooking = mc.s.a();
            blc state = mc.g.a_(posLooking);
            this.addLine(String.valueOf(fc.g.b((Object)state.c())));
            for (String line : BlockUtils.getFormattedBlockStateProperties((blc)state)) {
                this.addLine(line);
            }
        }
    }

    private static class LinePos
    implements Comparable<LinePos> {
        private final int position;
        private final InfoToggle type;

        private LinePos(int position, InfoToggle type) {
            this.position = position;
            this.type = type;
        }

        @Override
        public int compareTo(LinePos other) {
            if (this.position < 0) {
                return other.position >= 0 ? 1 : 0;
            }
            if (other.position < 0 && this.position >= 0) {
                return -1;
            }
            return this.position < other.position ? -1 : (this.position > other.position ? 1 : 0);
        }
    }

    private class StringHolder
    implements Comparable<StringHolder> {
        public final String str;

        public StringHolder(String str) {
            this.str = str;
        }

        @Override
        public int compareTo(StringHolder other) {
            int lenOther;
            int lenThis = this.str.length();
            if (lenThis == (lenOther = other.str.length())) {
                return 0;
            }
            return this.str.length() > other.str.length() ? -1 : 1;
        }
    }
}

