/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.config.ConfigType;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.config.IConfigInteger;
import fi.dy.masa.malilib.config.IHotkeyTogglable;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybind;
import fi.dy.masa.malilib.hotkeys.KeyCallbackToggleBoolean;
import fi.dy.masa.malilib.hotkeys.KeybindMulti;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.minihud.MiniHUD;

public enum InfoToggle implements IConfigInteger,
IHotkeyTogglable
{
    BIOME("infoBiome", false, 19, "", "Show the name of the current biome"),
    BIOME_REG_NAME("infoBiomeRegistryName", false, 20, "", "Show the registry name of the current biome"),
    BLOCK_IN_CHUNK("infoBlockInChunk", false, 28, "", "Show the player's current position within the Chunk"),
    BLOCK_POS("infoBlockPosition", false, 6, "", "Show the player's current block position"),
    BLOCK_PROPS("infoBlockProperties", false, 27, "", "Show the BlockState properties and values"),
    CHUNK_POS("infoChunkPosition", false, 7, "", "Show the Chunk the player is currently within"),
    CHUNK_SECTIONS("infoChunkSections", false, 14, "", "Show the currently rendered number of\nChunk sections (the C value from F3)"),
    CHUNK_SECTIONS_FULL("infoChunkSectionsLine", false, 15, "", "Show the entire line of the C value from the F3 screen"),
    CHUNK_UPDATES("infoChunkUpdates", false, 16, "", "Show the current number of chunk updates per second"),
    COORDINATES("infoCoordinates", true, 4, "", "Show the player's coordinates"),
    DIFFICULTY("infoDifficulty", false, 18, "", "Show the local difficulty"),
    DIMENSION("infoDimensionId", false, 5, "", "Show the current dimension ID\n(might not be accurate in every case,\ndepending on the server (Sponge?)!)"),
    DISTANCE("infoDistance", false, 33, "", "Show the distance to the current reference point.\nSet the reference point with the setDistanceReferencePoint hotkey"),
    ENTITIES("infoEntities", false, 21, "", "Show the visible/loaded entity count"),
    ENTITIES_CLIENT_WORLD("infoEntitiesClientWorld", false, 22, "", "Show the entity count in the world list/map"),
    ENTITY_REG_NAME("infoEntityRegistryName", false, 24, "", "Show the registry name of the entity\nthe player is currently looking at"),
    FACING("infoFacing", true, 8, "", "Show the player's current facing"),
    FPS("infoFPS", false, 0, "", "Show the current FPS"),
    LIGHT_LEVEL("infoLightLevel", false, 10, "", "Show the current light level"),
    LOOKING_AT_BLOCK("infoLookingAtBlock", false, 25, "", "Show which block the player is currently looking at"),
    LOOKING_AT_BLOCK_CHUNK("infoLookingAtBlockInChunk", false, 26, "", "Show which block within its containing chunk\nthe player is currently looking at"),
    LOOKING_AT_ENTITY("infoLookingAtEntity", false, 23, "", "Show the entity name and health when looked at"),
    MEMORY_USAGE("infoMemoryUsage", false, 0, "", "Show the memory usage and allocation"),
    LOADED_CHUNKS_COUNT("infoLoadedChunksCount", false, 31, "", "Show the number of loaded chunks on the client"),
    PARTICLE_COUNT("infoParticleCount", false, 17, "", "Show the currently renderer particle count (P from F3)"),
    PING("infoPing", false, 36, "", "Show the current ping to the server"),
    REGION_FILE("infoRegionFile", false, 29, "", "Show the region file the player is currently within"),
    ROTATION_PITCH("infoRotationPitch", false, 12, "", "Show the player's pitch rotation"),
    ROTATION_YAW("infoRotationYaw", false, 11, "", "Show the player's yaw rotation"),
    SERVER_TPS("infoServerTPS", false, 9, "", "Show the server TPS and ms/tick (MSPT) values\nNote: This is only accurate when running a Carpet server\nand the TPSdisplay carpet rule is enabled.\nOtherwise it is estimated on the client side,\nbased on the world time update packet, and it can\nonly detect TPS values lower than 20 that way."),
    SLIME_CHUNK("infoSlimeChunk", false, 22, "", "Show whether the player is currently in a slime chunk.\nNOTE: This only works in single player without any user intervention!\nOn a server the player needs to either:\n  1) be admin/OP and run the /seed command manually EVERY TIME\n     they join or change dimensions, or\n  2) input the seed via chat, by sending a \"command\" like: minihud-seed 12345"),
    SPAWNABLE_SUB_CHUNKS("infoSpawnableSubChunks", false, 32, "", "Show the spawnable sub chunk count for the current chunk"),
    SPEED("infoSpeed", false, 13, "", "Show the player's current moving speed"),
    SPEED_AXIS("infoSpeedAxis", false, 13, "", "Show the player's current moving speed per axis"),
    TILE_ENTITIES("infoTileEntities", false, 32, "", "Show the number of TileEntities in the client world"),
    TIME_DAY_MODULO("infoTimeDayModulo", false, 35, "", "Show a modulo of the current day time.\nSee Generic configs for the divisor."),
    TIME_REAL("infoTimeIRL", true, 1, "", "Show the current real time formatted according to dateFormatReal"),
    TIME_TOTAL_MODULO("infoTimeTotalModulo", false, 34, "", "Show a modulo of the current total world time.\nSee Generic configs for the divisor."),
    TIME_WORLD("infoTimeWorld", false, 2, "", "Show the current world time in ticks"),
    TIME_WORLD_FORMATTED("infoWorldTimeFormatted", false, 3, "", "Show the current world time formatted to days, hours, minutes");

    private final String name;
    private final String prettyName;
    private final String comment;
    private final IKeybind keybind;
    private final boolean defaultValueBoolean;
    private final int defaultLinePosition;
    private boolean valueBoolean;
    private int linePosition;

    private InfoToggle(String name, boolean defaultValue, int linePosition, String defaultHotkey, String comment) {
        this(name, defaultValue, linePosition, defaultHotkey, comment, KeybindSettings.DEFAULT);
    }

    private InfoToggle(String name, boolean defaultValue, int linePosition, String defaultHotkey, String comment, KeybindSettings settings) {
        this.name = name;
        this.prettyName = name;
        this.valueBoolean = defaultValue;
        this.defaultValueBoolean = defaultValue;
        this.keybind = KeybindMulti.fromStorageString((String)defaultHotkey, (KeybindSettings)settings);
        this.keybind.setCallback((IHotkeyCallback)new KeyCallbackToggleBoolean((IConfigBoolean)this));
        this.linePosition = linePosition;
        this.defaultLinePosition = linePosition;
        this.comment = comment;
    }

    public ConfigType getType() {
        return ConfigType.HOTKEY;
    }

    public String getName() {
        return this.name;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public String getStringValue() {
        return String.valueOf(this.valueBoolean);
    }

    public String getDefaultStringValue() {
        return String.valueOf(this.defaultValueBoolean);
    }

    public String getComment() {
        return this.comment != null ? this.comment : "";
    }

    public boolean getBooleanValue() {
        return this.valueBoolean;
    }

    public boolean getDefaultBooleanValue() {
        return this.defaultValueBoolean;
    }

    public void setBooleanValue(boolean value) {
        this.valueBoolean = value;
    }

    public int getIntegerValue() {
        return this.linePosition;
    }

    public int getDefaultIntegerValue() {
        return this.defaultLinePosition;
    }

    public void setIntegerValue(int value) {
        this.linePosition = value;
    }

    public int getMinIntegerValue() {
        return 0;
    }

    public int getMaxIntegerValue() {
        return InfoToggle.values().length - 1;
    }

    public IKeybind getKeybind() {
        return this.keybind;
    }

    public boolean isModified() {
        return this.valueBoolean != this.defaultValueBoolean;
    }

    public boolean isModified(String newValue) {
        return !String.valueOf(this.defaultValueBoolean).equals(newValue);
    }

    public void resetToDefault() {
        this.valueBoolean = this.defaultValueBoolean;
    }

    public void setValueFromString(String value) {
        try {
            this.valueBoolean = Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            MiniHUD.logger.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public void setValueFromJsonElement(JsonElement element) {
        try {
            if (element.isJsonPrimitive()) {
                this.valueBoolean = element.getAsBoolean();
            } else {
                MiniHUD.logger.warn("Failed to read config value for {} from the JSON config", (Object)this.getName());
            }
        }
        catch (Exception e) {
            MiniHUD.logger.warn("Failed to read config value for {} from the JSON config", (Object)this.getName(), (Object)e);
        }
    }

    public JsonElement getAsJsonElement() {
        return new JsonPrimitive(Boolean.valueOf(this.valueBoolean));
    }
}

