/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.entity.model.anim;

import net.optifine.Config;
import net.optifine.entity.model.CustomModelRenderer;
import net.optifine.entity.model.ModelAdapter;
import net.optifine.entity.model.anim.IModelResolver;
import net.optifine.entity.model.anim.IRenderResolver;
import net.optifine.entity.model.anim.ModelVariableFloat;
import net.optifine.entity.model.anim.ModelVariableType;
import net.optifine.entity.model.anim.RenderResolverEntity;
import net.optifine.entity.model.anim.RenderResolverTileEntity;
import net.optifine.expr.IExpression;

public class ModelResolver
implements IModelResolver {
    private ModelAdapter modelAdapter;
    private cpc model;
    private CustomModelRenderer[] customModelRenderers;
    private cqw thisModelRenderer;
    private cqw partModelRenderer;
    private IRenderResolver renderResolver;

    public ModelResolver(ModelAdapter modelAdapter, cpc model, CustomModelRenderer[] customModelRenderers) {
        this.modelAdapter = modelAdapter;
        this.model = model;
        this.customModelRenderers = customModelRenderers;
        Class entityClass = modelAdapter.getEntityClass();
        this.renderResolver = bji.class.isAssignableFrom(entityClass) ? new RenderResolverTileEntity() : new RenderResolverEntity();
    }

    @Override
    public IExpression getExpression(String name) {
        ModelVariableFloat mv = this.getModelVariable(name);
        if (mv != null) {
            return mv;
        }
        IExpression param = this.renderResolver.getParameter(name);
        if (param != null) {
            return param;
        }
        return null;
    }

    @Override
    public cqw getModelRenderer(String name) {
        if (name == null) {
            return null;
        }
        if (name.indexOf(":") >= 0) {
            String[] parts = Config.tokenize(name, ":");
            cqw mr = this.getModelRenderer(parts[0]);
            for (int i2 = 1; i2 < parts.length; ++i2) {
                String part = parts[i2];
                cqw mrSub = mr.getChildDeep(part);
                if (mrSub == null) {
                    return null;
                }
                mr = mrSub;
            }
            return mr;
        }
        if (this.thisModelRenderer != null && name.equals("this")) {
            return this.thisModelRenderer;
        }
        if (this.partModelRenderer != null && name.equals("part")) {
            return this.partModelRenderer;
        }
        cqw mrPart = this.modelAdapter.getModelRenderer(this.model, name);
        if (mrPart != null) {
            return mrPart;
        }
        for (int i3 = 0; i3 < this.customModelRenderers.length; ++i3) {
            CustomModelRenderer cmr = this.customModelRenderers[i3];
            cqw mr = cmr.getModelRenderer();
            if (name.equals(mr.getId())) {
                return mr;
            }
            cqw mrChild = mr.getChildDeep(name);
            if (mrChild == null) continue;
            return mrChild;
        }
        return null;
    }

    @Override
    public ModelVariableFloat getModelVariable(String name) {
        String[] parts = Config.tokenize(name, ".");
        if (parts.length != 2) {
            return null;
        }
        String modelName = parts[0];
        String varName = parts[1];
        cqw mr = this.getModelRenderer(modelName);
        if (mr == null) {
            return null;
        }
        ModelVariableType varType = ModelVariableType.parse(varName);
        if (varType == null) {
            return null;
        }
        return new ModelVariableFloat(name, mr, varType);
    }

    public void setPartModelRenderer(cqw partModelRenderer) {
        this.partModelRenderer = partModelRenderer;
    }

    public void setThisModelRenderer(cqw thisModelRenderer) {
        this.thisModelRenderer = thisModelRenderer;
    }
}

