/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.brigadier.context;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Primitives;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.RedirectModifier;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Map;

public class CommandContext<S> {
    private final S source;
    private final String input;
    private final Command<S> command;
    private final Map<String, ParsedArgument<S, ?>> arguments;
    private final Map<CommandNode<S>, StringRange> nodes;
    private final StringRange range;
    private final CommandContext<S> child;
    private final RedirectModifier<S> modifier;
    private final boolean forks;

    public CommandContext(S source, String input, Map<String, ParsedArgument<S, ?>> arguments, Command<S> command, Map<CommandNode<S>, StringRange> nodes, StringRange range, CommandContext<S> child, RedirectModifier<S> modifier, boolean forks) {
        this.source = source;
        this.input = input;
        this.arguments = arguments;
        this.command = command;
        this.nodes = nodes;
        this.range = range;
        this.child = child;
        this.modifier = modifier;
        this.forks = forks;
    }

    public CommandContext<S> copyFor(S source) {
        if (this.source == source) {
            return this;
        }
        return new CommandContext<S>(source, this.input, this.arguments, this.command, this.nodes, this.range, this.child, this.modifier, this.forks);
    }

    public CommandContext<S> getChild() {
        return this.child;
    }

    public CommandContext<S> getLastChild() {
        CommandContext<S> result = this;
        while (result.getChild() != null) {
            result = result.getChild();
        }
        return result;
    }

    public Command<S> getCommand() {
        return this.command;
    }

    public S getSource() {
        return this.source;
    }

    public <V> V getArgument(String name, Class<V> clazz) {
        ParsedArgument<S, ?> argument = this.arguments.get(name);
        if (argument == null) {
            throw new IllegalArgumentException("No such argument '" + name + "' exists on this command");
        }
        Object result = argument.getResult();
        if (Primitives.wrap(clazz).isAssignableFrom(result.getClass())) {
            return (V)result;
        }
        throw new IllegalArgumentException("Argument '" + name + "' is defined as " + result.getClass().getSimpleName() + ", not " + clazz);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommandContext)) {
            return false;
        }
        CommandContext that = (CommandContext)o;
        if (!this.arguments.equals(that.arguments)) {
            return false;
        }
        if (!Iterables.elementsEqual(this.nodes.entrySet(), that.nodes.entrySet())) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (!this.source.equals(that.source)) {
            return false;
        }
        return !(this.child != null ? !this.child.equals(that.child) : that.child != null);
    }

    public int hashCode() {
        int result = this.source.hashCode();
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
        result = 31 * result + this.nodes.hashCode();
        result = 31 * result + (this.child != null ? this.child.hashCode() : 0);
        return result;
    }

    public RedirectModifier<S> getRedirectModifier() {
        return this.modifier;
    }

    public StringRange getRange() {
        return this.range;
    }

    public String getInput() {
        return this.input;
    }

    public Map<CommandNode<S>, StringRange> getNodes() {
        return this.nodes;
    }

    public boolean isForked() {
        return this.forks;
    }
}

