/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.accesstransform;

import org.dimdev.accesstransform.AccessLevel;
import org.dimdev.accesstransform.AccessTransformationSet;
import org.dimdev.accesstransform.ElementReference;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class AccessTransformer {
    private final AccessTransformationSet transformations;

    public AccessTransformer(AccessTransformationSet transformations) {
        this.transformations = transformations;
    }

    public byte[] transformClass(String name, byte[] bytes) {
        if (bytes == null || !this.transformations.isClassAffected(name)) {
            return bytes;
        }
        ClassNode clazz = new ClassNode();
        ClassReader reader = new ClassReader(bytes);
        reader.accept((ClassVisitor)clazz, 0);
        clazz.access = this.getNewAccessLevel(new ElementReference(ElementReference.Kind.CLASS, null, name, null), clazz.access);
        for (FieldNode field : clazz.fields) {
            field.access = this.getNewAccessLevel(new ElementReference(ElementReference.Kind.FIELD, name, field.name, field.desc), field.access);
        }
        for (MethodNode method : clazz.methods) {
            method.access = this.getNewAccessLevel(new ElementReference(ElementReference.Kind.METHOD, name, method.name, method.desc), method.access);
        }
        ClassWriter writer = new ClassWriter(0);
        clazz.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private int getNewAccessLevel(ElementReference elementReference, int access) {
        AccessLevel.Visibility visibility;
        AccessLevel minimumAccessLevel = this.transformations.getMinimumAccessLevel(elementReference);
        if (minimumAccessLevel == null) {
            return access;
        }
        if ((access & 1) != 0) {
            visibility = AccessLevel.Visibility.PUBLIC;
            access &= 0xFFFFFFFE;
        } else if ((access & 4) != 0) {
            visibility = AccessLevel.Visibility.PROTECTED;
            access &= 0xFFFFFFFB;
        } else if ((access & 2) != 0) {
            visibility = AccessLevel.Visibility.PRIVATE;
            access &= 0xFFFFFFFD;
        } else {
            visibility = AccessLevel.Visibility.DEFAULT;
        }
        boolean isFinal = (access & 0x10) != 0;
        AccessLevel newAccessLevel = AccessLevel.union(minimumAccessLevel, new AccessLevel(visibility, isFinal));
        if (newAccessLevel == null) {
            return access;
        }
        if (isFinal && !newAccessLevel.isFinal) {
            access &= 0xFFFFFFEF;
        }
        switch (newAccessLevel.visibility) {
            case PUBLIC: {
                return access | 1;
            }
            case PROTECTED: {
                return access | 4;
            }
            case DEFAULT: {
                return access;
            }
            case PRIVATE: {
                return access | 2;
            }
        }
        throw new RuntimeException("Unknown visibility level '" + (Object)((Object)newAccessLevel.visibility) + "'");
    }
}

