/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;

public class RiftMod {
    @Nullable
    private ddg nativeImage;
    private List<String> authors;
    private String id;
    private String name;
    private String versions;
    private String url;
    private String description;
    private pc resourceLocation;

    public RiftMod(String id, File file) {
        this(id, id, file, false);
    }

    public RiftMod(String id, String name, File file, boolean loadIcon) {
        this.id = id;
        this.name = name;
        this.versions = "Unidentified";
        this.url = "Unidentified";
        this.description = "A mod for Rift.";
        this.authors = new ArrayList<String>();
        this.nativeImage = null;
        if (loadIcon) {
            this.tryLoadPackIcon(file, "pack.png");
        }
    }

    public static String loadValueFromJar(File file, String value) {
        return RiftMod.loadValueFromJar(file, value, "Unidentified");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadValueFromJar(File file, String value, String defaultAnswer) {
        if (!file.isFile()) {
            return defaultAnswer;
        }
        try (JarFile jar = new JarFile(file);){
            JarEntry entry = jar.getJarEntry("riftmod.json");
            if (entry == null) return defaultAnswer;
            InputStream inputStream = jar.getInputStream(entry);
            JsonElement element = new JsonParser().parse((Reader)new InputStreamReader(inputStream));
            JsonObject object = element.getAsJsonObject();
            if (!object.has(value)) return defaultAnswer;
            String string = object.get(value).getAsString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultAnswer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tryLoadPackIcon(File file, String iconFile) {
        if (!file.isFile()) {
            return false;
        }
        try (JarFile jar = new JarFile(file);){
            JarEntry entry = jar.getJarEntry(iconFile);
            if (entry == null) return false;
            InputStream inputStream = jar.getInputStream(entry);
            this.nativeImage = ddg.a((InputStream)inputStream);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersions() {
        return this.versions;
    }

    public void setVersions(String versions) {
        this.versions = versions;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<String> authors) {
        this.authors = authors;
    }

    public void setResourceLocation(pc resourceLocation) {
        this.resourceLocation = resourceLocation;
    }

    public pc getModIcon() {
        if (this.resourceLocation == null) {
            this.resourceLocation = this.nativeImage == null ? new pc("textures/misc/unknown_pack.png") : cft.s().E().a("modpackicon", new ddb(this.nativeImage));
        }
        return this.resourceLocation;
    }

    public String toString() {
        return "RiftMod(" + this.id + ")[" + this.name + "]: " + this.authors.toString();
    }
}

