/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.riftloader;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import net.minecraft.launchwrapper.Launch;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dimdev.accesstransform.AccessTransformationSet;
import org.dimdev.accesstransform.AccessTransformer;
import org.dimdev.riftloader.DuplicateModException;
import org.dimdev.riftloader.ModInfo;
import org.dimdev.riftloader.Side;
import org.dimdev.riftloader.listener.InitializationListener;
import org.dimdev.riftloader.listener.Instantiator;
import org.dimdev.utils.InstanceListMap;
import org.dimdev.utils.InstanceMap;
import org.dimdev.utils.ReflectionUtils;

public class RiftLoader {
    public static final RiftLoader instance = new RiftLoader();
    private static final Logger log = LogManager.getLogger((String)"RiftLoader");
    public final File modsDir = new File(Launch.minecraftHome, "mods");
    public final File configDir = new File(Launch.minecraftHome, "config");
    private Side side;
    private boolean loaded;
    public AccessTransformer accessTransformer;
    private Map<String, ModInfo> modInfoMap = new LinkedHashMap<String, ModInfo>();
    private List<Class<?>> listenerClasses = new ArrayList();
    private InstanceMap listenerInstanceMap = new InstanceMap();
    private InstanceListMap listeners = new InstanceListMap();
    private InstanceListMap customListenerInstances = new InstanceListMap();

    public void load(boolean isClient) {
        if (this.loaded) {
            throw new IllegalStateException("Already loaded");
        }
        this.loaded = true;
        this.side = isClient ? Side.CLIENT : Side.SERVER;
        this.findMods(this.modsDir);
        this.sortMods();
        this.initMods();
        this.initAccessTransformer();
    }

    private void findMods(File modsDir) {
        log.info("Searching mods on classpath");
        try {
            Enumeration<URL> urls = ClassLoader.getSystemResources("riftmod.json");
            block28: while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                InputStream in = url.openStream();
                switch (url.getProtocol()) {
                    case "jar": {
                        String spec = url.getFile();
                        int separator = spec.indexOf("!/");
                        if (separator == -1) {
                            throw new MalformedURLException("no !/ found in url spec:" + spec);
                        }
                        url = new URL(spec.substring(0, separator));
                        this.loadModFromJson(in, new File(url.toURI()));
                        continue block28;
                    }
                    case "file": {
                        this.loadModFromJson(in, new File(url.toURI()).getParentFile());
                        continue block28;
                    }
                }
                throw new RuntimeException("Unsupported protocol: " + url);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        log.info("Searching for mods in " + modsDir);
        modsDir.mkdirs();
        for (File file : modsDir.listFiles()) {
            if (!file.getName().endsWith(".jar")) continue;
            try (JarFile jar = new JarFile(file);){
                if (!file.isFile()) continue;
                JarEntry entry = jar.getJarEntry("riftmod.json");
                if (entry != null) {
                    this.loadModFromJson(jar.getInputStream(entry), file);
                    continue;
                }
                if (jar.getJarEntry("optifine/OptiFineClassTransformer.class") != null) {
                    ModInfo mod = new ModInfo();
                    mod.source = file;
                    mod.id = "optifine";
                    mod.name = "Optifine";
                    mod.authors.add("sp614x");
                    mod.listeners.add(new ModInfo.Listener("org.dimdev.riftloader.OptifineLoader"));
                    this.modInfoMap.put("optifine", mod);
                }
                log.debug("Skipping " + file + " since it does not contain riftmod.json");
            }
            catch (ZipException e) {
                log.error("Could not read file " + file + " as a jar file", (Throwable)e);
            }
            catch (Throwable t) {
                log.error("Exception while checking if file " + file + " is a mod", t);
            }
        }
        log.info("Loaded " + this.modInfoMap.size() + " mods");
    }

    private void loadModFromJson(InputStream in, File source) {
        try {
            ModInfo modInfo = (ModInfo)ModInfo.GSON.fromJson((Reader)new InputStreamReader(in), ModInfo.class);
            modInfo.source = source;
            if (modInfo.id == null) {
                log.error("Mod file " + modInfo.source + "'s riftmod.json is missing a 'id' field");
                return;
            }
            if (this.modInfoMap.containsKey(modInfo.id)) {
                throw new DuplicateModException(modInfo, this.modInfoMap.get(modInfo.id));
            }
            this.modInfoMap.put(modInfo.id, modInfo);
            log.info("Loaded mod '" + modInfo.id + "'");
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Could not read riftmod.json in " + source, e);
        }
    }

    private void sortMods() {
        log.debug("Sorting mods");
    }

    private void initMods() {
        log.info("Initializing mods");
        for (ModInfo modInfo : this.modInfoMap.values()) {
            try {
                RiftLoader.addURLToClasspath(modInfo.source.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        ArrayList<ModInfo.Listener> allListeners = new ArrayList<ModInfo.Listener>();
        for (ModInfo modInfo : this.modInfoMap.values()) {
            if (modInfo.listeners == null) continue;
            for (ModInfo.Listener listener2 : modInfo.listeners) {
                if (!listener2.side.includes(this.side)) continue;
                allListeners.add(listener2);
            }
        }
        allListeners.sort(Comparator.comparingInt(listener -> listener.priority).reversed());
        for (ModInfo.Listener listener2 : allListeners) {
            try {
                Class listenerClass = Launch.classLoader.findClass(listener2.className);
                this.listenerClasses.add(listenerClass);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to find listener class " + listener2.className, e);
            }
        }
        for (InitializationListener initializationListener : this.getListeners(InitializationListener.class)) {
            initializationListener.onInitialization();
        }
        log.info("Done initializing mods");
    }

    private static void addURLToClasspath(URL url) {
        ReflectionUtils.addURLToClasspath(url);
        Launch.classLoader.addURL(url);
    }

    private void initAccessTransformer() {
        try {
            AccessTransformationSet transformations = new AccessTransformationSet();
            Enumeration urls = Launch.classLoader.getResources("access_transformations.at");
            while (urls.hasMoreElements()) {
                URL url = (URL)urls.nextElement();
                Scanner scanner = new Scanner(url.openStream());
                Throwable throwable = null;
                try {
                    while (scanner.hasNextLine()) {
                        transformations.addMinimumAccessLevel(scanner.nextLine());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (scanner == null) continue;
                    if (throwable != null) {
                        try {
                            scanner.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    scanner.close();
                }
            }
            this.accessTransformer = new AccessTransformer(transformations);
            Launch.classLoader.registerTransformer("org.dimdev.riftloader.RiftAccessTransformer");
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to initialize access transformers", t);
        }
    }

    public Collection<ModInfo> getMods() {
        return this.modInfoMap.values();
    }

    public Side getSide() {
        return this.side;
    }

    public <T> List<T> getListeners(Class<T> listenerInterface) {
        List<T> listenerInstances = this.listeners.get(listenerInterface);
        if (listenerInstances == null) {
            this.loadListeners(listenerInterface);
            listenerInstances = this.listeners.get(listenerInterface);
        }
        return listenerInstances;
    }

    public <T> void loadListeners(Class<T> listenerInterface) {
        ArrayList<T> listenerInstances = new ArrayList<T>();
        this.listeners.put(listenerInterface, listenerInstances);
        for (Class<?> listenerClass : this.listenerClasses) {
            if (!listenerInterface.isAssignableFrom(listenerClass)) continue;
            try {
                Class.forName(listenerClass.getName(), true, listenerClass.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            T listenerInstance = listenerInterface.cast(this.listenerInstanceMap.get(listenerClass));
            if (listenerInstance == null) {
                try {
                    listenerInstance = listenerInterface.cast(this.newInstance(listenerClass));
                    this.listenerInstanceMap.castAndPut(listenerClass, listenerInstance);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException("Failed to create listener instance", e);
                }
            }
            listenerInstances.add(listenerInstance);
        }
        List<T> customInstances = this.customListenerInstances.get(listenerInterface);
        if (customInstances != null) {
            listenerInstances.addAll(customInstances);
        }
    }

    public <T> T newInstance(Class<T> clazz) throws ReflectiveOperationException {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterCount() != 0) continue;
            return clazz.cast(constructor.newInstance(new Object[0]));
        }
        for (Instantiator instantiator : this.getListeners(Instantiator.class)) {
            T instance = instantiator.newInstance(clazz);
            if (instance == null) continue;
            return instance;
        }
        throw new InstantiationException("Class has no public no-args constructor, and no instantiator handled it either");
    }

    public <T> void setInstanceForListenerClass(Class<T> listenerClass, T instance) {
        this.listenerInstanceMap.put(listenerClass, instance);
    }

    public <T> void addListener(Class<T> listenerInterface, T listener) {
        List<T> customInstances = this.customListenerInstances.get(listenerInterface);
        if (customInstances == null) {
            customInstances = new ArrayList<T>();
            this.customListenerInstances.put(listenerInterface, customInstances);
        }
        customInstances.add(listener);
        List<T> loadedInstances = this.listeners.get(listenerInterface);
        if (loadedInstances != null) {
            loadedInstances.add(listener);
        }
    }
}

