/*
 * Decompiled with CFR 0.152.
 */
package org.dimdev.riftloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dimdev.riftloader.Side;

public class ModInfo {
    public static Gson GSON = new GsonBuilder().registerTypeAdapter(Listener.class, (listener, type, context) -> {
        if (listener.priority == 0 && listener.side == Side.BOTH) {
            return new JsonPrimitive(listener.className);
        }
        return new Gson().toJsonTree(listener);
    }).registerTypeAdapter(Listener.class, (json, type, context) -> {
        if (json.isJsonPrimitive() && ((JsonPrimitive)json).isString()) {
            return new Listener(json.getAsString());
        }
        Listener listener = (Listener)new Gson().fromJson(json, Listener.class);
        if (listener.className == null) {
            throw new JsonSyntaxException("Listener with no class!");
        }
        if (listener.side == null) {
            listener.side = Side.BOTH;
        }
        return listener;
    }).create();
    public File source;
    public String id;
    public String name;
    public String description;
    public String version;
    public String url;
    public List<String> authors = new ArrayList<String>();
    public List<Listener> listeners = new ArrayList<Listener>();

    public static class Listener {
        @SerializedName(value="class")
        public String className;
        public int priority = 0;
        public Side side = Side.BOTH;

        public Listener(String className) {
            this.className = className;
        }
    }
}

